/*
 * Decompiled with CFR 0.152.
 */
package tico.board.components;

import org.jgraph.graph.AttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.encoding.InvalidFormatException;
import tico.board.encoding.TAttributeEncoder;
import tico.configuration.TLanguage;

public class TLabel
extends TComponent {
    public static String TYPE = "label";
    private static int labelCount = 0;
    private static String DEFAULT_TEXT = TLanguage.getString("TLabel.DEFAULT_TEXT");

    public TLabel() {
        this.setAllowsChildren(false);
        TBoardConstants.setSizeable(this.getAttributes(), false);
        TBoardConstants.setResizeToText(this.getAttributes(), true);
        TBoardConstants.setText(this.getAttributes(), DEFAULT_TEXT);
    }

    @Override
    public String newId() {
        return "label_" + new Integer(labelCount++);
    }

    @Override
    public Node XMLEncode(Document doc) {
        Element componentElement = doc.createElement("component");
        componentElement.setAttribute("type", TYPE);
        AttributeMap map = (AttributeMap)this.getAttributes().clone();
        map.remove("resizeToText");
        map.remove("sizeable");
        componentElement.appendChild(TAttributeEncoder.XMLEncode(map, doc));
        return componentElement;
    }

    public static TLabel XMLDecode(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("component") && element.getAttribute("type").equals(TYPE)) {
            TLabel label = new TLabel();
            Node attributesNode = element.getElementsByTagName("attributes").item(0);
            label.getAttributes().applyMap(TAttributeEncoder.XMLDecode((Element)attributesNode));
            return label;
        }
        return null;
    }
}

