/*
 * Decompiled with CFR 0.152.
 */
package tico.board.components;

import org.jgraph.graph.AttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tico.board.TBoardConstants;
import tico.board.components.TCell;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.board.encoding.InvalidFormatException;
import tico.board.encoding.TAttributeEncoder;

public class TGridCell
extends TComponent {
    public static String TYPE = "cell";

    public TGridCell() {
        this.setAllowsChildren(false);
        TBoardConstants.setTextSender(this.getAttributes(), true);
        TBoardConstants.setBrowseable(this.getAttributes(), true);
    }

    public TGridCell(int row, int column) {
        TBoardConstants.setColumn(this.getAttributes(), column);
        TBoardConstants.setRow(this.getAttributes(), row);
        TBoardConstants.setTextSender(this.getAttributes(), true);
        TBoardConstants.setBrowseable(this.getAttributes(), true);
        TBoardConstants.setId(this.getAttributes(), this.newId());
    }

    @Override
    public String newId() {
        return "cell_" + new Integer(TCell.cellCount++);
    }

    @Override
    public String getId() {
        return TBoardConstants.getId(this.getAttributes());
    }

    public TGrid getGrid() {
        return (TGrid)this.getParent();
    }

    @Override
    public Node XMLEncode(Document doc) {
        Element componentElement = doc.createElement("component");
        componentElement.setAttribute("type", TYPE);
        AttributeMap map = (AttributeMap)this.getAttributes().clone();
        map.remove("textSender");
        componentElement.appendChild(TAttributeEncoder.XMLEncode(map, doc));
        return componentElement;
    }

    public static TGridCell XMLDecode(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("component") && element.getAttribute("type").equals(TYPE)) {
            TGridCell gridCell = new TGridCell();
            Node attributesNode = element.getElementsByTagName("attributes").item(0);
            gridCell.getAttributes().applyMap(TAttributeEncoder.XMLDecode((Element)attributesNode));
            return gridCell;
        }
        throw new InvalidFormatException();
    }
}

