/*
 * Decompiled with CFR 0.152.
 */
package tico.board.components;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.jgraph.graph.AttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.components.TGridCell;
import tico.board.encoding.InvalidFormatException;
import tico.board.encoding.TAttributeEncoder;

public class TGrid
extends TComponent {
    public static String TYPE = "grid";
    private static int gridCount = 0;
    public static final int SEQUENTIAL = 0;
    public static final int ROWS = 1;
    public static final int COLUMNS = 2;
    public static final int CUSTOM = 3;
    private static final int DEFAULT_ORDER = 0;
    public static final double DEFAULT_HORIZONTAL_GAP = 10.0;
    public static final double DEFAULT_VERTICAL_GAP = 10.0;

    public TGrid(TGridCell[] childs) {
        super(childs);
        TBoardConstants.setGroupOpaque(this.getAttributes(), false);
        TBoardConstants.setBrowseable(this.getAttributes(), false);
    }

    @Override
    public String newId() {
        return "grid_" + new Integer(gridCount++);
    }

    public TGridCell getCell(int row, int column) {
        int i2 = 0;
        while (i2 < this.children.size()) {
            int currentColumn = TBoardConstants.getColumn(((TGridCell)this.children.get(i2)).getAttributes());
            int currentRow = TBoardConstants.getRow(((TGridCell)this.children.get(i2)).getAttributes());
            if (currentColumn == column && currentRow == row) {
                return (TGridCell)this.children.get(i2);
            }
            ++i2;
        }
        return null;
    }

    public int getColumnsCount() {
        int lastColumn = 0;
        int i2 = 0;
        while (i2 < this.children.size()) {
            int currentColumn = TBoardConstants.getColumn(((TGridCell)this.children.get(i2)).getAttributes());
            if (currentColumn > lastColumn) {
                lastColumn = currentColumn;
            }
            ++i2;
        }
        return lastColumn;
    }

    public int getRowsCount() {
        int lastRow = 0;
        int i2 = 0;
        while (i2 < this.children.size()) {
            int currentRow = TBoardConstants.getRow(((TGridCell)this.children.get(i2)).getAttributes());
            if (currentRow > lastRow) {
                lastRow = currentRow;
            }
            ++i2;
        }
        return lastRow;
    }

    public int getLastColumnRow(int row) {
        int lastColumn = 0;
        int i2 = 0;
        while (i2 < this.children.size()) {
            int currentColumn = TBoardConstants.getColumn(((TGridCell)this.children.get(i2)).getAttributes());
            if (row == TBoardConstants.getRow(((TGridCell)this.children.get(i2)).getAttributes()) && currentColumn > lastColumn) {
                lastColumn = currentColumn;
            }
            ++i2;
        }
        return lastColumn;
    }

    public int getLastRowColumn(int column) {
        int lastRow = 0;
        int i2 = 0;
        while (i2 < this.children.size()) {
            int currentRow = TBoardConstants.getRow(((TGridCell)this.children.get(i2)).getAttributes());
            if (column == TBoardConstants.getColumn(((TGridCell)this.children.get(i2)).getAttributes()) && currentRow > lastRow) {
                lastRow = currentRow;
            }
            ++i2;
        }
        return lastRow;
    }

    public int getColumnDimension(int column) {
        int dimension = 0;
        int i2 = 0;
        while (i2 < this.children.size()) {
            if (column == TBoardConstants.getColumn(((TGridCell)this.children.get(i2)).getAttributes())) {
                ++dimension;
            }
            ++i2;
        }
        return dimension;
    }

    public int getRowDimension(int row) {
        int dimension = 0;
        int i2 = 0;
        while (i2 < this.children.size()) {
            if (row == TBoardConstants.getRow(((TGridCell)this.children.get(i2)).getAttributes())) {
                ++dimension;
            }
            ++i2;
        }
        return dimension;
    }

    public TGridCell getFollowingRowCell(int row, int position) {
        int followingColumn = this.getLastColumnRow(row);
        if (followingColumn < position) {
            return null;
        }
        TGridCell followingCell = this.getCell(row, followingColumn);
        int i2 = 0;
        while (i2 < this.children.size()) {
            TGridCell currentCell = (TGridCell)this.children.get(i2);
            int currentColumn = TBoardConstants.getColumn(currentCell.getAttributes());
            if (row == TBoardConstants.getRow(currentCell.getAttributes()) && currentColumn < followingColumn && currentColumn >= position) {
                followingColumn = currentColumn;
                followingCell = currentCell;
            }
            ++i2;
        }
        return followingCell;
    }

    public TGridCell getFollowingColumnCell(int column, int position) {
        int followingRow = this.getLastRowColumn(column);
        if (followingRow < position) {
            return null;
        }
        TGridCell followingCell = this.getCell(followingRow, column);
        int i2 = 0;
        while (i2 < this.children.size()) {
            TGridCell currentCell = (TGridCell)this.children.get(i2);
            int currentRow = TBoardConstants.getRow(currentCell.getAttributes());
            if (column == TBoardConstants.getColumn(currentCell.getAttributes()) && currentRow < followingRow && currentRow >= position) {
                followingRow = currentRow;
                followingCell = currentCell;
            }
            ++i2;
        }
        return followingCell;
    }

    public Map reorderRows() {
        Hashtable<TGridCell, AttributeMap> nested = new Hashtable<TGridCell, AttributeMap>();
        int rows = this.getRowsCount();
        int currentRow = 1;
        while (currentRow <= rows) {
            TGridCell currentCell;
            int currentColumn = 1;
            int lastColumn = 1;
            while ((currentCell = this.getFollowingRowCell(currentRow, lastColumn)) != null) {
                lastColumn = TBoardConstants.getColumn(currentCell.getAttributes());
                if (lastColumn != currentColumn) {
                    AttributeMap attributeMap = new AttributeMap();
                    TBoardConstants.setColumn(attributeMap, currentColumn);
                    nested.put(currentCell, attributeMap);
                }
                ++lastColumn;
                ++currentColumn;
            }
            ++currentRow;
        }
        return nested;
    }

    public Map reorderColumns() {
        Hashtable<TGridCell, AttributeMap> nested = new Hashtable<TGridCell, AttributeMap>();
        int columns = this.getColumnsCount();
        int currentColumn = 1;
        while (currentColumn <= columns) {
            TGridCell currentCell;
            int currentRow = 1;
            int lastRow = 1;
            while ((currentCell = this.getFollowingColumnCell(currentColumn, lastRow)) != null) {
                lastRow = TBoardConstants.getRow(currentCell.getAttributes());
                if (lastRow != currentRow) {
                    AttributeMap attributeMap = new AttributeMap();
                    TBoardConstants.setRow(attributeMap, currentRow);
                    nested.put(currentCell, attributeMap);
                }
                ++lastRow;
                ++currentRow;
            }
            ++currentColumn;
        }
        return nested;
    }

    @Override
    public Node XMLEncode(Document doc) {
        Element componentElement = doc.createElement("component");
        componentElement.setAttribute("type", TYPE);
        AttributeMap map = (AttributeMap)this.getAttributes().clone();
        map.remove("browseable");
        map.remove("groupOpaque");
        componentElement.appendChild(TAttributeEncoder.XMLEncode(map, doc));
        int i2 = 0;
        while (i2 < this.getChildCount()) {
            componentElement.appendChild(((TComponent)this.getChildAt(i2)).XMLEncode(doc));
            ++i2;
        }
        return componentElement;
    }

    public static TGrid XMLDecode(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("component") && element.getAttribute("type").equals(TYPE)) {
            Hashtable<String, TGridCell> gridCellMap = new Hashtable<String, TGridCell>();
            NodeList componentNodeList = element.getElementsByTagName("component");
            TGridCell[] childrenList = new TGridCell[componentNodeList.getLength()];
            int i2 = 0;
            while (i2 < componentNodeList.getLength()) {
                Node boardNode = componentNodeList.item(i2);
                if (boardNode.getNodeType() == 1) {
                    TGridCell gridCell;
                    childrenList[i2] = gridCell = TGridCell.XMLDecode((Element)boardNode);
                }
                ++i2;
            }
            TGrid grid = new TGrid(childrenList);
            Node attributesNode = element.getElementsByTagName("attributes").item(0);
            AttributeMap attributes = TAttributeEncoder.XMLDecode((Element)attributesNode);
            grid.getAttributes().applyMap(attributes);
            if (attributes == null) {
                throw new InvalidFormatException();
            }
            int i3 = 0;
            while (i3 < grid.getChildCount()) {
                TGridCell gridCell = (TGridCell)grid.getChildAt(i3);
                gridCellMap.put(gridCell.getId(), gridCell);
                ++i3;
            }
            ArrayList idOrderedList = TBoardConstants.getOrderedCellList(attributes);
            ArrayList componentOrderedList = new ArrayList();
            int i4 = 0;
            while (i4 < idOrderedList.size()) {
                componentOrderedList.add(gridCellMap.get(idOrderedList.get(i4)));
                ++i4;
            }
            TBoardConstants.setOrderedCellList(attributes, componentOrderedList);
            grid.getAttributes().applyMap(attributes);
            return grid;
        }
        return null;
    }
}

