/*
 * Decompiled with CFR 0.152.
 */
package tico.board.components;

import org.jgraph.graph.DefaultGraphCell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tico.board.TBoardConstants;
import tico.board.components.TCell;
import tico.board.components.TControllerCell;
import tico.board.components.TGrid;
import tico.board.components.TLabel;
import tico.board.components.TLine;
import tico.board.components.TOval;
import tico.board.components.TRectangle;
import tico.board.components.TRoundRect;
import tico.board.components.TTextArea;
import tico.board.encoding.InvalidFormatException;

public abstract class TComponent
extends DefaultGraphCell {
    public abstract String newId();

    public TComponent() {
    }

    public TComponent(String id) {
        TBoardConstants.setId(this.getAttributes(), id);
    }

    public TComponent(TComponent[] childs) {
        super(null, null, childs);
    }

    public TComponent(String id, TComponent[] childs) {
        super(null, null, childs);
        TBoardConstants.setId(this.getAttributes(), id);
    }

    public String getId() {
        return TBoardConstants.getId(this.getAttributes());
    }

    @Override
    public String toString() {
        return this.getId();
    }

    public abstract Node XMLEncode(Document var1);

    public static TComponent XMLDecodeType(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("component")) {
            String type = element.getAttribute("type");
            if (type.equals(TCell.TYPE)) {
                return TCell.XMLDecode(element);
            }
            if (type.equals(TControllerCell.TYPE)) {
                return TControllerCell.XMLDecode(element);
            }
            if (type.equals(TGrid.TYPE)) {
                return TGrid.XMLDecode(element);
            }
            if (type.equals(TLabel.TYPE)) {
                return TLabel.XMLDecode(element);
            }
            if (type.equals(TLine.TYPE)) {
                return TLine.XMLDecode(element);
            }
            if (type.equals(TOval.TYPE)) {
                return TOval.XMLDecode(element);
            }
            if (type.equals(TRectangle.TYPE)) {
                return TRectangle.XMLDecode(element);
            }
            if (type.equals(TRoundRect.TYPE)) {
                return TRoundRect.XMLDecode(element);
            }
            if (type.equals(TTextArea.TYPE)) {
                return TTextArea.XMLDecode(element);
            }
        }
        return null;
    }
}

