/*
 * Decompiled with CFR 0.152.
 */
package tico.board.componentredenerer;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import tico.board.TBoardConstants;
import tico.board.componentredenerer.TComponentRenderer;
import tico.board.components.TComponent;
import tico.editor.TEditor;

public class TTextAreaRenderer
extends TComponentRenderer {
    protected transient String id = "";
    protected transient int borderWidth;
    protected transient int verticalAlignment;
    protected transient int horizontalAlignment;
    protected transient int height;
    protected transient int width;

    @Override
    protected void installAttributes(CellView view) {
        AttributeMap map = view.getAllAttributes();
        this.id = ((TComponent)view.getCell()).getId();
        this.height = (int)TBoardConstants.getBounds(map).getHeight();
        this.width = (int)TBoardConstants.getBounds(map).getWidth();
        this.setText("");
        Color borderColor = TBoardConstants.getBorderColor(map);
        if (borderColor != null) {
            this.borderWidth = Math.max(1, Math.round(TBoardConstants.getLineWidth(map)));
            this.setBorder(BorderFactory.createLineBorder(borderColor, this.borderWidth));
        } else {
            this.borderWidth = 0;
            this.setBorder(null);
        }
        Color backgroundColor = TBoardConstants.getBackground(map);
        this.setBackground(backgroundColor);
        this.setOpaque(backgroundColor != null);
        this.setGradientColor(TBoardConstants.getGradientColor(map));
        Font font = TBoardConstants.getFont(map);
        if (font == null) {
            font = TBoardConstants.DEFAULTFONT;
        }
        if (TEditor.get_android_mode()) {
            font = new Font("Droid Sans", font.getStyle(), font.getSize());
        }
        this.setFont(font);
        Color foregroundColor = TBoardConstants.getForeground(map);
        this.setForeground(foregroundColor != null ? foregroundColor : TBoardConstants.DEFAULT_FOREGROUND);
        String htmlBegin = "<html><body>";
        String htmlEnd = "</p></body></html>";
        this.verticalAlignment = TBoardConstants.getVerticalAlignment(map);
        this.horizontalAlignment = TBoardConstants.getHorizontalAlignment(map);
        this.setHorizontalAlignment(this.horizontalAlignment);
        this.setVerticalAlignment(this.verticalAlignment);
        switch (TBoardConstants.getHorizontalAlignment(map)) {
            case 0: {
                htmlBegin = String.valueOf(htmlBegin) + "<p align='center'>";
                htmlEnd = "</p>";
                break;
            }
            case 4: {
                htmlBegin = String.valueOf(htmlBegin) + "<p align='right'>";
                htmlEnd = "&nbsp;</p>";
            }
        }
        String text = TBoardConstants.getText(map);
        if (text == null) {
            text = "";
        }
        this.setText(String.valueOf(htmlBegin) + text + htmlEnd);
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.getGradientColor() != null && this.isOpaque()) {
            this.setOpaque(false);
            g22.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.getGradientColor(), true));
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g2);
        if (this.id != null) {
            int topIdPosition = this.verticalAlignment != 3 ? this.height - (6 + this.borderWidth) : 14 + this.borderWidth;
            int leftIdPosition = this.horizontalAlignment != 2 ? 6 + this.borderWidth : this.width - (6 + this.borderWidth) - g2.getFontMetrics(ID_FONT).stringWidth(this.id);
            g22.setFont(ID_FONT);
            if (this.getBackground() != Color.BLACK) {
                g22.setColor(Color.BLACK);
            } else {
                g22.setColor(Color.WHITE);
            }
            g22.drawString(this.id, leftIdPosition, topIdPosition);
        }
    }
}

