/*
 * Decompiled with CFR 0.152.
 */
package tico.board.componentredenerer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import tico.board.TBoardConstants;
import tico.board.componentredenerer.TComponentRenderer;
import tico.board.componentview.TRoundRectView;

public class TRoundRectRenderer
extends TComponentRenderer {
    protected transient Color gradientColor;
    protected transient Color backgroundColor;
    protected transient Color borderColor;
    protected transient int borderWidth;

    @Override
    protected void installAttributes(CellView view) {
        AttributeMap map = view.getAllAttributes();
        this.borderColor = TBoardConstants.getBorderColor(map);
        this.borderWidth = this.borderColor != null ? Math.max(1, Math.round(TBoardConstants.getLineWidth(map))) : 0;
        this.backgroundColor = TBoardConstants.getBackground(map);
        this.setOpaque(this.backgroundColor != null);
        this.gradientColor = TBoardConstants.getGradientColor(map);
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        Dimension dimension = this.getSize();
        boolean tmp = this.selected;
        int roundRectArc = TRoundRectView.getArcSize(dimension.width - this.borderWidth, dimension.height - this.borderWidth);
        if (this.isOpaque()) {
            g2.setColor(this.backgroundColor);
            if (this.gradientColor != null) {
                this.setOpaque(false);
                g22.setPaint(new GradientPaint(0.0f, 0.0f, this.backgroundColor, this.getWidth(), this.getHeight(), this.gradientColor, true));
            }
            g2.fillRoundRect(this.borderWidth - 1, this.borderWidth - 1, dimension.width - 2 * this.borderWidth, dimension.height - 2 * this.borderWidth, roundRectArc, roundRectArc);
        }
        try {
            this.setBorder(null);
            this.setOpaque(false);
            this.selected = false;
            super.paint(g2);
        }
        finally {
            this.selected = tmp;
        }
        if (this.borderColor != null) {
            g2.setColor(this.borderColor);
            g22.setStroke(new BasicStroke(this.borderWidth));
            g2.drawRoundRect(this.borderWidth - 1, this.borderWidth - 1, dimension.width - 2 * this.borderWidth, dimension.height - 2 * this.borderWidth, roundRectArc, roundRectArc);
        }
        if (this.selected) {
            g22.setStroke(GraphConstants.SELECTION_STROKE);
            g2.setColor(this.highlightColor);
            g2.drawRoundRect(this.borderWidth / 2, this.borderWidth / 2, dimension.width - this.borderWidth - 1, dimension.height - this.borderWidth - 1, roundRectArc, roundRectArc);
        }
    }
}

