/*
 * Decompiled with CFR 0.152.
 */
package tico.board.componentredenerer;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import tico.board.TBoardConstants;
import tico.board.componentredenerer.TComponentRenderer;

public class TRectangleRenderer
extends TComponentRenderer {
    @Override
    protected void installAttributes(CellView view) {
        AttributeMap map = view.getAllAttributes();
        Color borderColor = TBoardConstants.getBorderColor(map);
        if (borderColor != null) {
            int borderWidth = Math.max(1, Math.round(TBoardConstants.getLineWidth(map)));
            this.setBorder(BorderFactory.createLineBorder(borderColor, borderWidth));
        } else {
            this.setBorder(null);
        }
        Color backgroundColor = TBoardConstants.getBackground(map);
        this.setBackground(backgroundColor);
        this.setOpaque(backgroundColor != null);
        this.setGradientColor(TBoardConstants.getGradientColor(map));
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.getGradientColor() != null && this.isOpaque()) {
            this.setOpaque(false);
            g22.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.getGradientColor(), true));
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g2);
    }
}

