/*
 * Decompiled with CFR 0.152.
 */
package tico.board.componentredenerer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.GraphConstants;
import tico.board.TBoardConstants;
import tico.board.componentredenerer.TComponentRenderer;

public class TLineRenderer
extends TComponentRenderer {
    protected transient Color borderColor;
    protected transient int lineWidth;
    protected transient int startCorner;

    @Override
    protected void installAttributes(CellView view) {
        AttributeMap map = view.getAllAttributes();
        this.startCorner = TBoardConstants.getStartCorner(map);
        this.borderColor = TBoardConstants.getBorderColor(map);
        if (this.borderColor == null) {
            this.borderColor = TBoardConstants.DEFAULT_FOREGROUND;
        }
        this.lineWidth = Math.max(1, Math.round(TBoardConstants.getLineWidth(map)));
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        boolean tmp = this.selected;
        try {
            this.setBorder(null);
            this.setOpaque(false);
            this.selected = false;
            super.paint(g2);
        }
        finally {
            this.selected = tmp;
        }
        if (this.borderColor != null) {
            g22.setStroke(new BasicStroke(this.lineWidth));
            g2.setColor(this.borderColor);
            this.drawThisLine(g2);
        }
        if (this.selected) {
            g22.setStroke(GraphConstants.SELECTION_STROKE);
            g2.setColor(this.getHighlightColor());
            this.drawThisLine(g2);
        }
    }

    private void drawThisLine(Graphics g2) {
        Dimension dimension = this.getSize();
        switch (this.startCorner) {
            case 0: {
                g2.drawLine(this.lineWidth / 2, this.lineWidth / 2, dimension.width - this.lineWidth / 2, dimension.height - this.lineWidth / 2);
                break;
            }
            case 2: {
                g2.drawLine(dimension.width - this.lineWidth / 2, this.lineWidth / 2, this.lineWidth / 2, dimension.height - this.lineWidth / 2);
                break;
            }
            case 5: {
                g2.drawLine(this.lineWidth / 2, dimension.height - this.lineWidth / 2, dimension.width - this.lineWidth / 2, this.lineWidth / 2);
                break;
            }
            case 7: {
                g2.drawLine(dimension.width - this.lineWidth / 2, dimension.height - this.lineWidth / 2, this.lineWidth / 2, this.lineWidth / 2);
            }
        }
    }
}

