/*
 * Decompiled with CFR 0.152.
 */
package tico.board.componentredenerer;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.board.componentredenerer.TComponentRenderer;
import tico.editor.TEditor;

public class TLabelRenderer
extends TComponentRenderer {
    private static final int HORIZONTAL_MARGIN = 10;

    @Override
    protected void installAttributes(CellView view) {
        AttributeMap map = view.getAllAttributes();
        int borderWidth = 0;
        Color borderColor = TBoardConstants.getBorderColor(map);
        if (borderColor != null) {
            borderWidth = Math.max(1, Math.round(TBoardConstants.getLineWidth(map)));
            this.setBorder(BorderFactory.createLineBorder(borderColor, borderWidth));
        } else {
            this.setBorder(null);
        }
        Color backgroundColor = TBoardConstants.getBackground(map);
        this.setBackground(backgroundColor);
        this.setOpaque(backgroundColor != null);
        this.setGradientColor(TBoardConstants.getGradientColor(map));
        Font font = TBoardConstants.getFont(map);
        if (font == null) {
            font = TBoardConstants.DEFAULTFONT;
        }
        if (TEditor.get_android_mode()) {
            font = new Font("Droid Sans", font.getStyle(), font.getSize());
        }
        this.setFont(font);
        Color foregroundColor = TBoardConstants.getForeground(map);
        this.setForeground(foregroundColor != null ? foregroundColor : TBoardConstants.DEFAULT_FOREGROUND);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        String text = TBoardConstants.getText(map);
        if (text == null) {
            text = "";
        }
        this.setText(text);
        if (!TEditor.get_android_mode()) {
            TBoardConstants.setBounds(map, TBoardModel.computeNewBounds(TBoardConstants.getBounds(map), TBoardConstants.getText(map), TBoardConstants.getFont(map), Math.max(1, Math.round(TBoardConstants.getLineWidth(map)))));
        } else {
            font = new Font("Droid Sans", font.getStyle(), font.getSize());
            TBoardConstants.setBounds(map, TBoardModel.computeNewBounds(TBoardConstants.getBounds(map), TBoardConstants.getText(map), font, Math.max(1, Math.round(TBoardConstants.getLineWidth(map)))));
        }
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.getGradientColor() != null && this.isOpaque()) {
            this.setOpaque(false);
            g22.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.getGradientColor(), true));
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g2);
    }
}

