/*
 * Decompiled with CFR 0.152.
 */
package tico.board.componentredenerer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import tico.board.TBoardConstants;
import tico.board.componentredenerer.TComponentRenderer;
import tico.board.components.TComponent;
import tico.editor.TEditor;

public class TCellRenderer
extends TComponentRenderer {
    private static final int VERTICAL_ICON_MARGIN = 15;
    private static final int HORIZONTAL_ICON_MARGIN = 10;
    private static final int GAP_ICON_TEXT = 5;
    protected transient String id;
    protected transient int borderWidth;

    @Override
    protected void installAttributes(CellView view) {
        if (!TEditor.get_android_mode()) {
            this.installAttributesNormal(view);
        } else {
            this.installAttributesAndroid(view);
        }
    }

    @Override
    public void paint(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        if (this.getGradientColor() != null && this.isOpaque()) {
            this.setOpaque(false);
            g22.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.getGradientColor(), true));
            g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paint(g2);
        if (this.id != null) {
            g22.setFont(ID_FONT);
            if (this.getBackground() != Color.BLACK) {
                g22.setColor(Color.BLACK);
            } else {
                g22.setColor(Color.WHITE);
            }
            g22.drawString(this.id, 6 + this.borderWidth, 14 + this.borderWidth);
        }
    }

    protected void installAttributesNormal(CellView view) {
        ImageIcon icon;
        AttributeMap map = view.getAllAttributes();
        this.id = ((TComponent)view.getCell()).getId();
        Color borderColor = TBoardConstants.getBorderColor(map);
        if (borderColor != null) {
            this.borderWidth = Math.max(1, Math.round(TBoardConstants.getLineWidth(map)));
            this.setBorder(BorderFactory.createLineBorder(borderColor, this.borderWidth));
        } else {
            this.borderWidth = 0;
            this.setBorder(null);
        }
        Color backgroundColor = TBoardConstants.getBackground(map);
        this.setBackground(backgroundColor);
        this.setOpaque(backgroundColor != null);
        this.setGradientColor(TBoardConstants.getGradientColor(map));
        Font font = TBoardConstants.getFont(map);
        if (font == null) {
            font = TBoardConstants.DEFAULTFONT;
        }
        this.setFont(TBoardConstants.getFont(map));
        Color foregroundColor = TBoardConstants.getForeground(map);
        this.setForeground(foregroundColor != null ? foregroundColor : TBoardConstants.DEFAULT_FOREGROUND);
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.setVerticalTextPosition(TBoardConstants.getVerticalTextPosition(map));
        this.setHorizontalTextPosition(0);
        String text = TBoardConstants.getText(map);
        if (text == null) {
            text = "";
        }
        this.setText(text);
        int cellTextSpace = (int)TBoardConstants.getBounds(map).getWidth() - 2 * this.borderWidth - 20;
        JButton j2 = new JButton();
        j2.setSize(cellTextSpace, cellTextSpace);
        FontMetrics fm = j2.getFontMetrics(font);
        int textWidth = fm.stringWidth(text);
        if (textWidth > cellTextSpace) {
            int fontSize = font.getSize();
            int fontStyle = font.getStyle();
            String fontName = font.getFontName();
            while (textWidth > cellTextSpace && fontSize > 0) {
                font = new Font(fontName, fontStyle, --fontSize);
                fm = j2.getFontMetrics(font);
                textWidth = fm.stringWidth(text);
            }
            if (fontSize != 0) {
                this.setFont(font);
                this.setText(text);
            }
        }
        if ((icon = (ImageIcon)TBoardConstants.getIcon(map)) != null) {
            int textPosition = TBoardConstants.getVerticalTextPosition(map);
            int cellWidth = (int)TBoardConstants.getBounds(map).getWidth();
            int cellHeight = (int)TBoardConstants.getBounds(map).getHeight();
            int maxImageWidth = cellWidth - 2 * (this.borderWidth + 10);
            int maxImageHeight = cellHeight - 2 * (this.borderWidth + 15);
            if (textPosition != 0 && !text.equals("")) {
                this.setIconTextGap(5);
                maxImageWidth = cellWidth - 2 * (10 + this.borderWidth) - 5;
                maxImageHeight = cellHeight - 2 * (15 + this.borderWidth) - 5 - this.getFont().getSize();
            }
            if (icon.getIconHeight() > maxImageHeight) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(-1, maxImageHeight, 4));
            }
            if (icon.getIconWidth() > maxImageWidth) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
        }
        this.setIcon(icon);
    }

    protected void installAttributesAndroid(CellView view) {
        AttributeMap map = view.getAllAttributes();
        this.id = ((TComponent)view.getCell()).getId();
        Color borderColor = TBoardConstants.getBorderColor(map);
        if (borderColor != null) {
            this.borderWidth = Math.max(1, Math.round(TBoardConstants.getLineWidth(map)));
            this.setBorder(BorderFactory.createLineBorder(borderColor, this.borderWidth));
        } else {
            this.borderWidth = 0;
            this.setBorder(null);
        }
        Color backgroundColor = TBoardConstants.getBackground(map);
        this.setBackground(backgroundColor);
        this.setOpaque(backgroundColor != null);
        this.setGradientColor(TBoardConstants.getGradientColor(map));
        Font font = TBoardConstants.getFont(map);
        if (font == null) {
            font = TBoardConstants.DEFAULTFONT;
        }
        font = new Font("Droid Sans", font.getStyle(), font.getSize());
        this.setFont(font);
        Color foregroundColor = TBoardConstants.getForeground(map);
        this.setForeground(foregroundColor != null ? foregroundColor : TBoardConstants.DEFAULT_FOREGROUND);
        int textPosition = TBoardConstants.getVerticalTextPosition(map);
        if (textPosition == 1) {
            this.setVerticalAlignment(3);
        } else {
            this.setVerticalAlignment(1);
        }
        this.setHorizontalAlignment(0);
        this.setVerticalTextPosition(TBoardConstants.getVerticalTextPosition(map));
        this.setHorizontalTextPosition(0);
        String text = TBoardConstants.getText(map);
        if (text == null) {
            text = "";
        }
        this.setText(text);
        int cellTextSpace = (int)((double)((float)TBoardConstants.getBounds(map).getWidth() - (float)(2 * this.borderWidth)) * 0.9);
        JButton j2 = new JButton();
        j2.setSize(cellTextSpace, cellTextSpace);
        FontMetrics fm = j2.getFontMetrics(font);
        int textWidth = fm.stringWidth(text);
        if (textWidth > cellTextSpace) {
            int fontSize = font.getSize();
            int fontStyle = font.getStyle();
            String fontName = font.getFontName();
            while (textWidth > cellTextSpace && fontSize > 0) {
                font = new Font(fontName, fontStyle, --fontSize);
                fm = j2.getFontMetrics(font);
                textWidth = fm.stringWidth(text);
            }
            if (fontSize != 0) {
                this.setFont(font);
                this.setText(text);
            }
        }
        int cellWidth = (int)TBoardConstants.getBounds(map).getWidth();
        int cellHeight = (int)TBoardConstants.getBounds(map).getHeight();
        ImageIcon icon = (ImageIcon)TBoardConstants.getIcon(map);
        if (icon != null) {
            int maxImageWidth = cellWidth - 2 * this.borderWidth;
            int maxImageHeight = cellHeight - 2 * this.borderWidth;
            if ((icon = new ImageIcon(icon.getImage().getScaledInstance(-1, maxImageHeight, 4))).getIconWidth() > maxImageWidth) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(maxImageWidth, -1, 4));
            }
            this.setIconTextGap(cellHeight - 2 * this.borderWidth - fm.getHeight() - icon.getIconHeight());
        } else if (textPosition == 3) {
            this.setVerticalAlignment(3);
        }
        this.setIcon(icon);
    }
}

