/*
 * Decompiled with CFR 0.152.
 */
package tico.board;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;
import tico.board.components.TComponent;
import tico.board.encoding.InvalidFormatException;
import tico.board.events.BoardChangeEvent;
import tico.board.events.BoardChangeListener;
import tico.board.events.ProjectChangeEvent;
import tico.board.events.ProjectChangeListener;
import tico.editor.TBoardContainer;
import tico.editor.TEditor;

public class TProject {
    private static int projectCount = 0;
    private ArrayList boardList;
    private Hashtable boardTable;
    private TBoard initialBoard;
    private String name = null;
    private String defaultVoiceName = "";
    private int synthMode = 0;
    protected transient EventListenerList listenerList = new EventListenerList();

    public TProject() {
        this.boardList = new ArrayList();
        this.boardTable = new Hashtable();
    }

    public TProject(String name) {
        this();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireProjectChange(null, ProjectChangeEvent.NAME_CHANGED);
    }

    public static String newName() {
        return "project_" + projectCount++;
    }

    public void addBoard(TBoard board) {
        String boardName = board.getBoardName();
        if (boardName == null) {
            board.setBoardName(TBoard.newBoardName());
            boardName = board.getBoardName();
        }
        int boardCounter = 1;
        while (this.isUsedName(board.getBoardName())) {
            if (board.getBoardName().startsWith("board_")) {
                board.setBoardName(TBoard.newBoardName());
                continue;
            }
            board.setBoardName(String.valueOf(boardName) + "_" + boardCounter++);
        }
        board.addBoardChangeListener(new BoardChangeListener(){

            @Override
            public void boardChanged(BoardChangeEvent e2) {
                TProject.this.fireProjectChange((TBoard)e2.getSource(), ProjectChangeEvent.BOARD_MODIFIED);
            }
        });
        this.boardList.add(board);
        this.boardTable.put(board.getBoardName(), board);
        if (this.initialBoard == null) {
            this.setInitialBoard(board);
        }
        this.fireProjectChange(board, ProjectChangeEvent.BOARD_ADDED);
    }

    public void addProject(TProject project) {
        ArrayList boardList = project.getBoardList();
        int i2 = 0;
        while (i2 < boardList.size()) {
            this.addBoard((TBoard)boardList.get(i2));
            ++i2;
        }
    }

    public void removeBoard(TBoard board) {
        this.fireProjectChange(board, ProjectChangeEvent.BOARD_REMOVED);
        this.boardTable.remove(board.getBoardName());
        this.boardList.remove(board);
        ArrayList list = this.getBoardList();
        int i2 = 0;
        while (i2 < list.size()) {
            ((TBoardModel)((TBoard)list.get(i2)).getModel()).deleteBoardFromAttributes(board);
            ++i2;
        }
    }

    public int getBoardCount() {
        return this.boardList.size();
    }

    public TBoard getBoard(String name) {
        return (TBoard)this.boardTable.get(name);
    }

    public TBoard getBoard(int index) {
        return (TBoard)this.boardList.get(index);
    }

    public TBoard getInitialBoard() {
        return this.initialBoard;
    }

    public void setInitialBoard(TBoard initialBoard) {
        if (!this.boardList.contains(initialBoard)) {
            this.addBoard(initialBoard);
        }
        this.initialBoard = initialBoard;
        this.fireProjectChange(null, ProjectChangeEvent.INITIAL_BOARD_CHANGED);
    }

    public int getDefaultSynthMode() {
        return this.synthMode;
    }

    public void setDefaultSynthMode(int value) {
        this.synthMode = value;
    }

    public String getDefaultVoiceName() {
        return this.defaultVoiceName;
    }

    public void setDefaultVoiceName(String voiceName) {
        this.defaultVoiceName = voiceName;
    }

    public boolean isUsedName(String name) {
        boolean used = false;
        int i2 = 0;
        while (i2 < this.boardList.size() && !used) {
            used = ((TBoard)this.boardList.get(i2)).getBoardName().equals(name);
            ++i2;
        }
        return used;
    }

    public boolean isRepeatedName(TBoard board, String name) {
        boolean isRepeated = false;
        int i2 = 0;
        String nameBoard = board.getBoardName();
        while (i2 < this.boardList.size() && !isRepeated) {
            if (!((TBoard)this.boardList.get(i2)).getBoardName().equals(nameBoard)) {
                isRepeated = ((TBoard)this.boardList.get(i2)).getBoardName().equals(name);
            }
            ++i2;
        }
        return isRepeated;
    }

    public ArrayList getBoardList() {
        return (ArrayList)this.boardList.clone();
    }

    public void setBoardList(ArrayList newBoardList) {
        this.boardList.clear();
        int i2 = 0;
        while (i2 < newBoardList.size()) {
            this.boardList.add(((TBoardContainer)newBoardList.get(i2)).getBoard());
            ++i2;
        }
    }

    private void fireProjectChange(TBoard changedBoard, int change) {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == ProjectChangeListener.class) {
                ((ProjectChangeListener)listeners[i2 + 1]).projectChanged(new ProjectChangeEvent(this, changedBoard, change));
            }
            i2 -= 2;
        }
    }

    public void addProjectChangeListener(ProjectChangeListener listener) {
        this.listenerList.add(ProjectChangeListener.class, listener);
    }

    public void removeProjectChangeListener(ProjectChangeListener listener) {
        this.listenerList.remove(ProjectChangeListener.class, listener);
    }

    public Element XMLEncode(Document doc) {
        Element projectElement = doc.createElement("project");
        projectElement.setAttribute("name", this.getName());
        Element voice = doc.createElement("voice");
        voice.setAttribute("defaultVoiceName", this.getDefaultVoiceName());
        voice.setAttribute("defaultSynthMode", String.valueOf(this.getDefaultSynthMode()));
        projectElement.appendChild(voice);
        if (TEditor.get_android_mode() && !TEditor.get_android_orientation().equals("free")) {
            projectElement.setAttribute("orientation", TEditor.get_android_orientation());
        }
        Element boardElement = doc.createElement("initial_board");
        boardElement.appendChild(doc.createTextNode(this.getInitialBoard().toString()));
        projectElement.appendChild(boardElement);
        int i2 = 0;
        while (i2 < this.boardList.size()) {
            projectElement.appendChild(this.getBoard(i2).XMLEncode(doc));
            ++i2;
        }
        return projectElement;
    }

    public static TProject XMLDecode(Element element) throws InvalidFormatException {
        return TProject.XMLDecode(element, "");
    }

    public static TProject XMLDecode(Element element, String projectName) throws InvalidFormatException {
        String initialBoardName = null;
        String defaultVoiceName = "";
        int defaultSynthMode = 0;
        if (element.getTagName().equals("project")) {
            TProject project = new TProject();
            if (projectName != "") {
                project.setName(projectName);
            } else if (element.hasAttribute("name")) {
                project.setName(element.getAttribute("name"));
            }
            if (element.hasAttribute("orientation")) {
                TEditor.set_android_orientation(element.getAttribute("orientation"));
            } else {
                TEditor.set_android_orientation("free");
            }
            NodeList childNodes = element.getChildNodes();
            int i2 = 0;
            while (i2 < childNodes.getLength()) {
                String tagName = childNodes.item(i2).getNodeName();
                if (tagName.equals("board")) {
                    project.addBoard(TBoard.XMLDecode((Element)childNodes.item(i2)));
                } else if (tagName.equals("initial_board")) {
                    initialBoardName = childNodes.item(i2).getChildNodes().item(0).getNodeValue();
                } else if (tagName.equals("voice")) {
                    defaultVoiceName = childNodes.item(i2).getAttributes().getNamedItem("defaultVoiceName").getTextContent();
                    try {
                        defaultSynthMode = Integer.parseInt(childNodes.item(i2).getAttributes().getNamedItem("defaultSynthMode").getTextContent());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                ++i2;
            }
            Vector<TComponent> followingBoardComponents = new Vector<TComponent>();
            int i3 = 0;
            while (i3 < project.getBoardCount()) {
                TBoardModel boardModel = (TBoardModel)project.getBoard(i3).getModel();
                int j2 = 0;
                while (j2 < boardModel.getRootCount()) {
                    TComponent component = (TComponent)boardModel.getRootAt(j2);
                    if (component.getAttributes().containsKey("followingBoard")) {
                        followingBoardComponents.add(component);
                    }
                    int k2 = 0;
                    while (k2 < component.getChildCount()) {
                        TComponent childComponent = (TComponent)component.getChildAt(k2);
                        if (childComponent.getAttributes().containsKey("followingBoard")) {
                            followingBoardComponents.add(childComponent);
                        }
                        ++k2;
                    }
                    ++j2;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < followingBoardComponents.size()) {
                TComponent component = (TComponent)followingBoardComponents.get(i3);
                TBoard followingBoard = project.getBoard((String)component.getAttributes().get("followingBoard"));
                if (followingBoard != null) {
                    TBoardConstants.setFollowingBoard(component.getAttributes(), followingBoard.getBoardName());
                } else {
                    new InvalidFormatException();
                }
                ++i3;
            }
            project.setInitialBoard(project.getBoard(initialBoardName));
            project.setDefaultVoiceName(defaultVoiceName);
            project.setDefaultSynthMode(defaultSynthMode);
            return project;
        }
        throw new InvalidFormatException();
    }
}

