/*
 * Decompiled with CFR 0.152.
 */
package tico.board;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jgraph.plaf.basic.BasicGraphUI;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.TBoardModel;

public class TBoardUI
extends BasicGraphUI {
    protected TBoard getBoard() {
        return (TBoard)this.graph;
    }

    @Override
    protected void paintBackground(Graphics g2) {
        ImageIcon image;
        Map map = ((TBoardModel)this.getBoard().getModel()).getAttributes();
        Dimension size = TBoardConstants.getSize(map);
        int width = size.width;
        int height = size.height;
        double s2 = this.graph.getScale();
        Graphics2D g22 = (Graphics2D)g2;
        AffineTransform tmp = g22.getTransform();
        g22.scale(s2, s2);
        g2.setColor(TBoard.DEFAULT_BORDER_COLOR);
        g2.drawRect(-1, -1, width + 1, height + 1);
        Color backgroundColor = TBoardConstants.getBackground(map);
        Color gradientColor = TBoardConstants.getGradientColor(map);
        if (backgroundColor != null) {
            g2.setColor(backgroundColor);
            g2.fillRect(0, 0, width, height);
            if (gradientColor != null) {
                g22.setPaint(new GradientPaint(0.0f, 0.0f, backgroundColor, width, height, gradientColor, true));
                g22.fillRect(0, 0, width, height);
            }
        }
        if ((image = (ImageIcon)TBoardConstants.getIcon(map)) != null) {
            int imageWidth = image.getIconWidth();
            int imageHeight = image.getIconHeight();
            switch (TBoardConstants.getImageResizeStyle(map)) {
                case 0: {
                    image = new ImageIcon(image.getImage().getScaledInstance(width, height, 4));
                    break;
                }
                case 1: {
                    image = new ImageIcon(image.getImage().getScaledInstance(width, -1, 4));
                    if (image.getIconHeight() <= height) break;
                    image = new ImageIcon(image.getImage().getScaledInstance(-1, height, 4));
                    break;
                }
                case 2: {
                    if (imageHeight > height) {
                        image = new ImageIcon(image.getImage().getScaledInstance(-1, height, 4));
                    }
                    if (imageWidth <= width) break;
                    image = new ImageIcon(image.getImage().getScaledInstance(width, -1, 4));
                }
            }
            imageWidth = image.getIconWidth();
            imageHeight = image.getIconHeight();
            image.paintIcon(this.getBoard(), g2, (width - imageWidth) / 2, (height - imageHeight) / 2);
        }
        g22.setTransform(tmp);
        super.paintBackground(g2);
    }
}

