/*
 * Decompiled with CFR 0.152.
 */
package tico.board;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.undo.UndoableEdit;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tico.board.TBoard;
import tico.board.TBoardConstants;
import tico.board.components.TComponent;
import tico.board.components.TGrid;
import tico.board.components.TGridCell;
import tico.board.encoding.InvalidFormatException;
import tico.board.encoding.TAttributeEncoder;
import tico.components.resources.TFileUtils;
import tico.editor.TEditor;
import tico.editor.TFileHandler;

public class TBoardModel
extends DefaultGraphModel {
    private static final int HORIZONTAL_FIT_TEXT_MARGIN = 6;
    private static final int VERTICAL_FIT_TEXT_MARGIN = 4;

    public TBoardModel() {
        this(null, TBoardModel.defaultAttributes());
    }

    public TBoardModel(List roots) {
        this(roots, TBoardModel.defaultAttributes());
    }

    public TBoardModel(AttributeMap attributes) {
        this(null, attributes);
    }

    public TBoardModel(List roots, AttributeMap attributes) {
        super(roots, attributes);
    }

    private static AttributeMap defaultAttributes() {
        AttributeMap defaultAttributes = new AttributeMap();
        TBoardConstants.setBackground(defaultAttributes, TEditor.get_board_background_color());
        if (TEditor.get_board_gradient_color() != null) {
            TBoardConstants.setGradientColor(defaultAttributes, TEditor.get_board_gradient_color());
        }
        TBoardConstants.setSize(defaultAttributes, new Dimension(TEditor.get_board_width(), TEditor.get_board_height()));
        TBoardConstants.setUnorderedCellList(defaultAttributes, new ArrayList());
        TBoardConstants.setOrderedCellList(defaultAttributes, new ArrayList());
        return defaultAttributes;
    }

    @Override
    public Object getSource(Object edge) {
        return null;
    }

    @Override
    public Object getTarget(Object edge) {
        return null;
    }

    @Override
    public boolean acceptsSource(Object edge, Object port) {
        return false;
    }

    @Override
    public boolean acceptsTarget(Object edge, Object port) {
        return false;
    }

    @Override
    public AttributeMap getAttributes(Object node) {
        if (node == null || node instanceof GraphModel) {
            return super.getAttributes(null);
        }
        return super.getAttributes(node);
    }

    @Override
    public void insert(Object[] inserted, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        if (attributes == null) {
            attributes = new Hashtable();
        }
        if (inserted != null) {
            int i2 = 0;
            while (i2 < inserted.length) {
                boolean repeated = false;
                int j2 = 0;
                while (j2 < i2) {
                    if (inserted[i2] == inserted[j2]) {
                        repeated = true;
                    }
                    ++j2;
                }
                if (!repeated) {
                    TComponent newComponent = (TComponent)inserted[i2];
                    Map attributeMap = (Map)attributes.get(newComponent);
                    if (attributeMap == null) {
                        attributeMap = new AttributeMap();
                    } else {
                        attributeMap = (Map)((AttributeMap)attributeMap).clone();
                        attributes.remove(newComponent);
                    }
                    attributes.putAll(this.insertUpdateAttributes(newComponent, attributeMap, attributes));
                }
                ++i2;
            }
        }
        if (pm != null) {
            Iterator pmIterator = pm.entries();
            while (pmIterator.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)pmIterator.next();
                if (!(entry.getParent() instanceof TGrid) || !(entry.getChild() instanceof TGridCell)) continue;
                Map attributeMap = (Map)attributes.get(entry.getParent());
                if (attributeMap == null) {
                    attributeMap = new AttributeMap();
                } else {
                    attributeMap = (Map)((AttributeMap)attributeMap).clone();
                    attributes.remove(entry.getParent());
                }
                attributes.putAll(this.parentUpdateAttributes((TGridCell)entry.getChild(), (TGrid)entry.getParent(), attributeMap));
            }
        }
        super.insert(inserted, attributes, cs, pm, edits);
    }

    @Override
    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        if (attributes == null) {
            attributes = new Hashtable();
        }
        Iterator componentIterator = attributes.entrySet().iterator();
        Hashtable newAttributes = new Hashtable();
        while (componentIterator.hasNext()) {
            Map.Entry entry = componentIterator.next();
            if (!(entry.getKey() instanceof TComponent)) continue;
            TComponent component = (TComponent)entry.getKey();
            Map attributeMap = (Map)attributes.get(component);
            if (attributeMap == null) {
                attributeMap = new AttributeMap();
            }
            newAttributes.putAll(this.editUpdateAttributes(component, attributeMap));
        }
        attributes.putAll(newAttributes);
        super.edit(attributes, cs, pm, edits);
    }

    @Override
    public void remove(Object[] removed) {
        DefaultGraphModel.GraphModelEdit removeEdit;
        Hashtable attributes = new Hashtable();
        if (removed != null) {
            int i2 = 0;
            while (i2 < removed.length) {
                TComponent component = (TComponent)removed[i2];
                Map attributeMap = (Map)attributes.get(component);
                if (attributeMap == null) {
                    attributeMap = new AttributeMap();
                } else {
                    attributes.remove(component);
                }
                attributes.putAll(this.removeUpdateAttributes(component, attributes));
                ++i2;
            }
        }
        if ((removeEdit = this.createRemoveEdit(removed)) != null) {
            removeEdit.execute();
        }
        this.edit(attributes, null, null, new UndoableEdit[]{removeEdit});
    }

    @Override
    public void edit(Object[] inserted, Object[] removed, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] edits) {
        Map attributeMap;
        TComponent component;
        if (attributes == null) {
            attributes = new Hashtable();
        }
        if (inserted != null) {
            int i2 = 0;
            while (i2 < inserted.length) {
                TComponent newComponent = (TComponent)inserted[i2];
                Map attributeMap2 = (Map)attributes.get(newComponent);
                if (attributeMap2 == null) {
                    attributeMap2 = new AttributeMap();
                } else {
                    attributeMap2 = (Map)((AttributeMap)attributeMap2).clone();
                    attributes.remove(newComponent);
                }
                attributes.putAll(this.insertUpdateAttributes(newComponent, attributeMap2, attributes));
                ++i2;
            }
        }
        Iterator componentIterator = attributes.entrySet().iterator();
        Hashtable newAttributes = new Hashtable();
        while (componentIterator.hasNext()) {
            Map.Entry entry = componentIterator.next();
            if (!(entry.getKey() instanceof TComponent)) continue;
            component = (TComponent)entry.getKey();
            attributeMap = (Map)attributes.get(component);
            if (attributeMap == null) {
                attributeMap = new AttributeMap();
            }
            newAttributes.putAll(this.editUpdateAttributes(component, attributeMap));
        }
        attributes.putAll(newAttributes);
        if (pm != null) {
            Iterator pmIterator = pm.entries();
            while (pmIterator.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)pmIterator.next();
                if (!(entry.getParent() instanceof TGrid) || !(entry.getChild() instanceof TGridCell)) continue;
                attributeMap = (Map)attributes.get(entry.getParent());
                if (attributeMap == null) {
                    attributeMap = new AttributeMap();
                } else {
                    attributeMap = (Map)((AttributeMap)attributeMap).clone();
                    attributes.remove(entry.getParent());
                }
                attributes.putAll(this.parentUpdateAttributes((TGridCell)entry.getChild(), (TGrid)entry.getParent(), attributeMap));
            }
        }
        if (removed != null) {
            int i3 = 0;
            while (i3 < removed.length) {
                component = (TComponent)removed[i3];
                attributeMap = (Map)attributes.get(component);
                if (attributeMap == null) {
                    attributeMap = new AttributeMap();
                } else {
                    attributes.remove(component);
                }
                attributes.putAll(this.removeUpdateAttributes(component, attributes));
                ++i3;
            }
        }
        super.edit(inserted, removed, attributes, cs, pm, edits);
    }

    public void editAndRemove(Map attributes, Object[] removed) {
        DefaultGraphModel.GraphModelEdit removeEdit;
        if (removed != null) {
            int i2 = 0;
            while (i2 < removed.length) {
                TComponent component = (TComponent)removed[i2];
                Map attributeMap = (Map)attributes.get(component);
                if (attributeMap == null) {
                    attributeMap = new AttributeMap();
                } else {
                    attributes.remove(component);
                }
                attributes.putAll(this.removeUpdateAttributes(component, attributes));
                ++i2;
            }
        }
        if ((removeEdit = this.createRemoveEdit(removed)) != null) {
            removeEdit.execute();
        }
        this.edit(attributes, null, null, new UndoableEdit[]{removeEdit});
    }

    public void removeInsertAndEdit(Object[] insert, Object[] removed, Map attributes) {
        DefaultGraphModel.GraphModelEdit removeEdit;
        if (removed != null) {
            int i2 = 0;
            while (i2 < removed.length) {
                TComponent component = (TComponent)removed[i2];
                Map attributeMap = (Map)attributes.get(component);
                if (attributeMap == null) {
                    attributeMap = new AttributeMap();
                } else {
                    attributes.remove(component);
                }
                attributes.putAll(this.removeUpdateAttributes(component, attributes));
                ++i2;
            }
        }
        if ((removeEdit = this.createRemoveEdit(removed)) != null) {
            removeEdit.execute();
        }
        this.edit(insert, null, attributes, null, null, new UndoableEdit[]{removeEdit});
    }

    private Map insertUpdateAttributes(TComponent component, Map attributeMap, Map attributes) {
        String videoFilePath;
        String soundFilePath;
        ImageIcon alternativeIcon;
        ImageIcon icon;
        String newId;
        Hashtable<Serializable, Map> nested = new Hashtable<Serializable, Map>();
        if (attributeMap == null) {
            attributeMap = new AttributeMap();
        }
        if (TBoardConstants.isBrowseable(component.getAttributes())) {
            Map currentModelMap = (Map)attributes.get(this);
            ArrayList orderedCells = currentModelMap != null && currentModelMap.containsKey("orderedCellList") ? TBoardConstants.getOrderedCellList(currentModelMap) : TBoardConstants.getOrderedCellList(this.getAttributes());
            orderedCells.add(component);
            AttributeMap modelAttributeMap = new AttributeMap();
            TBoardConstants.setOrderedCellList(modelAttributeMap, orderedCells);
            nested.put(this, modelAttributeMap);
        }
        if ((newId = component.getId()) == null) {
            newId = component.newId();
        }
        while (this.existsId(newId)) {
            newId = component.newId();
        }
        TBoardConstants.setId(attributeMap, newId);
        if (TBoardConstants.isResizeToText(attributeMap)) {
            TBoardConstants.setBounds(attributeMap, TBoardModel.computeNewBounds(TBoardConstants.getBounds(attributeMap), TBoardConstants.getText(attributeMap), TBoardConstants.getFont(attributeMap), Math.max(1, Math.round(TBoardConstants.getLineWidth(attributeMap)))));
        }
        if ((icon = (ImageIcon)TBoardConstants.getIcon(attributeMap)) != null) {
            try {
                File imageFile = new File(TFileHandler.importFile(icon.getDescription()).getAbsolutePath());
                if (TFileUtils.isJAIRequired(imageFile)) {
                    RenderedOp src = JAI.create("fileload", imageFile.getAbsolutePath());
                    BufferedImage bufferedImage = src.getAsBufferedImage();
                    icon = new ImageIcon(bufferedImage, imageFile.getAbsolutePath());
                } else {
                    icon = new ImageIcon(imageFile.getAbsolutePath(), imageFile.getAbsolutePath());
                }
                TBoardConstants.setIcon(attributeMap, icon);
            }
            catch (Exception imageFile) {
                // empty catch block
            }
        }
        if ((alternativeIcon = (ImageIcon)TBoardConstants.getAlternativeIcon(attributeMap)) != null) {
            try {
                File imageFile = new File(TFileHandler.importFile(alternativeIcon.getDescription()).getAbsolutePath());
                if (TFileUtils.isJAIRequired(imageFile)) {
                    RenderedOp src = JAI.create("fileload", imageFile.getAbsolutePath());
                    BufferedImage bufferedImage = src.getAsBufferedImage();
                    alternativeIcon = new ImageIcon(bufferedImage, imageFile.getAbsolutePath());
                } else {
                    alternativeIcon = new ImageIcon(imageFile.getAbsolutePath(), imageFile.getAbsolutePath());
                }
                TBoardConstants.setAlternativeIcon(attributeMap, alternativeIcon);
            }
            catch (Exception imageFile) {
                // empty catch block
            }
        }
        if ((soundFilePath = TBoardConstants.getSoundFile(attributeMap)) != null) {
            try {
                TBoardConstants.setSoundFile(attributeMap, TFileHandler.importFile(soundFilePath).getAbsolutePath());
            }
            catch (Exception src) {
                // empty catch block
            }
        }
        if ((videoFilePath = TBoardConstants.getVideoFile(attributeMap)) != null) {
            try {
                TBoardConstants.setVideoFile(attributeMap, TFileHandler.importFile(videoFilePath).getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (TBoardConstants.getFollowingBoardName(attributeMap) != null && TBoardConstants.getFollowingBoardName(attributeMap).equals(TBoardConstants.currentBoard.getBoardName())) {
            attributeMap.remove("followingBoard");
            TBoardConstants.setRemoveAttributes(attributeMap, new Object[]{"followingBoard"});
        }
        nested.put(component, attributeMap);
        return nested;
    }

    private Map parentUpdateAttributes(TGridCell child, TGrid parent, Map parentAttributeMap) {
        ArrayList gridCellList;
        Hashtable<TGrid, Map> nested = new Hashtable<TGrid, Map>();
        if (parentAttributeMap == null) {
            parentAttributeMap = new AttributeMap();
        }
        if ((gridCellList = TBoardConstants.getOrderedCellList(parentAttributeMap)).isEmpty()) {
            gridCellList = TBoardConstants.getOrderedCellList(parent.getAttributes());
        }
        if (!gridCellList.contains(child)) {
            gridCellList.add(child);
        }
        TBoardConstants.setOrderedCellList(parentAttributeMap, gridCellList);
        nested.put(parent, parentAttributeMap);
        return nested;
    }

    private Map removeUpdateAttributes(TComponent component, Map attributes) {
        Hashtable<Object, AttributeMap> nested = new Hashtable<Object, AttributeMap>();
        if (TBoardConstants.isBrowseable(component.getAttributes())) {
            ArrayList orderedCells;
            Map currentModelMap = (Map)attributes.get(this);
            ArrayList unorderedCells = currentModelMap != null && currentModelMap.containsKey("unorderedCellList") ? TBoardConstants.getUnorderedCellList(currentModelMap) : TBoardConstants.getUnorderedCellList(this.getAttributes());
            if (!unorderedCells.isEmpty()) {
                unorderedCells.remove(component);
            }
            if (!(orderedCells = currentModelMap != null && currentModelMap.containsKey("orderedCellList") ? TBoardConstants.getOrderedCellList(currentModelMap) : TBoardConstants.getOrderedCellList(this.getAttributes())).isEmpty()) {
                orderedCells.remove(component);
            }
            AttributeMap modelAttributeMap = new AttributeMap();
            TBoardConstants.setOrderedCellList(modelAttributeMap, orderedCells);
            AttributeMap attributeMap = new AttributeMap();
            TBoardConstants.setUnorderedCellList(attributeMap, unorderedCells);
            TBoardConstants.setOrderedCellList(attributeMap, orderedCells);
            nested.put(this, attributeMap);
        }
        if (component instanceof TGridCell) {
            TGrid grid = (TGrid)component.getParent();
            ArrayList gridCellList = TBoardConstants.getOrderedCellList(grid.getAttributes());
            gridCellList.remove(component);
            AttributeMap attributeMap = new AttributeMap();
            TBoardConstants.setOrderedCellList(attributeMap, gridCellList);
            nested.put(grid, attributeMap);
        }
        if (TBoardConstants.isTextReceiver(component.getAttributes())) {
            Object[] components = TBoardModel.getAll(this);
            int i2 = 0;
            while (i2 < components.length) {
                TComponent textReceiver;
                if (TBoardConstants.isTextSender(((TComponent)components[i2]).getAttributes()) && (textReceiver = TBoardConstants.getSendTextTarget(((TComponent)components[i2]).getAttributes())) != null && textReceiver.equals(component)) {
                    AttributeMap newAttributes = new AttributeMap();
                    TBoardConstants.setRemoveAttributes(newAttributes, new Object[]{"sendText", "sendTextTarget", "sendTextTimer"});
                    nested.put(components[i2], newAttributes);
                }
                ++i2;
            }
        }
        return nested;
    }

    private Map editUpdateAttributes(TComponent component, Map attributeMap) {
        Hashtable<TComponent, Map> nested = new Hashtable<TComponent, Map>();
        if (attributeMap == null) {
            attributeMap = new AttributeMap();
        }
        AttributeMap finalAttributeMap = (AttributeMap)component.getAttributes().clone();
        finalAttributeMap.applyMap(attributeMap);
        if (TBoardConstants.isResizeToText(finalAttributeMap)) {
            TBoardConstants.setBounds(attributeMap, TBoardModel.computeNewBounds(TBoardConstants.getBounds(finalAttributeMap), TBoardConstants.getText(finalAttributeMap), TBoardConstants.getFont(finalAttributeMap), Math.max(1, Math.round(TBoardConstants.getLineWidth(finalAttributeMap)))));
        }
        nested.put(component, attributeMap);
        return nested;
    }

    public void deleteBoardFromAttributes(TBoard board) {
        if (board == null) {
            throw new NullPointerException();
        }
        TBoard followingBoard = null;
        Object[] components = TBoardModel.getAll(this);
        int i2 = 0;
        while (i2 < components.length) {
            String followingBoardName = TBoardConstants.getFollowingBoardName(((TComponent)components[i2]).getAttributes());
            if (followingBoardName != null && (followingBoard = TBoardConstants.editor.getProject().getBoard(followingBoardName)) != null && followingBoard.equals(board)) {
                AttributeMap attributeMap = new AttributeMap();
                TBoardConstants.setRemoveAttributes(attributeMap, new Object[]{"followingBoard"});
                this.getAttributes(components[i2]).applyMap(attributeMap);
            }
            ++i2;
        }
    }

    public boolean existsId(String id) {
        List components = this.getRoots();
        int i2 = 0;
        while (i2 < components.size()) {
            if (((TComponent)components.get(i2)).getId().equals(id)) {
                return true;
            }
            if ((TComponent)components.get(i2) instanceof TGrid && this.existsIdInGrid(id, (TGrid)components.get(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean existsIdInGrid(String id, TGrid grid) {
        List components = grid.getChildren();
        int i2 = 0;
        while (i2 < components.size()) {
            if (((TComponent)components.get(i2)).getId().equals(id)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean isRepeatedId(TComponent original, String id) {
        List components = this.getRoots();
        int i2 = 0;
        while (i2 < components.size()) {
            if (!original.equals(components.get(i2)) && ((TComponent)components.get(i2)).getId().equals(id)) {
                return true;
            }
            if ((TComponent)components.get(i2) instanceof TGrid && this.isRepeatedIdInGrid(original, id, (TGrid)components.get(i2))) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean isRepeatedIdInGrid(TComponent original, String id, TGrid grid) {
        List components = grid.getChildren();
        int i2 = 0;
        while (i2 < components.size()) {
            if (!original.equals(components.get(i2)) && ((TComponent)components.get(i2)).getId().equals(id)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static Rectangle2D computeNewBounds(Rectangle2D bounds, String text, Font font, int borderWidth) {
        Font fontAux = TEditor.get_android_mode() ? new Font("Droid Sans", font.getStyle(), font.getSize()) : font;
        JLabel sizeLabel = new JLabel();
        FontMetrics fontMetric = sizeLabel.getFontMetrics(fontAux);
        if (text == null) {
            text = "";
        }
        int textWidth = fontMetric.stringWidth(text);
        int textHeight = fontMetric.getHeight();
        int newLabelWidth = textWidth + 2 * (6 + borderWidth);
        int newLabelHeight = textHeight + 2 * (4 + borderWidth);
        bounds.setFrame(bounds.getX(), bounds.getY(), newLabelWidth, newLabelHeight);
        return bounds;
    }

    public Node XMLEncode(Document doc) {
        Element modelElement = doc.createElement("model");
        modelElement.appendChild(TAttributeEncoder.XMLEncode((AttributeMap)this.getAttributes(), doc));
        int i2 = 0;
        while (i2 < this.getRootCount()) {
            if ((TComponent)this.getRootAt(i2) instanceof TGrid) {
                int j2 = 0;
                while (j2 < ((TComponent)this.getRootAt(i2)).getChildCount()) {
                    modelElement.appendChild(((TComponent)((TComponent)this.getRootAt(i2)).getChildAt(j2)).XMLEncode(doc));
                    ++j2;
                }
            } else {
                modelElement.appendChild(((TComponent)this.getRootAt(i2)).XMLEncode(doc));
            }
            ++i2;
        }
        return modelElement;
    }

    public static TBoardModel XMLDecode(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("model")) {
            AttributeMap attributes = null;
            Vector<TComponent> componentList = new Vector<TComponent>();
            Hashtable<String, TComponent> componentMap = new Hashtable<String, TComponent>();
            Vector<TComponent> textSenderList = new Vector<TComponent>();
            NodeList childNodes = element.getChildNodes();
            int i2 = 0;
            while (i2 < childNodes.getLength()) {
                String tagName = childNodes.item(i2).getNodeName();
                if (tagName.equals("attributes")) {
                    attributes = TAttributeEncoder.XMLDecode((Element)childNodes.item(i2));
                }
                if (tagName.equals("component")) {
                    TComponent component = TComponent.XMLDecodeType((Element)childNodes.item(i2));
                    componentMap.put(component.getId(), component);
                    componentList.add(component);
                    if (component.getAttributes().containsKey("sendTextTarget")) {
                        textSenderList.add(component);
                    }
                    int j2 = 0;
                    while (j2 < component.getChildCount()) {
                        TComponent childComponent = (TComponent)component.getChildAt(j2);
                        if (childComponent.getAttributes().containsKey("sendTextTarget")) {
                            textSenderList.add(childComponent);
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
            if (attributes == null) {
                throw new InvalidFormatException();
            }
            ArrayList idUnorderedList = TBoardConstants.getUnorderedCellList(attributes);
            ArrayList idOrderedList = TBoardConstants.getOrderedCellList(attributes);
            ArrayList componentUnorderedList = new ArrayList();
            ArrayList componentOrderedList = new ArrayList();
            int i3 = 0;
            while (i3 < idUnorderedList.size()) {
                componentUnorderedList.add(componentMap.get(idUnorderedList.get(i3)));
                ++i3;
            }
            i3 = 0;
            while (i3 < idOrderedList.size()) {
                componentOrderedList.add(componentMap.get(idOrderedList.get(i3)));
                ++i3;
            }
            TBoardConstants.setOrderedCellList(attributes, componentOrderedList);
            TBoardConstants.setUnorderedCellList(attributes, componentUnorderedList);
            i3 = 0;
            while (i3 < textSenderList.size()) {
                TComponent component = (TComponent)textSenderList.get(i3);
                String sendTextTargetId = (String)component.getAttributes().get("sendTextTarget");
                TBoardConstants.setSendTextTarget(component.getAttributes(), (TComponent)componentMap.get(sendTextTargetId));
                ++i3;
            }
            TBoardModel model = new TBoardModel(componentList, attributes);
            return model;
        }
        throw new InvalidFormatException();
    }
}

