/*
 * Decompiled with CFR 0.152.
 */
package tico.board;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tico.board.TBoardConstants;
import tico.board.TBoardLayoutCache;
import tico.board.TBoardModel;
import tico.board.TBoardUI;
import tico.board.encoding.InvalidFormatException;
import tico.board.events.BoardChangeEvent;
import tico.board.events.BoardChangeListener;

public class TBoard
extends JGraph {
    private static int boardCount = 0;
    private String name = null;
    public static final Color DEFAULT_BORDER_COLOR = Color.BLACK;

    public TBoard() {
        this(new TBoardModel());
    }

    public TBoard(String name) {
        this(new TBoardModel());
        this.name = name;
    }

    public TBoard(AttributeMap attributes) {
        this(new TBoardModel(attributes));
    }

    public TBoard(AttributeMap attributes, String name) {
        this(attributes);
        this.name = name;
    }

    public TBoard(TBoardModel model, String name) {
        this(model);
        this.name = name;
    }

    public TBoard(TBoardModel model) {
        this.setTolerance(2);
        this.setSizeable(true);
        this.setCloneable(false);
        this.setConnectable(false);
        this.setDisconnectable(false);
        this.setBendable(false);
        this.setEditable(false);
        this.setAntiAliased(true);
        this.setGraphLayoutCache(new TBoardLayoutCache());
        model.addGraphModelListener(new GraphModelListener(){

            @Override
            public void graphChanged(GraphModelEvent e2) {
                Map attributes = e2.getChange().getAttributes();
                if (attributes != null) {
                    attributes = (Map)attributes.get(TBoard.this.getModel());
                }
                if (attributes != null && attributes.containsKey("size")) {
                    TBoard.this.setMinimumSize(TBoardConstants.getSize(attributes));
                }
                TBoard.this.fireBoardChange();
            }
        });
        this.setModel(model);
        this.setMinimumSize(TBoardConstants.getSize(this.getAttributes(null)));
    }

    @Override
    public String toString() {
        return this.getBoardName();
    }

    public String getBoardName() {
        return this.name;
    }

    public void setBoardName(String name) {
        this.name = name;
    }

    public static String newBoardName() {
        return "board_" + boardCount++;
    }

    @Override
    public void updateUI() {
        this.setUI(new TBoardUI());
        this.invalidate();
    }

    private void fireBoardChange() {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == BoardChangeListener.class) {
                ((BoardChangeListener)listeners[i2 + 1]).boardChanged(new BoardChangeEvent(this));
            }
            i2 -= 2;
        }
    }

    public void addBoardChangeListener(BoardChangeListener listener) {
        this.listenerList.add(BoardChangeListener.class, listener);
    }

    public void removeBoardChangeListener(BoardChangeListener listener) {
        this.listenerList.remove(BoardChangeListener.class, listener);
    }

    public BufferedImage getImage() {
        Dimension bounds = TBoardConstants.getSize(this.getAttributes(this.getModel()));
        if (bounds != null) {
            BufferedImage img = new BufferedImage(bounds.width, bounds.height, 1);
            Graphics2D graphics = img.createGraphics();
            this.print(graphics);
            return img;
        }
        return null;
    }

    public Element XMLEncode(Document doc) {
        Element boardElement = doc.createElement("board");
        boardElement.setAttribute("name", this.getBoardName());
        boardElement.appendChild(((TBoardModel)this.getModel()).XMLEncode(doc));
        return boardElement;
    }

    public static TBoard XMLDecode(Element element) throws InvalidFormatException {
        if (element.getTagName().equals("board")) {
            TBoardModel model = null;
            NodeList childNodes = element.getChildNodes();
            int i2 = 0;
            while (i2 < childNodes.getLength()) {
                String tagName = childNodes.item(i2).getNodeName();
                if (tagName.equals("model")) {
                    model = TBoardModel.XMLDecode((Element)childNodes.item(i2));
                }
                ++i2;
            }
            TBoard board = new TBoard(model);
            if (!element.hasAttribute("name")) {
                throw new InvalidFormatException();
            }
            board.setBoardName(element.getAttribute("name"));
            return board;
        }
        throw new InvalidFormatException();
    }
}

