/*
 * Decompiled with CFR 0.152.
 */
package tico;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import tico.board.TProject;
import tico.board.encoding.InvalidFormatException;
import tico.components.resources.TFileUtils;
import tico.configuration.TLanguage;
import tico.configuration.TSetup;
import tico.editor.TEditor;
import tico.editor.TProjectHandler;
import tico.environment.TEnvironment;
import tico.interpreter.TInterpreter;
import tico.interpreter.TInterpreterProject;

public class TLauncher {
    static File selectedFile;

    public static void main(String[] args) {
        try {
            TSetup.load();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Se ha producido un error cargando el fichero de configuraci\u00f3n. Se utilizar\u00e1 una por defecto.", "Error!", 0);
        }
        try {
            TLanguage.initLanguage(TSetup.getLanguage());
        }
        catch (Exception e3) {
            e3.printStackTrace();
            JOptionPane.showMessageDialog(null, "Se ha producido un error cargando el fichero de idioma. No se puede ejecutar la aplicaci\u00f3n.", "Error!", 0);
            System.exit(-1);
        }
        try {
            TEnvironment.initEnvironment("environment");
        }
        catch (IOException e4) {
            JOptionPane.showMessageDialog(null, "Se ha producido un error cargando el fichero de control de entorno. Esta funcionalidad no estar\u00e1 disponible.", "Error!", 0);
        }
        switch (args.length) {
            case 0: {
                new TEditor();
                new TInterpreter();
                break;
            }
            case 1: {
                if (args[0].equals("-i")) {
                    new TInterpreter();
                    break;
                }
                if (args[0].equals("-e")) {
                    new TEditor();
                    break;
                }
                TLauncher.displayUsage();
                System.exit(-1);
                break;
            }
            case 2: {
                TProject initialProject = null;
                TInterpreterProject initialInterpreterProject = null;
                try {
                    selectedFile = new File(args[1]);
                    if (!selectedFile.exists()) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("TLauncher.NOT_EXIST_FILE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                    }
                    if (!TFileUtils.isProjectFile(selectedFile)) {
                        JOptionPane.showMessageDialog(null, TLanguage.getString("TLauncher.INVALID_FILE_ERROR"), String.valueOf(TLanguage.getString("ERROR")) + "!", 0);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (args[0].equals("-i")) {
                    try {
                        initialInterpreterProject = TProjectHandler.loadProjectInterpreter(selectedFile);
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                    catch (ParserConfigurationException e6) {
                        e6.printStackTrace();
                    }
                    catch (InvalidFormatException e7) {
                        e7.printStackTrace();
                    }
                    catch (SAXException e8) {
                        e8.printStackTrace();
                    }
                    new TInterpreter(initialInterpreterProject);
                    break;
                }
                if (args[0].equals("-e")) {
                    try {
                        initialProject = TProjectHandler.loadProject(selectedFile);
                    }
                    catch (IOException e9) {
                        e9.printStackTrace();
                    }
                    catch (ParserConfigurationException e10) {
                        e10.printStackTrace();
                    }
                    catch (InvalidFormatException e11) {
                        e11.printStackTrace();
                    }
                    catch (SAXException e12) {
                        e12.printStackTrace();
                    }
                    new TEditor(initialProject);
                    break;
                }
                TLauncher.displayUsage();
                System.exit(-1);
                break;
            }
            default: {
                TLauncher.displayUsage();
                System.exit(-1);
            }
        }
    }

    private static void displayUsage() {
        System.out.println("Usage: tico [-e|-i] [<project_file>]");
    }
}

