/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled;

import java.util.ArrayList;
import java.util.Random;
import javax.sound.sampled.AudioFormat;

public class FloatSampleBuffer {
    private static final boolean LAZY_DEFAULT = true;
    private ArrayList channels = new ArrayList();
    private int sampleCount = 0;
    private int channelCount = 0;
    private float sampleRate = 0.0f;
    private int originalFormatType = 0;
    public static final int DITHER_MODE_AUTOMATIC = 0;
    public static final int DITHER_MODE_ON = 1;
    public static final int DITHER_MODE_OFF = 2;
    private static Random random = null;
    private float ditherBits = 0.8f;
    private boolean doDither = false;
    private int ditherMode = 0;
    private static final int F_8 = 1;
    private static final int F_16 = 2;
    private static final int F_24 = 3;
    private static final int F_32 = 4;
    private static final int F_SAMPLE_WIDTH_MASK = 7;
    private static final int F_SIGNED = 8;
    private static final int F_BIGENDIAN = 16;
    private static final int CT_8S = 9;
    private static final int CT_8U = 1;
    private static final int CT_16SB = 26;
    private static final int CT_16SL = 10;
    private static final int CT_24SB = 27;
    private static final int CT_24SL = 11;
    private static final int CT_32SB = 28;
    private static final int CT_32SL = 12;
    private static final float twoPower7 = 128.0f;
    private static final float twoPower15 = 32768.0f;
    private static final float twoPower23 = 8388608.0f;
    private static final float twoPower31 = 2.1474836E9f;
    private static final float invTwoPower7 = 0.0078125f;
    private static final float invTwoPower15 = 3.0517578E-5f;
    private static final float invTwoPower23 = 1.1920929E-7f;
    private static final float invTwoPower31 = 4.656613E-10f;

    public FloatSampleBuffer() {
        this(0, 0, 1.0f);
    }

    public FloatSampleBuffer(int channelCount, int sampleCount, float sampleRate) {
        this.init(channelCount, sampleCount, sampleRate, true);
    }

    public FloatSampleBuffer(byte[] buffer, int offset, int byteCount, AudioFormat format) {
        this(format.getChannels(), byteCount / (format.getSampleSizeInBits() / 8 * format.getChannels()), format.getSampleRate());
        this.initFromByteArray(buffer, offset, byteCount, format);
    }

    protected void init(int channelCount, int sampleCount, float sampleRate) {
        this.init(channelCount, sampleCount, sampleRate, true);
    }

    protected void init(int channelCount, int sampleCount, float sampleRate, boolean lazy) {
        if (channelCount < 0 || sampleCount < 0) {
            throw new IllegalArgumentException("Invalid parameters in initialization of FloatSampleBuffer.");
        }
        this.setSampleRate(sampleRate);
        if (this.getSampleCount() != sampleCount || this.getChannelCount() != channelCount) {
            this.createChannels(channelCount, sampleCount, lazy);
        }
    }

    private void createChannels(int channelCount, int sampleCount, boolean lazy) {
        this.sampleCount = sampleCount;
        this.channelCount = 0;
        for (int ch = 0; ch < channelCount; ++ch) {
            this.insertChannel(ch, false, lazy);
        }
        if (!lazy) {
            while (this.channels.size() > channelCount) {
                this.channels.remove(this.channels.size() - 1);
            }
        }
    }

    public void initFromByteArray(byte[] buffer, int offset, int byteCount, AudioFormat format) {
        this.initFromByteArray(buffer, offset, byteCount, format, true);
    }

    public void initFromByteArray(byte[] buffer, int offset, int byteCount, AudioFormat format, boolean lazy) {
        int formatType;
        if (offset + byteCount > buffer.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.initFromByteArray: buffer too small.");
        }
        boolean signed = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        if (!signed && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("FloatSampleBuffer: only PCM samples are possible.");
        }
        int bytesPerSample = format.getSampleSizeInBits() / 8;
        int bytesPerFrame = bytesPerSample * format.getChannels();
        int thisSampleCount = byteCount / bytesPerFrame;
        this.init(format.getChannels(), thisSampleCount, format.getSampleRate(), lazy);
        this.originalFormatType = formatType = this.getFormatType(format.getSampleSizeInBits(), signed, format.isBigEndian());
        for (int ch = 0; ch < format.getChannels(); ++ch) {
            FloatSampleBuffer.convertByteToFloat(buffer, offset, bytesPerFrame, formatType, this.getChannel(ch), 0, this.sampleCount);
            offset += bytesPerSample;
        }
    }

    public void initFromFloatSampleBuffer(FloatSampleBuffer source) {
        this.init(source.getChannelCount(), source.getSampleCount(), source.getSampleRate());
        for (int ch = 0; ch < this.getChannelCount(); ++ch) {
            System.arraycopy(source.getChannel(ch), 0, this.getChannel(ch), 0, this.sampleCount);
        }
    }

    public void reset() {
        this.init(0, 0, 1.0f, false);
    }

    public void reset(int channels, int sampleCount, float sampleRate) {
        this.init(channels, sampleCount, sampleRate, false);
    }

    public int getByteArrayBufferSize(AudioFormat format) {
        if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("FloatSampleBuffer: only PCM samples are possible.");
        }
        int bytesPerSample = format.getSampleSizeInBits() / 8;
        int bytesPerFrame = bytesPerSample * format.getChannels();
        return bytesPerFrame * this.getSampleCount();
    }

    public int convertToByteArray(byte[] buffer, int offset, AudioFormat format) {
        int byteCount = this.getByteArrayBufferSize(format);
        if (offset + byteCount > buffer.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: buffer too small.");
        }
        boolean signed = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        if (!signed && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: only PCM samples are allowed.");
        }
        if (format.getSampleRate() != this.getSampleRate()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different samplerates.");
        }
        if (format.getChannels() != this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.convertToByteArray: different channel count.");
        }
        int bytesPerSample = format.getSampleSizeInBits() / 8;
        int bytesPerFrame = bytesPerSample * format.getChannels();
        int formatType = this.getFormatType(format.getSampleSizeInBits(), signed, format.isBigEndian());
        for (int ch = 0; ch < format.getChannels(); ++ch) {
            this.convertFloatToByte(this.getChannel(ch), this.sampleCount, buffer, offset, bytesPerFrame, formatType);
            offset += bytesPerSample;
        }
        return this.getSampleCount() * bytesPerFrame;
    }

    public byte[] convertToByteArray(AudioFormat format) {
        byte[] res = new byte[this.getByteArrayBufferSize(format)];
        this.convertToByteArray(res, 0, format);
        return res;
    }

    public void changeSampleCount(int newSampleCount, boolean keepOldSamples) {
        int oldSampleCount = this.getSampleCount();
        if (oldSampleCount == newSampleCount) {
            return;
        }
        Object[] oldChannels = null;
        if (keepOldSamples) {
            oldChannels = this.getAllChannels();
        }
        this.init(this.getChannelCount(), newSampleCount, this.getSampleRate());
        if (keepOldSamples) {
            int copyCount = newSampleCount < oldSampleCount ? newSampleCount : oldSampleCount;
            for (int ch = 0; ch < this.getChannelCount(); ++ch) {
                float[] oldSamples = (float[])oldChannels[ch];
                float[] newSamples = this.getChannel(ch);
                if (oldSamples != newSamples) {
                    System.arraycopy(oldSamples, 0, newSamples, 0, copyCount);
                }
                if (oldSampleCount >= newSampleCount) continue;
                for (int i2 = oldSampleCount; i2 < newSampleCount; ++i2) {
                    newSamples[i2] = 0.0f;
                }
            }
        }
    }

    public void makeSilence() {
        if (this.getChannelCount() > 0) {
            this.makeSilence(0);
            for (int ch = 1; ch < this.getChannelCount(); ++ch) {
                this.copyChannel(0, ch);
            }
        }
    }

    public void makeSilence(int channel) {
        float[] samples = this.getChannel(0);
        for (int i2 = 0; i2 < this.getSampleCount(); ++i2) {
            samples[i2] = 0.0f;
        }
    }

    public void addChannel(boolean silent) {
        this.insertChannel(this.getChannelCount(), silent);
    }

    public void insertChannel(int index, boolean silent) {
        this.insertChannel(index, silent, true);
    }

    public void insertChannel(int index, boolean silent, boolean lazy) {
        int physSize = this.channels.size();
        int virtSize = this.getChannelCount();
        float[] newChannel = null;
        if (physSize > virtSize) {
            for (int ch = virtSize; ch < physSize; ++ch) {
                float[] thisChannel = (float[])this.channels.get(ch);
                if ((!lazy || thisChannel.length < this.getSampleCount()) && (lazy || thisChannel.length != this.getSampleCount())) continue;
                newChannel = thisChannel;
                this.channels.remove(ch);
                break;
            }
        }
        if (newChannel == null) {
            newChannel = new float[this.getSampleCount()];
        }
        this.channels.add(index, newChannel);
        ++this.channelCount;
        if (silent) {
            this.makeSilence(index);
        }
    }

    public void removeChannel(int channel) {
        this.removeChannel(channel, true);
    }

    public void removeChannel(int channel, boolean lazy) {
        if (!lazy) {
            this.channels.remove(channel);
        } else if (channel < this.getChannelCount() - 1) {
            this.channels.add(this.channels.remove(channel));
        }
        --this.channelCount;
    }

    public void copyChannel(int sourceChannel, int targetChannel) {
        float[] source = this.getChannel(sourceChannel);
        float[] target = this.getChannel(targetChannel);
        System.arraycopy(source, 0, target, 0, this.getSampleCount());
    }

    public void copy(int sourceIndex, int destIndex, int length) {
        for (int i2 = 0; i2 < this.getChannelCount(); ++i2) {
            this.copy(i2, sourceIndex, destIndex, length);
        }
    }

    public void copy(int channel, int sourceIndex, int destIndex, int length) {
        float[] data = this.getChannel(channel);
        int bufferCount = this.getSampleCount();
        if (sourceIndex + length > bufferCount || destIndex + length > bufferCount || sourceIndex < 0 || destIndex < 0 || length < 0) {
            throw new IndexOutOfBoundsException("parameters exceed buffer size");
        }
        System.arraycopy(data, sourceIndex, data, destIndex, length);
    }

    public void expandChannel(int targetChannelCount) {
        if (this.getChannelCount() != 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: can only expand channels for mono signals.");
        }
        for (int ch = 1; ch < targetChannelCount; ++ch) {
            this.addChannel(false);
            this.copyChannel(0, ch);
        }
    }

    public void mixDownChannels() {
        float[] firstChannel = this.getChannel(0);
        int sampleCount = this.getSampleCount();
        int channelCount = this.getChannelCount();
        for (int ch = channelCount - 1; ch > 0; --ch) {
            float[] thisChannel = this.getChannel(ch);
            for (int i2 = 0; i2 < sampleCount; ++i2) {
                int n2 = i2;
                firstChannel[n2] = firstChannel[n2] + thisChannel[i2];
            }
            this.removeChannel(ch);
        }
    }

    public void setSamplesFromBytes(byte[] srcBuffer, int srcOffset, AudioFormat format, int destOffset, int lengthInSamples) {
        int bytesPerSample = (format.getSampleSizeInBits() + 7) / 8;
        int bytesPerFrame = bytesPerSample * format.getChannels();
        if (srcOffset + lengthInSamples * bytesPerFrame > srcBuffer.length) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: srcBuffer too small.");
        }
        if (destOffset + lengthInSamples > this.getSampleCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer.setSamplesFromBytes: destBuffer too small.");
        }
        boolean signed = format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED);
        boolean unsigned = format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED);
        if (!signed && !unsigned) {
            throw new IllegalArgumentException("FloatSampleBuffer: only PCM samples are possible.");
        }
        int formatType = this.getFormatType(format.getSampleSizeInBits(), signed, format.isBigEndian());
        for (int ch = 0; ch < format.getChannels(); ++ch) {
            FloatSampleBuffer.convertByteToFloat(srcBuffer, srcOffset, bytesPerFrame, formatType, this.getChannel(ch), destOffset, lengthInSamples);
            srcOffset += bytesPerSample;
        }
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        if (sampleRate <= 0.0f) {
            throw new IllegalArgumentException("Invalid samplerate for FloatSampleBuffer.");
        }
        this.sampleRate = sampleRate;
    }

    public float[] getChannel(int channel) {
        if (channel < 0 || channel >= this.getChannelCount()) {
            throw new IllegalArgumentException("FloatSampleBuffer: invalid channel number.");
        }
        return (float[])this.channels.get(channel);
    }

    public Object[] getAllChannels() {
        Object[] res = new Object[this.getChannelCount()];
        for (int ch = 0; ch < this.getChannelCount(); ++ch) {
            res[ch] = this.getChannel(ch);
        }
        return res;
    }

    public void setDitherBits(float ditherBits) {
        if (ditherBits <= 0.0f) {
            throw new IllegalArgumentException("DitherBits must be greater than 0");
        }
        this.ditherBits = ditherBits;
    }

    public float getDitherBits() {
        return this.ditherBits;
    }

    public void setDitherMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Illegal DitherMode");
        }
        this.ditherMode = mode;
    }

    public int getDitherMode() {
        return this.ditherMode;
    }

    public int getFormatType(int ssib, boolean signed, boolean bigEndian) {
        int bytesPerSample = ssib / 8;
        int res = 0;
        if (ssib == 8) {
            res = 1;
        } else if (ssib == 16) {
            res = 2;
        } else if (ssib == 24) {
            res = 3;
        } else if (ssib == 32) {
            res = 4;
        }
        if (res == 0) {
            throw new IllegalArgumentException("FloatSampleBuffer: unsupported sample size of " + ssib + " bits per sample.");
        }
        if (!signed && bytesPerSample > 1) {
            throw new IllegalArgumentException("FloatSampleBuffer: unsigned samples larger than 8 bit are not supported");
        }
        if (signed) {
            res |= 8;
        }
        if (bigEndian && ssib != 8) {
            res |= 0x10;
        }
        return res;
    }

    private static void convertByteToFloat(byte[] input, int inputOffset, int bytesPerFrame, int formatType, float[] output, int outputOffset, int sampleCount) {
        int endCount = outputOffset + sampleCount;
        for (int sample = outputOffset; sample < endCount; ++sample) {
            switch (formatType) {
                case 9: {
                    output[sample] = (float)input[inputOffset] * 0.0078125f;
                    break;
                }
                case 1: {
                    output[sample] = (float)((input[inputOffset] & 0xFF) - 128) * 0.0078125f;
                    break;
                }
                case 26: {
                    output[sample] = (float)(input[inputOffset] << 8 | input[inputOffset + 1] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 10: {
                    output[sample] = (float)(input[inputOffset + 1] << 8 | input[inputOffset] & 0xFF) * 3.0517578E-5f;
                    break;
                }
                case 27: {
                    output[sample] = (float)(input[inputOffset] << 16 | (input[inputOffset + 1] & 0xFF) << 8 | input[inputOffset + 2] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 11: {
                    output[sample] = (float)(input[inputOffset + 2] << 16 | (input[inputOffset + 1] & 0xFF) << 8 | input[inputOffset] & 0xFF) * 1.1920929E-7f;
                    break;
                }
                case 28: {
                    output[sample] = (float)(input[inputOffset] << 24 | (input[inputOffset + 1] & 0xFF) << 16 | (input[inputOffset + 2] & 0xFF) << 8 | input[inputOffset + 3] & 0xFF) * 4.656613E-10f;
                    break;
                }
                case 12: {
                    output[sample] = (float)(input[inputOffset + 3] << 24 | (input[inputOffset + 2] & 0xFF) << 16 | (input[inputOffset + 1] & 0xFF) << 8 | input[inputOffset] & 0xFF) * 4.656613E-10f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported formatType=" + formatType);
                }
            }
            inputOffset += bytesPerFrame;
        }
    }

    protected byte quantize8(float sample) {
        if (this.doDither) {
            sample += random.nextFloat() * this.ditherBits;
        }
        if (sample >= 127.0f) {
            return 127;
        }
        if (sample <= -128.0f) {
            return -128;
        }
        return (byte)(sample < 0.0f ? sample - 0.5f : sample + 0.5f);
    }

    protected int quantize16(float sample) {
        if (this.doDither) {
            sample += random.nextFloat() * this.ditherBits;
        }
        if (sample >= 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (sample <= -32768.0f) {
            return Short.MIN_VALUE;
        }
        return (int)(sample < 0.0f ? sample - 0.5f : sample + 0.5f);
    }

    protected int quantize24(float sample) {
        if (this.doDither) {
            sample += random.nextFloat() * this.ditherBits;
        }
        if (sample >= 8388607.0f) {
            return 0x7FFFFF;
        }
        if (sample <= -8388608.0f) {
            return -8388608;
        }
        return (int)(sample < 0.0f ? sample - 0.5f : sample + 0.5f);
    }

    protected int quantize32(float sample) {
        if (this.doDither) {
            sample += random.nextFloat() * this.ditherBits;
        }
        if (sample >= 2.1474836E9f) {
            return Integer.MAX_VALUE;
        }
        if (sample <= -2.1474836E9f) {
            return Integer.MIN_VALUE;
        }
        return (int)(sample < 0.0f ? sample - 0.5f : sample + 0.5f);
    }

    private void convertFloatToByte(float[] input, int sampleCount, byte[] output, int offset, int bytesPerFrame, int formatType) {
        switch (this.ditherMode) {
            case 0: {
                this.doDither = (this.originalFormatType & 7) > (formatType & 7);
                break;
            }
            case 1: {
                this.doDither = true;
                break;
            }
            case 2: {
                this.doDither = false;
            }
        }
        if (this.doDither && random == null) {
            random = new Random();
        }
        for (int inIndex = 0; inIndex < sampleCount; ++inIndex) {
            switch (formatType) {
                case 9: {
                    output[offset] = this.quantize8(input[inIndex] * 128.0f);
                    break;
                }
                case 1: {
                    output[offset] = (byte)(this.quantize8(input[inIndex] * 128.0f) + 128);
                    break;
                }
                case 26: {
                    int iSample = this.quantize16(input[inIndex] * 32768.0f);
                    output[offset] = (byte)(iSample >> 8);
                    output[offset + 1] = (byte)(iSample & 0xFF);
                    break;
                }
                case 10: {
                    int iSample = this.quantize16(input[inIndex] * 32768.0f);
                    output[offset + 1] = (byte)(iSample >> 8);
                    output[offset] = (byte)(iSample & 0xFF);
                    break;
                }
                case 27: {
                    int iSample = this.quantize24(input[inIndex] * 8388608.0f);
                    output[offset] = (byte)(iSample >> 16);
                    output[offset + 1] = (byte)(iSample >>> 8 & 0xFF);
                    output[offset + 2] = (byte)(iSample & 0xFF);
                    break;
                }
                case 11: {
                    int iSample = this.quantize24(input[inIndex] * 8388608.0f);
                    output[offset + 2] = (byte)(iSample >> 16);
                    output[offset + 1] = (byte)(iSample >>> 8 & 0xFF);
                    output[offset] = (byte)(iSample & 0xFF);
                    break;
                }
                case 28: {
                    int iSample = this.quantize32(input[inIndex] * 2.1474836E9f);
                    output[offset] = (byte)(iSample >> 24);
                    output[offset + 1] = (byte)(iSample >>> 16 & 0xFF);
                    output[offset + 2] = (byte)(iSample >>> 8 & 0xFF);
                    output[offset + 3] = (byte)(iSample & 0xFF);
                    break;
                }
                case 12: {
                    int iSample = this.quantize32(input[inIndex] * 2.1474836E9f);
                    output[offset + 3] = (byte)(iSample >> 24);
                    output[offset + 2] = (byte)(iSample >>> 16 & 0xFF);
                    output[offset + 1] = (byte)(iSample >>> 8 & 0xFF);
                    output[offset] = (byte)(iSample & 0xFF);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported formatType=" + formatType);
                }
            }
            offset += bytesPerFrame;
        }
    }

    private static String formatType2Str(int formatType) {
        String res = "" + formatType + ": ";
        switch (formatType & 7) {
            case 1: {
                res = res + "8bit";
                break;
            }
            case 2: {
                res = res + "16bit";
                break;
            }
            case 3: {
                res = res + "24bit";
                break;
            }
            case 4: {
                res = res + "32bit";
            }
        }
        res = res + ((formatType & 8) == 8 ? " signed" : " unsigned");
        if ((formatType & 7) != 1) {
            res = res + ((formatType & 0x10) == 16 ? " big endian" : " little endian");
        }
        return res;
    }
}

