/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.javalayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TMatrixFormatConversionProvider;

public class MpegFormatConversionProvider
extends TMatrixFormatConversionProvider {
    public static final AudioFormat.Encoding MPEG1L1 = Encodings.getEncoding("MPEG1L1");
    public static final AudioFormat.Encoding MPEG1L2 = Encodings.getEncoding("MPEG1L2");
    public static final AudioFormat.Encoding MPEG1L3 = Encodings.getEncoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L1 = Encodings.getEncoding("MPEG2L1");
    public static final AudioFormat.Encoding MPEG2L2 = Encodings.getEncoding("MPEG2L2");
    public static final AudioFormat.Encoding MPEG2L3 = Encodings.getEncoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L1 = Encodings.getEncoding("MPEG2DOT5L1");
    public static final AudioFormat.Encoding MPEG2DOT5L2 = Encodings.getEncoding("MPEG2DOT5L2");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = Encodings.getEncoding("MPEG2DOT5L3");
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(MPEG1L1, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L1, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L1, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 32000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 44100.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, 48000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 16000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 22050.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, 24000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, 12000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 8000.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 11025.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, 12000.0f, -1, 2, -1, -1.0f, false)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(8000.0f, 16, 1, true, false), new AudioFormat(8000.0f, 16, 1, true, true), new AudioFormat(8000.0f, 16, 2, true, false), new AudioFormat(8000.0f, 16, 2, true, true), new AudioFormat(11025.0f, 16, 1, true, false), new AudioFormat(11025.0f, 16, 1, true, true), new AudioFormat(11025.0f, 16, 2, true, false), new AudioFormat(11025.0f, 16, 2, true, true), new AudioFormat(12000.0f, 16, 1, true, false), new AudioFormat(12000.0f, 16, 1, true, true), new AudioFormat(12000.0f, 16, 2, true, false), new AudioFormat(12000.0f, 16, 2, true, true), new AudioFormat(16000.0f, 16, 1, true, false), new AudioFormat(16000.0f, 16, 1, true, true), new AudioFormat(16000.0f, 16, 2, true, false), new AudioFormat(16000.0f, 16, 2, true, true), new AudioFormat(22050.0f, 16, 1, true, false), new AudioFormat(22050.0f, 16, 1, true, true), new AudioFormat(22050.0f, 16, 2, true, false), new AudioFormat(22050.0f, 16, 2, true, true), new AudioFormat(24000.0f, 16, 1, true, false), new AudioFormat(24000.0f, 16, 1, true, true), new AudioFormat(24000.0f, 16, 2, true, false), new AudioFormat(24000.0f, 16, 2, true, true), new AudioFormat(32000.0f, 16, 1, true, false), new AudioFormat(32000.0f, 16, 1, true, true), new AudioFormat(32000.0f, 16, 2, true, false), new AudioFormat(32000.0f, 16, 2, true, true), new AudioFormat(44100.0f, 16, 1, true, false), new AudioFormat(44100.0f, 16, 1, true, true), new AudioFormat(44100.0f, 16, 2, true, false), new AudioFormat(44100.0f, 16, 2, true, true), new AudioFormat(48000.0f, 16, 1, true, false), new AudioFormat(48000.0f, 16, 1, true, true), new AudioFormat(48000.0f, 16, 2, true, false), new AudioFormat(48000.0f, 16, 2, true, true)};
    private static final boolean t = true;
    private static final boolean f = false;
    private static final boolean[][] CONVERSIONS = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}};

    public MpegFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS), CONVERSIONS);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.<init>(): begin");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.<init>(): end");
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        AudioFormat matchingFormat;
        if (TDebug.TraceAudioConverter) {
            TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
            TDebug.out("trying to convert");
            TDebug.out("\tfrom: " + audioInputStream.getFormat());
            TDebug.out("\tto: " + targetFormat);
        }
        if ((matchingFormat = this.getMatchingFormat(targetFormat, audioInputStream.getFormat())) != null) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tisConversionSupported() accepted it; now setting up the conversion");
            }
            targetFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(targetFormat, matchingFormat);
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tcompleted target format (1. stage): " + targetFormat);
            }
            targetFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(targetFormat, audioInputStream.getFormat());
            if (TDebug.TraceAudioConverter) {
                TDebug.out("MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out("\tcompleted target format (2. stage): " + targetFormat);
            }
            return new DecodedMpegAudioInputStream(targetFormat, audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    private static AudioFormat setUnspecifiedFieldsFromProto(AudioFormat incomplete, AudioFormat prototype) {
        AudioFormat format = new AudioFormat(incomplete.getEncoding(), MpegFormatConversionProvider.getSpecificValue(incomplete.getSampleRate(), prototype.getSampleRate()), MpegFormatConversionProvider.getSpecificValue(incomplete.getSampleSizeInBits(), prototype.getSampleSizeInBits()), MpegFormatConversionProvider.getSpecificValue(incomplete.getChannels(), prototype.getChannels()), MpegFormatConversionProvider.getSpecificValue(incomplete.getFrameSize(), prototype.getFrameSize()), MpegFormatConversionProvider.getSpecificValue(incomplete.getFrameRate(), prototype.getFrameRate()), incomplete.isBigEndian());
        return format;
    }

    private static float getSpecificValue(float fIncomplete, float fProto) {
        return fIncomplete == -1.0f ? fProto : fIncomplete;
    }

    private static int getSpecificValue(int nIncomplete, int nProto) {
        return nIncomplete == -1 ? nProto : nIncomplete;
    }

    public static class DecodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream m_encodedStream;
        private Bitstream m_bitstream;
        private Decoder m_decoder;
        private DMAISObuffer m_oBuffer;

        public DecodedMpegAudioInputStream(AudioFormat outputFormat, AudioInputStream inputStream) {
            super(outputFormat, -1L);
            this.m_encodedStream = inputStream;
            this.m_bitstream = new Bitstream(inputStream);
            this.m_decoder = new Decoder(null);
            this.m_oBuffer = new DMAISObuffer(outputFormat.getChannels());
            this.m_decoder.setOutputBuffer(this.m_oBuffer);
        }

        public void execute() {
            block6: {
                try {
                    Header header = this.m_bitstream.readFrame();
                    if (header == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out("header is null (end of mpeg stream)");
                        }
                        this.getCircularBuffer().close();
                        return;
                    }
                    Obuffer decoderOutput = this.m_decoder.decodeFrame(header, this.m_bitstream);
                    this.m_bitstream.closeFrame();
                    this.getCircularBuffer().write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
                    this.m_oBuffer.reset();
                }
                catch (BitstreamException e2) {
                    if (TDebug.TraceAudioConverter || TDebug.TraceAllExceptions) {
                        TDebug.out(e2);
                    }
                }
                catch (DecoderException e3) {
                    if (!TDebug.TraceAudioConverter && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out(e3);
                }
            }
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }

        private class DMAISObuffer
        extends Obuffer {
            private int m_nChannels;
            private byte[] m_abBuffer;
            private int[] m_anBufferPointers;
            private boolean m_bIsBigEndian;

            public DMAISObuffer(int nChannels) {
                this.m_nChannels = nChannels;
                this.m_abBuffer = new byte[2304 * nChannels];
                this.m_anBufferPointers = new int[nChannels];
                this.reset();
                this.m_bIsBigEndian = DecodedMpegAudioInputStream.this.isBigEndian();
            }

            public void append(int nChannel, short sValue) {
                TConversionTool.shortToBytes16(sValue, this.m_abBuffer, this.m_anBufferPointers[nChannel], this.m_bIsBigEndian);
                int n2 = nChannel;
                this.m_anBufferPointers[n2] = this.m_anBufferPointers[n2] + this.m_nChannels * 2;
            }

            public void set_stop_flag() {
            }

            public void close() {
            }

            public void write_buffer(int nValue) {
            }

            public void clear_buffer() {
            }

            public byte[] getBuffer() {
                return this.m_abBuffer;
            }

            public int getCurrentBufferSize() {
                return this.m_anBufferPointers[0];
            }

            public void reset() {
                for (int i2 = 0; i2 < this.m_nChannels; ++i2) {
                    this.m_anBufferPointers[i2] = i2 * 2;
                }
            }
        }
    }
}

