/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.sqlite.Codes;
import org.sqlite.Conn;
import org.sqlite.Stmt;

final class PrepStmt
extends Stmt
implements PreparedStatement,
ParameterMetaData,
Codes {
    private int columnCount;
    private int paramCount;

    PrepStmt(Conn conn, String string) throws SQLException {
        super(conn);
        this.sql = string;
        this.db.prepare(this);
        this.rs.colsMeta = this.db.column_names(this.pointer);
        this.columnCount = this.db.column_count(this.pointer);
        this.paramCount = this.db.bind_parameter_count(this.pointer);
        this.batch = new Object[this.paramCount];
        this.batchPos = 0;
    }

    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.db.reset(this.pointer);
        this.clearBatch();
    }

    protected void finalize() throws SQLException {
        this.close();
    }

    public boolean execute() throws SQLException {
        this.checkOpen();
        this.rs.close();
        this.db.reset(this.pointer);
        this.resultsWaiting = this.db.execute(this, this.batch);
        return this.columnCount != 0;
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        if (this.columnCount == 0) {
            throw new SQLException("query does not return results");
        }
        this.rs.close();
        this.db.reset(this.pointer);
        this.resultsWaiting = this.db.execute(this, this.batch);
        return this.getResultSet();
    }

    public int executeUpdate() throws SQLException {
        this.checkOpen();
        if (this.columnCount != 0) {
            throw new SQLException("query returns results");
        }
        this.rs.close();
        this.db.reset(this.pointer);
        return this.db.executeUpdate(this, this.batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        if (this.batchPos == 0) {
            return new int[0];
        }
        try {
            int[] nArray = this.db.executeBatch(this.pointer, this.batchPos / this.paramCount, this.batch);
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        if (this.pointer == 0L || this.resultsWaiting) {
            return -1;
        }
        return this.db.changes();
    }

    public void addBatch() throws SQLException {
        this.checkOpen();
        this.batchPos += this.paramCount;
        if (this.batchPos + this.paramCount > this.batch.length) {
            Object[] objectArray = new Object[this.batch.length * 2];
            System.arraycopy(this.batch, 0, objectArray, 0, this.batch.length);
            this.batch = objectArray;
        }
        System.arraycopy(this.batch, this.batchPos - this.paramCount, this.batch, this.batchPos, this.paramCount);
    }

    public ParameterMetaData getParameterMetaData() {
        return this;
    }

    public int getParameterCount() throws SQLException {
        this.checkOpen();
        return this.paramCount;
    }

    public String getParameterClassName(int n2) throws SQLException {
        this.checkOpen();
        return "java.lang.String";
    }

    public String getParameterTypeName(int n2) {
        return "VARCHAR";
    }

    public int getParameterType(int n2) {
        return 12;
    }

    public int getParameterMode(int n2) {
        return 1;
    }

    public int getPrecision(int n2) {
        return 0;
    }

    public int getScale(int n2) {
        return 0;
    }

    public int isNullable(int n2) {
        return 1;
    }

    public boolean isSigned(int n2) {
        return true;
    }

    public Statement getStatement() {
        return this;
    }

    private void batch(int n2, Object object) throws SQLException {
        this.checkOpen();
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
        }
        this.batch[this.batchPos + n2 - 1] = object;
    }

    public void setBoolean(int n2, boolean bl) throws SQLException {
        this.setInt(n2, bl ? 1 : 0);
    }

    public void setByte(int n2, byte by) throws SQLException {
        this.setInt(n2, by);
    }

    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.batch(n2, byArray);
    }

    public void setDouble(int n2, double d2) throws SQLException {
        this.batch(n2, new Double(d2));
    }

    public void setFloat(int n2, float f2) throws SQLException {
        this.setDouble(n2, f2);
    }

    public void setInt(int n2, int n3) throws SQLException {
        this.batch(n2, new Integer(n3));
    }

    public void setLong(int n2, long l2) throws SQLException {
        this.batch(n2, new Long(l2));
    }

    public void setNull(int n2, int n3) throws SQLException {
        this.setNull(n2, n3, null);
    }

    public void setNull(int n2, int n3, String string) throws SQLException {
        this.batch(n2, null);
    }

    public void setObject(int n2, Object object) throws SQLException {
        if (object == null) {
            this.batch(n2, null);
        } else if (object instanceof Date) {
            this.batch(n2, new Long(((Date)object).getTime()));
        } else if (object instanceof java.sql.Date) {
            this.batch(n2, new Long(((java.sql.Date)object).getTime()));
        } else if (object instanceof Time) {
            this.batch(n2, new Long(((Time)object).getTime()));
        } else if (object instanceof Timestamp) {
            this.batch(n2, new Long(((Timestamp)object).getTime()));
        } else if (object instanceof Long) {
            this.batch(n2, object);
        } else if (object instanceof Integer) {
            this.batch(n2, object);
        } else if (object instanceof Float) {
            this.batch(n2, object);
        } else if (object instanceof Double) {
            this.batch(n2, object);
        } else {
            this.batch(n2, object.toString());
        }
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObject(n2, object);
    }

    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.setObject(n2, object);
    }

    public void setShort(int n2, short s2) throws SQLException {
        this.setInt(n2, s2);
    }

    public void setString(int n2, String string) throws SQLException {
        this.batch(n2, string);
    }

    public void setDate(int n2, java.sql.Date date) throws SQLException {
        this.setObject(n2, date);
    }

    public void setDate(int n2, java.sql.Date date, Calendar calendar) throws SQLException {
        this.setObject(n2, date);
    }

    public void setTime(int n2, Time time) throws SQLException {
        this.setObject(n2, time);
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.setObject(n2, time);
    }

    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.setObject(n2, timestamp);
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setObject(n2, timestamp);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this.rs;
    }

    public boolean execute(String string) throws SQLException {
        throw this.unused();
    }

    public int executeUpdate(String string) throws SQLException {
        throw this.unused();
    }

    public ResultSet executeQuery(String string) throws SQLException {
        throw this.unused();
    }

    public void addBatch(String string) throws SQLException {
        throw this.unused();
    }

    private SQLException unused() {
        return new SQLException("not supported by PreparedStatment");
    }
}

