/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.PrintWriter;
import java.sql.SQLException;
import org.ibex.nestedvm.Runtime;
import org.sqlite.DB;
import org.sqlite.Function;

final class NestedDB
extends DB
implements Runtime.CallJavaCB {
    int handle = 0;
    private Runtime rt = null;
    private Function[] functions = null;
    private String[] funcNames = null;
    private final int[] p0 = new int[0];
    private final int[] p1 = new int[]{0};
    private final int[] p2 = new int[]{0, 0};
    private final int[] p3 = new int[]{0, 0, 0};
    private final int[] p4 = new int[]{0, 0, 0, 0};
    private final int[] p5 = new int[]{0, 0, 0, 0, 0};

    NestedDB() {
    }

    protected synchronized void _open(String string) throws SQLException {
        if (this.handle != 0) {
            throw new SQLException("DB already open");
        }
        if (string.length() > 2) {
            char c2 = Character.toLowerCase(string.charAt(0));
            if (string.charAt(1) == ':' && c2 >= 'a' && c2 <= 'z') {
                string = string.substring(2);
                string = string.replace('\\', '/');
                string = "/" + c2 + ":" + string;
            }
        }
        try {
            this.rt = (Runtime)Class.forName("org.sqlite.SQLite").newInstance();
            this.rt.start();
        }
        catch (Exception exception) {
            throw new CausedSQLException(exception);
        }
        this.rt.setCallJavaCB(this);
        int n2 = this.rt.xmalloc(4);
        int n3 = this.rt.strdup(string);
        if (this.call("sqlite3_open", n3, n2) != 0) {
            this.throwex();
        }
        this.handle = this.deref(n2);
        this.rt.free(n3);
        this.rt.free(n2);
    }

    public int call(int n2, int n3, int n4, int n5) {
        this.xUDF(n2, n3, n4, n5);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void _close() throws SQLException {
        if (this.handle == 0) {
            return;
        }
        try {
            if (this.call("sqlite3_close", this.handle) != 0) {
                this.throwex();
            }
        }
        finally {
            this.handle = 0;
            this.rt.stop();
            this.rt = null;
        }
    }

    int shared_cache(boolean bl) throws SQLException {
        return -1;
    }

    synchronized void interrupt() throws SQLException {
        this.call("sqlite3_interrupt", this.handle);
    }

    synchronized void busy_timeout(int n2) throws SQLException {
        this.call("sqlite3_busy_timeout", this.handle, n2);
    }

    protected synchronized long prepare(String string) throws SQLException {
        int n2 = this.rt.xmalloc(4);
        int n3 = this.rt.strdup(string);
        int n4 = this.call("sqlite3_prepare_v2", this.handle, n3, -1, n2, 0);
        this.rt.free(n3);
        if (n4 != 0) {
            this.rt.free(n2);
            this.throwex();
        }
        int n5 = this.deref(n2);
        this.rt.free(n2);
        return n5;
    }

    synchronized String errmsg() throws SQLException {
        return this.cstring(this.call("sqlite3_errmsg", this.handle));
    }

    synchronized String libversion() throws SQLException {
        return this.cstring(this.call("sqlite3_libversion", this.handle));
    }

    synchronized int changes() throws SQLException {
        return this.call("sqlite3_changes", this.handle);
    }

    protected synchronized int finalize(long l2) throws SQLException {
        return this.call("sqlite3_finalize", (int)l2);
    }

    protected synchronized int step(long l2) throws SQLException {
        return this.call("sqlite3_step", (int)l2);
    }

    protected synchronized int reset(long l2) throws SQLException {
        return this.call("sqlite3_reset", (int)l2);
    }

    synchronized int clear_bindings(long l2) throws SQLException {
        return this.call("sqlite3_clear_bindings", (int)l2);
    }

    synchronized int bind_parameter_count(long l2) throws SQLException {
        return this.call("sqlite3_bind_parameter_count", (int)l2);
    }

    synchronized int column_count(long l2) throws SQLException {
        return this.call("sqlite3_column_count", (int)l2);
    }

    synchronized int column_type(long l2, int n2) throws SQLException {
        return this.call("sqlite3_column_type", (int)l2, n2);
    }

    synchronized String column_name(long l2, int n2) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_name", (int)l2, n2));
    }

    synchronized String column_text(long l2, int n2) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_text", (int)l2, n2));
    }

    synchronized byte[] column_blob(long l2, int n2) throws SQLException {
        int n3 = this.call("sqlite3_column_blob", (int)l2, n2);
        if (n3 == 0) {
            return null;
        }
        byte[] byArray = new byte[this.call("sqlite3_column_bytes", (int)l2, n2)];
        this.copyin(n3, byArray, byArray.length);
        return byArray;
    }

    synchronized double column_double(long l2, int n2) throws SQLException {
        try {
            return Double.parseDouble(this.column_text(l2, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    synchronized long column_long(long l2, int n2) throws SQLException {
        try {
            return Long.parseLong(this.column_text(l2, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    synchronized int column_int(long l2, int n2) throws SQLException {
        return this.call("sqlite3_column_int", (int)l2, n2);
    }

    synchronized String column_decltype(long l2, int n2) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_decltype", (int)l2, n2));
    }

    synchronized String column_table_name(long l2, int n2) throws SQLException {
        return this.utfstring(this.call("sqlite3_column_table_name", (int)l2, n2));
    }

    synchronized int bind_null(long l2, int n2) throws SQLException {
        return this.call("sqlite3_bind_null", (int)l2, n2);
    }

    synchronized int bind_int(long l2, int n2, int n3) throws SQLException {
        return this.call("sqlite3_bind_int", (int)l2, n2, n3);
    }

    synchronized int bind_long(long l2, int n2, long l3) throws SQLException {
        return this.bind_text(l2, n2, Long.toString(l3));
    }

    synchronized int bind_double(long l2, int n2, double d2) throws SQLException {
        return this.bind_text(l2, n2, Double.toString(d2));
    }

    synchronized int bind_text(long l2, int n2, String string) throws SQLException {
        if (string == null) {
            return this.bind_null(l2, n2);
        }
        return this.call("sqlite3_bind_text", (int)l2, n2, this.rt.strdup(string), -1, this.rt.lookupSymbol("free"));
    }

    synchronized int bind_blob(long l2, int n2, byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length < 1) {
            return this.bind_null(l2, n2);
        }
        int n3 = byArray.length;
        int n4 = this.rt.xmalloc(n3);
        this.copyout(byArray, n4, n3);
        return this.call("sqlite3_bind_blob", (int)l2, n2, n4, n3, this.rt.lookupSymbol("free"));
    }

    synchronized void result_null(long l2) throws SQLException {
        this.call("sqlite3_result_null", (int)l2);
    }

    synchronized void result_text(long l2, String string) throws SQLException {
        this.call("sqlite3_result_text", (int)l2, this.rt.strdup(string), -1, this.rt.lookupSymbol("free"));
    }

    synchronized void result_blob(long l2, byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            this.result_null(l2);
            return;
        }
        int n2 = this.rt.xmalloc(byArray.length);
        this.copyout(byArray, n2, byArray.length);
        this.call("sqlite3_result_blob", (int)l2, n2, byArray.length, this.rt.lookupSymbol("free"));
    }

    synchronized void result_double(long l2, double d2) throws SQLException {
        this.result_text(l2, Double.toString(d2));
    }

    synchronized void result_long(long l2, long l3) throws SQLException {
        this.result_text(l2, Long.toString(l3));
    }

    synchronized void result_int(long l2, int n2) throws SQLException {
        this.call("sqlite3_result_int", (int)l2, n2);
    }

    synchronized void result_error(long l2, String string) throws SQLException {
        int n2 = this.rt.strdup(string);
        this.call("sqlite3_result_error", (int)l2, n2, -1);
        this.rt.free(n2);
    }

    synchronized int value_bytes(Function function, int n2) throws SQLException {
        return this.call("sqlite3_value_bytes", this.value(function, n2));
    }

    synchronized String value_text(Function function, int n2) throws SQLException {
        return this.utfstring(this.call("sqlite3_value_text", this.value(function, n2)));
    }

    synchronized byte[] value_blob(Function function, int n2) throws SQLException {
        int n3 = this.call("sqlite3_value_blob", this.value(function, n2));
        if (n3 == 0) {
            return null;
        }
        byte[] byArray = new byte[this.value_bytes(function, n2)];
        this.copyin(n3, byArray, byArray.length);
        return byArray;
    }

    synchronized double value_double(Function function, int n2) throws SQLException {
        return Double.parseDouble(this.value_text(function, n2));
    }

    synchronized long value_long(Function function, int n2) throws SQLException {
        return Long.parseLong(this.value_text(function, n2));
    }

    synchronized int value_int(Function function, int n2) throws SQLException {
        return this.call("sqlite3_value_int", this.value(function, n2));
    }

    synchronized int value_type(Function function, int n2) throws SQLException {
        return this.call("sqlite3_value_type", this.value(function, n2));
    }

    private int value(Function function, int n2) throws SQLException {
        return this.deref((int)function.value + n2 * 4);
    }

    synchronized int create_function(String string, Function function) throws SQLException {
        int n2;
        if (this.functions == null) {
            this.functions = new Function[10];
            this.funcNames = new String[10];
        }
        for (n2 = 0; n2 < this.functions.length && this.functions[n2] != null; ++n2) {
        }
        if (n2 == this.functions.length) {
            Function[] functionArray = new Function[this.functions.length * 2];
            String[] stringArray = new String[this.funcNames.length * 2];
            System.arraycopy(this.functions, 0, functionArray, 0, this.functions.length);
            System.arraycopy(this.funcNames, 0, stringArray, 0, this.funcNames.length);
            this.functions = functionArray;
            this.funcNames = stringArray;
        }
        this.functions[n2] = function;
        this.funcNames[n2] = string;
        int n3 = this.rt.strdup(string);
        int n4 = this.call("create_function_helper", this.handle, n3, n2, function instanceof Function.Aggregate ? 1 : 0);
        this.rt.free(n3);
        return n4;
    }

    synchronized int destroy_function(String string) throws SQLException {
        int n2;
        if (string == null) {
            return 0;
        }
        for (n2 = 0; n2 < this.funcNames.length && !string.equals(this.funcNames[n2]); ++n2) {
        }
        if (n2 == this.funcNames.length) {
            return 0;
        }
        this.functions[n2] = null;
        this.funcNames[n2] = null;
        int n3 = this.rt.strdup(string);
        int n4 = this.call("create_function_helper", this.handle, n3, -1, 0);
        this.rt.free(n3);
        return n4;
    }

    synchronized void free_functions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void xUDF(int n2, int n3, int n4, int n5) {
        Function function = null;
        try {
            int n6 = this.call("sqlite3_user_data", n3);
            function = this.functions[n6];
            if (function == null) {
                throw new SQLException("function state inconsistent");
            }
            function.context = n3;
            function.value = n5;
            function.args = n4;
            switch (n2) {
                case 1: {
                    function.xFunc();
                    return;
                }
                case 2: {
                    ((Function.Aggregate)function).xStep();
                    return;
                }
                case 3: {
                    ((Function.Aggregate)function).xFinal();
                    return;
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            try {
                String string = sQLException.toString();
                if (string == null) {
                    string = "unknown error";
                }
                int n7 = this.rt.strdup(string);
                this.call("sqlite3_result_error", n3, n7, -1);
                this.rt.free(n7);
                return;
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                return;
            }
        }
        finally {
            if (function != null) {
                function.context = 0L;
                function.value = 0L;
                function.args = 0;
            }
        }
    }

    synchronized boolean[][] column_metadata(long l2) throws SQLException {
        int n2 = this.call("sqlite3_column_count", (int)l2);
        boolean[][] blArray = new boolean[n2][3];
        int n3 = this.rt.xmalloc(12);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.call("column_metadata_helper", this.handle, (int)l2, i2, n3);
            blArray[i2][0] = this.deref(n3) == 1;
            blArray[i2][1] = this.deref(n3 + 4) == 1;
            blArray[i2][2] = this.deref(n3 + 8) == 1;
        }
        this.rt.free(n3);
        return blArray;
    }

    private int call(String string, int n2) throws SQLException {
        this.p1[0] = n2;
        return this.call(string, this.p1);
    }

    private int call(String string, int n2, int n3) throws SQLException {
        this.p2[0] = n2;
        this.p2[1] = n3;
        return this.call(string, this.p2);
    }

    private int call(String string, int n2, int n3, int n4) throws SQLException {
        this.p3[0] = n2;
        this.p3[1] = n3;
        this.p3[2] = n4;
        return this.call(string, this.p3);
    }

    private int call(String string, int n2, int n3, int n4, int n5) throws SQLException {
        this.p4[0] = n2;
        this.p4[1] = n3;
        this.p4[2] = n4;
        this.p4[3] = n5;
        return this.call(string, this.p4);
    }

    private int call(String string, int n2, int n3, int n4, int n5, int n6) throws SQLException {
        this.p5[0] = n2;
        this.p5[1] = n3;
        this.p5[2] = n4;
        this.p5[3] = n5;
        this.p5[4] = n6;
        return this.call(string, this.p5);
    }

    private int call(String string, int[] nArray) throws SQLException {
        try {
            return this.rt.call(string, nArray);
        }
        catch (Runtime.CallException callException) {
            throw new CausedSQLException(callException);
        }
    }

    private int deref(int n2) throws SQLException {
        try {
            return this.rt.memRead(n2);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private String utfstring(int n2) throws SQLException {
        try {
            return this.rt.utfstring(n2);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private String cstring(int n2) throws SQLException {
        try {
            return this.rt.cstring(n2);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private void copyin(int n2, byte[] byArray, int n3) throws SQLException {
        try {
            this.rt.copyin(n2, byArray, n3);
        }
        catch (Runtime.ReadFaultException readFaultException) {
            throw new CausedSQLException(readFaultException);
        }
    }

    private void copyout(byte[] byArray, int n2, int n3) throws SQLException {
        try {
            this.rt.copyout(byArray, n2, n3);
        }
        catch (Runtime.FaultException faultException) {
            throw new CausedSQLException(faultException);
        }
    }

    private static final class CausedSQLException
    extends SQLException {
        private final Exception cause;

        CausedSQLException(Exception exception) {
            if (exception == null) {
                throw new RuntimeException("null exception cause");
            }
            this.cause = exception;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public void printStackTrace() {
            this.cause.printStackTrace();
        }

        public void printStackTrace(PrintWriter printWriter) {
            this.cause.printStackTrace(printWriter);
        }

        public Throwable fillInStackTrace() {
            return this.cause.fillInStackTrace();
        }

        public StackTraceElement[] getStackTrace() {
            return this.cause.getStackTrace();
        }

        public String getMessage() {
            return this.cause.getMessage();
        }
    }
}

