/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.sqlite.Codes;
import org.sqlite.Conn;
import org.sqlite.Function;
import org.sqlite.Stmt;

abstract class DB
implements Codes {
    Conn conn = null;
    long begin = 0L;
    long commit = 0L;
    private Map stmts = new Hashtable();

    DB() {
    }

    abstract void interrupt() throws SQLException;

    abstract void busy_timeout(int var1) throws SQLException;

    abstract String errmsg() throws SQLException;

    abstract String libversion() throws SQLException;

    abstract int changes() throws SQLException;

    abstract int shared_cache(boolean var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void exec(String string) throws SQLException {
        long l2 = 0L;
        try {
            l2 = this.prepare(string);
            switch (this.step(l2)) {
                case 101: {
                    this.ensureAutoCommit();
                    return;
                }
                case 100: {
                    return;
                }
            }
            this.throwex();
        }
        finally {
            this.finalize(l2);
        }
    }

    final synchronized void open(Conn conn, String string) throws SQLException {
        this.conn = conn;
        this._open(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void close() throws SQLException {
        Map map = this.stmts;
        synchronized (map) {
            Iterator iterator = this.stmts.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Stmt stmt = (Stmt)entry.getValue();
                this.finalize((Long)entry.getKey());
                if (stmt != null) {
                    stmt.pointer = 0L;
                }
                iterator.remove();
            }
        }
        this.free_functions();
        if (this.begin != 0L) {
            this.finalize(this.begin);
            this.begin = 0L;
        }
        if (this.commit != 0L) {
            this.finalize(this.commit);
            this.commit = 0L;
        }
        this._close();
    }

    final synchronized void prepare(Stmt stmt) throws SQLException {
        if (stmt.pointer != 0L) {
            this.finalize(stmt);
        }
        stmt.pointer = this.prepare(stmt.sql);
        this.stmts.put(new Long(stmt.pointer), stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized int finalize(Stmt stmt) throws SQLException {
        if (stmt.pointer == 0L) {
            return 0;
        }
        int n2 = 1;
        try {
            n2 = this.finalize(stmt.pointer);
        }
        finally {
            this.stmts.remove(new Long(stmt.pointer));
            stmt.pointer = 0L;
        }
        return n2;
    }

    protected abstract void _open(String var1) throws SQLException;

    protected abstract void _close() throws SQLException;

    protected abstract long prepare(String var1) throws SQLException;

    protected abstract int finalize(long var1) throws SQLException;

    protected abstract int step(long var1) throws SQLException;

    protected abstract int reset(long var1) throws SQLException;

    abstract int clear_bindings(long var1) throws SQLException;

    abstract int bind_parameter_count(long var1) throws SQLException;

    abstract int column_count(long var1) throws SQLException;

    abstract int column_type(long var1, int var3) throws SQLException;

    abstract String column_decltype(long var1, int var3) throws SQLException;

    abstract String column_table_name(long var1, int var3) throws SQLException;

    abstract String column_name(long var1, int var3) throws SQLException;

    abstract String column_text(long var1, int var3) throws SQLException;

    abstract byte[] column_blob(long var1, int var3) throws SQLException;

    abstract double column_double(long var1, int var3) throws SQLException;

    abstract long column_long(long var1, int var3) throws SQLException;

    abstract int column_int(long var1, int var3) throws SQLException;

    abstract int bind_null(long var1, int var3) throws SQLException;

    abstract int bind_int(long var1, int var3, int var4) throws SQLException;

    abstract int bind_long(long var1, int var3, long var4) throws SQLException;

    abstract int bind_double(long var1, int var3, double var4) throws SQLException;

    abstract int bind_text(long var1, int var3, String var4) throws SQLException;

    abstract int bind_blob(long var1, int var3, byte[] var4) throws SQLException;

    abstract void result_null(long var1) throws SQLException;

    abstract void result_text(long var1, String var3) throws SQLException;

    abstract void result_blob(long var1, byte[] var3) throws SQLException;

    abstract void result_double(long var1, double var3) throws SQLException;

    abstract void result_long(long var1, long var3) throws SQLException;

    abstract void result_int(long var1, int var3) throws SQLException;

    abstract void result_error(long var1, String var3) throws SQLException;

    abstract int value_bytes(Function var1, int var2) throws SQLException;

    abstract String value_text(Function var1, int var2) throws SQLException;

    abstract byte[] value_blob(Function var1, int var2) throws SQLException;

    abstract double value_double(Function var1, int var2) throws SQLException;

    abstract long value_long(Function var1, int var2) throws SQLException;

    abstract int value_int(Function var1, int var2) throws SQLException;

    abstract int value_type(Function var1, int var2) throws SQLException;

    abstract int create_function(String var1, Function var2) throws SQLException;

    abstract int destroy_function(String var1) throws SQLException;

    abstract void free_functions() throws SQLException;

    abstract boolean[][] column_metadata(long var1) throws SQLException;

    final synchronized String[] column_names(long l2) throws SQLException {
        String[] stringArray = new String[this.column_count(l2)];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.column_name(l2, i2);
        }
        return stringArray;
    }

    final synchronized int sqlbind(long l2, int n2, Object object) throws SQLException {
        ++n2;
        if (object == null) {
            return this.bind_null(l2, n2);
        }
        if (object instanceof Integer) {
            return this.bind_int(l2, n2, (Integer)object);
        }
        if (object instanceof Long) {
            return this.bind_long(l2, n2, (Long)object);
        }
        if (object instanceof Double) {
            return this.bind_double(l2, n2, (Double)object);
        }
        if (object instanceof String) {
            return this.bind_text(l2, n2, (String)object);
        }
        if (object instanceof byte[]) {
            return this.bind_blob(l2, n2, (byte[])object);
        }
        throw new SQLException("unexpected param type: " + object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized int[] executeBatch(long l2, int n2, Object[] objectArray) throws SQLException {
        if (n2 < 1) {
            throw new SQLException("count (" + n2 + ") < 1");
        }
        int n3 = this.bind_parameter_count(l2);
        int[] nArray = new int[n2];
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.reset(l2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (this.sqlbind(l2, i3, objectArray[i2 * n3 + i3]) == 0) continue;
                    this.throwex();
                }
                int n4 = this.step(l2);
                if (n4 != 101) {
                    this.reset(l2);
                    if (n4 == 100) {
                        throw new BatchUpdateException("batch entry " + i2 + ": query returns results", nArray);
                    }
                    this.throwex();
                }
                nArray[i2] = this.changes();
            }
        }
        finally {
            this.ensureAutoCommit();
        }
        this.reset(l2);
        return nArray;
    }

    final synchronized boolean execute(Stmt stmt, Object[] objectArray) throws SQLException {
        if (objectArray != null) {
            int n2 = this.bind_parameter_count(stmt.pointer);
            if (n2 != objectArray.length) {
                throw new SQLException("assertion failure: param count (" + n2 + ") != value count (" + objectArray.length + ")");
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.sqlbind(stmt.pointer, i2, objectArray[i2]) == 0) continue;
                this.throwex();
            }
        }
        switch (this.step(stmt.pointer)) {
            case 101: {
                this.reset(stmt.pointer);
                this.ensureAutoCommit();
                return false;
            }
            case 100: {
                return true;
            }
            case 5: 
            case 6: {
                throw new SQLException("database locked");
            }
            case 21: {
                throw new SQLException(this.errmsg());
            }
        }
        this.finalize(stmt);
        throw new SQLException(this.errmsg());
    }

    final synchronized int executeUpdate(Stmt stmt, Object[] objectArray) throws SQLException {
        if (this.execute(stmt, objectArray)) {
            throw new SQLException("query returns results");
        }
        this.reset(stmt.pointer);
        return this.changes();
    }

    final void throwex() throws SQLException {
        throw new SQLException(this.errmsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureAutoCommit() throws SQLException {
        if (!this.conn.getAutoCommit()) {
            return;
        }
        if (this.begin == 0L) {
            this.begin = this.prepare("begin;");
        }
        if (this.commit == 0L) {
            this.commit = this.prepare("commit;");
        }
        try {
            if (this.step(this.begin) != 101) {
                return;
            }
            if (this.step(this.commit) != 101) {
                this.reset(this.commit);
                this.throwex();
            }
        }
        finally {
            this.reset(this.begin);
            this.reset(this.commit);
        }
    }
}

