/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.geom.Point2D;
import org.jgraph.util.Spline;

public class Spline2D {
    private double[] t;
    private Spline splineX;
    private Spline splineY;
    private double length;

    public Spline2D(Point2D[] point2DArray) {
        double[] dArray = new double[point2DArray.length];
        double[] dArray2 = new double[point2DArray.length];
        for (int i2 = 0; i2 < point2DArray.length; ++i2) {
            dArray[i2] = point2DArray[i2].getX();
            dArray2[i2] = point2DArray[i2].getY();
        }
        this.init(dArray, dArray2);
    }

    public Spline2D(double[] dArray, double[] dArray2) {
        this.init(dArray, dArray2);
    }

    private void init(double[] dArray, double[] dArray2) {
        int n2;
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must have the same length.");
        }
        if (dArray.length < 2) {
            throw new IllegalArgumentException("Spline edges must have at least two points.");
        }
        this.t = new double[dArray.length];
        this.t[0] = 0.0;
        for (n2 = 1; n2 < this.t.length; ++n2) {
            double d2 = dArray[n2] - dArray[n2 - 1];
            double d3 = dArray2[n2] - dArray2[n2 - 1];
            this.t[n2] = 0.0 == d2 ? Math.abs(d3) : (0.0 == d3 ? Math.abs(d2) : Math.sqrt(d2 * d2 + d3 * d3));
            this.length += this.t[n2];
            int n3 = n2;
            this.t[n3] = this.t[n3] + this.t[n2 - 1];
        }
        for (n2 = 1; n2 < this.t.length - 1; ++n2) {
            this.t[n2] = this.t[n2] / this.length;
        }
        this.t[this.t.length - 1] = 1.0;
        this.splineX = new Spline(this.t, dArray);
        this.splineY = new Spline(this.t, dArray2);
    }

    public double[] getPoint(double d2) {
        double[] dArray = new double[]{this.splineX.getValue(d2), this.splineY.getValue(d2)};
        return dArray;
    }

    public double getDx(double d2) {
        return this.splineX.getDx(d2);
    }

    public double getDy(double d2) {
        return this.splineY.getDx(d2);
    }

    public double getLength() {
        return this.length;
    }
}

