/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.util.Arrays;

public class Spline {
    private double[] xx;
    private double[] yy;
    private double[] a;
    private double[] b;
    private double[] c;
    private double[] d;

    public Spline(double[] dArray, double[] dArray2) {
        this.setValues(dArray, dArray2);
    }

    public void setValues(double[] dArray, double[] dArray2) {
        this.xx = dArray;
        this.yy = dArray2;
        if (dArray.length > 1) {
            this.calculateCoefficients();
        }
    }

    public double getValue(double d2) {
        if (this.xx.length == 0) {
            return Double.NaN;
        }
        if (this.xx.length == 1) {
            if (this.xx[0] == d2) {
                return this.yy[0];
            }
            return Double.NaN;
        }
        int n2 = Arrays.binarySearch(this.xx, d2);
        if (n2 > 0) {
            return this.yy[n2];
        }
        if ((n2 = -(n2 + 1) - 1) < 0) {
            return this.yy[0];
        }
        return this.a[n2] + this.b[n2] * (d2 - this.xx[n2]) + this.c[n2] * Math.pow(d2 - this.xx[n2], 2.0) + this.d[n2] * Math.pow(d2 - this.xx[n2], 3.0);
    }

    public double getDx(double d2) {
        if (this.xx.length == 0 || this.xx.length == 1) {
            return 0.0;
        }
        int n2 = Arrays.binarySearch(this.xx, d2);
        if (n2 < 0) {
            n2 = -(n2 + 1) - 1;
        }
        return this.b[n2] + 2.0 * this.c[n2] * (d2 - this.xx[n2]) + 3.0 * this.d[n2] * Math.pow(d2 - this.xx[n2], 2.0);
    }

    private void calculateCoefficients() {
        int n2;
        int n3 = this.yy.length;
        this.a = new double[n3];
        this.b = new double[n3];
        this.c = new double[n3];
        this.d = new double[n3];
        if (n3 == 2) {
            this.a[0] = this.yy[0];
            this.b[0] = this.yy[1] - this.yy[0];
            return;
        }
        double[] dArray = new double[n3 - 1];
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            this.a[i2] = this.yy[i2];
            dArray[i2] = this.xx[i2 + 1] - this.xx[i2];
        }
        this.a[n3 - 1] = this.yy[n3 - 1];
        double[][] dArray2 = new double[n3 - 2][n3 - 2];
        double[] dArray3 = new double[n3 - 2];
        for (n2 = 0; n2 < n3 - 2; ++n2) {
            dArray3[n2] = 3.0 * ((this.yy[n2 + 2] - this.yy[n2 + 1]) / dArray[n2 + 1] - (this.yy[n2 + 1] - this.yy[n2]) / dArray[n2]);
            dArray2[n2][n2] = 2.0 * (dArray[n2] + dArray[n2 + 1]);
            if (n2 > 0) {
                dArray2[n2][n2 - 1] = dArray[n2];
            }
            if (n2 >= n3 - 3) continue;
            dArray2[n2][n2 + 1] = dArray[n2 + 1];
        }
        this.solve(dArray2, dArray3);
        for (n2 = 0; n2 < n3 - 2; ++n2) {
            this.c[n2 + 1] = dArray3[n2];
            this.b[n2] = (this.a[n2 + 1] - this.a[n2]) / dArray[n2] - (2.0 * this.c[n2] + this.c[n2 + 1]) / 3.0 * dArray[n2];
            this.d[n2] = (this.c[n2 + 1] - this.c[n2]) / (3.0 * dArray[n2]);
        }
        this.b[n3 - 2] = (this.a[n3 - 1] - this.a[n3 - 2]) / dArray[n3 - 2] - (2.0 * this.c[n3 - 2] + this.c[n3 - 1]) / 3.0 * dArray[n3 - 2];
        this.d[n3 - 2] = (this.c[n3 - 1] - this.c[n3 - 2]) / (3.0 * dArray[n3 - 2]);
    }

    public void solve(double[][] dArray, double[] dArray2) {
        int n2;
        int n3 = dArray2.length;
        for (n2 = 1; n2 < n3; ++n2) {
            dArray[n2][n2 - 1] = dArray[n2][n2 - 1] / dArray[n2 - 1][n2 - 1];
            dArray[n2][n2] = dArray[n2][n2] - dArray[n2 - 1][n2] * dArray[n2][n2 - 1];
            dArray2[n2] = dArray2[n2] - dArray[n2][n2 - 1] * dArray2[n2 - 1];
        }
        dArray2[n3 - 1] = dArray2[n3 - 1] / dArray[n3 - 1][n3 - 1];
        for (n2 = dArray2.length - 2; n2 >= 0; --n2) {
            dArray2[n2] = (dArray2[n2] - dArray[n2][n2 + 1] * dArray2[n2 + 1]) / dArray[n2][n2];
        }
    }
}

