/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class EdgeView
extends AbstractCellView {
    public static transient EdgeRenderer renderer = new EdgeRenderer();
    protected transient List points;
    protected transient CellView source;
    protected transient CellView target;
    protected transient Point2D labelPosition;
    protected transient Point2D[] extraLabelPositions;
    public Shape beginShape;
    public Shape endShape;
    public Shape lineShape;
    public transient GeneralPath sharedPath = null;
    protected transient Rectangle2D cachedLabelBounds = null;
    protected transient Rectangle2D[] cachedExtraLabelBounds = null;
    protected transient Rectangle2D cachedBounds = null;
    protected transient Point2D labelVector = null;
    protected transient CellView sourceParentView;
    protected transient CellView targetParentView;

    public EdgeView() {
    }

    public EdgeView(Object object) {
        super(object);
    }

    public void refresh(GraphModel graphModel, CellMapper cellMapper, boolean bl) {
        this.points = null;
        super.refresh(graphModel, cellMapper, bl);
        Object object = graphModel.getSource(this.cell);
        Object object2 = graphModel.getTarget(this.cell);
        this.setSource(cellMapper.getMapping(object, bl));
        this.setTarget(cellMapper.getMapping(object2, bl));
        this.sourceParentView = object != null && this.getSource() == null ? this.getVisibleParent(graphModel, cellMapper, object) : null;
        this.targetParentView = object2 != null && this.getTarget() == null ? this.getVisibleParent(graphModel, cellMapper, object2) : null;
    }

    protected CellView getVisibleParent(GraphModel graphModel, CellMapper cellMapper, Object object) {
        CellView cellView = null;
        do {
            cellView = cellMapper.getMapping(object, false);
            object = graphModel.getParent(object);
        } while (cellView == null && object != null);
        return cellView;
    }

    public void update() {
        super.update();
        ArrayList<Point2D> arrayList = GraphConstants.getPoints(this.allAttributes);
        if (arrayList == null) {
            arrayList = new ArrayList<Point2D>(4);
            arrayList.add(this.allAttributes.createPoint(10.0, 10.0));
            arrayList.add(this.allAttributes.createPoint(20.0, 20.0));
            GraphConstants.setPoints(this.allAttributes, arrayList);
        }
        if (this.points == null) {
            this.points = arrayList;
        }
        Edge.Routing routing = GraphConstants.getRouting(this.allAttributes);
        List list = null;
        if (routing != null) {
            list = routing.route(this);
        }
        List<Point2D> list2 = this.points = list != null && !list.isEmpty() ? list : arrayList;
        if (this.points == arrayList) {
            if (this.source != null) {
                this.setSource(this.source);
            }
            if (this.target != null) {
                this.setTarget(this.target);
            }
        }
        this.checkDefaultLabelPosition();
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(this.allAttributes);
        if (point2DArray != null) {
            this.extraLabelPositions = new Point2D[point2DArray.length];
            for (int i2 = 0; i2 < point2DArray.length; ++i2) {
                this.extraLabelPositions[i2] = point2DArray[i2];
            }
        } else {
            this.extraLabelPositions = null;
        }
        this.beginShape = null;
        this.endShape = null;
        this.lineShape = null;
        this.invalidate();
    }

    protected void checkDefaultLabelPosition() {
        this.labelPosition = GraphConstants.getLabelPosition(this.allAttributes);
        String string = String.valueOf(this.getCell());
        if (this.labelPosition == null && string != null && string.length() > 0) {
            int n2 = 500;
            this.labelPosition = new Point(n2, 0);
            GraphConstants.setLabelPosition(this.allAttributes, this.labelPosition);
        }
    }

    void invalidate() {
        this.labelVector = null;
        this.sharedPath = null;
        this.cachedBounds = null;
        this.cachedLabelBounds = null;
        this.cachedExtraLabelBounds = null;
    }

    public Shape getShape() {
        if (this.sharedPath != null) {
            return this.sharedPath;
        }
        this.sharedPath = (GeneralPath)this.getEdgeRenderer().createShape();
        return this.sharedPath;
    }

    public Rectangle2D getLabelBounds() {
        if (this.cachedLabelBounds != null) {
            return this.cachedLabelBounds;
        }
        this.cachedLabelBounds = this.getEdgeRenderer().getLabelBounds(null, this);
        return this.cachedLabelBounds;
    }

    public Rectangle2D getExtraLabelBounds(int n2) {
        if (this.cachedLabelBounds != null && n2 < this.cachedExtraLabelBounds.length && this.cachedExtraLabelBounds[n2] != null) {
            return this.cachedExtraLabelBounds[n2];
        }
        this.cachedExtraLabelBounds[n2] = this.getEdgeRenderer().getExtraLabelBounds(null, this, n2);
        return this.cachedExtraLabelBounds[n2];
    }

    public boolean intersects(JGraph jGraph, Rectangle2D rectangle2D) {
        boolean bl = super.intersects(jGraph, rectangle2D);
        if (!this.isLeaf()) {
            return bl;
        }
        if (bl) {
            Rectangle rectangle = new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            return this.getEdgeRenderer().intersects(jGraph, this, rectangle);
        }
        return false;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = super.getBounds();
        if (rectangle2D == null) {
            if (this.cachedBounds == null) {
                this.cachedBounds = this.getEdgeRenderer().getBounds(this);
            }
            rectangle2D = this.cachedBounds;
        }
        return rectangle2D;
    }

    EdgeRenderer getEdgeRenderer() {
        return (EdgeRenderer)this.getRenderer();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return new EdgeHandle(this, graphContext);
    }

    public CellView getSource() {
        return this.source;
    }

    public CellView getSourceParentView() {
        return this.sourceParentView;
    }

    public void setSource(CellView cellView) {
        this.sourceParentView = null;
        this.source = cellView;
        if (this.source != null) {
            this.points.set(0, this.source);
        } else {
            this.points.set(0, this.getPoint(0));
        }
        this.invalidate();
    }

    public CellView getTarget() {
        return this.target;
    }

    public CellView getTargetParentView() {
        return this.targetParentView;
    }

    public void setTarget(CellView cellView) {
        this.target = cellView;
        this.targetParentView = null;
        int n2 = this.points.size() - 1;
        if (this.target != null) {
            this.points.set(n2, this.target);
        } else {
            this.points.set(n2, this.getPoint(n2));
        }
        this.invalidate();
    }

    public Point2D getExtraLabelPosition(int n2) {
        return this.extraLabelPositions[n2];
    }

    public Point2D getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(Point2D point2D) {
        this.labelPosition.setLocation(point2D);
        this.invalidate();
    }

    public void setExtraLabelPosition(int n2, Point2D point2D) {
        this.extraLabelPositions[n2].setLocation(point2D);
        this.invalidate();
    }

    public boolean isLoop() {
        return this.getSource() != null && this.getSource() == this.getTarget() || this.sourceParentView != null && this.sourceParentView == this.targetParentView || this.sourceParentView != null && this.getTarget() != null && this.getTarget().getParentView() == this.sourceParentView || this.targetParentView != null && this.getSource() != null && this.getSource().getParentView() == this.targetParentView;
    }

    public List getPoints() {
        return this.points;
    }

    public int getPointCount() {
        return this.points.size();
    }

    public Point2D getPoint(int n2) {
        Object e2 = this.points.get(n2);
        if (n2 == 0 && this.sourceParentView != null) {
            return this.sourceParentView.getPerimeterPoint(this, EdgeView.getCenterPoint(this.sourceParentView), this.getNearestPoint(n2 == 0));
        }
        if (n2 == this.getPointCount() - 1 && this.targetParentView != null) {
            return this.targetParentView.getPerimeterPoint(this, EdgeView.getCenterPoint(this.targetParentView), this.getNearestPoint(n2 == 0));
        }
        if (e2 instanceof PortView) {
            return ((PortView)e2).getLocation(this, this.getNearestPoint(n2 == 0));
        }
        if (e2 instanceof CellView) {
            Rectangle2D rectangle2D = ((CellView)e2).getBounds();
            return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        }
        if (e2 instanceof Point2D) {
            return (Point2D)e2;
        }
        return null;
    }

    protected Point2D getNearestPoint(boolean bl) {
        if (this.getPointCount() == 2) {
            if (bl && this.targetParentView != null && this.targetParentView.isLeaf()) {
                return EdgeView.getCenterPoint(this.targetParentView);
            }
            if (!bl && this.sourceParentView != null && this.sourceParentView.isLeaf()) {
                return EdgeView.getCenterPoint(this.sourceParentView);
            }
        }
        return this.getPointLocation(bl ? 1 : this.getPointCount() - 2);
    }

    protected Point2D getPointLocation(int n2) {
        CellView cellView;
        Object e2 = this.points.get(n2);
        if (e2 instanceof Point2D) {
            return (Point2D)e2;
        }
        if (e2 instanceof PortView && (cellView = ((CellView)e2).getParentView()) != null) {
            return EdgeView.getCenterPoint(cellView);
        }
        return null;
    }

    public void setPoint(int n2, Point2D point2D) {
        this.points.set(n2, point2D);
        this.invalidate();
    }

    public void addPoint(int n2, Point2D point2D) {
        this.points.add(n2, point2D);
        this.invalidate();
    }

    public void removePoint(int n2) {
        this.points.remove(n2);
        this.invalidate();
    }

    public void addExtraLabel(Point2D point2D, Object object) {
        Object[] objectArray = GraphConstants.getExtraLabels(this.getAllAttributes());
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (objectArray == null) {
            objectArray = new Object[1];
            point2DArray = new Point2D[1];
        } else {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray = objectArray2;
            Point2D[] point2DArray2 = new Point2D[point2DArray.length + 1];
            System.arraycopy(point2DArray, 0, point2DArray2, 0, point2DArray.length);
            point2DArray = point2DArray2;
        }
        int n2 = objectArray.length - 1;
        objectArray[n2] = object;
        point2DArray[n2] = point2D;
        GraphConstants.setExtraLabels(this.getAllAttributes(), objectArray);
        GraphConstants.setExtraLabelPositions(this.getAllAttributes(), point2DArray);
    }

    public void removeExtraLabel(int n2) {
        Object[] objectArray = GraphConstants.getExtraLabels(this.getAllAttributes());
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(this.getAllAttributes());
        if (objectArray == null || objectArray.length > 1) {
            Object[] objectArray2 = new Object[objectArray.length - 1];
            Point2D[] point2DArray2 = new Point2D[point2DArray.length - 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, n2);
            if (n2 < objectArray2.length) {
                System.arraycopy(objectArray, n2 + 1, objectArray2, n2, objectArray2.length - n2);
            }
            System.arraycopy(point2DArray, 0, point2DArray2, 0, n2);
            if (n2 < point2DArray2.length) {
                System.arraycopy(point2DArray, n2 + 1, point2DArray2, n2, point2DArray2.length - n2);
            }
            GraphConstants.setExtraLabels(this.getAllAttributes(), objectArray2);
            GraphConstants.setExtraLabelPositions(this.getAllAttributes(), point2DArray2);
        } else {
            GraphConstants.setExtraLabels(this.getAllAttributes(), new Object[0]);
            GraphConstants.setExtraLabelPositions(this.getAllAttributes(), new Point2D[0]);
        }
    }

    public Point2D getLabelVector() {
        if (this.labelVector == null) {
            Point2D point2D = this.getPoint(0);
            double d2 = 0.0;
            double d3 = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            int n2 = this.getPointCount();
            if (this.isLoop()) {
                for (int i2 = 1; i2 < n2; ++i2) {
                    Point2D point2D2 = this.getPoint(i2);
                    d2 += point2D2.getX() - point2D.getX();
                    d3 += point2D2.getY() - point2D.getY();
                }
                this.labelVector = new Point2D.Double(d2 /= (double)(n2 /= 2), d3 /= (double)n2);
            } else {
                Point2D point2D3 = this.getPoint(n2 - 1);
                this.labelVector = new Point2D.Double(d2 += point2D3.getX() - point2D.getX(), d3 += point2D3.getY() - point2D.getY());
            }
        }
        return this.labelVector;
    }

    public static double getLength(CellView cellView) {
        double d2 = 1.0;
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            Point2D point2D = null;
            Point2D point2D2 = null;
            for (int i2 = 0; i2 < edgeView.getPointCount(); ++i2) {
                point2D2 = edgeView.getPoint(i2);
                if (point2D != null) {
                    d2 += point2D.distance(point2D2);
                }
                point2D = point2D2;
            }
        }
        return d2;
    }

    public Point2D getPerimeterPoint(EdgeView edgeView, Point2D point2D, Point2D point2D2) {
        if (this.getPointCount() > 2) {
            return this.getPoint(this.getPointCount() / 2);
        }
        Point2D point2D3 = this.getPoint(0);
        Point2D point2D4 = this.getPoint(this.getPointCount() - 1);
        return new Point2D.Double((point2D4.getX() + point2D3.getX()) / 2.0, (point2D4.getY() + point2D3.getY()) / 2.0);
    }

    public static class EdgeHandle
    implements CellHandle,
    Serializable {
        protected JGraph graph;
        protected EdgeView edge;
        protected EdgeView orig;
        protected boolean label = false;
        protected boolean source = false;
        protected boolean target = false;
        protected int currentLabel = -1;
        protected int currentIndex = -1;
        protected Point2D currentPoint;
        protected transient Rectangle2D[] r;
        protected transient Rectangle2D loc;
        protected transient Rectangle2D[] extraLabelLocations;
        protected boolean firstOverlayCall = true;
        protected boolean isEdgeConnectable = true;
        protected EdgeView relevantEdge = null;
        protected boolean editing = false;
        protected Point2D initialLabelLocation = null;
        protected boolean edgeModified = false;

        public EdgeHandle(EdgeView edgeView, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.edge = edgeView;
            this.editing = this.graph.getEditingCell() == edgeView.getCell();
            this.loc = new Rectangle();
            Object[] objectArray = GraphConstants.getExtraLabels(edgeView.getAllAttributes());
            if (objectArray != null) {
                this.extraLabelLocations = new Rectangle[objectArray.length];
                for (int i2 = 0; i2 < this.extraLabelLocations.length; ++i2) {
                    this.extraLabelLocations[i2] = new Rectangle();
                }
            }
            this.orig = (EdgeView)this.graph.getGraphLayoutCache().getMapping(edgeView.getCell(), false);
            this.reloadPoints(this.orig);
            this.isEdgeConnectable = GraphConstants.isConnectable(edgeView.getAllAttributes());
        }

        protected void reloadPoints(EdgeView edgeView) {
            this.relevantEdge = edgeView;
            this.r = new Rectangle[edgeView.getPointCount()];
            for (int i2 = 0; i2 < this.r.length; ++i2) {
                this.r[i2] = new Rectangle();
            }
            this.invalidate();
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            if (!this.edge.isLeaf()) {
                return;
            }
            for (int i2 = 0; i2 < this.r.length; ++i2) {
                Point2D point2D;
                if (this.isEdgeConnectable && !this.editing) {
                    graphics.setColor(this.graph.getHandleColor());
                } else {
                    graphics.setColor(this.graph.getLockedHandleColor());
                }
                graphics.fill3DRect((int)this.r[i2].getX(), (int)this.r[i2].getY(), (int)this.r[i2].getWidth(), (int)this.r[i2].getHeight(), true);
                CellView cellView = null;
                if (i2 == 0 && this.edge.getSource() != null) {
                    cellView = this.edge.getSource();
                } else if (i2 == this.r.length - 1 && this.edge.getTarget() != null) {
                    cellView = this.edge.getTarget();
                }
                if (cellView == null && (i2 != 0 || this.edge.getSourceParentView() == null) && (i2 != this.r.length - 1 || this.edge.getTargetParentView() == null)) continue;
                graphics.setColor(this.graph.getLockedHandleColor());
                Point2D point2D2 = point2D = cellView != null ? GraphConstants.getOffset(cellView.getAllAttributes()) : null;
                if (point2D != null) {
                    graphics.drawLine((int)this.r[i2].getX() + 1, (int)this.r[i2].getY() + 1, (int)(this.r[i2].getX() + this.r[i2].getWidth()) - 3, (int)(this.r[i2].getY() + this.r[i2].getHeight()) - 3);
                    graphics.drawLine((int)this.r[i2].getX() + 1, (int)(this.r[i2].getY() + this.r[i2].getHeight()) - 3, (int)(this.r[i2].getX() + this.r[i2].getWidth()) - 3, (int)this.r[i2].getY() + 1);
                    continue;
                }
                graphics.drawRect((int)this.r[i2].getX() + 2, (int)this.r[i2].getY() + 2, (int)this.r[i2].getWidth() - 5, (int)this.r[i2].getHeight() - 5);
            }
        }

        public void overlay(Graphics graphics) {
            if (this.edge != null && !this.firstOverlayCall && this.edge.isLeaf()) {
                graphics.setColor(this.graph.getForeground());
                graphics.setXORMode(this.graph.getBackground().darker());
                Graphics2D graphics2D = (Graphics2D)graphics;
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                this.graph.getUI().paintCell(graphics, this.edge, this.edge.getBounds(), true);
                graphics2D.setTransform(affineTransform);
                if (this.isSourceEditing() && this.edge.getSource() != null) {
                    this.paintPort(graphics, this.edge.getSource());
                } else if (this.isTargetEditing() && this.edge.getTarget() != null) {
                    this.paintPort(graphics, this.edge.getTarget());
                }
            }
            this.firstOverlayCall = false;
        }

        protected void paintPort(Graphics graphics, CellView cellView) {
            boolean bl = GraphConstants.getOffset(cellView.getAllAttributes()) != null;
            Rectangle2D rectangle2D = bl ? cellView.getBounds() : cellView.getParentView().getBounds();
            rectangle2D = this.graph.toScreen((Rectangle2D)rectangle2D.clone());
            int n2 = 3;
            rectangle2D.setFrame(rectangle2D.getX() - (double)n2, rectangle2D.getY() - (double)n2, rectangle2D.getWidth() + (double)(2 * n2), rectangle2D.getHeight() + (double)(2 * n2));
            this.graph.getUI().paintCell(graphics, cellView, rectangle2D, true);
        }

        protected boolean snap(boolean bl, Point2D point2D) {
            CellView cellView;
            boolean bl2 = this.graph.isConnectable() && this.isEdgeConnectable;
            Object object = this.graph.getPortForLocation(point2D.getX(), point2D.getY());
            if (object != null && this.graph.getModel().getParent(object) == this.edge.getCell()) {
                object = null;
            }
            if (object != null && bl2 && GraphConstants.isConnectable((cellView = this.graph.getGraphLayoutCache().getMapping(object, false)).getParentView().getAllAttributes())) {
                Object object2 = this.edge.getCell();
                if (bl && this.graph.getModel().acceptsSource(object2, object)) {
                    if (this.edge.getSource() != cellView) {
                        this.edgeModified = true;
                        this.overlay(this.graph.getGraphics());
                        this.edge.setSource(cellView);
                        this.edge.update();
                        this.overlay(this.graph.getGraphics());
                    }
                    return true;
                }
                if (!bl && this.graph.getModel().acceptsTarget(object2, object)) {
                    if (this.edge.getTarget() != cellView) {
                        this.edgeModified = true;
                        this.overlay(this.graph.getGraphics());
                        this.edge.setTarget(cellView);
                        this.edge.update();
                        this.overlay(this.graph.getGraphics());
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean isConstrainedMoveEvent(MouseEvent mouseEvent) {
            GraphUI graphUI = this.graph.getUI();
            if (graphUI instanceof BasicGraphUI) {
                return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        public boolean isAddPointEvent(MouseEvent mouseEvent) {
            return mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent);
        }

        public boolean isRemovePointEvent(MouseEvent mouseEvent) {
            return mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent);
        }

        protected boolean isSourceEditing() {
            return this.source;
        }

        protected boolean isTargetEditing() {
            return this.target;
        }

        protected boolean isEditing() {
            return this.source || this.target || this.label || this.currentLabel >= 0 || this.currentPoint != null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n2;
            for (n2 = 0; n2 < this.r.length; ++n2) {
                if (!this.r[n2].contains(mouseEvent.getPoint())) continue;
                this.graph.setCursor(new Cursor(1));
                mouseEvent.consume();
                return;
            }
            if (this.loc.contains(mouseEvent.getPoint()) && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                this.graph.setCursor(new Cursor(12));
                mouseEvent.consume();
            }
            if (this.extraLabelLocations != null && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                for (n2 = 0; n2 < this.extraLabelLocations.length; ++n2) {
                    if (!this.extraLabelLocations[n2].contains(mouseEvent.getPoint())) continue;
                    this.graph.setCursor(new Cursor(12));
                    mouseEvent.consume();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Rectangle2D rectangle2D;
            int n2;
            if (!this.edge.isLeaf()) {
                return;
            }
            boolean bl = this.graph.isBendable() && GraphConstants.isBendable(this.edge.getAllAttributes());
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            int n5 = 0;
            for (n5 = 0; n5 < this.r.length; ++n5) {
                if (!this.r[n5].contains(n3, n4)) continue;
                this.currentPoint = this.edge.getPoint(n5);
                this.currentIndex = n5;
                this.source = n5 == 0;
                this.target = n5 == this.r.length - 1;
                break;
            }
            if (!this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes()) && this.loc != null && this.loc.contains(n3, n4) && !this.isAddPointEvent(mouseEvent) && !this.isRemovePointEvent(mouseEvent)) {
                this.initialLabelLocation = (Point2D)this.edge.getLabelPosition().clone();
                this.label = true;
            } else if (this.extraLabelLocations != null && !this.isEditing() && this.graph.isMoveable() && GraphConstants.isMoveable(this.edge.getAllAttributes())) {
                for (n2 = 0; n2 < this.extraLabelLocations.length; ++n2) {
                    if (this.extraLabelLocations[n2] == null || !this.extraLabelLocations[n2].contains(n3, n4)) continue;
                    this.currentLabel = n2;
                    this.initialLabelLocation = (Point2D)this.edge.getExtraLabelPosition(this.currentLabel).clone();
                    if (!this.isRemovePointEvent(mouseEvent)) break;
                    this.edge.removeExtraLabel(n2);
                    this.edgeModified = true;
                    this.mouseReleased(mouseEvent);
                    break;
                }
            }
            if (!(!this.isRemovePointEvent(mouseEvent) || this.currentPoint == null || this.source || this.target || !bl || this.edge.getSource() != null && this.currentIndex <= 0 || this.edge.getTarget() != null && this.currentIndex >= this.edge.getPointCount() - 1)) {
                this.edge.removePoint(n5);
                this.edgeModified = true;
                this.mouseReleased(mouseEvent);
            } else if (this.isAddPointEvent(mouseEvent) && !this.isEditing() && bl && this.edge.intersects(this.graph, rectangle2D = this.graph.fromScreen(new Rectangle(n3 - (n2 = this.graph.getHandleSize()), n4 - n2, 2 * n2, 2 * n2)))) {
                Point2D point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                double d2 = Double.MAX_VALUE;
                double d3 = 0.0;
                for (int i2 = 0; i2 < this.edge.getPointCount() - 1; ++i2) {
                    Point2D point2D2;
                    Point2D point2D3 = this.edge.getPoint(i2);
                    d3 = new Line2D.Double(point2D3, point2D2 = this.edge.getPoint(i2 + 1)).ptLineDistSq(point2D);
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    n5 = i2 + 1;
                }
                this.edge.addPoint(n5, point2D);
                this.edgeModified = true;
                this.currentPoint = point2D;
                this.reloadPoints(this.edge);
                this.paint(this.graph.getGraphics());
            }
            if (this.isEditing()) {
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Point2D point2D = this.graph.fromScreen(new Point(mouseEvent.getPoint()));
            if (this.label || this.currentLabel >= 0) {
                Rectangle2D rectangle2D = this.edge.getBounds();
                if (rectangle2D != null) {
                    this.edgeModified = true;
                    double d2 = point2D.getX();
                    double d3 = point2D.getY();
                    Point2D point2D2 = this.edge.getPoint(0);
                    double d4 = point2D2.getX();
                    double d5 = point2D2.getY();
                    Point2D point2D3 = this.edge.getLabelVector();
                    double d6 = point2D3.getX();
                    double d7 = point2D3.getY();
                    double d8 = point2D2.getX() + d6;
                    double d9 = point2D2.getY() + d7;
                    double d10 = Math.sqrt(d6 * d6 + d7 * d7);
                    if (d10 > 0.0) {
                        double d11 = 1000.0;
                        double d12 = d10 * (-d3 * d6 + d5 * d6 + d2 * d7 - d4 * d7) / (-d9 * d7 + d5 * d7 - d6 * d8 + d6 * d4);
                        double d13 = d11 * (-d3 * d9 + d3 * d5 + d5 * d9 - d5 * d5 - d8 * d2 + d8 * d4 + d4 * d2 - d4 * d4) / (-d9 * d7 + d5 * d7 - d6 * d8 + d6 * d4);
                        point2D = new Point2D.Double(d13, d12);
                    } else {
                        point2D = new Point2D.Double(d2 - point2D2.getX(), d3 - point2D2.getY());
                    }
                    this.overlay(this.graph.getGraphics());
                    if (this.label) {
                        this.edge.setLabelPosition(point2D);
                    } else {
                        this.edge.setExtraLabelPosition(this.currentLabel, point2D);
                    }
                    this.edge.update();
                    this.overlay(this.graph.getGraphics());
                }
            } else if (this.isEditing() && this.currentPoint != null) {
                boolean bl;
                boolean bl2 = bl = !this.source && !this.target || this.graph.isDisconnectable() && GraphConstants.isDisconnectable(this.orig.getAllAttributes());
                if (this.source) {
                    boolean bl3 = bl = bl && (this.orig.getSource() == null && this.orig.getSourceParentView() == null || this.orig.getSource() != null && GraphConstants.isDisconnectable(this.orig.getSource().getParentView().getAllAttributes()) || this.orig.getSourceParentView() != null && GraphConstants.isDisconnectable(this.orig.getSourceParentView().getAllAttributes()));
                }
                if (this.target) {
                    boolean bl4 = bl = bl && (this.orig.getTarget() == null && this.orig.getTargetParentView() == null || this.orig.getTarget() != null && GraphConstants.isDisconnectable(this.orig.getTarget().getParentView().getAllAttributes()) || this.orig.getTargetParentView() != null && GraphConstants.isDisconnectable(this.orig.getTargetParentView().getAllAttributes()));
                }
                if (!(this.source && this.snap(true, mouseEvent.getPoint()) || this.target && this.snap(false, mouseEvent.getPoint()) || !bl)) {
                    boolean bl5;
                    boolean bl6 = this.source && (this.graph.getModel().acceptsSource(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                    boolean bl7 = bl5 = this.target && (this.graph.getModel().acceptsTarget(this.edge.getCell(), null) || this.graph.isPreviewInvalidNullPorts());
                    if (bl6 || bl5 || !this.source && !this.target) {
                        this.edgeModified = true;
                        this.overlay(this.graph.getGraphics());
                        point2D = this.graph.fromScreen(this.graph.snap(new Point(mouseEvent.getPoint())));
                        if (this.isConstrainedMoveEvent(mouseEvent) && this.currentIndex >= 0) {
                            EdgeView edgeView = (EdgeView)this.graph.getGraphLayoutCache().getMapping(this.edge.getCell(), false);
                            Point2D point2D4 = edgeView.getPoint(this.currentIndex);
                            double d14 = point2D.getX() - point2D4.getX();
                            double d15 = point2D.getY() - point2D4.getY();
                            if (Math.abs(d14) < Math.abs(d15)) {
                                point2D.setLocation(point2D4.getX(), point2D.getY());
                            } else {
                                point2D.setLocation(point2D.getX(), point2D4.getY());
                            }
                        }
                        point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
                        this.currentPoint.setLocation(point2D);
                        if (this.source) {
                            this.edge.setPoint(0, point2D);
                            this.edge.setSource(null);
                        } else if (this.target) {
                            this.edge.setPoint(this.edge.getPointCount() - 1, point2D);
                            this.edge.setTarget(null);
                        }
                        this.edge.update();
                        this.overlay(this.graph.getGraphics());
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object;
            boolean bl = mouseEvent.isControlDown() && this.graph.isCloneable();
            GraphModel graphModel = this.graph.getModel();
            Object object2 = this.edge.getSource() != null ? this.edge.getSource().getCell() : null;
            Object object3 = object = this.edge.getTarget() != null ? this.edge.getTarget().getCell() : null;
            if (this.edgeModified && graphModel.acceptsSource(this.edge.getCell(), object2) && graphModel.acceptsTarget(this.edge.getCell(), object)) {
                List list;
                Object object4;
                Object object5;
                Object object6;
                if (bl && this.initialLabelLocation != null) {
                    object6 = null;
                    object5 = null;
                    object4 = GraphConstants.getExtraLabels(this.edge.getAllAttributes());
                    if (this.label) {
                        object5 = (Point2D)this.edge.getLabelPosition().clone();
                        object6 = this.graph.convertValueToString(this.orig);
                        this.edge.setLabelPosition(this.initialLabelLocation);
                    } else {
                        object5 = (Point2D)this.edge.getExtraLabelPosition(this.currentLabel).clone();
                        object6 = object4[this.currentLabel];
                        this.edge.setExtraLabelPosition(this.currentLabel, this.initialLabelLocation);
                    }
                    this.edge.addExtraLabel((Point2D)object5, object6);
                    this.edge.update();
                    bl = false;
                }
                object6 = this.createConnectionSet(this.edge, bl);
                object5 = GraphConstants.createAttributes(new CellView[]{this.edge}, null);
                object4 = (Map)object5.get(this.edge.getCell());
                List list2 = GraphConstants.getPoints((Map)object4);
                if (list2 != (list = this.edge.getPoints())) {
                    list2.set(0, this.edge.getPoint(0));
                    list2.set(list2.size() - 1, this.edge.getPoint(this.edge.getPointCount() - 1));
                }
                if (bl) {
                    Map map = this.graph.cloneCells(this.graph.getDescendants(new Object[]{this.edge.getCell()}));
                    this.processNestedMap((Map)object5, true);
                    object5 = GraphConstants.replaceKeys(map, (Map)object5);
                    object6 = ((ConnectionSet)object6).clone(map);
                    Object[] objectArray = map.values().toArray();
                    this.graph.getGraphLayoutCache().insert(objectArray, (Map)object5, (ConnectionSet)object6, null, null);
                } else {
                    this.processNestedMap((Map)object5, false);
                    this.graph.getGraphLayoutCache().edit((Map)object5, (ConnectionSet)object6, null, null);
                }
            } else {
                this.overlay(this.graph.getGraphics());
                this.edge.refresh(this.graph.getModel(), this.graph.getGraphLayoutCache(), false);
            }
            this.initialLabelLocation = null;
            this.currentPoint = null;
            this.edgeModified = false;
            this.label = false;
            this.source = false;
            this.target = false;
            this.currentLabel = -1;
            this.currentIndex = -1;
            this.firstOverlayCall = true;
            mouseEvent.consume();
        }

        protected void processNestedMap(Map map, boolean bl) {
        }

        protected ConnectionSet createConnectionSet(EdgeView edgeView, boolean bl) {
            Object object = edgeView.getCell();
            GraphModel graphModel = this.graph.getModel();
            ConnectionSet connectionSet = new ConnectionSet();
            Object object2 = null;
            Object object3 = null;
            if (edgeView.getSource() != null) {
                object2 = edgeView.getSource().getCell();
            } else if (edgeView.getSourceParentView() != null) {
                object2 = graphModel.getSource(object);
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            } else if (edgeView.getTargetParentView() != null) {
                object3 = graphModel.getTarget(object);
            }
            if (edgeView.getTarget() != null) {
                object3 = edgeView.getTarget().getCell();
            }
            if (bl || object2 != graphModel.getSource(object) && this.source) {
                connectionSet.connect(object, object2, true);
            }
            if (bl || object3 != graphModel.getTarget(object) && this.target) {
                connectionSet.connect(object, object3, false);
            }
            return connectionSet;
        }

        protected void invalidate() {
            Point2D point2D;
            Dimension dimension;
            Point2D point2D2;
            int n2;
            EdgeView edgeView = this.relevantEdge;
            int n3 = this.graph.getHandleSize();
            EdgeRenderer edgeRenderer = (EdgeRenderer)this.edge.getRenderer();
            for (n2 = 0; n2 < this.r.length; ++n2) {
                point2D2 = edgeView.getPoint(n2);
                point2D2 = this.graph.toScreen(new Point2D.Double(point2D2.getX(), point2D2.getY()));
                this.r[n2].setFrame(point2D2.getX() - (double)n3, point2D2.getY() - (double)n3, 2 * n3, 2 * n3);
                point2D2 = this.graph.toScreen(edgeRenderer.getLabelPosition(edgeView));
                dimension = edgeRenderer.getLabelSize(edgeView, this.graph.convertValueToString(edgeView));
                if (point2D2 == null || dimension == null) continue;
                point2D = this.graph.toScreen(new Point2D.Double(dimension.width, dimension.height));
                this.loc.setFrame(point2D2.getX() - point2D.getX() / 2.0, point2D2.getY() - point2D.getY() / 2.0, point2D.getX(), point2D.getY());
            }
            if (this.extraLabelLocations != null) {
                for (n2 = 0; n2 < this.extraLabelLocations.length; ++n2) {
                    point2D2 = edgeRenderer.getExtraLabelPosition(edgeView, n2);
                    if (point2D2 == null) continue;
                    point2D2 = this.graph.toScreen((Point2D)point2D2.clone());
                    dimension = edgeRenderer.getExtraLabelSize(this.graph, edgeView, n2);
                    if (dimension == null) continue;
                    point2D = this.graph.toScreen(new Point2D.Double(dimension.width, dimension.height));
                    this.extraLabelLocations[n2].setFrame(point2D2.getX() - point2D.getX() / 2.0, point2D2.getY() - point2D.getY() / 2.0, point2D.getX(), point2D.getY());
                }
            }
        }
    }
}

