/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.event.EventListenerList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.Port;

public class DefaultGraphModel
extends UndoableEditSupport
implements Serializable,
GraphModel {
    protected transient EventListenerList listenerList = new EventListenerList();
    protected transient Iterator emptyIterator = new EmptyIterator();
    protected List roots = null;
    protected boolean asksAllowsChildren = false;
    protected AttributeMap attributes = null;
    static /* synthetic */ Class class$org$jgraph$event$GraphModelListener;

    public DefaultGraphModel() {
        this(null, null);
    }

    public DefaultGraphModel(List list, AttributeMap attributeMap) {
        this.roots = list != null ? list : new ArrayList();
        this.attributes = attributeMap != null ? attributeMap : new AttributeMap();
    }

    public DefaultGraphModel(List list, AttributeMap attributeMap, ConnectionSet connectionSet) {
        this(list, attributeMap);
        this.handleConnectionSet(connectionSet);
    }

    public List getRoots() {
        return this.roots;
    }

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int n2) {
        return this.roots.get(n2);
    }

    public int getIndexOfRoot(Object object) {
        return this.roots.indexOf(object);
    }

    public boolean contains(Object object) {
        Object object2 = null;
        while ((object2 = this.getParent(object)) != null) {
            object = object2;
        }
        return this.roots.contains(object);
    }

    public AttributeMap getAttributes(Object object) {
        if (object instanceof GraphCell) {
            return ((GraphCell)object).getAttributes();
        }
        if (object == null) {
            return this.attributes;
        }
        return null;
    }

    public Object getValue(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)object).getUserObject();
        }
        return null;
    }

    public Map getAttributes() {
        return this.getAttributes(null);
    }

    public Object getSource(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getSource();
        }
        return null;
    }

    public Object getTarget(Object object) {
        if (object instanceof Edge) {
            return ((Edge)object).getTarget();
        }
        return null;
    }

    public boolean acceptsSource(Object object, Object object2) {
        return true;
    }

    public boolean acceptsTarget(Object object, Object object2) {
        return true;
    }

    public Iterator edges(Object object) {
        if (object instanceof Port) {
            return ((Port)object).edges();
        }
        return this.emptyIterator;
    }

    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    public boolean isPort(Object object) {
        return object instanceof Port;
    }

    public ConnectionSet getConnectionSet() {
        return ConnectionSet.create(this, DefaultGraphModel.getAll(this), false);
    }

    public Map cloneCells(Object[] objectArray) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            hashtable.put(objectArray[i2], this.cloneCell(objectArray[i2]));
        }
        Iterator iterator = hashtable.entrySet().iterator();
        while (iterator.hasNext()) {
            Port port;
            Map.Entry entry = iterator.next();
            Object v2 = entry.getValue();
            Object k2 = entry.getKey();
            Object object = this.getParent(k2);
            if (object != null) {
                object = hashtable.get(object);
            }
            if (object != null) {
                ((DefaultMutableTreeNode)object).add((DefaultMutableTreeNode)v2);
            }
            if (!(v2 instanceof Port) || (port = ((Port)v2).getAnchor()) == null) continue;
            ((Port)v2).setAnchor((Port)hashtable.get(port));
        }
        return hashtable;
    }

    protected void setParent(Object object, Object object2) {
        if (object instanceof DefaultMutableTreeNode && object2 instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
            defaultMutableTreeNode.add((DefaultMutableTreeNode)object);
        }
    }

    protected Object cloneCell(Object object) {
        if (object instanceof DefaultGraphCell) {
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
            DefaultGraphCell defaultGraphCell2 = (DefaultGraphCell)defaultGraphCell.clone();
            defaultGraphCell2.setUserObject(this.cloneUserObject(defaultGraphCell.getUserObject()));
            return defaultGraphCell2;
        }
        return object;
    }

    protected Object cloneUserObject(Object object) {
        return object;
    }

    public Object getParent(Object object) {
        if (object != null && object instanceof TreeNode) {
            return ((TreeNode)object).getParent();
        }
        return null;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        return ((TreeNode)object).getIndex((TreeNode)object2);
    }

    public Object getChild(Object object, int n2) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildAt(n2);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        if (this.asksAllowsChildren && object instanceof TreeNode) {
            return !((TreeNode)object).getAllowsChildren();
        }
        return ((TreeNode)object).isLeaf();
    }

    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = this.createEdit(objectArray, null, map, connectionSet, parentMap, undoableEditArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            if (undoableEditArray != null) {
                for (int i2 = 0; i2 < undoableEditArray.length; ++i2) {
                    if (!(undoableEditArray[i2] instanceof GraphLayoutCache.GraphLayoutCacheEdit)) continue;
                    ((GraphLayoutCache.GraphLayoutCacheEdit)undoableEditArray[i2]).execute();
                }
            }
            this.postEdit(graphModelEdit);
        }
    }

    public void remove(Object[] objectArray) {
        GraphModelEdit graphModelEdit = this.createRemoveEdit(objectArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            this.postEdit(graphModelEdit);
        }
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        this.edit(null, null, map, connectionSet, parentMap, undoableEditArray);
    }

    public void edit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        if (!(objectArray != null && objectArray.length != 0 || objectArray2 != null && objectArray2.length != 0 || map != null && !map.isEmpty() || connectionSet != null && !connectionSet.isEmpty() || parentMap != null || undoableEditArray == null || undoableEditArray.length != 1)) {
            if (undoableEditArray[0] instanceof GraphLayoutCache.GraphLayoutCacheEdit) {
                ((GraphLayoutCache.GraphLayoutCacheEdit)undoableEditArray[0]).execute();
            }
            this.postEdit(undoableEditArray[0]);
        } else {
            GraphModelEdit graphModelEdit = this.createEdit(objectArray, objectArray2, map, connectionSet, parentMap, undoableEditArray);
            if (graphModelEdit != null) {
                graphModelEdit.execute();
                if (undoableEditArray != null) {
                    for (int i2 = 0; i2 < undoableEditArray.length; ++i2) {
                        if (!(undoableEditArray[i2] instanceof GraphLayoutCache.GraphLayoutCacheEdit)) continue;
                        ((GraphLayoutCache.GraphLayoutCacheEdit)undoableEditArray[i2]).execute();
                    }
                }
                this.postEdit(graphModelEdit);
            }
        }
    }

    public void toBack(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = this.createLayerEdit(objectArray, -2);
        if (graphModelLayerEdit != null) {
            graphModelLayerEdit.execute();
            this.postEdit(graphModelLayerEdit);
        }
    }

    public void toFront(Object[] objectArray) {
        GraphModelLayerEdit graphModelLayerEdit = this.createLayerEdit(objectArray, -1);
        if (graphModelLayerEdit != null) {
            graphModelLayerEdit.execute();
            this.postEdit(graphModelLayerEdit);
        }
    }

    protected GraphModelLayerEdit createLayerEdit(Object[] objectArray, int n2) {
        return new GraphModelLayerEdit(objectArray, n2);
    }

    protected GraphModelEdit createRemoveEdit(Object[] objectArray) {
        ParentMap parentMap;
        ConnectionSet connectionSet = ConnectionSet.create(this, objectArray, true);
        GraphModelEdit graphModelEdit = this.createEdit(null, objectArray, null, connectionSet, parentMap = ParentMap.create(this, objectArray, true, false), null);
        if (graphModelEdit != null) {
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected GraphModelEdit createEdit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        GraphModelEdit graphModelEdit = new GraphModelEdit(objectArray, objectArray2, map, connectionSet, parentMap);
        if (graphModelEdit != null) {
            if (undoableEditArray != null) {
                for (int i2 = 0; i2 < undoableEditArray.length; ++i2) {
                    graphModelEdit.addEdit(undoableEditArray[i2]);
                }
            }
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected Object[] handleInsert(Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (this.getParent(objectArray[i2]) != null) continue;
                this.roots.add(objectArray[i2]);
            }
            objectArray2 = DefaultGraphModel.getDescendants(this, objectArray).toArray();
        }
        return objectArray2;
    }

    protected Object[] handleRemove(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (this.getParent(objectArray[i2]) != null || !this.roots.remove(objectArray[i2])) continue;
                arrayList.add(objectArray[i2]);
            }
        }
        return arrayList.toArray();
    }

    protected ParentMap handleParentMap(ParentMap parentMap) {
        if (parentMap != null) {
            ParentMap parentMap2 = new ParentMap();
            Iterator iterator = parentMap.entries();
            while (iterator.hasNext()) {
                ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                Object object = entry.getChild();
                Object object2 = entry.getParent();
                parentMap2.addEntry(object, this.getParent(object));
                if (object2 == null) {
                    if (object instanceof MutableTreeNode) {
                        ((MutableTreeNode)object).removeFromParent();
                    }
                } else if (object2 instanceof DefaultMutableTreeNode && object instanceof MutableTreeNode) {
                    ((DefaultMutableTreeNode)object2).add((MutableTreeNode)object);
                }
                boolean bl = this.roots.contains(object);
                if (object2 == null && !bl) {
                    this.roots.add(object);
                    continue;
                }
                if (object2 == null || !bl) continue;
                this.roots.remove(object);
            }
            return parentMap2;
        }
        return null;
    }

    protected Map handleAttributes(Map map) {
        if (map != null) {
            Hashtable hashtable = new Hashtable(map.size());
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Object v2;
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                Map map2 = (Map)entry.getValue();
                Hashtable hashtable2 = null;
                AttributeMap attributeMap = this.getAttributes(k2);
                if (attributeMap != null) {
                    hashtable2 = attributeMap.applyMap(map2);
                    hashtable.put(k2, (AttributeMap)hashtable2);
                } else {
                    hashtable2 = new Hashtable(2);
                }
                if ((v2 = map2.get("value")) == null) continue;
                Object object = this.valueForCellChanged(k2, v2);
                if (object != null) {
                    GraphConstants.setValue(hashtable2, object);
                    continue;
                }
                GraphConstants.setRemoveAttributes(hashtable2, new Object[]{"value"});
            }
            return hashtable;
        }
        return null;
    }

    public Object valueForCellChanged(Object object, Object object2) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object3 = defaultMutableTreeNode.getUserObject();
            defaultMutableTreeNode.setUserObject(object2);
            return object3;
        }
        return null;
    }

    protected ConnectionSet handleConnectionSet(ConnectionSet connectionSet) {
        if (connectionSet != null) {
            ConnectionSet connectionSet2 = new ConnectionSet();
            Iterator iterator = connectionSet.connections();
            while (iterator.hasNext()) {
                ConnectionSet.Connection connection = (ConnectionSet.Connection)iterator.next();
                Object object = connection.getEdge();
                if (connection.isSource()) {
                    connectionSet2.connect(object, this.getSource(object), true);
                } else {
                    connectionSet2.connect(object, this.getTarget(object), false);
                }
                this.handleConnection(connection, false);
            }
            iterator = connectionSet.connections();
            while (iterator.hasNext()) {
                this.handleConnection((ConnectionSet.Connection)iterator.next(), true);
            }
            return connectionSet2;
        }
        return null;
    }

    protected void handleConnection(ConnectionSet.Connection connection, boolean bl) {
        Object object = connection.getEdge();
        Object object2 = bl ? connection.getPort() : (connection.isSource() ? this.getSource(object) : this.getTarget(object));
        this.connect(object, object2, connection.isSource(), bl);
    }

    protected void connect(Object object, Object object2, boolean bl, boolean bl2) {
        if (object2 instanceof Port) {
            if (bl2) {
                ((Port)object2).addEdge(object);
            } else if (bl ? this.getTarget(object) != object2 : this.getSource(object) != object2) {
                ((Port)object2).removeEdge(object);
            }
        }
        if (!bl2) {
            object2 = null;
        }
        if (object instanceof Edge) {
            if (bl) {
                ((Edge)object).setSource(object2);
            } else {
                ((Edge)object).setTarget(object2);
            }
        }
    }

    public void addGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.add(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, graphModelListener);
    }

    public void removeGraphModelListener(GraphModelListener graphModelListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener, graphModelListener);
    }

    public void cellsChanged(final Object[] objectArray) {
        if (objectArray != null) {
            this.fireGraphChanged(this, new GraphModelEvent.GraphModelChange(){

                public Object[] getInserted() {
                    return null;
                }

                public Object[] getRemoved() {
                    return null;
                }

                public Map getPreviousAttributes() {
                    return null;
                }

                public ConnectionSet getConnectionSet() {
                    return null;
                }

                public ConnectionSet getPreviousConnectionSet() {
                    return null;
                }

                public ParentMap getParentMap() {
                    return null;
                }

                public ParentMap getPreviousParentMap() {
                    return null;
                }

                public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
                }

                public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
                    return null;
                }

                public Object getSource() {
                    return this;
                }

                public Object[] getChanged() {
                    return objectArray;
                }

                public Map getAttributes() {
                    return null;
                }

                public Object[] getContext() {
                    return null;
                }
            });
        }
    }

    protected void fireGraphChanged(Object object, GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = this.listenerList.getListenerList();
        GraphModelEvent graphModelEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$org$jgraph$event$GraphModelListener == null ? DefaultGraphModel.class$("org.jgraph.event.GraphModelListener") : class$org$jgraph$event$GraphModelListener)) continue;
            if (graphModelEvent == null) {
                graphModelEvent = new GraphModelEvent(object, graphModelChange);
            }
            ((GraphModelListener)objectArray[i2 + 1]).graphChanged(graphModelEvent);
        }
    }

    public GraphModelListener[] getGraphModelListeners() {
        return (GraphModelListener[])this.listenerList.getListeners(class$org$jgraph$event$GraphModelListener == null ? (class$org$jgraph$event$GraphModelListener = DefaultGraphModel.class$("org.jgraph.event.GraphModelListener")) : class$org$jgraph$event$GraphModelListener);
    }

    public static Object cloneCell(GraphModel graphModel, Object object) {
        Map map = graphModel.cloneCells(DefaultGraphModel.getDescendants(graphModel, new Object[]{object}).toArray());
        return map.get(object);
    }

    public static Object[] cloneCell(GraphModel graphModel, Object[] objectArray) {
        Map map = graphModel.cloneCells(DefaultGraphModel.getDescendants(graphModel, objectArray).toArray());
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = map.get(objectArray[i2]);
        }
        return objectArray;
    }

    public static void setSourcePort(GraphModel graphModel, Object object, Object object2) {
        graphModel.edit(null, new ConnectionSet(object, object2, true), null, null);
    }

    public static void setTargetPort(GraphModel graphModel, Object object, Object object2) {
        graphModel.edit(null, new ConnectionSet(object, object2, false), null, null);
    }

    public static Object getSourceVertex(GraphModel graphModel, Object object) {
        if (graphModel != null) {
            return graphModel.getParent(graphModel.getSource(object));
        }
        return null;
    }

    public static Object getTargetVertex(GraphModel graphModel, Object object) {
        if (graphModel != null) {
            return graphModel.getParent(graphModel.getTarget(object));
        }
        return null;
    }

    public static Object getUserObject(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            return ((DefaultMutableTreeNode)object).getUserObject();
        }
        return null;
    }

    public static boolean isGroup(GraphModel graphModel, Object object) {
        for (int i2 = 0; i2 < graphModel.getChildCount(object); ++i2) {
            if (graphModel.isPort(graphModel.getChild(object, i2))) continue;
            return true;
        }
        return false;
    }

    public static Object[] getAll(GraphModel graphModel) {
        return DefaultGraphModel.getDescendants(graphModel, DefaultGraphModel.getRoots(graphModel)).toArray();
    }

    public static Object[] getRoots(GraphModel graphModel) {
        Object[] objectArray = null;
        if (graphModel != null) {
            if (graphModel instanceof DefaultGraphModel) {
                objectArray = ((DefaultGraphModel)graphModel).getRoots().toArray();
            } else {
                objectArray = new Object[graphModel.getRootCount()];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    objectArray[i2] = graphModel.getRootAt(i2);
                }
            }
        }
        return objectArray;
    }

    public static Object[] getRoots(GraphModel graphModel, Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (graphModel.getParent(objectArray[i2]) != null) continue;
                arrayList.add(objectArray[i2]);
            }
        }
        return arrayList.toArray();
    }

    public static Object[] getTopmostCells(GraphModel graphModel, Object[] objectArray) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            hashSet.add(objectArray[i2]);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            if (DefaultGraphModel.hasAncestorIn(graphModel, hashSet, objectArray[i3])) continue;
            arrayList.add(objectArray[i3]);
        }
        return arrayList.toArray();
    }

    public static boolean hasAncestorIn(GraphModel graphModel, Set set, Object object) {
        Object object2 = graphModel.getParent(object);
        while (object2 != null) {
            if (set.contains(object2)) {
                return true;
            }
            object2 = graphModel.getParent(object2);
        }
        return false;
    }

    public static List getDescendants(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            Stack<Object> stack = new Stack<Object>();
            for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                stack.add(objectArray[i2]);
            }
            LinkedList linkedList = new LinkedList();
            while (!stack.isEmpty()) {
                Object e2 = stack.pop();
                for (int i3 = graphModel.getChildCount(e2) - 1; i3 >= 0; --i3) {
                    stack.add(graphModel.getChild(e2, i3));
                }
                if (e2 == null) continue;
                linkedList.add(e2);
            }
            return linkedList;
        }
        return null;
    }

    public static Object[] order(GraphModel graphModel, Object[] objectArray) {
        if (objectArray != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                hashSet.add(objectArray[i2]);
            }
            Stack<Object> stack = new Stack<Object>();
            for (int i3 = graphModel.getRootCount() - 1; i3 >= 0; --i3) {
                stack.add(graphModel.getRootAt(i3));
            }
            LinkedList linkedList = new LinkedList();
            while (!stack.isEmpty()) {
                Object e2 = stack.pop();
                for (int i4 = graphModel.getChildCount(e2) - 1; i4 >= 0; --i4) {
                    stack.add(graphModel.getChild(e2, i4));
                }
                if (!hashSet.remove(e2)) continue;
                linkedList.add(e2);
            }
            return linkedList.toArray();
        }
        return null;
    }

    public static Set getEdges(GraphModel graphModel, Object[] objectArray) {
        HashSet hashSet = new HashSet();
        if (objectArray != null) {
            HashSet<Object> hashSet2 = new HashSet<Object>(objectArray.length * 2 + 8, 0.75f);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                hashSet2.add(objectArray[i2]);
            }
            hashSet2.addAll(DefaultGraphModel.getDescendants(graphModel, objectArray));
            if (hashSet2 != null) {
                Iterator iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    Iterator iterator2 = graphModel.edges(iterator.next());
                    while (iterator2.hasNext()) {
                        hashSet.add(iterator2.next());
                    }
                }
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    hashSet.remove(objectArray[i3]);
                }
            }
        }
        return hashSet;
    }

    public static Object getOpposite(GraphModel graphModel, Object object, Object object2) {
        Object object3;
        boolean bl = graphModel.isPort(object2);
        Object object4 = object3 = bl ? graphModel.getSource(object) : DefaultGraphModel.getSourceVertex(graphModel, object);
        if (object2 == object3) {
            return bl ? graphModel.getTarget(object) : DefaultGraphModel.getTargetVertex(graphModel, object);
        }
        return object3;
    }

    public static boolean containsEdgeBetween(GraphModel graphModel, Object object, Object object2) {
        Object[] objectArray = DefaultGraphModel.getEdgesBetween(graphModel, object, object2, false);
        return objectArray != null && objectArray.length > 0;
    }

    public static Object[] getEdgesBetween(GraphModel graphModel, Object object, Object object2, boolean bl) {
        boolean bl2 = graphModel.isPort(object);
        boolean bl3 = graphModel.isPort(object2);
        ArrayList arrayList = new ArrayList();
        Set set = DefaultGraphModel.getEdges(graphModel, new Object[]{object});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object3;
            Object e2 = iterator.next();
            Object object4 = bl2 ? graphModel.getSource(e2) : DefaultGraphModel.getSourceVertex(graphModel, e2);
            Object object5 = object3 = bl3 ? graphModel.getTarget(e2) : DefaultGraphModel.getTargetVertex(graphModel, e2);
            if ((object4 != object || object3 != object2) && (bl || object4 != object2 || object3 != object)) continue;
            arrayList.add(e2);
        }
        return arrayList.toArray();
    }

    public static Object[] getOutgoingEdges(GraphModel graphModel, Object object) {
        return DefaultGraphModel.getEdges(graphModel, object, false);
    }

    public static Object[] getIncomingEdges(GraphModel graphModel, Object object) {
        return DefaultGraphModel.getEdges(graphModel, object, true);
    }

    public static Object[] getEdges(GraphModel graphModel, Object object, boolean bl) {
        ArrayList arrayList = new ArrayList();
        Set set = DefaultGraphModel.getEdges(graphModel, new Object[]{object});
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Object object2 = bl ? graphModel.getTarget(e2) : graphModel.getSource(e2);
            Object object3 = graphModel.getParent(object2);
            if (object2 != object && object3 != object) continue;
            arrayList.add(e2);
        }
        return arrayList.toArray();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.emptyIterator = new EmptyIterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class EmptyIterator
    implements Iterator,
    Serializable {
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    }

    public class GraphModelLayerEdit
    extends AbstractUndoableEdit
    implements GraphModelEvent.GraphModelChange {
        public static final int FRONT = -1;
        public static final int BACK = -2;
        protected Object changeSource;
        protected transient Object[] cells;
        protected transient int[] next;
        protected transient int[] prev;
        protected int layer;
        protected Object[] changed;

        public GraphModelLayerEdit(Object[] objectArray, int n2) {
            this.cells = objectArray;
            this.layer = n2;
            this.next = new int[objectArray.length];
            this.prev = new int[objectArray.length];
            this.updateNext();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = DefaultGraphModel.this.getParent(objectArray[i2]);
                if (object == null) {
                    object = objectArray[i2];
                }
                hashSet.add(object);
            }
            this.changed = hashSet.toArray();
        }

        protected void updateNext() {
            for (int i2 = 0; i2 < this.next.length; ++i2) {
                this.next[i2] = this.layer;
            }
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getInserted() {
            return null;
        }

        public Object[] getRemoved() {
            return null;
        }

        public Object[] getContext() {
            return null;
        }

        public Map getAttributes() {
            return null;
        }

        public Map getPreviousAttributes() {
            return null;
        }

        public ConnectionSet getConnectionSet() {
            return null;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return null;
        }

        public ParentMap getParentMap() {
            return null;
        }

        public ParentMap getPreviousParentMap() {
            return null;
        }

        public void addImplicitEdit(UndoableEdit undoableEdit) {
        }

        public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
            return null;
        }

        public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.updateNext();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            for (int i2 = 0; i2 < this.cells.length; ++i2) {
                List list = this.getParentList(this.cells[i2]);
                if (list == null) continue;
                this.prev[i2] = list.indexOf(this.cells[i2]);
                if (this.prev[i2] < 0) continue;
                list.remove(this.prev[i2]);
                int n2 = this.next[i2];
                if (n2 == -1) {
                    n2 = list.size();
                } else if (n2 == -2) {
                    n2 = 0;
                }
                list.add(n2, this.cells[i2]);
                this.next[i2] = this.prev[i2];
            }
            this.updateListeners();
        }

        protected void updateListeners() {
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        protected List getParentList(Object object) {
            List list = null;
            if (object instanceof DefaultMutableTreeNode) {
                TreeNode treeNode = ((DefaultMutableTreeNode)object).getParent();
                list = treeNode instanceof DefaultGraphCell ? ((DefaultGraphCell)treeNode).getChildren() : DefaultGraphModel.this.roots;
            }
            return list;
        }
    }

    public class GraphModelEdit
    extends CompoundEdit
    implements GraphModelEvent.GraphModelChange {
        protected Object[] insert;
        protected Object[] changed;
        protected Object[] remove;
        protected Object[] context;
        protected Object[] inserted;
        protected Object[] removed;
        protected Map attributes;
        protected Map previousAttributes;
        protected ParentMap parentMap;
        protected ParentMap previousParentMap;
        protected ConnectionSet connectionSet;
        protected ConnectionSet previousConnectionSet;
        protected Map cellViews = new Hashtable();

        public GraphModelEdit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
            this.insert = objectArray;
            this.remove = objectArray2;
            this.connectionSet = connectionSet;
            this.attributes = map;
            this.parentMap = parentMap;
            this.previousAttributes = null;
            this.previousConnectionSet = connectionSet;
            this.previousParentMap = parentMap;
            if (parentMap != null) {
                Hashtable hashtable = new Hashtable();
                Iterator iterator = parentMap.entries();
                while (iterator.hasNext()) {
                    Object object;
                    Object object2;
                    ParentMap.Entry entry = (ParentMap.Entry)iterator.next();
                    Object object3 = entry.getChild();
                    if (DefaultGraphModel.this.isPort(object3) || (object2 = DefaultGraphModel.this.getParent(object3)) == (object = entry.getParent())) continue;
                    this.changeChildCount(hashtable, object2, -1);
                    this.changeChildCount(hashtable, object, 1);
                }
                this.handleEmptyGroups(this.filterParents(hashtable, 0));
            }
        }

        public Object[] filterParents(Map map, int n2) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof Integer) || (Integer)entry.getValue() != n2) continue;
                arrayList.add(entry.getKey());
            }
            return arrayList.toArray();
        }

        protected void changeChildCount(Map map, Object object, int n2) {
            if (object != null) {
                Integer n3 = (Integer)map.get(object);
                if (n3 == null) {
                    n3 = new Integer(DefaultGraphModel.this.getChildCount(object));
                }
                int n4 = n3 + n2;
                map.put(object, new Integer(n4));
            }
        }

        protected void handleEmptyGroups(Object[] objectArray) {
            if (objectArray != null && objectArray.length > 0) {
                if (this.remove == null) {
                    this.remove = new Object[0];
                }
                Object[] objectArray2 = new Object[this.remove.length + objectArray.length];
                System.arraycopy(this.remove, 0, objectArray2, 0, this.remove.length);
                System.arraycopy(objectArray, 0, objectArray2, this.remove.length, objectArray.length);
                this.remove = objectArray2;
            }
        }

        public boolean isSignificant() {
            return true;
        }

        public Object getSource() {
            return DefaultGraphModel.this;
        }

        public Object[] getChanged() {
            return this.changed;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Object[] getInserted() {
            return this.inserted;
        }

        public Object[] getRemoved() {
            return this.removed;
        }

        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public ConnectionSet getConnectionSet() {
            return this.connectionSet;
        }

        public ConnectionSet getPreviousConnectionSet() {
            return this.previousConnectionSet;
        }

        public ParentMap getParentMap() {
            return this.parentMap;
        }

        public ParentMap getPreviousParentMap() {
            return this.previousParentMap;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            HashSet hashSet = new HashSet();
            if (this.attributes != null) {
                hashSet.addAll(this.attributes.keySet());
            }
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            if (this.connectionSet != null) {
                hashSet.addAll(this.connectionSet.getChangedEdges());
            }
            if (this.remove != null) {
                for (int i2 = 0; i2 < this.remove.length; ++i2) {
                    hashSet.remove(this.remove[i2]);
                }
            }
            this.changed = hashSet.toArray();
            Set set = DefaultGraphModel.getEdges(DefaultGraphModel.this, this.changed);
            this.context = set.toArray();
            this.inserted = this.insert;
            this.removed = this.remove;
            this.remove = DefaultGraphModel.this.handleInsert(this.inserted);
            this.previousParentMap = this.parentMap;
            this.parentMap = DefaultGraphModel.this.handleParentMap(this.parentMap);
            if (this.parentMap != null) {
                hashSet.addAll(this.parentMap.getChangedNodes());
            }
            this.previousConnectionSet = this.connectionSet;
            this.connectionSet = DefaultGraphModel.this.handleConnectionSet(this.connectionSet);
            this.insert = DefaultGraphModel.this.handleRemove(this.removed);
            this.previousAttributes = this.attributes;
            this.attributes = DefaultGraphModel.this.handleAttributes(this.attributes);
            this.changed = hashSet.toArray();
            DefaultGraphModel.this.fireGraphChanged(DefaultGraphModel.this, this);
        }

        public void putViews(GraphLayoutCache graphLayoutCache, CellView[] cellViewArray) {
            if (graphLayoutCache != null && cellViewArray != null) {
                this.cellViews.put(graphLayoutCache, cellViewArray);
            }
        }

        public CellView[] getViews(GraphLayoutCache graphLayoutCache) {
            return (CellView[])this.cellViews.get(graphLayoutCache);
        }

        public String toString() {
            int n2;
            String string = new String();
            if (this.inserted != null) {
                string = string + "Inserted:\n";
                for (n2 = 0; n2 < this.inserted.length; ++n2) {
                    string = string + "  " + this.inserted[n2] + "\n";
                }
            } else {
                string = string + "None inserted\n";
            }
            if (this.removed != null) {
                string = string + "Removed:\n";
                for (n2 = 0; n2 < this.removed.length; ++n2) {
                    string = string + "  " + this.removed[n2] + "\n";
                }
            } else {
                string = string + "None removed\n";
            }
            if (this.changed != null && this.changed.length > 0) {
                string = string + "Changed:\n";
                for (n2 = 0; n2 < this.changed.length; ++n2) {
                    string = string + "  " + this.changed[n2] + "\n";
                }
            } else {
                string = string + "None changed\n";
            }
            string = this.parentMap != null ? string + this.parentMap.toString() : string + "No parent map\n";
            return string;
        }
    }
}

