/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.DateFormatSymbols;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import org.ibex.nestedvm.util.Seekable;

public abstract class Platform {
    private static final Platform p;
    static /* synthetic */ Class class$org$ibex$nestedvm$util$Platform;

    Platform() {
    }

    public static String getProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    abstract boolean _atomicCreateFile(File var1) throws IOException;

    public static boolean atomicCreateFile(File file) throws IOException {
        return p._atomicCreateFile(file);
    }

    abstract Seekable.Lock _lockFile(Seekable var1, RandomAccessFile var2, long var3, long var5, boolean var7) throws IOException;

    public static Seekable.Lock lockFile(Seekable seekable, RandomAccessFile randomAccessFile, long l2, long l3, boolean bl) throws IOException {
        return p._lockFile(seekable, randomAccessFile, l2, l3, bl);
    }

    abstract void _socketHalfClose(Socket var1, boolean var2) throws IOException;

    public static void socketHalfClose(Socket socket, boolean bl) throws IOException {
        p._socketHalfClose(socket, bl);
    }

    abstract void _socketSetKeepAlive(Socket var1, boolean var2) throws SocketException;

    public static void socketSetKeepAlive(Socket socket, boolean bl) throws SocketException {
        p._socketSetKeepAlive(socket, bl);
    }

    abstract InetAddress _inetAddressFromBytes(byte[] var1) throws UnknownHostException;

    public static InetAddress inetAddressFromBytes(byte[] byArray) throws UnknownHostException {
        return p._inetAddressFromBytes(byArray);
    }

    abstract String _timeZoneGetDisplayName(TimeZone var1, boolean var2, boolean var3, Locale var4);

    public static String timeZoneGetDisplayName(TimeZone timeZone, boolean bl, boolean bl2, Locale locale) {
        return p._timeZoneGetDisplayName(timeZone, bl, bl2, locale);
    }

    public static String timeZoneGetDisplayName(TimeZone timeZone, boolean bl, boolean bl2) {
        return Platform.timeZoneGetDisplayName(timeZone, bl, bl2, Locale.getDefault());
    }

    abstract void _setFileLength(RandomAccessFile var1, int var2) throws IOException;

    public static void setFileLength(RandomAccessFile randomAccessFile, int n2) throws IOException {
        p._setFileLength(randomAccessFile, n2);
    }

    abstract File[] _listRoots();

    public static File[] listRoots() {
        return p._listRoots();
    }

    abstract File _getRoot(File var1);

    public static File getRoot(File file) {
        return p._getRoot(file);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        float f2;
        try {
            f2 = Platform.getProperty("java.vm.name").equals("SableVM") ? 1.2f : Float.valueOf(Platform.getProperty("java.specification.version")).floatValue();
        }
        catch (Exception exception) {
            System.err.println("WARNING: " + exception + " while trying to find jvm version -  assuming 1.1");
            f2 = 1.1f;
        }
        if (f2 >= 1.4f) {
            string = "Jdk14";
        } else if (f2 >= 1.3f) {
            string = "Jdk13";
        } else if (f2 >= 1.2f) {
            string = "Jdk12";
        } else if (f2 >= 1.1f) {
            string = "Jdk11";
        } else {
            throw new Error("JVM Specification version: " + f2 + " is too old. (see org.ibex.util.Platform to add support)");
        }
        try {
            p = (Platform)Class.forName((class$org$ibex$nestedvm$util$Platform == null ? (class$org$ibex$nestedvm$util$Platform = Platform.class$("org.ibex.nestedvm.util.Platform")) : class$org$ibex$nestedvm$util$Platform).getName() + "$" + string).newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("Error instansiating platform class");
        }
    }

    private static final class Jdk14FileLock
    extends Seekable.Lock {
        private final Seekable s;
        private final FileLock l;

        Jdk14FileLock(Seekable seekable, FileLock fileLock) {
            this.s = seekable;
            this.l = fileLock;
        }

        public Seekable seekable() {
            return this.s;
        }

        public boolean isShared() {
            return this.l.isShared();
        }

        public boolean isValid() {
            return this.l.isValid();
        }

        public void release() throws IOException {
            this.l.release();
        }

        public long position() {
            return this.l.position();
        }

        public long size() {
            return this.l.size();
        }

        public String toString() {
            return this.l.toString();
        }
    }

    static class Jdk14
    extends Jdk13 {
        Jdk14() {
        }

        InetAddress _inetAddressFromBytes(byte[] byArray) throws UnknownHostException {
            return InetAddress.getByAddress(byArray);
        }

        Seekable.Lock _lockFile(Seekable seekable, RandomAccessFile randomAccessFile, long l2, long l3, boolean bl) throws IOException {
            FileLock fileLock;
            try {
                fileLock = l2 == 0L && l3 == 0L ? randomAccessFile.getChannel().lock() : randomAccessFile.getChannel().tryLock(l2, l3, bl);
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                fileLock = null;
            }
            if (fileLock == null) {
                return null;
            }
            return new Jdk14FileLock(seekable, fileLock);
        }
    }

    static class Jdk13
    extends Jdk12 {
        Jdk13() {
        }

        void _socketHalfClose(Socket socket, boolean bl) throws IOException {
            if (bl) {
                socket.shutdownOutput();
            } else {
                socket.shutdownInput();
            }
        }

        void _socketSetKeepAlive(Socket socket, boolean bl) throws SocketException {
            socket.setKeepAlive(bl);
        }
    }

    static class Jdk12
    extends Jdk11 {
        Jdk12() {
        }

        boolean _atomicCreateFile(File file) throws IOException {
            return file.createNewFile();
        }

        String _timeZoneGetDisplayName(TimeZone timeZone, boolean bl, boolean bl2, Locale locale) {
            return timeZone.getDisplayName(bl, bl2 ? 1 : 0, locale);
        }

        void _setFileLength(RandomAccessFile randomAccessFile, int n2) throws IOException {
            randomAccessFile.setLength(n2);
        }

        File[] _listRoots() {
            return File.listRoots();
        }
    }

    static class Jdk11
    extends Platform {
        Jdk11() {
        }

        boolean _atomicCreateFile(File file) throws IOException {
            if (file.exists()) {
                return false;
            }
            new FileOutputStream(file).close();
            return true;
        }

        Seekable.Lock _lockFile(Seekable seekable, RandomAccessFile randomAccessFile, long l2, long l3, boolean bl) throws IOException {
            throw new IOException("file locking requires jdk 1.4+");
        }

        void _socketHalfClose(Socket socket, boolean bl) throws IOException {
            throw new IOException("half closing sockets not supported");
        }

        InetAddress _inetAddressFromBytes(byte[] byArray) throws UnknownHostException {
            if (byArray.length != 4) {
                throw new UnknownHostException("only ipv4 addrs supported");
            }
            return InetAddress.getByName("" + (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF));
        }

        void _socketSetKeepAlive(Socket socket, boolean bl) throws SocketException {
            if (bl) {
                throw new SocketException("keepalive not supported");
            }
        }

        String _timeZoneGetDisplayName(TimeZone timeZone, boolean bl, boolean bl2, Locale locale) {
            String[][] stringArray = new DateFormatSymbols(locale).getZoneStrings();
            String string = timeZone.getID();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!stringArray[i2][0].equals(string)) continue;
                return stringArray[i2][bl ? (bl2 ? 3 : 4) : (bl2 ? 1 : 2)];
            }
            StringBuffer stringBuffer = new StringBuffer("GMT");
            int n2 = timeZone.getRawOffset() / 1000;
            if (n2 < 0) {
                stringBuffer.append("-");
                n2 = -n2;
            } else {
                stringBuffer.append("+");
            }
            stringBuffer.append(n2 / 3600);
            if ((n2 %= 3600) > 0) {
                stringBuffer.append(":").append(n2 / 60);
            }
            if ((n2 %= 60) > 0) {
                stringBuffer.append(":").append(n2);
            }
            return stringBuffer.toString();
        }

        void _setFileLength(RandomAccessFile randomAccessFile, int n2) throws IOException {
            int n3;
            FileInputStream fileInputStream = new FileInputStream(randomAccessFile.getFD());
            FileOutputStream fileOutputStream = new FileOutputStream(randomAccessFile.getFD());
            byte[] byArray = new byte[1024];
            while (n2 > 0 && (n3 = ((InputStream)fileInputStream).read(byArray, 0, Math.min(n2, byArray.length))) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n3);
                n2 -= n3;
            }
            if (n2 == 0) {
                return;
            }
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray[n3] = 0;
            }
            while (n2 > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, Math.min(n2, byArray.length));
                n2 -= byArray.length;
            }
        }

        RandomAccessFile _truncatedRandomAccessFile(File file, String string) throws IOException {
            new FileOutputStream(file).close();
            return new RandomAccessFile(file, string);
        }

        File[] _listRoots() {
            Object object;
            String[] stringArray = new String[]{"java.home", "java.class.path", "java.library.path", "java.io.tmpdir", "java.ext.dirs", "user.home", "user.dir"};
            Hashtable<File, Boolean> hashtable = new Hashtable<File, Boolean>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                int n2;
                String string = Jdk11.getProperty(stringArray[i2]);
                if (string == null) continue;
                do {
                    object = string;
                    n2 = string.indexOf(File.pathSeparatorChar);
                    if (n2 != -1) {
                        object = string.substring(0, n2);
                        string = string.substring(n2 + 1);
                    }
                    File file = Jdk11.getRoot(new File((String)object));
                    hashtable.put(file, Boolean.TRUE);
                } while (n2 != -1);
            }
            File[] fileArray = new File[hashtable.size()];
            int n3 = 0;
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                fileArray[n3++] = (File)object.nextElement();
            }
            return fileArray;
        }

        File _getRoot(File file) {
            String string;
            if (!file.isAbsolute()) {
                file = new File(file.getAbsolutePath());
            }
            while ((string = file.getParent()) != null) {
                file = new File(string);
            }
            if (file.getPath().length() == 0) {
                file = new File("/");
            }
            return file;
        }
    }
}

