/*
 * Decompiled with CFR 0.152.
 */
package jess.xml;

import java.util.Iterator;
import jess.Accumulate;
import jess.ConditionalElement;
import jess.Deffacts;
import jess.Deffunction;
import jess.Defglobal;
import jess.Defmodule;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.Group;
import jess.JessException;
import jess.Named;
import jess.Pattern;
import jess.RU;
import jess.Test1;
import jess.Value;
import jess.ValueVector;
import jess.Variable;
import jess.Visitable;
import jess.Visitor;
import jess.xml.XMLWriter;

public class XMLVisitor
implements Visitor {
    private final Visitable m_visitable;

    public XMLVisitor(Visitable visitable) {
        this.m_visitable = visitable;
    }

    public Object visitDeffacts(Deffacts deffacts) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("facts");
        xMLWriter.textElementNoSpace("name", deffacts.getName());
        XMLVisitor.possiblyEmitDocstring(xMLWriter, deffacts);
        int n2 = deffacts.getNFacts();
        for (int i2 = 0; i2 < n2; ++i2) {
            Fact fact = deffacts.getFact(i2);
            xMLWriter.append(this.visitFact(fact));
        }
        xMLWriter.closeTag("facts");
        return xMLWriter.toString();
    }

    private static void possiblyEmitDocstring(XMLWriter xMLWriter, Named named) {
        String string = named.getDocstring();
        if (string != null && string.length() > 0) {
            xMLWriter.textElementNoSpace("comment", named.getDocstring());
        }
    }

    public Object visitDeftemplate(Deftemplate deftemplate) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("template");
        xMLWriter.textElementNoSpace("name", deftemplate.getName());
        if (deftemplate.getParent() != Deftemplate.getRootTemplate()) {
            xMLWriter.textElementNoSpace("extends", deftemplate.getParent().getName());
        }
        XMLVisitor.possiblyEmitDocstring(xMLWriter, deftemplate);
        try {
            if (XMLVisitor.hasTemplateDeclarables(deftemplate)) {
                xMLWriter.openTag("properties");
                if (deftemplate.isShadowTemplate()) {
                    this.emitProperty(xMLWriter, "from-class", XMLVisitor.newSymbolValue(deftemplate.getShadowClassName()));
                    if (deftemplate.includesVariables()) {
                        this.emitProperty(xMLWriter, "include-variables", Funcall.TRUE);
                    }
                }
                if (deftemplate.isSlotSpecific()) {
                    this.emitProperty(xMLWriter, "slot-specific", Funcall.TRUE);
                }
                if (deftemplate.getBackwardChaining()) {
                    this.emitProperty(xMLWriter, "backchain-reactive", Funcall.TRUE);
                }
                xMLWriter.closeTag("properties");
            }
        }
        catch (JessException jessException) {
            return jessException.toString();
        }
        if (!deftemplate.isShadowTemplate()) {
            for (int i2 = 0; i2 < deftemplate.getNSlots(); ++i2) {
                try {
                    int n2;
                    String string = deftemplate.getSlotName(i2);
                    Value value = deftemplate.getSlotDefault(i2);
                    if (deftemplate.getSlotType(i2) == 32768) {
                        xMLWriter.openTag("multislot");
                        xMLWriter.textElementNoSpace("name", string);
                        n2 = deftemplate.getSlotDataType(i2);
                        if (n2 != -1) {
                            xMLWriter.textElementNoSpace("type", RU.getTypeName(n2));
                        }
                        xMLWriter.append(this.visitValueVector(value.listValue(null)));
                        xMLWriter.closeTag("multislot");
                        continue;
                    }
                    xMLWriter.openTag("slot");
                    xMLWriter.textElementNoSpace("name", string);
                    n2 = deftemplate.getSlotDataType(i2);
                    if (n2 != -1) {
                        xMLWriter.textElementNoSpace("type", RU.getTypeName(n2));
                    }
                    xMLWriter.appendln(this.visitValue(value));
                    xMLWriter.closeTag("slot");
                    continue;
                }
                catch (JessException jessException) {
                    return jessException.toString();
                }
            }
        }
        xMLWriter.closeTag("template");
        return xMLWriter.toString();
    }

    private void emitProperty(XMLWriter xMLWriter, String string, Value value) {
        xMLWriter.openTag("property");
        xMLWriter.textElementNoSpace("name", string);
        xMLWriter.append(this.visitValue(value));
        xMLWriter.closeTag("property");
    }

    private static Value newSymbolValue(String string) {
        try {
            return new Value(string, 1);
        }
        catch (JessException jessException) {
            return null;
        }
    }

    private static boolean hasTemplateDeclarables(Deftemplate deftemplate) {
        return deftemplate.isShadowTemplate() || deftemplate.isSlotSpecific() || deftemplate.getBackwardChaining();
    }

    public Object visitDeffunction(Deffunction deffunction) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("function");
        xMLWriter.textElementNoSpace("name", deffunction.getName());
        XMLVisitor.possiblyEmitDocstring(xMLWriter, deffunction);
        xMLWriter.openTag("arguments");
        Iterator iterator = deffunction.getArguments();
        while (iterator.hasNext()) {
            Deffunction.Argument argument = (Deffunction.Argument)iterator.next();
            xMLWriter.openTag("argument");
            xMLWriter.textElementNoSpace("name", argument.getName());
            xMLWriter.textElementNoSpace("type", RU.getTypeName(argument.getType()));
            xMLWriter.closeTag("argument");
        }
        xMLWriter.closeTag("arguments");
        iterator = deffunction.getActions();
        while (iterator.hasNext()) {
            xMLWriter.appendln(this.visitValue((Value)iterator.next()));
        }
        xMLWriter.closeTag("function");
        return xMLWriter.toString();
    }

    public Object visitDefglobal(Defglobal defglobal) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("global");
        xMLWriter.textElementNoSpace("name", defglobal.getName());
        xMLWriter.appendln(this.visitValue(defglobal.getInitializationValue()));
        xMLWriter.closeTag("global");
        return xMLWriter.toString();
    }

    public Object visitDefrule(Defrule defrule) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("rule");
        xMLWriter.textElementNoSpace("name", defrule.getName());
        XMLVisitor.possiblyEmitDocstring(xMLWriter, defrule);
        if (XMLVisitor.hasRuleDeclarables(defrule)) {
            xMLWriter.openTag("properties");
            if (defrule.hasNonDefaultSalience()) {
                this.emitProperty(xMLWriter, "salience", defrule.getSalienceValue());
            }
            if (defrule.getAutoFocus()) {
                this.emitProperty(xMLWriter, "auto-focus", Funcall.TRUE);
            }
            if (defrule.isNoLoop()) {
                this.emitProperty(xMLWriter, "no-loop", Funcall.TRUE);
            }
            if (defrule.getNodeIndexHash() != 0) {
                this.emitProperty(xMLWriter, "node-index-hash", XMLVisitor.makeIntValue(defrule.getNodeIndexHash()));
            }
            xMLWriter.closeTag("properties");
        }
        xMLWriter.openTag("lhs");
        if (defrule.getNext() != null) {
            xMLWriter.openTag("group");
            xMLWriter.textElementNoSpace("name", "or");
        }
        for (Defrule defrule2 = defrule; defrule2 != null; defrule2 = (Defrule)defrule2.getNext()) {
            xMLWriter.append(this.visitGroup((Group)defrule2.getConditionalElements()));
        }
        if (defrule.getNext() != null) {
            xMLWriter.closeTag("group");
        }
        xMLWriter.closeTag("lhs");
        xMLWriter.openTag("rhs");
        for (int i2 = 0; i2 < defrule.getNActions(); ++i2) {
            xMLWriter.append(this.visitFuncall(defrule.getAction(i2)));
        }
        xMLWriter.closeTag("rhs");
        xMLWriter.closeTag("rule");
        return xMLWriter.toString();
    }

    private static boolean hasRuleDeclarables(Defrule defrule) {
        return defrule.hasNonDefaultSalience() || defrule.getAutoFocus() || defrule.isNoLoop() || defrule.getNodeIndexHash() != 0;
    }

    private static boolean hasQueryDeclarables(Defquery defquery) {
        return defquery.getMaxBackgroundRules() > 0 || defquery.getNodeIndexHash() != 0;
    }

    public Object visitDefquery(Defquery defquery) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("query");
        xMLWriter.textElementNoSpace("name", defquery.getName());
        XMLVisitor.possiblyEmitDocstring(xMLWriter, defquery);
        int n2 = defquery.getNVariables();
        xMLWriter.openTag("arguments");
        for (int i2 = 0; i2 < n2; ++i2) {
            Variable variable = defquery.getQueryVariable(i2);
            xMLWriter.openTag("argument");
            xMLWriter.textElementNoSpace("name", RU.removePrefix(variable.variableValue(null)));
            xMLWriter.textElementNoSpace("type", RU.getTypeName(variable.type()));
            xMLWriter.closeTag("argument");
        }
        xMLWriter.closeTag("arguments");
        if (XMLVisitor.hasQueryDeclarables(defquery)) {
            xMLWriter.openTag("properties");
            if (defquery.getMaxBackgroundRules() > 0) {
                this.emitProperty(xMLWriter, "max-background-rules", XMLVisitor.makeIntValue(defquery.getMaxBackgroundRules()));
            }
            if (defquery.getNodeIndexHash() != 0) {
                this.emitProperty(xMLWriter, "node-index-hash", XMLVisitor.makeIntValue(defquery.getNodeIndexHash()));
            }
            xMLWriter.closeTag("properties");
        }
        xMLWriter.openTag("lhs");
        if (defquery.getNext() != null) {
            xMLWriter.openTag("group");
            xMLWriter.textElementNoSpace("name", "or");
        }
        for (Defquery defquery2 = defquery; defquery2 != null; defquery2 = (Defquery)defquery2.getNext()) {
            xMLWriter.append(this.visitGroup((Group)defquery2.getConditionalElements()));
        }
        if (defquery.getNext() != null) {
            xMLWriter.closeTag("group");
        }
        xMLWriter.closeTag("lhs");
        xMLWriter.closeTag("query");
        return xMLWriter.toString();
    }

    private static Value makeIntValue(int n2) {
        try {
            return new Value(n2, 4);
        }
        catch (JessException jessException) {
            return null;
        }
    }

    public Object visitPattern(Pattern pattern) {
        if (pattern.getName().indexOf("__query-trigger-") > 0) {
            return "";
        }
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("pattern");
        String string = pattern.getName();
        if (string.equals("MAIN::test")) {
            string = "test";
        }
        xMLWriter.textElementNoSpace("name", string);
        if (pattern.getBoundName() != null) {
            xMLWriter.textElementNoSpace("binding", pattern.getBoundName());
        }
        Deftemplate deftemplate = pattern.getDeftemplate();
        try {
            for (int i2 = 0; i2 < pattern.getNSlots(); ++i2) {
                if (pattern.getNTests(i2) <= 0 && pattern.getSlotLength(i2) == -1) continue;
                xMLWriter.openTag("slot");
                xMLWriter.textElementNoSpace("name", deftemplate.getSlotName(i2));
                for (int i3 = 0; i3 < pattern.getNTests(i2); ++i3) {
                    Test1 test1 = pattern.getTest(i2, i3);
                    xMLWriter.append(this.visitTest1(test1));
                }
                xMLWriter.closeTag("slot");
            }
        }
        catch (JessException jessException) {
            return jessException.toString();
        }
        xMLWriter.closeTag("pattern");
        return xMLWriter.toString();
    }

    public Object visitGroup(Group group) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("group");
        xMLWriter.textElementNoSpace("name", group.getName());
        for (int i2 = 0; i2 < group.getGroupSize(); ++i2) {
            ConditionalElement conditionalElement = group.getConditionalElement(i2);
            if (this.ceWasProbablyInserted(group, i2)) continue;
            xMLWriter.append(new XMLVisitor((Visitable)((Object)conditionalElement)));
        }
        xMLWriter.closeTag("group");
        return xMLWriter.toString();
    }

    private boolean ceWasProbablyInserted(Group group, int n2) {
        ConditionalElement conditionalElement = group.getConditionalElement(n2);
        if (n2 > 0 || !conditionalElement.getName().equals(Deftemplate.getInitialTemplate().getName())) {
            return false;
        }
        if (group.getGroupSize() == 1) {
            return true;
        }
        String string = group.getConditionalElement(n2 + 1).getName();
        return Group.isNegatedName(string) || string.equals("logical");
    }

    public Object visitTest1(Test1 test1) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("test");
        xMLWriter.textElementNoSpace("type", test1.getTest() == 0 ? "eq" : "neq");
        if (test1.getConjunction() != 0) {
            xMLWriter.textElementNoSpace("conjunction", test1.getConjunction() == 1 ? "and" : "or");
        }
        xMLWriter.appendln(this.visitValue(test1.getValue()));
        xMLWriter.closeTag("test");
        return xMLWriter.toString();
    }

    private Object visitValue(Value value) {
        try {
            int n2 = value.type();
            if (n2 == 16) {
                return this.visitFact(value.factValue(null));
            }
            if (n2 == 64) {
                return this.visitFuncall(value.funcallValue(null));
            }
            if (n2 == 512) {
                return this.makeList(value.listValue(null));
            }
            if (n2 == 4096) {
                n2 = 8;
            }
            XMLWriter xMLWriter = new XMLWriter();
            xMLWriter.openTagNoNewline("value", "type", RU.getTypeName(n2));
            switch (n2) {
                case 1: 
                case 2: {
                    xMLWriter.append(XMLWriter.escape(value.stringValue(null)));
                    break;
                }
                case 8: 
                case 8192: {
                    xMLWriter.append(RU.removePrefix(value.variableValue(null)));
                    break;
                }
                default: {
                    xMLWriter.append(value.toString());
                }
            }
            xMLWriter.closeTagNoIndentation("value");
            return xMLWriter;
        }
        catch (JessException jessException) {
            return jessException.toString();
        }
    }

    private Object visitValueVector(ValueVector valueVector) {
        try {
            XMLWriter xMLWriter = new XMLWriter();
            for (int i2 = 0; i2 < valueVector.size(); ++i2) {
                xMLWriter.appendln(this.visitValue(valueVector.get(i2)));
            }
            return xMLWriter.toString();
        }
        catch (JessException jessException) {
            return jessException.toString();
        }
    }

    private Object makeList(ValueVector valueVector) {
        XMLWriter xMLWriter = new XMLWriter();
        try {
            xMLWriter.openTag("list");
            for (int i2 = 0; i2 < valueVector.size(); ++i2) {
                xMLWriter.appendln(this.visitValue(valueVector.get(i2)));
            }
            xMLWriter.closeTag("list");
            return xMLWriter.toString();
        }
        catch (JessException jessException) {
            xMLWriter.append(jessException.toString());
            return xMLWriter.toString();
        }
    }

    public Object visitFact(Fact fact) {
        try {
            XMLWriter xMLWriter = new XMLWriter();
            Deftemplate deftemplate = fact.getDeftemplate();
            xMLWriter.openTag("fact");
            xMLWriter.textElementNoSpace("name", fact.getName());
            for (int i2 = 0; i2 < deftemplate.getNSlots(); ++i2) {
                String string = deftemplate.getSlotName(i2);
                Value value = fact.getSlotValue(string);
                if (deftemplate.getSlotDefault(i2).equals(value)) continue;
                xMLWriter.openTag("slot");
                xMLWriter.textElementNoSpace("name", string);
                if (value.type() != 512) {
                    xMLWriter.append(this.visitValue(value));
                    xMLWriter.appendln("");
                } else {
                    xMLWriter.append(this.visitValueVector(value.listValue(null)));
                }
                xMLWriter.closeTag("slot");
            }
            xMLWriter.closeTag("fact");
            return xMLWriter.toString();
        }
        catch (JessException jessException) {
            return jessException.toString();
        }
    }

    public Object visitFuncall(Funcall funcall) {
        XMLWriter xMLWriter = new XMLWriter();
        try {
            xMLWriter.openTag("funcall");
            xMLWriter.textElementNoSpace("name", funcall.get(0).symbolValue(null));
            for (int i2 = 1; i2 < funcall.size(); ++i2) {
                xMLWriter.appendln(this.visitValue(funcall.get(i2)));
            }
            xMLWriter.closeTag("funcall");
            return xMLWriter.toString();
        }
        catch (JessException jessException) {
            return jessException.toString();
        }
    }

    public Object visitAccumulate(Accumulate accumulate) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("accumulate");
        if (accumulate.getBoundName() != null) {
            xMLWriter.textElementNoSpace("binding", accumulate.getBoundName());
        }
        xMLWriter.openTag("accum-init");
        xMLWriter.append(this.visitValue(accumulate.getInitializer()));
        xMLWriter.closeTag("accum-init");
        xMLWriter.openTag("accum-body");
        xMLWriter.append(this.visitValue(accumulate.getBody()));
        xMLWriter.closeTag("accum-body");
        xMLWriter.openTag("accum-return");
        xMLWriter.append(this.visitValue(accumulate.getReturn()));
        xMLWriter.closeTag("accum-return");
        xMLWriter.append(new XMLVisitor((Visitable)((Object)accumulate.getConditionalElement(0))));
        xMLWriter.closeTag("accumulate");
        return xMLWriter.toString();
    }

    public Object visitDefmodule(Defmodule defmodule) {
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.openTag("module");
        xMLWriter.textElementNoSpace("name", defmodule.getName());
        XMLVisitor.possiblyEmitDocstring(xMLWriter, defmodule);
        xMLWriter.closeTag("module");
        return xMLWriter.toString();
    }

    public String toString() {
        return (String)this.m_visitable.accept(this);
    }
}

