/*
 * Decompiled with CFR 0.152.
 */
package jess.xml;

import java.io.StringReader;
import java.io.StringWriter;
import jess.Defrule;
import jess.Fact;
import jess.JessException;
import jess.Pattern;
import jess.Rete;
import jess.Test1;
import jess.Value;
import jess.Variable;
import jess.xml.JessSAXParser;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.InputSource;

public class JessSAXParserTest
extends TestCase {
    private Rete m_engine = new Rete();
    static /* synthetic */ Class class$jess$xml$JessSAXParserTest;

    public static TestSuite suite() {
        return new TestSuite(class$jess$xml$JessSAXParserTest == null ? (class$jess$xml$JessSAXParserTest = JessSAXParserTest.class$("jess.xml.JessSAXParserTest")) : class$jess$xml$JessSAXParserTest);
    }

    public void testMatchMulti() throws JessException {
        this.m_engine.assertString("(foo 7 3)");
        this.m_engine.assertString("(foo 8 4)");
        this.m_engine.assertString("(foo 6 5)");
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs>    <pattern><name>foo</name>      <slot><name>__data</name>      <test><type>eq</type><value type='variable'>x</value></test>      <test><type>eq</type><value type='variable'>y</value></test>      <test><conjunction>and</conjunction><type>eq</type><value type='integer'>3</value></test>      </slot>    </pattern>  </lhs>  <rhs>    <funcall><name>store</name><value type='symbol'>x</value><value type='VARIABLE'>x</value></funcall>\n    <funcall><name>store</name><value type='symbol'>y</value><value type='VARIABLE'>y</value></funcall>\n  </rhs>\n</rule>\n";
        this.parseRule(string);
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
        JessSAXParserTest.assertEquals((int)7, (int)this.m_engine.fetch("x").intValue(null));
        JessSAXParserTest.assertEquals((int)3, (int)this.m_engine.fetch("y").intValue(null));
    }

    public void testEmptyProperties() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n<properties></properties>  <lhs>  </lhs>\n  <rhs>  </rhs>\n</rule>\n";
        this.parseRule(string);
    }

    public void testFixedSalience() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n<properties><property><name>salience</name><value type='INTEGER'>123</value></property></properties>  <lhs>  </lhs>\n  <rhs>  </rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        JessSAXParserTest.assertEquals((int)123, (int)defrule.getSalience());
    }

    public void testBinding() throws JessException {
        this.m_engine.assertString("(foo)");
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs>    <pattern><binding>f</binding><name>foo</name></pattern>  </lhs>\n  <rhs>    <funcall><name>retract</name><value type='VARIABLE'>f</value></funcall>\n  </rhs>\n</rule>\n";
        this.parseRule(string);
        JessSAXParserTest.assertTrue((boolean)this.m_engine.listFacts().hasNext());
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
        JessSAXParserTest.assertFalse((boolean)this.m_engine.listFacts().hasNext());
    }

    public void testAssert() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs></lhs>\n  <rhs><funcall><name>store</name>         <value type='SYMBOL'>X</value>\n         <funcall><name>assert</name>\n          <fact><name>foo</name>            <slot><name>__data</name>              <value type='SYMBOL'>bar</value>              <value type='SYMBOL'>baz</value>              <funcall><name>+</name>                <value type='FLOAT'>0.2</value>                <value type='FLOAT'>0.2</value>              </funcall>            </slot>\n          </fact>\n       </funcall></funcall>\n  </rhs>\n</rule>\n";
        this.parseRule(string);
        this.m_engine.reset();
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
        Fact fact = this.m_engine.fetch("X").factValue(null);
        JessSAXParserTest.assertEquals((String)"MAIN::foo", (String)fact.getName());
        JessSAXParserTest.assertEquals((int)3, (int)fact.getSlotValue("__data").listValue(null).size());
        JessSAXParserTest.assertEquals((String)"bar", (String)fact.getSlotValue("__data").listValue(null).get(0).symbolValue(null));
        JessSAXParserTest.assertEquals((String)"baz", (String)fact.getSlotValue("__data").listValue(null).get(1).symbolValue(null));
        JessSAXParserTest.assertEquals((double)0.4, (double)fact.getSlotValue("__data").listValue(null).get(2).floatValue(null), (double)1.0E-6);
    }

    public void testAssertUnordered() throws JessException {
        this.m_engine.eval("(deftemplate foo (slot bar))");
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs></lhs>\n  <rhs><funcall><name>store</name>         <value type='SYMBOL'>X</value>\n         <funcall><name>assert</name>\n          <fact><name>foo</name>            <slot><name>bar</name>              <value type='INTEGER'>37</value>            </slot>\n          </fact>\n       </funcall></funcall>\n  </rhs>\n</rule>\n";
        this.parseRule(string);
        this.m_engine.reset();
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
        Fact fact = this.m_engine.fetch("X").factValue(null);
        JessSAXParserTest.assertEquals((String)"MAIN::foo", (String)fact.getName());
        JessSAXParserTest.assertEquals((int)37, (int)fact.getSlotValue("bar").intValue(null));
    }

    public void testModifyUnordered() throws JessException {
        this.m_engine.eval("(deftemplate foo (slot bar))");
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs>    <pattern><binding>f</binding>      <name>foo</name>\n      <slot><name>bar</name>        <test><type>neq</type><value type='integer'>37</value></test>      </slot>    </pattern>  </lhs>\n  <rhs>    <funcall><name>modify</name>         <value type='variable'>f</value>         <slot><name>bar</name>           <value type='INTEGER'>37</value>         </slot>\n    </funcall>  </rhs>\n</rule>\n";
        this.parseRule(string);
        this.m_engine.reset();
        Fact fact = this.m_engine.assertString("(foo (bar 17))");
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
        JessSAXParserTest.assertEquals((int)37, (int)fact.getSlotValue("bar").intValue(null));
    }

    public void testNestedFuncallInFuncall() throws JessException {
        StringWriter stringWriter = new StringWriter();
        this.m_engine.addOutputRouter("probe", stringWriter);
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs></lhs>\n  <rhs><funcall><name>printout</name>\n         <value type='SYMBOL'>probe</value>\n         <funcall><name>+</name>\n           <value type='INTEGER'>2</value>\n           <value type='INTEGER'>2</value>\n         </funcall>\n  </funcall></rhs>\n</rule>\n";
        this.parseRule(string);
        this.m_engine.reset();
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
        JessSAXParserTest.assertEquals((String)"4", (String)stringWriter.toString());
    }

    public void testNestedGroups() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs><group><name>or</name>    <group><name>and</name>      <pattern><name>a</name></pattern>      <pattern><name>b</name></pattern>    </group>    <group><name>and</name>      <pattern><name>c</name></pattern>      <pattern><name>d</name></pattern>    </group>  </group></lhs>\n  <rhs></rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        JessSAXParserTest.assertEquals((int)2, (int)defrule.getPatternCount());
        JessSAXParserTest.assertEquals((String)"MAIN::a", (String)defrule.getConditionalElements().getConditionalElement(0).getName());
        JessSAXParserTest.assertEquals((String)"MAIN::b", (String)defrule.getConditionalElements().getConditionalElement(1).getName());
        JessSAXParserTest.assertNotNull((Object)defrule.getNext());
        defrule = (Defrule)defrule.getNext();
        JessSAXParserTest.assertEquals((int)2, (int)defrule.getPatternCount());
        JessSAXParserTest.assertEquals((String)"MAIN::c", (String)defrule.getConditionalElements().getConditionalElement(0).getName());
        JessSAXParserTest.assertEquals((String)"MAIN::d", (String)defrule.getConditionalElements().getConditionalElement(1).getName());
        JessSAXParserTest.assertNull((Object)defrule.getNext());
    }

    public void testGroup() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs><group><name>or</name>    <pattern><name>foo</name></pattern>    <pattern><name>bar</name></pattern>  </group></lhs>\n  <rhs></rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        JessSAXParserTest.assertEquals((int)1, (int)defrule.getPatternCount());
        JessSAXParserTest.assertEquals((String)"MAIN::foo", (String)defrule.getConditionalElements().getConditionalElement(0).getName());
        JessSAXParserTest.assertNotNull((Object)defrule.getNext());
        defrule = (Defrule)defrule.getNext();
        JessSAXParserTest.assertEquals((int)1, (int)defrule.getPatternCount());
        JessSAXParserTest.assertEquals((String)"MAIN::bar", (String)defrule.getConditionalElements().getConditionalElement(0).getName());
        JessSAXParserTest.assertNull((Object)defrule.getNext());
    }

    public void testSingleOrdered() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs><pattern><name>foo</name></pattern></lhs>\n  <rhs></rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        JessSAXParserTest.assertEquals((int)1, (int)defrule.getPatternCount());
        JessSAXParserTest.assertEquals((String)"MAIN::foo", (String)defrule.getConditionalElements().getConditionalElement(0).getName());
        JessSAXParserTest.assertEquals((int)0, (int)defrule.getNActions());
        JessSAXParserTest.assertEquals((int)0, (int)this.m_engine.run());
        this.m_engine.reset();
        JessSAXParserTest.assertEquals((int)0, (int)this.m_engine.run());
        this.m_engine.assertString("(foo)");
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
    }

    public void testfuncall() throws JessException {
        StringWriter stringWriter = new StringWriter();
        this.m_engine.addOutputRouter("probe", stringWriter);
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs></lhs>\n  <rhs><funcall><name>printout</name>\n    <value type='SYMBOL'>probe</value>\n    <value type='STRING'>Hello</value>\n    <value type='SYMBOL'>crlf</value>\n  </funcall></rhs>\n</rule>\n";
        this.parseRule(string);
        this.m_engine.reset();
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
        JessSAXParserTest.assertEquals((String)"Hello\n", (String)stringWriter.toString());
    }

    public void testDoubleOrdered() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs>    <pattern><name>foo</name></pattern>    <pattern><name>bar</name></pattern>  </lhs>\n  <rhs></rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        JessSAXParserTest.assertEquals((int)2, (int)defrule.getPatternCount());
        JessSAXParserTest.assertEquals((String)"MAIN::foo", (String)defrule.getConditionalElements().getConditionalElement(0).getName());
        JessSAXParserTest.assertEquals((String)"MAIN::bar", (String)defrule.getConditionalElements().getConditionalElement(1).getName());
        JessSAXParserTest.assertEquals((int)0, (int)defrule.getNActions());
        this.m_engine.assertString("(foo)");
        this.m_engine.assertString("(bar)");
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
    }

    public void testConjunctions() throws Exception {
        this.m_engine.eval("(deftemplate foo (slot bar))");
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs>    <pattern><name>foo</name>    <slot><name>bar</name>      <test><type>eq</type><value type='INTEGER'>1</value></test>      <test><conjunction>or</conjunction><type>neq</type><value type='INTEGER'>2</value></test>    </slot>    </pattern>  </lhs>\n  <rhs></rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        Pattern pattern = (Pattern)defrule.getConditionalElements().getConditionalElement(0);
        JessSAXParserTest.assertEquals((int)2, (int)pattern.getNTests(0));
        Test1 test1 = pattern.getTest(0, 0);
        JessSAXParserTest.assertEquals((int)0, (int)test1.getTest());
        JessSAXParserTest.assertEquals((int)test1.getValue().type(), (int)8);
        JessSAXParserTest.assertEquals((int)test1.getConjunction(), (int)1);
        test1 = pattern.getTest(0, 1);
        JessSAXParserTest.assertEquals((int)0, (int)test1.getTest());
        JessSAXParserTest.assertEquals((int)test1.getValue().type(), (int)64);
        JessSAXParserTest.assertEquals((int)test1.getConjunction(), (int)1);
    }

    public void testUnorderedSimpleTests() throws Exception {
        this.m_engine.eval("(deftemplate foo (slot bar)(slot baz))");
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs>    <pattern><name>foo</name>    <slot><name>bar</name>      <test><type>neq</type><value type='INTEGER'>1</value></test>    </slot>    <slot><name>baz</name>      <test><type>eq</type><value type='VARIABLE'>X</value></test>    </slot>    </pattern>  </lhs>\n  <rhs></rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        Pattern pattern = (Pattern)defrule.getConditionalElements().getConditionalElement(0);
        JessSAXParserTest.assertEquals((int)1, (int)pattern.getNTests(0));
        Test1 test1 = pattern.getTest(0, 0);
        JessSAXParserTest.assertEquals((int)1, (int)test1.getTest());
        JessSAXParserTest.assertEquals((Object)test1.getValue(), (Object)new Value(1, 4));
        JessSAXParserTest.assertEquals((int)1, (int)pattern.getNTests(1));
        test1 = pattern.getTest(1, 0);
        JessSAXParserTest.assertEquals((int)0, (int)test1.getTest());
        JessSAXParserTest.assertEquals((Object)test1.getValue(), (Object)new Variable("X", 8));
    }

    public void testEmptyRule() throws JessException {
        String string = "<rule>\n  <name>rule-1</name>\n  <lhs></lhs>\n  <rhs></rhs>\n</rule>\n";
        Defrule defrule = this.parseRule(string);
        JessSAXParserTest.assertEquals((int)1, (int)defrule.getPatternCount());
        JessSAXParserTest.assertEquals((String)"MAIN::initial-fact", (String)defrule.getConditionalElements().getConditionalElement(0).getName());
        JessSAXParserTest.assertEquals((int)0, (int)defrule.getNActions());
        JessSAXParserTest.assertEquals((int)0, (int)this.m_engine.run());
        this.m_engine.reset();
        JessSAXParserTest.assertEquals((int)1, (int)this.m_engine.run());
    }

    private Defrule parseRule(String string) throws JessException {
        JessSAXParser jessSAXParser = new JessSAXParser(this.m_engine);
        InputSource inputSource = JessSAXParserTest.makeSource("rulebase", string);
        jessSAXParser.parse(inputSource);
        Defrule defrule = (Defrule)this.m_engine.findDefrule("rule-1");
        JessSAXParserTest.assertNotNull((Object)defrule);
        return defrule;
    }

    public static InputSource makeSource(String string, String string2) {
        String string3 = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?>\n<?version \"1.0\"?>\n<" + string + ">\n";
        String string4 = "</" + string + ">\n\n\n";
        StringReader stringReader = new StringReader(string3 + string2 + string4);
        return new InputSource(stringReader);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

