/*
 * Decompiled with CFR 0.152.
 */
package jess.server;

import java.io.StringReader;
import java.io.StringWriter;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Main;
import jess.Rete;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;
import jess.server.DebugListener;
import jess.server.DebugThreadGroup;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class DebugListenerTest
extends TestCase {
    private StringWriter m_events;
    private StringWriter m_output;
    private DebugListener m_server;
    static /* synthetic */ Class class$jess$server$DebugListenerTest;

    public static TestSuite suite() {
        return new TestSuite(class$jess$server$DebugListenerTest == null ? (class$jess$server$DebugListenerTest = DebugListenerTest.class$("jess.server.DebugListenerTest")) : class$jess$server$DebugListenerTest);
    }

    public DebugListenerTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_events = new StringWriter();
        this.m_output = new StringWriter();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_events = null;
        this.m_output = null;
    }

    public void testStartStop() throws InterruptedException {
        this.createServer("wait 0\njoin 0\n", "testdata/exit.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testThreadCreate() throws InterruptedException {
        this.createServer("wait 0\nstepo 0\njoin 0\nstepo 0\njoin 0\nwait 1\nquit\n", "testdata/2threads.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n16\nTHREAD_CREATE 1\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testCurrentActivation() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nstep 0\njoin 0\nactivation\nstep 0\njoin 0\nactivation\nquit", "testdata/rules.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n47\nACTIVATION MAIN::sample-rule <Fact-0> <Fact-1>\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n16\nACTIVATION NONE\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testAgenda() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nagenda 3\nquit", "testdata/agenda.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n80\nAGENDA MAIN 3\nMAIN::rule-5 <Fact-5>\nMAIN::rule-4 <Fact-4>\nMAIN::rule-3 <Fact-3>\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testFact() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nfact 0\nfact 1\nfact 2\nfact 3\nquit", "testdata/facts.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n28\nFACT 0 MAIN::initial-fact 0\n34\nFACT 1 MAIN::foo 1\n__data 5\n1 2 3\n53\nFACT 2 MAIN::a-template 2\na-slot 1\naanother-slot 1\nb\n22\nFACT 3 (retracted) 0\n\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testBreak() throws InterruptedException {
        this.createServer("wait 0\nbreak 2 testdata/linear.clp\nbreak 4 testdata/linear.clp\njoin 0\nresume 0\njoin 0\nresume 0\njoin 0\nresume 0\nquit", "testdata/linear.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n10\nRESUMED 0\n43\nSUSPENDED_BREAK 0 2 19\ntestdata/linear.clp\n10\nRESUMED 0\n43\nSUSPENDED_BREAK 0 4 19\ntestdata/linear.clp\n10\nRESUMED 0\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testBreakCommand() throws InterruptedException {
        this.createServer("wait 0 \nbreak 4 testdata/debug.clp\n", "testdata/exit.clp");
        DebugListenerTest.assertTrue((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 4));
        DebugListenerTest.assertFalse((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 3));
        DebugListenerTest.assertFalse((boolean)this.m_server.shouldBreakAt("testdata/nosuchfile.clp", 3));
    }

    public void testUnbreakCommand() throws InterruptedException {
        this.createServer("wait 0\nbreak 3 testdata/debug.clp\nbreak 4 testdata/debug.clp\nunbreak 4 testdata/debug.clp\n", "testdata/exit.clp");
        DebugListenerTest.assertTrue((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 3));
        DebugListenerTest.assertFalse((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 4));
    }

    public void testBreakpointTable() throws InterruptedException {
        this.createServer("wait 0\n", "testdata/exit.clp");
        this.m_server.addBreakpoint("testdata/debug.clp", 4);
        this.m_server.addBreakpoint("testdata/debug.clp", 5);
        DebugListenerTest.assertTrue((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 4));
        DebugListenerTest.assertTrue((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 5));
        DebugListenerTest.assertFalse((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 3));
        DebugListenerTest.assertFalse((boolean)this.m_server.shouldBreakAt("testdata/nosuchfile.clp", 3));
        this.m_server.removeBreakpoint("testdata/debug.clp", 5);
        DebugListenerTest.assertFalse((boolean)this.m_server.shouldBreakAt("testdata/debug.clp", 5));
    }

    public void testSuspend() throws InterruptedException {
        this.createServer("wait 0\nresume 0\nsuspend 0\njoin 0\nstep 0\njoin 0\nquit\n", "testdata/debug.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n10\nRESUMED 0\n12\nSUSPENDED 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testLHSVariables() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nstack 0\nprint 0 0 2\n?xquit\n", "testdata/debug.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n65\nSTACK 0 53\n<,testdata/debug.clp,4,x|assert,testdata/debug.clp,9|\n17\nPRINT 0 0 ?x 1\n1\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testStack() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstack 0\nquit\n", "testdata/variables.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n96\nSTACK 0 84\nprintout,testdata/variables.clp,8,*x*,*y*,i,j,k|f,testdata/variables.clp,10,*x*,*y*|\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testNestedStack() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstack 0\nquit\n", "testdata/nested.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n96\nSTACK 0 84\n>,testdata/nested.clp,3,x|while,testdata/nested.clp,3,x|foo,testdata/nested.clp,6,z|\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testNestedPrint() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstack 0\nprint 0 0 2\n?x\nprint 0 1 2\n?x\nprint 0 2 2\n?zquit\n", "testdata/nested.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n97\nSTACK 0 85\n--,testdata/nested.clp,4,x|while,testdata/nested.clp,3,x|foo,testdata/nested.clp,6,z|\n18\nPRINT 0 0 ?x 2\n10\n18\nPRINT 0 1 ?x 2\n10\n18\nPRINT 0 2 ?z 2\n17\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testToplevelBreak() throws Exception {
        this.createServer("wait 0\nbreak 17 testdata/deffunctions.clp\nresume 0\njoin 0\nstack 0\nquit\n", "testdata/deffunctions.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n10\nRESUMED 0\n50\nSUSPENDED_BREAK 0 17 25\ntestdata/deffunctions.clp\n44\nSTACK 0 32\nf3,testdata/deffunctions.clp,17|\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testStepInto1() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nprint 0 0 2\n?istep 0\njoin 0\nprint 0 0 2\n?istep 0\njoin 0\nprint 0 0 2\n?iquit\n", "testdata/step.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n1\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n2\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n3\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testStepInto2() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nprint 0 0 2\n?istep 0\njoin 0\nprint 0 0 2\n?istep 0\njoin 0\nprint 0 0 2\n?istep 0\njoin 0\nprint 0 0 2\n?istep 0\njoin 0\nprint 0 0 2\n?istep 0\njoin 0\nprint 0 0 2\n?iquit\n", "testdata/step2.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n1\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n1\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n2\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n2\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n3\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n3\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testStepOver1() throws InterruptedException {
        this.createServer("wait 0\nstepo 0\njoin 0\nprint 0 0 2\n?istepo 0\njoin 0\nprint 0 0 2\n?istepo 0\njoin 0\nprint 0 0 2\n?iquit\n", "testdata/step.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n1\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n2\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n3\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testStepOver2() throws InterruptedException {
        this.createServer("wait 0\nstepo 0\njoin 0\nprint 0 0 2\n?istepo 0\njoin 0\nprint 0 0 2\n?istepo 0\njoin 0\nprint 0 0 2\n?iquit\n", "testdata/step2.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n1\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n2\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n3\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testPrintExprSimple() throws InterruptedException {
        this.createServer("wait 0\nprint 0 0 7\n(+ 2 2)quit\n", "testdata/step2.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n22\nPRINT 0 0 (+ 2 2) 1\n4\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testPrint() throws InterruptedException {
        this.createServer("wait 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nstep 0\njoin 0\nprint 0 0 2\n?iprint 0 0 2\n?jprint 0 0 2\n?kprint 0 0 4\n?*x*print 0 0 4\n?*y*quit\n", "testdata/variables.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n15\nRESUMED_STEP 0\n17\nSUSPENDED_STEP 0\n17\nPRINT 0 0 ?i 1\n1\n17\nPRINT 0 0 ?j 1\n2\n17\nPRINT 0 0 ?k 1\n3\n19\nPRINT 0 0 ?*x* 1\n3\n25\nPRINT 0 0 ?*y* 7\n\"Hello\"\n5\nQUIT\n", (String)this.m_events.toString());
    }

    public void testQuit() throws InterruptedException {
        this.createServer("wait 0\njoin 0\nquit\n", "testdata/debug.clp");
        DebugListenerTest.assertEquals((String)"8\nSTARTED\n5\nQUIT\n", (String)this.m_events.toString());
    }

    private void createServer(String string, String string2) throws InterruptedException {
        StringReader stringReader = new StringReader(string);
        Rete rete = new Rete();
        rete.addOutputRouter("t", new StringWriter());
        this.m_server = new DebugListener(stringReader, this.m_output, this.m_events, rete);
        rete.addDebugListener(this.m_server);
        rete.addUserfunction(new NullUserfunction("exit"));
        rete.setDebug(true);
        final Main main = new Main();
        this.m_server.addObserver(main);
        main.initialize(new String[]{"-nologo", string2}, rete);
        this.m_server.setListeningForEvents(true);
        DebugThreadGroup debugThreadGroup = new DebugThreadGroup("Debugger Test");
        Thread thread = new Thread((ThreadGroup)debugThreadGroup, new Runnable(){

            public void run() {
                main.execute(false);
            }
        });
        thread.start();
        thread.join();
        this.m_server.join();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class NullUserfunction
    implements Userfunction {
        private String m_name;

        public NullUserfunction(String string) {
            this.m_name = string;
        }

        public String getName() {
            return this.m_name;
        }

        public Value call(ValueVector valueVector, Context context) throws JessException {
            return Funcall.NIL;
        }
    }
}

