/*
 * Decompiled with CFR 0.152.
 */
package jess.jsr94;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rules.Handle;
import javax.rules.InvalidRuleSessionException;
import javax.rules.ObjectFilter;
import javax.rules.admin.RuleExecutionSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import jess.Batch;
import jess.Defrule;
import jess.Jesp;
import jess.JessException;
import jess.Rete;
import jess.jsr94.HandleImpl;
import jess.jsr94.NameDescriptionProperties;
import jess.jsr94.RuleImpl;
import jess.xml.JessSAXHandler;
import jess.xml.JessSAXParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

class RuleExecutionSetImpl
extends NameDescriptionProperties
implements RuleExecutionSet,
Cloneable {
    private Rete m_engine;
    private String m_filter;
    private String m_uri;

    public RuleExecutionSetImpl(Reader reader, Map map) throws IOException, JessException {
        super(map);
        this.m_engine = new Rete();
        PushbackReader pushbackReader = new PushbackReader(reader, 512);
        if (Batch.isXMLDocument(pushbackReader)) {
            JessSAXParser jessSAXParser = new JessSAXParser(this.m_engine);
            jessSAXParser.parse(new InputSource(pushbackReader));
        } else {
            Jesp jesp = new Jesp(pushbackReader, this.m_engine);
            jesp.parse(false, this.m_engine.getGlobalContext());
        }
    }

    public RuleExecutionSetImpl(Rete rete, Map map) {
        super(map);
        this.m_engine = rete;
    }

    public RuleExecutionSetImpl(Element element, Map map) throws JessException {
        super(map);
        try {
            this.m_engine = new Rete();
            DOMSource dOMSource = new DOMSource(element);
            SAXResult sAXResult = new SAXResult(new JessSAXHandler(this.m_engine, "rulebase"));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(dOMSource, sAXResult);
        }
        catch (TransformerException transformerException) {
            throw new JessException("RuleExecutionSetImpl", "Can't build rules from DOM", transformerException);
        }
    }

    public void setDefaultObjectFilter(String string) {
        this.m_filter = string;
    }

    public String getDefaultObjectFilter() {
        return this.m_filter;
    }

    public List getRules() {
        ArrayList<RuleImpl> arrayList = new ArrayList<RuleImpl>();
        Iterator iterator = this.m_engine.listDefrules();
        while (iterator.hasNext()) {
            arrayList.add(new RuleImpl((Defrule)iterator.next()));
        }
        return arrayList;
    }

    public Rete getEngine() {
        return this.m_engine;
    }

    public void run() throws InvalidRuleSessionException {
        try {
            this.m_engine.run();
        }
        catch (JessException jessException) {
            throw new InvalidRuleSessionException(jessException.getMessage(), jessException);
        }
    }

    public void reset() throws InvalidRuleSessionException {
        try {
            Iterator iterator = this.m_engine.listDefinstances();
            while (iterator.hasNext()) {
                this.m_engine.undefinstance(iterator.next());
            }
            this.m_engine.reset();
        }
        catch (JessException jessException) {
            throw new InvalidRuleSessionException(jessException.getMessage(), jessException);
        }
    }

    public void release() {
        try {
            this.m_engine.clear();
        }
        catch (JessException jessException) {
            // empty catch block
        }
    }

    public Handle addObject(Object object) throws InvalidRuleSessionException {
        try {
            this.m_engine.add(object);
            return new HandleImpl(object);
        }
        catch (JessException jessException) {
            throw new InvalidRuleSessionException(jessException.getMessage(), jessException);
        }
    }

    public boolean containsObject(Handle handle) {
        Object object = ((HandleImpl)handle).getObject();
        return this.m_engine.containsObject(object);
    }

    public void removeObject(Handle handle) throws InvalidRuleSessionException {
        try {
            Object object = ((HandleImpl)handle).getObject();
            this.m_engine.undefinstance(object);
        }
        catch (JessException jessException) {
            throw new InvalidRuleSessionException(jessException.getMessage(), jessException);
        }
    }

    public List getObjects() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.m_engine.listDefinstances();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public String getURI() {
        return this.m_uri;
    }

    public void setURI(String string) {
        this.m_uri = string;
    }

    public List getObjects(ObjectFilter objectFilter) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.m_engine.listDefinstances();
        while (iterator.hasNext()) {
            Object object = objectFilter.filter(iterator.next());
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public Object clone() {
        try {
            RuleExecutionSetImpl ruleExecutionSetImpl = (RuleExecutionSetImpl)super.clone();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.m_engine.bsave(byteArrayOutputStream);
            Rete rete = new Rete();
            rete.bload(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ruleExecutionSetImpl.m_engine = rete;
            return ruleExecutionSetImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

