/*
 * Decompiled with CFR 0.152.
 */
package jess.awt;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public class TextReader
extends Reader
implements Serializable {
    private StringBuffer m_buf = new StringBuffer(256);
    private int m_ptr = 0;
    private boolean m_dontWait = false;
    private boolean m_open = true;

    public TextReader(boolean bl) {
        this.m_dontWait = bl;
    }

    public synchronized int read() throws IOException {
        if (!this.m_open) {
            throw new IOException("Closed");
        }
        while (this.m_ptr >= this.m_buf.length()) {
            if (this.m_dontWait) {
                return -1;
            }
            if (!this.m_open) {
                return -1;
            }
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                if (this.m_open) continue;
                return -1;
            }
        }
        char c2 = this.m_buf.charAt(this.m_ptr++);
        if (this.m_ptr >= this.m_buf.length()) {
            this.clear();
        }
        return c2;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            int n4 = this.read();
            if (n4 == -1) {
                return i2 > n2 ? i2 - n2 : -1;
            }
            cArray[i2] = (char)n4;
        }
        return n3;
    }

    public void close() {
        this.m_open = false;
    }

    public int available() {
        return this.m_buf.length() - this.m_ptr;
    }

    public synchronized void appendText(String string) {
        this.m_buf.append(string);
        this.notifyAll();
    }

    public synchronized void clear() {
        this.m_buf.setLength(0);
        this.m_ptr = 0;
    }
}

