/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import jess.Funcall;
import jess.JessException;
import jess.LongValue;
import jess.Value;

public class ValueVector
implements Cloneable,
Serializable {
    protected Value[] m_v;
    protected int m_ptr = 0;

    public ValueVector() {
        this(10);
    }

    public ValueVector(int n2) {
        this.m_v = new Value[n2];
    }

    public final int size() {
        return this.m_ptr;
    }

    public Object clone() {
        return this.cloneInto(new ValueVector(this.m_ptr));
    }

    public ValueVector cloneInto(ValueVector valueVector) {
        if (this.m_ptr > valueVector.m_v.length) {
            valueVector.m_v = new Value[this.m_ptr];
        }
        valueVector.m_ptr = this.m_ptr;
        System.arraycopy(this.m_v, 0, valueVector.m_v, 0, this.m_ptr);
        return valueVector;
    }

    public Value get(int n2) throws JessException {
        if (n2 < 0 || n2 >= this.m_ptr) {
            throw new JessException("ValueVector.get", "Index " + n2 + " out of bounds on this vector:", this.toStringWithParens());
        }
        return this.m_v[n2];
    }

    public ValueVector setLength(int n2) {
        if (n2 > this.m_v.length) {
            Value[] valueArray = new Value[n2];
            System.arraycopy(this.m_v, 0, valueArray, 0, this.m_v.length);
            this.m_v = valueArray;
        }
        this.m_ptr = n2;
        return this;
    }

    public final ValueVector set(Value value, int n2) throws JessException {
        if (n2 < 0 || n2 >= this.m_ptr) {
            throw new JessException("ValueVector.set", "Bad index " + n2 + " in call to set() on this vector:", this.toStringWithParens());
        }
        this.m_v[n2] = value;
        return this;
    }

    public final ValueVector add(Value value) {
        if (this.m_ptr >= this.m_v.length) {
            Value[] valueArray = new Value[this.m_v.length * 2];
            System.arraycopy(this.m_v, 0, valueArray, 0, this.m_v.length);
            this.m_v = valueArray;
        }
        this.m_v[this.m_ptr++] = value;
        return this;
    }

    public final ValueVector add(String string) throws JessException {
        return this.add(new Value(string, 1));
    }

    public final ValueVector add(int n2) throws JessException {
        return this.add(new Value(n2, 4));
    }

    public final ValueVector add(double d2) throws JessException {
        return this.add(new Value(d2, 32));
    }

    public final ValueVector add(boolean bl) {
        return this.add(bl ? Funcall.TRUE : Funcall.FALSE);
    }

    public final ValueVector add(long l2) throws JessException {
        return this.add(new LongValue(l2));
    }

    public final ValueVector add(Object object) {
        if (object instanceof Value) {
            return this.add((Value)object);
        }
        return this.add(new Value(object));
    }

    public final ValueVector remove(int n2) throws JessException {
        if (n2 < 0 || n2 >= this.m_ptr) {
            throw new JessException("ValueVector.set", "Bad index " + n2 + " in call to remove() on this vector:", this.toStringWithParens());
        }
        if (n2 < this.m_ptr - 1) {
            System.arraycopy(this.m_v, n2 + 1, this.m_v, n2, this.m_ptr - n2);
        }
        this.m_v[--this.m_ptr] = null;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueVector)) {
            return false;
        }
        ValueVector valueVector = (ValueVector)object;
        if (this.m_ptr != valueVector.m_ptr) {
            return false;
        }
        for (int i2 = this.m_ptr - 1; i2 >= 0; --i2) {
            if (this.m_v[i2].equals(valueVector.m_v[i2])) continue;
            return false;
        }
        return true;
    }

    public static void copy(ValueVector valueVector, int n2, ValueVector valueVector2, int n3, int n4) {
        int n5 = n3 + n4;
        int n6 = valueVector2.m_ptr;
        if (n5 > n6) {
            valueVector2.setLength(n5);
        }
        for (int i2 = n6; i2 < n3; ++i2) {
            valueVector2.m_v[i2] = Funcall.NIL;
        }
        System.arraycopy(valueVector.m_v, n2, valueVector2.m_v, n3, n4);
    }

    public ValueVector addAll(ValueVector valueVector) {
        ValueVector.copy(valueVector, 0, this, this.m_ptr, valueVector.m_ptr);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        for (int i2 = 0; i2 < this.m_ptr; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.m_v[i2]);
        }
        return stringBuffer.toString();
    }

    public String toStringWithParens() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("(");
        for (int i2 = 0; i2 < this.m_ptr; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.m_v[i2].toStringWithParens());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            this.add(value);
        }
    }

    public int hashCode() {
        try {
            int n2 = 0;
            for (int i2 = 0; i2 < this.size(); ++i2) {
                n2 += this.get(i2).hashCode();
            }
            return n2;
        }
        catch (JessException jessException) {
            return 0;
        }
    }
}

