/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.StringReader;
import jess.JessToken;
import jess.ReaderTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TokenizerTest
extends TestCase {
    private int m_index;
    static LineNumberTest[] lineNumberTests = new LineNumberTest[]{new LineNumberTest("symbol", 1, 0, "symbol"), new LineNumberTest(";Comment\nsymbol", 2, 0, "symbol"), new LineNumberTest(";Comment\n;Comment\nsymbol", 3, 0, "symbol"), new LineNumberTest("\"Multiline\nstring\"\nsymbol", 3, 1, "symbol"), new LineNumberTest("(inside\nparens\nmultiline\nexpr", 4, 4, "expr"), new LineNumberTest("(inside\nparens ;with comment\nmultiline\nexpr", 4, 4, "expr")};
    static /* synthetic */ Class class$jess$TokenizerTest;

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite(class$jess$TokenizerTest == null ? (class$jess$TokenizerTest = TokenizerTest.class$("jess.TokenizerTest")) : class$jess$TokenizerTest);
        for (int i2 = 0; i2 < lineNumberTests.length; ++i2) {
            testSuite.addTest((Test)new TokenizerTest("doTestLineNumbers", i2));
        }
        return testSuite;
    }

    public TokenizerTest(String string, int n2) {
        super(string);
        this.m_index = n2;
    }

    public TokenizerTest(String string) {
        super(string);
    }

    public void doTestLineNumbers() throws Exception {
        LineNumberTest lineNumberTest = lineNumberTests[this.m_index];
        ReaderTokenizer readerTokenizer = new ReaderTokenizer(new StringReader(lineNumberTest.data), false);
        JessToken jessToken = null;
        int n2 = -1;
        do {
            jessToken = readerTokenizer.nextToken();
        } while (++n2 < lineNumberTest.tokenIndex);
        TokenizerTest.assertEquals((String)"Found the right token", (String)lineNumberTest.token, (String)jessToken.toString());
        TokenizerTest.assertEquals((String)"Line number", (int)lineNumberTest.lineNumber, (int)jessToken.m_lineno);
    }

    public void testReturnNewlines() throws Exception {
        StringReader stringReader = new StringReader("; comment\ncode\n\"str\ning\"\n;comment");
        ReaderTokenizer readerTokenizer = new ReaderTokenizer(stringReader, true);
        readerTokenizer.reportNewlines(true);
        TokenizerTest.assertEquals((int)7, (int)readerTokenizer.nextToken().m_ttype);
        TokenizerTest.assertEquals((int)10, (int)readerTokenizer.nextToken().m_ttype);
        TokenizerTest.assertEquals((int)4, (int)readerTokenizer.nextToken().m_ttype);
        TokenizerTest.assertEquals((int)10, (int)readerTokenizer.nextToken().m_ttype);
        TokenizerTest.assertEquals((int)3, (int)readerTokenizer.nextToken().m_ttype);
        TokenizerTest.assertEquals((int)10, (int)readerTokenizer.nextToken().m_ttype);
        TokenizerTest.assertEquals((int)7, (int)readerTokenizer.nextToken().m_ttype);
    }

    public void testCommentInContext() throws Exception {
        StringReader stringReader = new StringReader("; fullline comment\n(+ 2 2) ; endline comment\n");
        ReaderTokenizer readerTokenizer = new ReaderTokenizer(stringReader, true);
        int[] nArray = new int[]{7, 40, 4, 5, 5, 41, 7};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TokenizerTest.assertEquals((int)nArray[i2], (int)readerTokenizer.nextToken().m_ttype);
        }
    }

    public void testWindowsLines() throws Exception {
        String string = "(reset)\r\n(run)\r\n\"abc\"\r\n1\r\n(/ 1 1)";
        int[] nArray = new int[]{0, 1, 6, 9, 10, 13, 16, 23, 26, 27, 29, 31, 32};
        StringReader stringReader = new StringReader(string);
        ReaderTokenizer readerTokenizer = new ReaderTokenizer(stringReader, false);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            TokenizerTest.assertEquals((int)n2, (int)readerTokenizer.nextToken().m_start);
        }
    }

    public void testUNIXLines() throws Exception {
        String string = "(reset)\n(run)\n\"abc\"\n1\n(/ 1 1)";
        int[] nArray = new int[]{0, 1, 6, 8, 9, 12, 14, 20, 22, 23, 25, 27, 28};
        StringReader stringReader = new StringReader(string);
        ReaderTokenizer readerTokenizer = new ReaderTokenizer(stringReader, false);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            TokenizerTest.assertEquals((int)n2, (int)readerTokenizer.nextToken().m_start);
        }
    }

    public void testIsALong() throws Exception {
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong("1L"));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong("1"));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong("-1L"));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong("-1"));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong(String.valueOf(Long.MAX_VALUE)));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong(String.valueOf(Long.MAX_VALUE) + "L"));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong(String.valueOf(Long.MAX_VALUE) + "l"));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong(String.valueOf(Long.MIN_VALUE)));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong(String.valueOf(Long.MIN_VALUE) + "L"));
        TokenizerTest.assertTrue((boolean)ReaderTokenizer.isALong(String.valueOf(Long.MIN_VALUE) + "l"));
    }

    public void testNextToken() throws Exception {
        JessToken jessToken;
        String string = "(this \"is\" seven ?tokens) last";
        JessToken[] jessTokenArray = new JessToken[]{new JessToken(0, 1, 40, "("), new JessToken(1, 5, 4, "this"), new JessToken(6, 10, 3, "is"), new JessToken(11, 16, 4, "seven"), new JessToken(17, 24, 2, "tokens"), new JessToken(24, 25, 41, ")"), new JessToken(26, 30, 4, "last")};
        StringReader stringReader = new StringReader(string);
        ReaderTokenizer readerTokenizer = new ReaderTokenizer(stringReader, true);
        int n2 = 0;
        while (!(jessToken = readerTokenizer.nextToken()).isEOF()) {
            TokenizerTest.assertEquals((Object)jessTokenArray[n2++], (Object)jessToken);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class LineNumberTest {
        String data;
        int lineNumber;
        int tokenIndex;
        String token;

        public LineNumberTest(String string, int n2, int n3, String string2) {
            this.data = string;
            this.lineNumber = n2;
            this.tokenIndex = n3;
            this.token = string2;
        }
    }
}

