/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Fact;
import jess.JessException;
import jess.Rete;

public class Token
implements Serializable {
    private Token m_parent;
    int m_negcnt;
    int m_sortcode;
    private int m_size;
    private Fact m_fact;
    private int m_totalTime;
    private int m_time;

    Token getParent() {
        return this.m_parent;
    }

    public final Fact topFact() {
        return this.m_fact;
    }

    public final Fact fact(int n2) {
        int n3 = this.m_size - n2;
        if (n3 == 1) {
            return this.m_fact;
        }
        Token token = this;
        while (--n3 > 0) {
            token = token.m_parent;
        }
        return token.m_fact;
    }

    public final int size() {
        return this.m_size;
    }

    public Token(Fact fact, int n2) throws JessException {
        this(fact);
    }

    public Token(Fact fact) throws JessException {
        ++this.m_size;
        this.m_fact = fact;
        this.m_time = this.m_totalTime = fact.getTime();
        this.m_sortcode = fact.getFactId();
    }

    public Token(Token token, Fact fact) throws JessException {
        this.m_fact = fact;
        this.m_parent = token;
        this.m_size = token.m_size + 1;
        this.m_sortcode = (token.m_sortcode << 3) + fact.getFactId();
        int n2 = fact.getTime();
        this.m_totalTime = token.m_totalTime + n2;
        this.m_time = Math.max(n2, token.m_time);
    }

    public Token(Token token, Token token2) throws JessException {
        this(token, token2.topFact());
    }

    public Token(Token token) throws JessException {
        this.m_fact = token.m_fact;
        this.m_parent = token.m_parent;
        this.m_size = token.m_size;
        this.m_sortcode = token.m_sortcode;
        this.m_time = token.m_time;
        this.m_totalTime = token.m_totalTime;
        this.m_negcnt = token.m_negcnt;
    }

    void updateTime(Rete rete) {
        int n2 = rete.getTime();
        this.m_totalTime = this.m_totalTime - this.m_fact.getTime() + n2;
        this.m_time = n2;
    }

    public int getTime() {
        return this.m_time;
    }

    public int getTotalTime() {
        return this.m_totalTime;
    }

    public final boolean dataEquals(Token token) {
        if (token == this) {
            return true;
        }
        if (this.m_sortcode != token.m_sortcode) {
            return false;
        }
        if (this.m_fact.getFactId() != token.m_fact.getFactId()) {
            return false;
        }
        if (!this.m_fact.equals(token.m_fact)) {
            return false;
        }
        if (this.m_parent == token.m_parent) {
            return true;
        }
        return this.m_parent.dataEquals(token.m_parent);
    }

    public final boolean fastDataEquals(Token token) {
        if (token == this) {
            return true;
        }
        if (this.m_sortcode != token.m_sortcode) {
            return false;
        }
        if (this.m_fact.getFactId() != token.m_fact.getFactId()) {
            return false;
        }
        if (this.m_parent == token.m_parent) {
            return true;
        }
        return this.m_parent.fastDataEquals(token.m_parent);
    }

    public boolean equals(Object object) {
        if (object instanceof Token) {
            return this.dataEquals((Token)object);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[Token: size=");
        stringBuffer.append(this.m_size);
        stringBuffer.append(";sortcode=");
        stringBuffer.append(this.m_sortcode);
        stringBuffer.append(";negcnt=");
        stringBuffer.append(this.m_negcnt);
        stringBuffer.append(";facts=");
        for (int i2 = 0; i2 < this.m_size; ++i2) {
            stringBuffer.append(this.fact(i2).toString());
            stringBuffer.append(";");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    String factList() {
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl = true;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            int n2;
            if (!bl) {
                stringBuffer.append(",");
            }
            if ((n2 = this.fact(i2).getFactId()) > -1) {
                stringBuffer.append(" f-");
                stringBuffer.append(n2);
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.m_sortcode;
    }

    public Token prepare(boolean bl) throws JessException {
        return this;
    }
}

