/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jess.JessException;
import jess.ReflectFunctions;
import jess.Rete;
import jess.SerializableD;

class SerializablePD
implements SerializableD {
    private String m_class;
    private String m_property;
    private transient Method m_get;
    private transient Method m_set;
    static Object[] s_nullArgs = new Object[0];

    SerializablePD(String string, String string2) {
        this.m_class = string;
        this.m_property = string2;
    }

    private void reload(Rete rete) throws JessException {
        try {
            Class clazz = rete.findClass(this.m_class);
            PropertyDescriptor[] propertyDescriptorArray = ReflectFunctions.getPropertyDescriptors(clazz);
            for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                if (!propertyDescriptorArray[i2].getName().equals(this.m_property)) continue;
                this.m_get = propertyDescriptorArray[i2].getReadMethod();
                this.m_set = propertyDescriptorArray[i2].getWriteMethod();
                return;
            }
        }
        catch (Exception exception) {
            throw new JessException("SerializablePD.reload", "Can't recreate property", exception);
        }
    }

    public String getName() {
        return this.m_property;
    }

    public Class getPropertyType(Rete rete) throws JessException {
        Method method = this.getReadMethod(rete);
        return method.getReturnType();
    }

    public Object getPropertyValue(Rete rete, Object object) throws JessException, IllegalAccessException, InvocationTargetException {
        Method method = this.getReadMethod(rete);
        return method.invoke(object, s_nullArgs);
    }

    public void setPropertyValue(Rete rete, Object object, Object object2) throws JessException, IllegalAccessException, InvocationTargetException {
        Method method = this.getWriteMethod(rete);
        if (method == null) {
            throw new JessException("SerializablePD.setPropertyValue", "Property is read-only", this.m_property);
        }
        method.invoke(object, object2);
    }

    private Method getReadMethod(Rete rete) throws JessException {
        if (this.m_get == null) {
            this.reload(rete);
        }
        return this.m_get;
    }

    private Method getWriteMethod(Rete rete) throws JessException {
        if (this.m_set == null) {
            this.reload(rete);
        }
        return this.m_set;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SerializablePD)) {
            return false;
        }
        SerializablePD serializablePD = (SerializablePD)object;
        return this.m_class.equals(serializablePD.m_class) && this.m_property.equals(serializablePD.m_property);
    }
}

