/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import jess.Defmodule;
import jess.Fact;
import jess.JessException;
import jess.MockBean;
import jess.Rete;
import jess.Value;
import jess.WorkingMemoryMarker;
import jess.xml.JessSAXParser;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.InputSource;

public class ReteTest
extends TestCase {
    static /* synthetic */ Class class$jess$ReteTest;
    static /* synthetic */ Class class$java$awt$Button;

    public static TestSuite suite() {
        return new TestSuite(class$jess$ReteTest == null ? (class$jess$ReteTest = ReteTest.class$("jess.ReteTest")) : class$jess$ReteTest);
    }

    public ReteTest(String string) {
        super(string);
    }

    public void testJavaClassForDefclass() throws Exception {
        Rete rete = new Rete();
        rete.defclass("button", "java.awt.Button", null);
        ReteTest.assertNull((Object)rete.javaClassForDefclass("foo"));
        ReteTest.assertEquals((Object)(class$java$awt$Button == null ? (class$java$awt$Button = ReteTest.class$("java.awt.Button")) : class$java$awt$Button), (Object)rete.javaClassForDefclass("button"));
        ReteTest.assertEquals((Object)(class$java$awt$Button == null ? (class$java$awt$Button = ReteTest.class$("java.awt.Button")) : class$java$awt$Button), (Object)rete.javaClassForDefclass("MAIN::button"));
        int n2 = 0;
        Iterator iterator = rete.listDefclasses();
        while (iterator.hasNext()) {
            ReteTest.assertNotNull(iterator.next());
            ++n2;
        }
        ReteTest.assertEquals((int)1, (int)n2);
    }

    public void testGetCurrentRule() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule foo => (store RULE ((engine) getThisRuleName)))");
        rete.reset();
        rete.run();
        ReteTest.assertEquals((String)"MAIN::foo", (String)rete.fetch("RULE").stringValue(null));
        ReteTest.assertNull((Object)rete.getThisRuleName());
    }

    public void testWatchModify() throws Exception {
        Rete rete = new Rete();
        rete.eval("(deftemplate t (slot s))");
        Fact fact = rete.assertString("(t (s 1))");
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("WSTDOUT", stringWriter);
        rete.watch(0);
        rete.modify(fact, "s", new Value(2, 4));
        String string = stringWriter.toString();
        ReteTest.assertTrue((string.indexOf("<=>") > -1 ? 1 : 0) != 0);
    }

    public void testChangeWatchRouter() throws Exception {
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("WSTDOUT", stringWriter);
        rete.watch(0);
        ReteTest.assertEquals((int)0, (int)stringWriter.toString().length());
        rete.assertString("(foo)");
        ReteTest.assertTrue((stringWriter.toString().length() > 0 ? 1 : 0) != 0);
        StringWriter stringWriter2 = new StringWriter();
        rete.addOutputRouter("WWATCH", stringWriter2);
        stringWriter = new StringWriter();
        rete.addOutputRouter("WSTDOUT", stringWriter);
        String string = rete.setWatchRouter("WWATCH");
        ReteTest.assertEquals((String)"WSTDOUT", (String)string);
        ReteTest.assertEquals((int)0, (int)stringWriter.toString().length());
        ReteTest.assertEquals((int)0, (int)stringWriter2.toString().length());
        rete.assertString("(bar)");
        ReteTest.assertEquals((int)0, (int)stringWriter.toString().length());
        ReteTest.assertTrue((stringWriter2.toString().length() > 0 ? 1 : 0) != 0);
    }

    public void testBogusWatchRouter() throws Exception {
        Rete rete = new Rete();
        StringWriter stringWriter = new StringWriter();
        rete.addOutputRouter("WSTDOUT", stringWriter);
        rete.watch(0);
        ReteTest.assertEquals((int)0, (int)stringWriter.toString().length());
        try {
            rete.setWatchRouter("BOGUS");
            ReteTest.fail((String)"Didn't see expected exception");
        }
        catch (JessException jessException) {
            // empty catch block
        }
        ReteTest.assertEquals((int)0, (int)stringWriter.toString().length());
        rete.assertString("(bar)");
        ReteTest.assertTrue((stringWriter.toString().length() > 0 ? 1 : 0) != 0);
    }

    public void testModifyCallPlain() throws Exception {
        Rete rete = new Rete();
        rete.eval("(deftemplate t (slot s))");
        Fact fact = rete.assertString("(t (s 1))");
        rete.modify(fact, "s", new Value(2, 4));
        ReteTest.assertEquals((int)2, (int)fact.getSlotValue("s").intValue(null));
    }

    public void testModifyCallStatic() throws Exception {
        Rete rete = new Rete();
        MockBean mockBean = new MockBean();
        mockBean.setFoo("abc");
        rete.defclass("bean", "jess.MockBean", null);
        Fact fact = rete.definstance("bean", mockBean, false).factValue(null);
        rete.modify(fact, "foo", new Value("xyz", 2));
        ReteTest.assertEquals((String)"xyz", (String)fact.getSlotValue("foo").symbolValue(null));
        ReteTest.assertEquals((String)"xyz", (String)mockBean.getFoo());
    }

    public void testModifyCallDynamic() throws Exception {
        Rete rete = new Rete();
        MockBean mockBean = new MockBean();
        mockBean.setFoo("abc");
        rete.defclass("bean", "jess.MockBean", null);
        Fact fact = rete.definstance("bean", mockBean, true).factValue(null);
        rete.modify(fact, "foo", new Value("xyz", 2));
        ReteTest.assertEquals((String)"xyz", (String)fact.getSlotValue("foo").symbolValue(null));
        ReteTest.assertEquals((String)"xyz", (String)mockBean.getFoo());
    }

    public void testListFocusStack() throws Exception {
        Rete rete = new Rete();
        rete.addDefmodule(new Defmodule("module-1", ""));
        rete.addDefmodule(new Defmodule("module-2", ""));
        rete.addDefmodule(new Defmodule("module-3", ""));
        rete.eval("(focus module-1 module-2 module-3)");
        Iterator iterator = rete.listFocusStack();
        ReteTest.assertEquals((Object)"module-3", iterator.next());
        ReteTest.assertEquals((Object)"module-2", iterator.next());
        ReteTest.assertEquals((Object)"module-1", iterator.next());
    }

    public void testRequireProvide() throws Exception {
        Rete rete = new Rete();
        rete.defineFeature("foo");
        ReteTest.assertTrue((boolean)rete.isFeatureDefined("foo"));
        ReteTest.assertFalse((boolean)rete.isFeatureDefined("bar"));
        rete.reset();
        ReteTest.assertTrue((boolean)rete.isFeatureDefined("foo"));
        rete.clear();
        ReteTest.assertFalse((boolean)rete.isFeatureDefined("foo"));
    }

    public void testAddAll() throws Exception {
        Integer n2 = new Integer(1);
        Short s2 = new Short(2);
        Double d2 = new Double(3.0);
        ArrayList<Number> arrayList = new ArrayList<Number>();
        arrayList.add(n2);
        arrayList.add(s2);
        arrayList.add(d2);
        Rete rete = new Rete();
        rete.addAll(arrayList);
        ReteTest.assertTrue((boolean)rete.containsObject(n2));
        ReteTest.assertTrue((boolean)rete.containsObject(s2));
        ReteTest.assertTrue((boolean)rete.containsObject(d2));
    }

    public void testResetToMark() throws Exception {
        Integer n2 = new Integer(1);
        Short s2 = new Short(2);
        Double d2 = new Double(3.0);
        Rete rete = new Rete();
        rete.add(n2);
        rete.add(s2);
        WorkingMemoryMarker workingMemoryMarker = rete.mark();
        rete.add(d2);
        rete.add("Hello");
        ReteTest.assertTrue((boolean)rete.containsObject(n2));
        ReteTest.assertTrue((boolean)rete.containsObject(s2));
        ReteTest.assertTrue((boolean)rete.containsObject(d2));
        ReteTest.assertTrue((boolean)rete.containsObject("Hello"));
        rete.resetToMark(workingMemoryMarker);
        ReteTest.assertTrue((boolean)rete.containsObject(n2));
        ReteTest.assertTrue((boolean)rete.containsObject(s2));
        ReteTest.assertFalse((boolean)rete.containsObject(d2));
        ReteTest.assertFalse((boolean)rete.containsObject("Hello"));
        rete.clear();
        workingMemoryMarker = rete.mark();
        rete.resetToMark(workingMemoryMarker);
    }

    public void testResolveTemplateNameInFocusModule() throws Exception {
        Rete rete = new Rete();
        ReteTest.assertEquals((String)"FOO::foo", (String)rete.resolveTemplateNameInFocusModule("FOO::foo"));
        ReteTest.assertEquals((String)"foo", (String)rete.resolveTemplateNameInFocusModule("foo"));
        rete.eval("(defmodule BAR)");
        rete.eval("(deftemplate foo)");
        rete.setCurrentModule("MAIN");
        rete.reset();
        rete.setFocus("BAR");
        ReteTest.assertEquals((String)"MAIN", (String)rete.getCurrentModule());
        ReteTest.assertEquals((String)"BAR", (String)rete.getFocus());
        ReteTest.assertEquals((String)"BAR::foo", (String)rete.resolveTemplateNameInFocusModule("foo"));
    }

    public void testPpFacts() throws Exception {
        Rete rete = new Rete();
        rete.eval("(deftemplate foo (slot bar))");
        rete.reset();
        rete.assertString("(foo (bar 1))");
        rete.assertString("(foo (bar 2))");
        StringWriter stringWriter = new StringWriter();
        rete.ppFacts("foo", stringWriter, true);
        String string = stringWriter.toString();
        ReteTest.assertTrue((boolean)string.startsWith("<"));
        Rete rete2 = new Rete();
        rete2.eval("(deftemplate foo (slot bar))");
        JessSAXParser jessSAXParser = new JessSAXParser(rete2, "fact-list");
        jessSAXParser.parse(new InputSource(new StringReader(string)));
        ReteTest.assertNull((Object)rete2.assertString("(foo (bar 1))"));
        ReteTest.assertNull((Object)rete2.assertString("(foo (bar 2))"));
        ReteTest.assertNotNull((Object)rete2.assertString("(foo (bar 3))"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

