/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import jess.ClassResearcher;
import jess.ClassTemplateMaker;
import jess.JessException;
import jess.ReflectFunctions;
import jess.Rete;

public class ReflectionClassResearcher
implements ClassResearcher {
    private Rete m_engine;

    public ReflectionClassResearcher(Rete rete) {
        this.m_engine = rete;
    }

    public String resolveClassName(String string) throws ClassNotFoundException {
        Class clazz = this.m_engine.findClass(string);
        return clazz.getName();
    }

    public ClassResearcher.Property[] getBeanProperties(String string) throws ClassNotFoundException, JessException {
        Class clazz = this.m_engine.findClass(string);
        try {
            PropertyDescriptor[] propertyDescriptorArray = ReflectFunctions.getPropertyDescriptors(clazz);
            ArrayList<ClassResearcher.Property> arrayList = new ArrayList<ClassResearcher.Property>();
            for (int i2 = 0; i2 < propertyDescriptorArray.length; ++i2) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i2];
                Method method = propertyDescriptorArray[i2].getReadMethod();
                if (method == null) continue;
                String string2 = propertyDescriptor.getName();
                Class<?> clazz2 = propertyDescriptor.getPropertyType();
                boolean bl = clazz2.isArray();
                if (bl) {
                    clazz2 = clazz2.getComponentType();
                }
                String string3 = ClassTemplateMaker.getSlotType(clazz2);
                arrayList.add(new ClassResearcher.Property(string2, string3, bl));
            }
            return arrayList.toArray(new ClassResearcher.Property[arrayList.size()]);
        }
        catch (IntrospectionException introspectionException) {
            throw new JessException("ReflectionClassResearcher.getBeanProperties", "Introspector threw an exception", introspectionException);
        }
    }

    public ClassResearcher.Property[] getPublicInstanceFields(String string) throws ClassNotFoundException, JessException {
        Class clazz = this.m_engine.findClass(string);
        Field[] fieldArray = clazz.getFields();
        ArrayList<ClassResearcher.Property> arrayList = new ArrayList<ClassResearcher.Property>();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Field field = fieldArray[i2];
            if (Modifier.isStatic(field.getModifiers())) continue;
            String string2 = field.getName();
            Class<?> clazz2 = field.getType();
            boolean bl = clazz2.isArray();
            if (bl) {
                clazz2 = clazz2.getComponentType();
            }
            String string3 = ClassTemplateMaker.getSlotType(clazz2);
            arrayList.add(new ClassResearcher.Property(string2, string3, bl));
        }
        return arrayList.toArray(new ClassResearcher.Property[arrayList.size()]);
    }
}

