/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.PrintThread;
import jess.Userfunction;
import jess.Value;
import jess.ValueVector;

class Printout
implements Userfunction,
Serializable {
    private boolean m_multithreadedIO = false;
    private static String NEWLINE = System.getProperty("line.separator");

    Printout() {
    }

    public String getName() {
        return "printout";
    }

    public Value call(ValueVector valueVector, Context context) throws JessException {
        String string = valueVector.get(1).stringValue(context);
        Writer writer = context.getEngine().getOutputRouter(string);
        if (writer == null) {
            throw new JessException("printout", "printout: bad router", string);
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        block11: for (int i2 = 2; i2 < valueVector.size(); ++i2) {
            Value value = valueVector.get(i2).resolveValue(context);
            switch (value.type()) {
                case 1: {
                    if (value.equals("crlf")) {
                        stringBuffer.append(NEWLINE);
                        continue block11;
                    }
                }
                case 2: {
                    stringBuffer.append(value.stringValue(context));
                    continue block11;
                }
                case 4: {
                    stringBuffer.append(value.intValue(context));
                    continue block11;
                }
                case 32: {
                    stringBuffer.append(value.numericValue(context));
                    continue block11;
                }
                case 16: {
                    stringBuffer.append(value);
                    continue block11;
                }
                case 512: {
                    stringBuffer.append(value.listValue(context).toStringWithParens());
                    continue block11;
                }
                case 2048: {
                    stringBuffer.append(value.toString());
                    continue block11;
                }
                default: {
                    stringBuffer.append(value.toString());
                }
            }
        }
        try {
            writer.write(stringBuffer.toString());
            if (this.m_multithreadedIO) {
                PrintThread.getPrintThread().assignWork(writer);
            } else {
                writer.flush();
            }
        }
        catch (IOException iOException) {
            throw new JessException("printout", "I/O Exception", iOException);
        }
        return Funcall.NIL;
    }

    boolean isMultithreadedIO() {
        return this.m_multithreadedIO;
    }

    void setMultithreadedIO(boolean bl) {
        this.m_multithreadedIO = bl;
    }
}

