/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

class PrintfFormat {
    private List vFmt = new ArrayList();
    private int cPos = 0;
    private DecimalFormatSymbols dfs = null;

    public PrintfFormat(String string) throws IllegalArgumentException {
        this(Locale.getDefault(), string);
    }

    public PrintfFormat(Locale locale, String string) throws IllegalArgumentException {
        ConversionSpecification conversionSpecification;
        this.dfs = new DecimalFormatSymbols(locale);
        String string2 = this.nonControl(string, 0);
        if (string2 != null) {
            conversionSpecification = new ConversionSpecification();
            conversionSpecification.setLiteral(string2);
            this.vFmt.add(conversionSpecification);
        }
        while (this.cPos != -1 && this.cPos < string.length()) {
            char c2;
            int n2;
            for (n2 = this.cPos + 1; n2 < string.length() && (c2 = string.charAt(n2)) != 'i' && c2 != 'd' && c2 != 'f' && c2 != 'g' && c2 != 'G' && c2 != 'o' && c2 != 'x' && c2 != 'X' && c2 != 'e' && c2 != 'E' && c2 != 'c' && c2 != 's' && c2 != 'n' && c2 != '%'; ++n2) {
            }
            n2 = Math.min(n2 + 1, string.length());
            conversionSpecification = new ConversionSpecification(string.substring(this.cPos, n2));
            this.vFmt.add(conversionSpecification);
            string2 = this.nonControl(string, n2);
            if (string2 == null) continue;
            conversionSpecification = new ConversionSpecification();
            conversionSpecification.setLiteral(string2);
            this.vFmt.add(conversionSpecification);
        }
    }

    private String nonControl(String string, int n2) {
        this.cPos = string.indexOf("%", n2);
        if (this.cPos == -1) {
            this.cPos = string.length();
        }
        return string.substring(n2, this.cPos);
    }

    public String sprintf(Object[] objectArray) {
        Iterator iterator = this.vFmt.iterator();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ConversionSpecification conversionSpecification = (ConversionSpecification)iterator.next();
            char c2 = conversionSpecification.getConversionCharacter();
            if (c2 == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("%");
                continue;
            }
            if (c2 == 'n') {
                stringBuffer.append("\n");
                continue;
            }
            if (conversionSpecification.isPositionalSpecification()) {
                int n3;
                n2 = conversionSpecification.getArgumentPosition() - 1;
                if (conversionSpecification.isPositionalFieldWidth()) {
                    n3 = conversionSpecification.getArgumentPositionForFieldWidth() - 1;
                    conversionSpecification.setFieldWidthWithArg((Integer)objectArray[n3]);
                }
                if (conversionSpecification.isPositionalPrecision()) {
                    n3 = conversionSpecification.getArgumentPositionForPrecision() - 1;
                    conversionSpecification.setPrecisionWithArg((Integer)objectArray[n3]);
                }
            } else {
                if (conversionSpecification.isVariableFieldWidth()) {
                    conversionSpecification.setFieldWidthWithArg((Integer)objectArray[n2]);
                    ++n2;
                }
                if (conversionSpecification.isVariablePrecision()) {
                    conversionSpecification.setPrecisionWithArg((Integer)objectArray[n2]);
                    ++n2;
                }
            }
            if (objectArray[n2] instanceof Byte) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Byte)objectArray[n2]).byteValue()));
            } else if (objectArray[n2] instanceof Short) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Short)objectArray[n2]).shortValue()));
            } else if (objectArray[n2] instanceof Integer) {
                stringBuffer.append(conversionSpecification.internalsprintf((Integer)objectArray[n2]));
            } else if (objectArray[n2] instanceof Long) {
                stringBuffer.append(conversionSpecification.internalsprintf((Long)objectArray[n2]));
            } else if (objectArray[n2] instanceof Float) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Float)objectArray[n2]).floatValue()));
            } else if (objectArray[n2] instanceof Double) {
                stringBuffer.append(conversionSpecification.internalsprintf((Double)objectArray[n2]));
            } else if (objectArray[n2] instanceof Character) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Character)objectArray[n2]).charValue()));
            } else if (objectArray[n2] instanceof String) {
                stringBuffer.append(conversionSpecification.internalsprintf((String)objectArray[n2]));
            } else {
                stringBuffer.append(conversionSpecification.internalsprintf(objectArray[n2]));
            }
            if (conversionSpecification.isPositionalSpecification()) continue;
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String sprintf() {
        Iterator iterator = this.vFmt.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ConversionSpecification conversionSpecification = (ConversionSpecification)iterator.next();
            char c2 = conversionSpecification.getConversionCharacter();
            if (c2 == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c2 != '%') continue;
            stringBuffer.append("%");
        }
        return stringBuffer.toString();
    }

    public String sprintf(int n2) throws IllegalArgumentException {
        Iterator iterator = this.vFmt.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ConversionSpecification conversionSpecification = (ConversionSpecification)iterator.next();
            char c2 = conversionSpecification.getConversionCharacter();
            if (c2 == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(n2));
        }
        return stringBuffer.toString();
    }

    public String sprintf(long l2) throws IllegalArgumentException {
        Iterator iterator = this.vFmt.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ConversionSpecification conversionSpecification = (ConversionSpecification)iterator.next();
            char c2 = conversionSpecification.getConversionCharacter();
            if (c2 == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(l2));
        }
        return stringBuffer.toString();
    }

    public String sprintf(double d2) throws IllegalArgumentException {
        Iterator iterator = this.vFmt.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ConversionSpecification conversionSpecification = (ConversionSpecification)iterator.next();
            char c2 = conversionSpecification.getConversionCharacter();
            if (c2 == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(d2));
        }
        return stringBuffer.toString();
    }

    public String sprintf(String string) throws IllegalArgumentException {
        Iterator iterator = this.vFmt.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ConversionSpecification conversionSpecification = (ConversionSpecification)iterator.next();
            char c2 = conversionSpecification.getConversionCharacter();
            if (c2 == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("%");
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(string));
        }
        return stringBuffer.toString();
    }

    public String sprintf(Object object) throws IllegalArgumentException {
        Iterator iterator = this.vFmt.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            ConversionSpecification conversionSpecification = (ConversionSpecification)iterator.next();
            char c2 = conversionSpecification.getConversionCharacter();
            if (c2 == '\u0000') {
                stringBuffer.append(conversionSpecification.getLiteral());
                continue;
            }
            if (c2 == '%') {
                stringBuffer.append("%");
                continue;
            }
            if (object instanceof Byte) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Byte)object).byteValue()));
                continue;
            }
            if (object instanceof Short) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Short)object).shortValue()));
                continue;
            }
            if (object instanceof Integer) {
                stringBuffer.append(conversionSpecification.internalsprintf((Integer)object));
                continue;
            }
            if (object instanceof Long) {
                stringBuffer.append(conversionSpecification.internalsprintf((Long)object));
                continue;
            }
            if (object instanceof Float) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Float)object).floatValue()));
                continue;
            }
            if (object instanceof Double) {
                stringBuffer.append(conversionSpecification.internalsprintf((Double)object));
                continue;
            }
            if (object instanceof Character) {
                stringBuffer.append(conversionSpecification.internalsprintf(((Character)object).charValue()));
                continue;
            }
            if (object instanceof String) {
                stringBuffer.append(conversionSpecification.internalsprintf((String)object));
                continue;
            }
            stringBuffer.append(conversionSpecification.internalsprintf(object));
        }
        return stringBuffer.toString();
    }

    private class ConversionSpecification {
        private boolean thousands = false;
        private boolean leftJustify = false;
        private boolean leadingSign = false;
        private boolean leadingSpace = false;
        private boolean alternateForm = false;
        private boolean leadingZeros = false;
        private boolean variableFieldWidth = false;
        private int fieldWidth = 0;
        private boolean fieldWidthSet = false;
        private int precision = 0;
        private static final int defaultDigits = 6;
        private boolean variablePrecision = false;
        private boolean precisionSet = false;
        private boolean positionalSpecification = false;
        private int argumentPosition = 0;
        private boolean positionalFieldWidth = false;
        private int argumentPositionForFieldWidth = 0;
        private boolean positionalPrecision = false;
        private int argumentPositionForPrecision = 0;
        private boolean optionalh = false;
        private boolean optionall = false;
        private boolean optionalL = false;
        private char conversionCharacter = '\u0000';
        private int pos = 0;
        private String fmt;

        ConversionSpecification() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        ConversionSpecification(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new NullPointerException();
            }
            if (string.length() == 0) {
                throw new IllegalArgumentException("Control strings must have positive lengths.");
            }
            if (string.charAt(0) != '%') throw new IllegalArgumentException("Control strings must begin with %.");
            this.fmt = string;
            this.pos = 1;
            this.setArgPosition();
            this.setFlagCharacters();
            this.setFieldWidth();
            this.setPrecision();
            this.setOptionalHL();
            if (!this.setConversionCharacter()) throw new IllegalArgumentException("Malformed conversion specification=" + string);
            if (this.pos != string.length()) throw new IllegalArgumentException("Malformed conversion specification=" + string);
            if (this.leadingZeros && this.leftJustify) {
                this.leadingZeros = false;
            }
            if (!this.precisionSet || !this.leadingZeros || this.conversionCharacter != 'd' && this.conversionCharacter != 'i' && this.conversionCharacter != 'o' && this.conversionCharacter != 'x') return;
            this.leadingZeros = false;
        }

        void setLiteral(String string) {
            this.fmt = string;
        }

        String getLiteral() {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.fmt.length()) {
                if (this.fmt.charAt(n2) == '\\') {
                    if (++n2 < this.fmt.length()) {
                        char c2 = this.fmt.charAt(n2);
                        switch (c2) {
                            case 'a': {
                                stringBuffer.append('\u0007');
                                break;
                            }
                            case 'b': {
                                stringBuffer.append('\b');
                                break;
                            }
                            case 'f': {
                                stringBuffer.append('\f');
                                break;
                            }
                            case 'n': {
                                stringBuffer.append(System.getProperty("line.separator"));
                                break;
                            }
                            case 'r': {
                                stringBuffer.append('\r');
                                break;
                            }
                            case 't': {
                                stringBuffer.append('\t');
                                break;
                            }
                            case 'v': {
                                stringBuffer.append('\u000b');
                                break;
                            }
                            case '\\': {
                                stringBuffer.append('\\');
                            }
                        }
                        ++n2;
                        continue;
                    }
                    stringBuffer.append('\\');
                    continue;
                }
                ++n2;
            }
            return this.fmt;
        }

        char getConversionCharacter() {
            return this.conversionCharacter;
        }

        boolean isVariableFieldWidth() {
            return this.variableFieldWidth;
        }

        void setFieldWidthWithArg(int n2) {
            if (n2 < 0) {
                this.leftJustify = true;
            }
            this.fieldWidthSet = true;
            this.fieldWidth = Math.abs(n2);
        }

        boolean isVariablePrecision() {
            return this.variablePrecision;
        }

        void setPrecisionWithArg(int n2) {
            this.precisionSet = true;
            this.precision = Math.max(n2, 0);
        }

        String internalsprintf(int n2) throws IllegalArgumentException {
            String string;
            switch (this.conversionCharacter) {
                case 'd': 
                case 'i': {
                    if (this.optionalh) {
                        string = this.printDFormat((short)n2);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printDFormat((long)n2);
                        break;
                    }
                    string = this.printDFormat(n2);
                    break;
                }
                case 'X': 
                case 'x': {
                    if (this.optionalh) {
                        string = this.printXFormat((short)n2);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printXFormat((long)n2);
                        break;
                    }
                    string = this.printXFormat(n2);
                    break;
                }
                case 'o': {
                    if (this.optionalh) {
                        string = this.printOFormat((short)n2);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printOFormat((long)n2);
                        break;
                    }
                    string = this.printOFormat(n2);
                    break;
                }
                case 'C': 
                case 'c': {
                    string = this.printCFormat((char)n2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a int with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return string;
        }

        String internalsprintf(long l2) throws IllegalArgumentException {
            String string;
            switch (this.conversionCharacter) {
                case 'd': 
                case 'i': {
                    if (this.optionalh) {
                        string = this.printDFormat((short)l2);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printDFormat(l2);
                        break;
                    }
                    string = this.printDFormat((int)l2);
                    break;
                }
                case 'X': 
                case 'x': {
                    if (this.optionalh) {
                        string = this.printXFormat((short)l2);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printXFormat(l2);
                        break;
                    }
                    string = this.printXFormat((int)l2);
                    break;
                }
                case 'o': {
                    if (this.optionalh) {
                        string = this.printOFormat((short)l2);
                        break;
                    }
                    if (this.optionall) {
                        string = this.printOFormat(l2);
                        break;
                    }
                    string = this.printOFormat((int)l2);
                    break;
                }
                case 'C': 
                case 'c': {
                    string = this.printCFormat((char)l2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a long with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return string;
        }

        String internalsprintf(double d2) throws IllegalArgumentException {
            String string;
            switch (this.conversionCharacter) {
                case 'f': {
                    string = this.printFFormat(d2);
                    break;
                }
                case 'E': 
                case 'e': {
                    string = this.printEFormat(d2);
                    break;
                }
                case 'G': 
                case 'g': {
                    string = this.printGFormat(d2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot format a double with a format using a " + this.conversionCharacter + " conversion character.");
                }
            }
            return string;
        }

        String internalsprintf(String string) throws IllegalArgumentException {
            if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
                throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
            }
            String string2 = this.printSFormat(string);
            return string2;
        }

        String internalsprintf(Object object) {
            if (this.conversionCharacter != 's' && this.conversionCharacter != 'S') {
                throw new IllegalArgumentException("Cannot format a String with a format using a " + this.conversionCharacter + " conversion character.");
            }
            String string = this.printSFormat(object.toString());
            return string;
        }

        private char[] fFormatDigits(double d2) {
            char[] cArray;
            int n2;
            int n3;
            int n4;
            char[] cArray2;
            char[] cArray3;
            int n5;
            int n6;
            int n7;
            String string;
            int n8 = 0;
            boolean bl = false;
            if (d2 > 0.0) {
                string = Double.toString(d2);
            } else if (d2 < 0.0) {
                string = Double.toString(-d2);
                bl = true;
            } else {
                string = Double.toString(d2);
                if (string.charAt(0) == '-') {
                    bl = true;
                    string = string.substring(1);
                }
            }
            int n9 = string.indexOf(69);
            int n10 = string.indexOf(46);
            int n11 = n10 != -1 ? n10 : (n9 != -1 ? n9 : string.length());
            int n12 = n10 != -1 ? (n9 != -1 ? n9 - n10 - 1 : string.length() - n10 - 1) : 0;
            if (n9 != -1) {
                n7 = n9 + 1;
                n8 = 0;
                if (string.charAt(n7) == '-') {
                    ++n7;
                    while (n7 < string.length() && string.charAt(n7) == '0') {
                        ++n7;
                    }
                    if (n7 < string.length()) {
                        n8 = -Integer.parseInt(string.substring(n7));
                    }
                } else {
                    if (string.charAt(n7) == '+') {
                        ++n7;
                    }
                    while (n7 < string.length() && string.charAt(n7) == '0') {
                        ++n7;
                    }
                    if (n7 < string.length()) {
                        n8 = Integer.parseInt(string.substring(n7));
                    }
                }
            }
            n7 = this.precisionSet ? this.precision : 5;
            char[] cArray4 = string.toCharArray();
            char[] cArray5 = new char[n11 + n12];
            for (n6 = 0; n6 < n11; ++n6) {
                cArray5[n6] = cArray4[n6];
            }
            int n13 = n6 + 1;
            for (n5 = 0; n5 < n12; ++n5) {
                cArray5[n6] = cArray4[n13];
                ++n6;
                ++n13;
            }
            if (n11 + n8 <= 0) {
                cArray3 = new char[-n8 + n12];
                n6 = 0;
                n5 = 0;
                while (n5 < -n11 - n8) {
                    cArray3[n6] = 48;
                    ++n5;
                    ++n6;
                }
                n13 = 0;
                while (n13 < n11 + n12) {
                    cArray3[n6] = cArray5[n13];
                    ++n13;
                    ++n6;
                }
            } else {
                cArray3 = cArray5;
            }
            boolean bl2 = false;
            if (n7 < -n8 + n12 && (bl2 = this.checkForCarry(cArray3, n13 = n8 < 0 ? n7 : n7 + n11))) {
                bl2 = this.startSymbolicCarry(cArray3, n13 - 1, 0);
            }
            if (n11 + n8 <= 0) {
                cArray2 = new char[2 + n7];
                cArray2[0] = !bl2 ? 48 : 49;
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    cArray2[1] = 46;
                    n13 = 0;
                    n6 = 2;
                    while (n13 < Math.min(n7, cArray3.length)) {
                        cArray2[n6] = cArray3[n13];
                        ++n13;
                        ++n6;
                    }
                    while (n6 < cArray2.length) {
                        cArray2[n6] = 48;
                        ++n6;
                    }
                }
            } else {
                if (!bl2) {
                    cArray2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n11 + n8 + n7 + 1] : new char[n11 + n8];
                    n6 = 0;
                } else {
                    cArray2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[n11 + n8 + n7 + 2] : new char[n11 + n8 + 1];
                    cArray2[0] = 49;
                    n6 = 1;
                }
                n13 = 0;
                while (n13 < Math.min(n11 + n8, cArray3.length)) {
                    cArray2[n6] = cArray3[n13];
                    ++n13;
                    ++n6;
                }
                while (n13 < n11 + n8) {
                    cArray2[n6] = 48;
                    ++n13;
                    ++n6;
                }
                if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                    cArray2[n6] = 46;
                    ++n6;
                    for (n5 = 0; n13 < cArray3.length && n5 < n7; ++n5) {
                        cArray2[n6] = cArray3[n13];
                        ++n13;
                        ++n6;
                    }
                    while (n6 < cArray2.length) {
                        cArray2[n6] = 48;
                        ++n6;
                    }
                }
            }
            int n14 = 0;
            if (!this.leftJustify && this.leadingZeros) {
                n4 = 0;
                if (this.thousands) {
                    n3 = 0;
                    if (cArray2[0] == '+' || cArray2[0] == '-' || cArray2[0] == ' ') {
                        n3 = 1;
                    }
                    for (n2 = n3; n2 < cArray2.length && cArray2[n2] != '.'; ++n2) {
                    }
                    n4 = (n2 - n3) / 3;
                }
                if (this.fieldWidthSet) {
                    n14 = this.fieldWidth - cArray2.length;
                }
                if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                    --n14;
                }
                if ((n14 -= n4) < 0) {
                    n14 = 0;
                }
            }
            n6 = 0;
            if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                cArray = new char[cArray2.length + n14 + 1];
                ++n6;
            } else {
                cArray = new char[cArray2.length + n14];
            }
            if (!bl) {
                if (this.leadingSign) {
                    cArray[0] = 43;
                }
                if (this.leadingSpace) {
                    cArray[0] = 32;
                }
            } else {
                cArray[0] = 45;
            }
            n13 = 0;
            while (n13 < n14) {
                cArray[n6] = 48;
                ++n13;
                ++n6;
            }
            n13 = 0;
            while (n13 < cArray2.length) {
                cArray[n6] = cArray2[n13];
                ++n13;
                ++n6;
            }
            n4 = 0;
            if (cArray[0] == '+' || cArray[0] == '-' || cArray[0] == ' ') {
                n4 = 1;
            }
            for (n3 = n4; n3 < cArray.length && cArray[n3] != '.'; ++n3) {
            }
            n2 = (n3 - n4) / 3;
            if (n3 < cArray.length) {
                cArray[n3] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] cArray6 = cArray;
            if (this.thousands && n2 > 0) {
                cArray6 = new char[cArray.length + n2 + n4];
                cArray6[0] = cArray[0];
                n5 = n4;
                for (n13 = n4; n13 < n3; ++n13) {
                    if (n13 > 0 && (n3 - n13) % 3 == 0) {
                        cArray6[n5] = PrintfFormat.this.dfs.getGroupingSeparator();
                        cArray6[n5 + 1] = cArray[n13];
                        n5 += 2;
                        continue;
                    }
                    cArray6[n5] = cArray[n13];
                    ++n5;
                }
                while (n13 < cArray.length) {
                    cArray6[n5] = cArray[n13];
                    ++n13;
                    ++n5;
                }
            }
            return cArray6;
        }

        private String fFormatString(double d2) {
            char[] cArray = Double.isInfinite(d2) ? (d2 == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray()) : (Double.isNaN(d2) ? (this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray())) : this.fFormatDigits(d2));
            char[] cArray2 = this.applyFloatPadding(cArray, false);
            return new String(cArray2);
        }

        private char[] eFormatDigits(double d2, char c2) {
            char[] cArray;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            char[] cArray2;
            int n8;
            int n9;
            int n10;
            String string;
            int n11 = 0;
            boolean bl = false;
            if (d2 > 0.0) {
                string = Double.toString(d2);
            } else if (d2 < 0.0) {
                string = Double.toString(-d2);
                bl = true;
            } else {
                string = Double.toString(d2);
                if (string.charAt(0) == '-') {
                    bl = true;
                    string = string.substring(1);
                }
            }
            int n12 = string.indexOf(69);
            if (n12 == -1) {
                n12 = string.indexOf(101);
            }
            int n13 = (n10 = string.indexOf(46)) != -1 ? n10 : (n12 != -1 ? n12 : string.length());
            int n14 = n10 != -1 ? (n12 != -1 ? n12 - n10 - 1 : string.length() - n10 - 1) : 0;
            if (n12 != -1) {
                n9 = n12 + 1;
                n11 = 0;
                if (string.charAt(n9) == '-') {
                    ++n9;
                    while (n9 < string.length() && string.charAt(n9) == '0') {
                        ++n9;
                    }
                    if (n9 < string.length()) {
                        n11 = -Integer.parseInt(string.substring(n9));
                    }
                } else {
                    if (string.charAt(n9) == '+') {
                        ++n9;
                    }
                    while (n9 < string.length() && string.charAt(n9) == '0') {
                        ++n9;
                    }
                    if (n9 < string.length()) {
                        n11 = Integer.parseInt(string.substring(n9));
                    }
                }
            }
            if (n10 != -1) {
                n11 += n10 - 1;
            }
            int n15 = this.precisionSet ? this.precision : 5;
            char[] cArray3 = n10 != -1 && n12 != -1 ? (string.substring(0, n10) + string.substring(n10 + 1, n12)).toCharArray() : (n10 != -1 ? (string.substring(0, n10) + string.substring(n10 + 1)).toCharArray() : (n12 != -1 ? string.substring(0, n12).toCharArray() : string.toCharArray()));
            if (cArray3[0] != '0') {
                n8 = 0;
            } else {
                for (n8 = 0; n8 < cArray3.length && cArray3[n8] == '0'; ++n8) {
                }
            }
            if (n8 + n15 < cArray3.length - 1) {
                n9 = this.checkForCarry(cArray3, n8 + n15 + 1) ? 1 : 0;
                if (n9 != 0) {
                    n9 = this.startSymbolicCarry(cArray3, n8 + n15, n8) ? 1 : 0;
                }
                if (n9 != 0) {
                    cArray2 = new char[n8 + n15 + 1];
                    cArray2[n8] = 49;
                    for (n7 = 0; n7 < n8; ++n7) {
                        cArray2[n7] = 48;
                    }
                    n6 = n8;
                    for (n7 = n8 + 1; n7 < n15 + 1; ++n7) {
                        cArray2[n7] = cArray3[n6];
                        ++n6;
                    }
                    ++n11;
                    cArray3 = cArray2;
                }
            }
            int n16 = Math.abs(n11) < 100 && !this.optionalL ? 4 : 5;
            cArray2 = this.alternateForm || !this.precisionSet || this.precision != 0 ? new char[2 + n15 + n16] : new char[1 + n16];
            if (cArray3[0] != '0') {
                cArray2[0] = cArray3[0];
                n7 = 1;
            } else {
                for (n7 = 1; n7 < (n12 == -1 ? cArray3.length : n12) && cArray3[n7] == '0'; ++n7) {
                }
                if (n12 != -1 && n7 < n12 || n12 == -1 && n7 < cArray3.length) {
                    cArray2[0] = cArray3[n7];
                    n11 -= n7;
                    ++n7;
                } else {
                    cArray2[0] = 48;
                    n7 = 2;
                }
            }
            if (this.alternateForm || !this.precisionSet || this.precision != 0) {
                cArray2[1] = 46;
                n6 = 2;
            } else {
                n6 = 1;
            }
            for (n5 = 0; n5 < n15 && n7 < cArray3.length; ++n5) {
                cArray2[n6] = cArray3[n7];
                ++n7;
                ++n6;
            }
            while (n6 < cArray2.length - n16) {
                cArray2[n6] = 48;
                ++n6;
            }
            cArray2[n6++] = c2;
            cArray2[n6++] = n11 < 0 ? 45 : 43;
            if ((n11 = Math.abs(n11)) >= 100) {
                switch (n11 / 100) {
                    case 1: {
                        cArray2[n6] = 49;
                        break;
                    }
                    case 2: {
                        cArray2[n6] = 50;
                        break;
                    }
                    case 3: {
                        cArray2[n6] = 51;
                        break;
                    }
                    case 4: {
                        cArray2[n6] = 52;
                        break;
                    }
                    case 5: {
                        cArray2[n6] = 53;
                        break;
                    }
                    case 6: {
                        cArray2[n6] = 54;
                        break;
                    }
                    case 7: {
                        cArray2[n6] = 55;
                        break;
                    }
                    case 8: {
                        cArray2[n6] = 56;
                        break;
                    }
                    case 9: {
                        cArray2[n6] = 57;
                    }
                }
                ++n6;
            }
            switch (n11 % 100 / 10) {
                case 0: {
                    cArray2[n6] = 48;
                    break;
                }
                case 1: {
                    cArray2[n6] = 49;
                    break;
                }
                case 2: {
                    cArray2[n6] = 50;
                    break;
                }
                case 3: {
                    cArray2[n6] = 51;
                    break;
                }
                case 4: {
                    cArray2[n6] = 52;
                    break;
                }
                case 5: {
                    cArray2[n6] = 53;
                    break;
                }
                case 6: {
                    cArray2[n6] = 54;
                    break;
                }
                case 7: {
                    cArray2[n6] = 55;
                    break;
                }
                case 8: {
                    cArray2[n6] = 56;
                    break;
                }
                case 9: {
                    cArray2[n6] = 57;
                }
            }
            ++n6;
            switch (n11 % 10) {
                case 0: {
                    cArray2[n6] = 48;
                    break;
                }
                case 1: {
                    cArray2[n6] = 49;
                    break;
                }
                case 2: {
                    cArray2[n6] = 50;
                    break;
                }
                case 3: {
                    cArray2[n6] = 51;
                    break;
                }
                case 4: {
                    cArray2[n6] = 52;
                    break;
                }
                case 5: {
                    cArray2[n6] = 53;
                    break;
                }
                case 6: {
                    cArray2[n6] = 54;
                    break;
                }
                case 7: {
                    cArray2[n6] = 55;
                    break;
                }
                case 8: {
                    cArray2[n6] = 56;
                    break;
                }
                case 9: {
                    cArray2[n6] = 57;
                }
            }
            int n17 = 0;
            if (!this.leftJustify && this.leadingZeros) {
                n4 = 0;
                if (this.thousands) {
                    n3 = 0;
                    if (cArray2[0] == '+' || cArray2[0] == '-' || cArray2[0] == ' ') {
                        n3 = 1;
                    }
                    for (n2 = n3; n2 < cArray2.length && cArray2[n2] != '.'; ++n2) {
                    }
                    n4 = (n2 - n3) / 3;
                }
                if (this.fieldWidthSet) {
                    n17 = this.fieldWidth - cArray2.length;
                }
                if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                    --n17;
                }
                if ((n17 -= n4) < 0) {
                    n17 = 0;
                }
            }
            n7 = 0;
            if (!bl && (this.leadingSign || this.leadingSpace) || bl) {
                cArray = new char[cArray2.length + n17 + 1];
                ++n7;
            } else {
                cArray = new char[cArray2.length + n17];
            }
            if (!bl) {
                if (this.leadingSign) {
                    cArray[0] = 43;
                }
                if (this.leadingSpace) {
                    cArray[0] = 32;
                }
            } else {
                cArray[0] = 45;
            }
            for (n5 = 0; n5 < n17; ++n5) {
                cArray[n7] = 48;
                ++n7;
            }
            for (n6 = 0; n6 < cArray2.length && n7 < cArray.length; ++n6, ++n7) {
                cArray[n7] = cArray2[n6];
            }
            n4 = 0;
            if (cArray[0] == '+' || cArray[0] == '-' || cArray[0] == ' ') {
                n4 = 1;
            }
            for (n3 = n4; n3 < cArray.length && cArray[n3] != '.'; ++n3) {
            }
            n2 = n3 / 3;
            if (n3 < cArray.length) {
                cArray[n3] = PrintfFormat.this.dfs.getDecimalSeparator();
            }
            char[] cArray4 = cArray;
            if (this.thousands && n2 > 0) {
                cArray4 = new char[cArray.length + n2 + n4];
                cArray4[0] = cArray[0];
                n5 = n4;
                for (n6 = n4; n6 < n3; ++n6) {
                    if (n6 > 0 && (n3 - n6) % 3 == 0) {
                        cArray4[n5] = PrintfFormat.this.dfs.getGroupingSeparator();
                        cArray4[n5 + 1] = cArray[n6];
                        n5 += 2;
                        continue;
                    }
                    cArray4[n5] = cArray[n6];
                    ++n5;
                }
                while (n6 < cArray.length) {
                    cArray4[n5] = cArray[n6];
                    ++n6;
                    ++n5;
                }
            }
            return cArray4;
        }

        private boolean checkForCarry(char[] cArray, int n2) {
            boolean bl = false;
            if (n2 < cArray.length) {
                if (cArray[n2] == '6' || cArray[n2] == '7' || cArray[n2] == '8' || cArray[n2] == '9') {
                    bl = true;
                } else if (cArray[n2] == '5') {
                    int n3;
                    for (n3 = n2 + 1; n3 < cArray.length && cArray[n3] == '0'; ++n3) {
                    }
                    boolean bl2 = bl = n3 < cArray.length;
                    if (!bl && n2 > 0) {
                        bl = cArray[n2 - 1] == '1' || cArray[n2 - 1] == '3' || cArray[n2 - 1] == '5' || cArray[n2 - 1] == '7' || cArray[n2 - 1] == '9';
                    }
                }
            }
            return bl;
        }

        private boolean startSymbolicCarry(char[] cArray, int n2, int n3) {
            boolean bl = true;
            block12: for (int i2 = n2; bl && i2 >= n3; --i2) {
                bl = false;
                switch (cArray[i2]) {
                    case '0': {
                        cArray[i2] = 49;
                        continue block12;
                    }
                    case '1': {
                        cArray[i2] = 50;
                        continue block12;
                    }
                    case '2': {
                        cArray[i2] = 51;
                        continue block12;
                    }
                    case '3': {
                        cArray[i2] = 52;
                        continue block12;
                    }
                    case '4': {
                        cArray[i2] = 53;
                        continue block12;
                    }
                    case '5': {
                        cArray[i2] = 54;
                        continue block12;
                    }
                    case '6': {
                        cArray[i2] = 55;
                        continue block12;
                    }
                    case '7': {
                        cArray[i2] = 56;
                        continue block12;
                    }
                    case '8': {
                        cArray[i2] = 57;
                        continue block12;
                    }
                    case '9': {
                        cArray[i2] = 48;
                        bl = true;
                    }
                }
            }
            return bl;
        }

        private String eFormatString(double d2, char c2) {
            char[] cArray = Double.isInfinite(d2) ? (d2 == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray()) : (Double.isNaN(d2) ? (this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray())) : this.eFormatDigits(d2, c2));
            char[] cArray2 = this.applyFloatPadding(cArray, false);
            return new String(cArray2);
        }

        private char[] applyFloatPadding(char[] cArray, boolean bl) {
            char[] cArray2;
            block8: {
                block10: {
                    int n2;
                    block9: {
                        int n3;
                        cArray2 = cArray;
                        if (!this.fieldWidthSet) break block8;
                        if (!this.leftJustify) break block9;
                        int n4 = this.fieldWidth - cArray.length;
                        if (n4 <= 0) break block8;
                        cArray2 = new char[cArray.length + n4];
                        for (n3 = 0; n3 < cArray.length; ++n3) {
                            cArray2[n3] = cArray[n3];
                        }
                        int n5 = 0;
                        while (n5 < n4) {
                            cArray2[n3] = 32;
                            ++n5;
                            ++n3;
                        }
                        break block8;
                    }
                    if (this.leadingZeros && !bl) break block10;
                    int n6 = this.fieldWidth - cArray.length;
                    if (n6 <= 0) break block8;
                    cArray2 = new char[cArray.length + n6];
                    for (n2 = 0; n2 < n6; ++n2) {
                        cArray2[n2] = 32;
                    }
                    for (int i2 = 0; i2 < cArray.length; ++i2) {
                        cArray2[n2] = cArray[i2];
                        ++n2;
                    }
                    break block8;
                }
                int n7 = this.fieldWidth - cArray.length;
                if (n7 > 0) {
                    cArray2 = new char[cArray.length + n7];
                    int n8 = 0;
                    int n9 = 0;
                    if (cArray[0] == '-') {
                        cArray2[0] = 45;
                        ++n8;
                        ++n9;
                    }
                    for (int i3 = 0; i3 < n7; ++i3) {
                        cArray2[n8] = 48;
                        ++n8;
                    }
                    while (n9 < cArray.length) {
                        cArray2[n8] = cArray[n9];
                        ++n8;
                        ++n9;
                    }
                }
            }
            return cArray2;
        }

        private String printFFormat(double d2) {
            return this.fFormatString(d2);
        }

        private String printEFormat(double d2) {
            if (this.conversionCharacter == 'e') {
                return this.eFormatString(d2, 'e');
            }
            return this.eFormatString(d2, 'E');
        }

        private String printGFormat(double d2) {
            char[] cArray;
            int n2 = this.precision;
            if (Double.isInfinite(d2)) {
                cArray = d2 == Double.POSITIVE_INFINITY ? (this.leadingSign ? "+Inf".toCharArray() : (this.leadingSpace ? " Inf".toCharArray() : "Inf".toCharArray())) : "-Inf".toCharArray();
            } else if (Double.isNaN(d2)) {
                cArray = this.leadingSign ? "+NaN".toCharArray() : (this.leadingSpace ? " NaN".toCharArray() : "NaN".toCharArray());
            } else {
                String string;
                int n3;
                String string2;
                if (!this.precisionSet) {
                    this.precision = 6;
                }
                if (this.precision == 0) {
                    this.precision = 1;
                }
                if (this.conversionCharacter == 'g') {
                    string2 = this.eFormatString(d2, 'e').trim();
                    n3 = string2.indexOf(101);
                } else {
                    string2 = this.eFormatString(d2, 'E').trim();
                    n3 = string2.indexOf(69);
                }
                int n4 = n3 + 1;
                int n5 = 0;
                if (string2.charAt(n4) == '-') {
                    ++n4;
                    while (n4 < string2.length() && string2.charAt(n4) == '0') {
                        ++n4;
                    }
                    if (n4 < string2.length()) {
                        n5 = -Integer.parseInt(string2.substring(n4));
                    }
                } else {
                    if (string2.charAt(n4) == '+') {
                        ++n4;
                    }
                    while (n4 < string2.length() && string2.charAt(n4) == '0') {
                        ++n4;
                    }
                    if (n4 < string2.length()) {
                        n5 = Integer.parseInt(string2.substring(n4));
                    }
                }
                if (!this.alternateForm) {
                    String string3 = n5 >= -4 && n5 < this.precision ? this.fFormatString(d2).trim() : string2.substring(0, n3);
                    for (n4 = string3.length() - 1; n4 >= 0 && string3.charAt(n4) == '0'; --n4) {
                    }
                    if (n4 >= 0 && string3.charAt(n4) == '.') {
                        --n4;
                    }
                    String string4 = n4 == -1 ? "0" : (!Character.isDigit(string3.charAt(n4)) ? string3.substring(0, n4 + 1) + "0" : string3.substring(0, n4 + 1));
                    string = n5 >= -4 && n5 < this.precision ? string4 : string4 + string2.substring(n3);
                } else {
                    string = n5 >= -4 && n5 < this.precision ? this.fFormatString(d2).trim() : string2;
                }
                if (this.leadingSpace && d2 >= 0.0) {
                    string = " " + string;
                }
                cArray = string.toCharArray();
            }
            char[] cArray2 = this.applyFloatPadding(cArray, false);
            this.precision = n2;
            return new String(cArray2);
        }

        private String printDFormat(short s2) {
            return this.printDFormat(Short.toString(s2));
        }

        private String printDFormat(long l2) {
            return this.printDFormat(Long.toString(l2));
        }

        private String printDFormat(int n2) {
            return this.printDFormat(Integer.toString(n2));
        }

        private String printDFormat(String string) {
            char[] cArray;
            block30: {
                int n2;
                int n3;
                boolean bl;
                int n4;
                int n5;
                block33: {
                    int n6;
                    block31: {
                        block34: {
                            block32: {
                                block29: {
                                    int n7;
                                    n5 = 0;
                                    n6 = 0;
                                    int n8 = 0;
                                    n4 = 0;
                                    boolean bl2 = bl = string.charAt(0) == '-';
                                    if (string.equals("0") && this.precisionSet && this.precision == 0) {
                                        string = "";
                                    }
                                    if (!bl) {
                                        if (this.precisionSet && string.length() < this.precision) {
                                            n5 = this.precision - string.length();
                                        }
                                    } else if (this.precisionSet && string.length() - 1 < this.precision) {
                                        n5 = this.precision - string.length() + 1;
                                    }
                                    if (n5 < 0) {
                                        n5 = 0;
                                    }
                                    if (this.fieldWidthSet) {
                                        n6 = this.fieldWidth - n5 - string.length();
                                        if (!bl && (this.leadingSign || this.leadingSpace)) {
                                            --n6;
                                        }
                                    }
                                    if (n6 < 0) {
                                        n6 = 0;
                                    }
                                    if (this.leadingSign) {
                                        ++n8;
                                    } else if (this.leadingSpace) {
                                        ++n8;
                                    }
                                    n8 += n6;
                                    n8 += n5;
                                    cArray = new char[n8 += string.length()];
                                    if (!this.leftJustify) break block29;
                                    if (bl) {
                                        cArray[n4++] = 45;
                                    } else if (this.leadingSign) {
                                        cArray[n4++] = 43;
                                    } else if (this.leadingSpace) {
                                        cArray[n4++] = 32;
                                    }
                                    char[] cArray2 = string.toCharArray();
                                    int n9 = bl ? 1 : 0;
                                    for (n7 = 0; n7 < n5; ++n7) {
                                        cArray[n4] = 48;
                                        ++n4;
                                    }
                                    n7 = n9;
                                    while (n7 < cArray2.length) {
                                        cArray[n4] = cArray2[n7];
                                        ++n7;
                                        ++n4;
                                    }
                                    for (n7 = 0; n7 < n6; ++n7) {
                                        cArray[n4] = 32;
                                        ++n4;
                                    }
                                    break block30;
                                }
                                if (this.leadingZeros) break block31;
                                for (n4 = 0; n4 < n6; ++n4) {
                                    cArray[n4] = 32;
                                }
                                if (!bl) break block32;
                                cArray[n4++] = 45;
                                break block33;
                            }
                            if (!this.leadingSign) break block34;
                            cArray[n4++] = 43;
                            break block33;
                        }
                        if (!this.leadingSpace) break block33;
                        cArray[n4++] = 32;
                        break block33;
                    }
                    if (bl) {
                        cArray[n4++] = 45;
                    } else if (this.leadingSign) {
                        cArray[n4++] = 43;
                    } else if (this.leadingSpace) {
                        cArray[n4++] = 32;
                    }
                    n3 = 0;
                    while (n3 < n6) {
                        cArray[n4] = 48;
                        ++n3;
                        ++n4;
                    }
                }
                n3 = 0;
                while (n3 < n5) {
                    cArray[n4] = 48;
                    ++n3;
                    ++n4;
                }
                char[] cArray3 = string.toCharArray();
                int n10 = n2 = bl ? 1 : 0;
                while (n10 < cArray3.length) {
                    cArray[n4] = cArray3[n10];
                    ++n10;
                    ++n4;
                }
            }
            return new String(cArray);
        }

        private String printXFormat(short s2) {
            String string = null;
            if (s2 == Short.MIN_VALUE) {
                string = "8000";
            } else if (s2 < 0) {
                String string2;
                if (s2 == Short.MIN_VALUE) {
                    string2 = "0";
                } else {
                    string2 = Integer.toString(~(-s2 - 1) ^ Short.MIN_VALUE, 16);
                    if (string2.charAt(0) == 'F' || string2.charAt(0) == 'f') {
                        string2 = string2.substring(16, 32);
                    }
                }
                block0 : switch (string2.length()) {
                    case 1: {
                        string = "800" + string2;
                        break;
                    }
                    case 2: {
                        string = "80" + string2;
                        break;
                    }
                    case 3: {
                        string = "8" + string2;
                        break;
                    }
                    case 4: {
                        switch (string2.charAt(0)) {
                            case '1': {
                                string = "9" + string2.substring(1, 4);
                                break block0;
                            }
                            case '2': {
                                string = "a" + string2.substring(1, 4);
                                break block0;
                            }
                            case '3': {
                                string = "b" + string2.substring(1, 4);
                                break block0;
                            }
                            case '4': {
                                string = "c" + string2.substring(1, 4);
                                break block0;
                            }
                            case '5': {
                                string = "d" + string2.substring(1, 4);
                                break block0;
                            }
                            case '6': {
                                string = "e" + string2.substring(1, 4);
                                break block0;
                            }
                            case '7': {
                                string = "f" + string2.substring(1, 4);
                            }
                        }
                    }
                }
            } else {
                string = Integer.toString(s2, 16);
            }
            return this.printXFormat(string);
        }

        private String printXFormat(long l2) {
            String string = null;
            if (l2 == Long.MIN_VALUE) {
                string = "8000000000000000";
            } else if (l2 < 0L) {
                String string2 = Long.toString(-l2 - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 16);
                block0 : switch (string2.length()) {
                    case 1: {
                        string = "800000000000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "80000000000000" + string2;
                        break;
                    }
                    case 3: {
                        string = "8000000000000" + string2;
                        break;
                    }
                    case 4: {
                        string = "800000000000" + string2;
                        break;
                    }
                    case 5: {
                        string = "80000000000" + string2;
                        break;
                    }
                    case 6: {
                        string = "8000000000" + string2;
                        break;
                    }
                    case 7: {
                        string = "800000000" + string2;
                        break;
                    }
                    case 8: {
                        string = "80000000" + string2;
                        break;
                    }
                    case 9: {
                        string = "8000000" + string2;
                        break;
                    }
                    case 10: {
                        string = "800000" + string2;
                        break;
                    }
                    case 11: {
                        string = "80000" + string2;
                        break;
                    }
                    case 12: {
                        string = "8000" + string2;
                        break;
                    }
                    case 13: {
                        string = "800" + string2;
                        break;
                    }
                    case 14: {
                        string = "80" + string2;
                        break;
                    }
                    case 15: {
                        string = "8" + string2;
                        break;
                    }
                    case 16: {
                        switch (string2.charAt(0)) {
                            case '1': {
                                string = "9" + string2.substring(1, 16);
                                break block0;
                            }
                            case '2': {
                                string = "a" + string2.substring(1, 16);
                                break block0;
                            }
                            case '3': {
                                string = "b" + string2.substring(1, 16);
                                break block0;
                            }
                            case '4': {
                                string = "c" + string2.substring(1, 16);
                                break block0;
                            }
                            case '5': {
                                string = "d" + string2.substring(1, 16);
                                break block0;
                            }
                            case '6': {
                                string = "e" + string2.substring(1, 16);
                                break block0;
                            }
                            case '7': {
                                string = "f" + string2.substring(1, 16);
                            }
                        }
                    }
                }
            } else {
                string = Long.toString(l2, 16);
            }
            return this.printXFormat(string);
        }

        private String printXFormat(int n2) {
            String string = null;
            if (n2 == Integer.MIN_VALUE) {
                string = "80000000";
            } else if (n2 < 0) {
                String string2 = Integer.toString(~(-n2 - 1) ^ Integer.MIN_VALUE, 16);
                block0 : switch (string2.length()) {
                    case 1: {
                        string = "8000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "800000" + string2;
                        break;
                    }
                    case 3: {
                        string = "80000" + string2;
                        break;
                    }
                    case 4: {
                        string = "8000" + string2;
                        break;
                    }
                    case 5: {
                        string = "800" + string2;
                        break;
                    }
                    case 6: {
                        string = "80" + string2;
                        break;
                    }
                    case 7: {
                        string = "8" + string2;
                        break;
                    }
                    case 8: {
                        switch (string2.charAt(0)) {
                            case '1': {
                                string = "9" + string2.substring(1, 8);
                                break block0;
                            }
                            case '2': {
                                string = "a" + string2.substring(1, 8);
                                break block0;
                            }
                            case '3': {
                                string = "b" + string2.substring(1, 8);
                                break block0;
                            }
                            case '4': {
                                string = "c" + string2.substring(1, 8);
                                break block0;
                            }
                            case '5': {
                                string = "d" + string2.substring(1, 8);
                                break block0;
                            }
                            case '6': {
                                string = "e" + string2.substring(1, 8);
                                break block0;
                            }
                            case '7': {
                                string = "f" + string2.substring(1, 8);
                            }
                        }
                    }
                }
            } else {
                string = Integer.toString(n2, 16);
            }
            return this.printXFormat(string);
        }

        private String printXFormat(String string) {
            Object object;
            int n2 = 0;
            int n3 = 0;
            if (string.equals("0") && this.precisionSet && this.precision == 0) {
                string = "";
            }
            if (this.precisionSet) {
                n2 = this.precision - string.length();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.fieldWidthSet) {
                n3 = this.fieldWidth - n2 - string.length();
                if (this.alternateForm) {
                    n3 -= 2;
                }
            }
            if (n3 < 0) {
                n3 = 0;
            }
            int n4 = 0;
            if (this.alternateForm) {
                n4 += 2;
            }
            n4 += n2;
            n4 += string.length();
            char[] cArray = new char[n4 += n3];
            int n5 = 0;
            if (this.leftJustify) {
                if (this.alternateForm) {
                    cArray[n5++] = 48;
                    cArray[n5++] = 120;
                }
                int n6 = 0;
                while (n6 < n2) {
                    cArray[n5] = 48;
                    ++n6;
                    ++n5;
                }
                object = string.toCharArray();
                int n7 = 0;
                while (n7 < ((char[])object).length) {
                    cArray[n5] = object[n7];
                    ++n7;
                    ++n5;
                }
                n7 = 0;
                while (n7 < n3) {
                    cArray[n5] = 32;
                    ++n7;
                    ++n5;
                }
            } else {
                int n8;
                if (!this.leadingZeros) {
                    n8 = 0;
                    while (n8 < n3) {
                        cArray[n5] = 32;
                        ++n8;
                        ++n5;
                    }
                }
                if (this.alternateForm) {
                    cArray[n5++] = 48;
                    cArray[n5++] = 120;
                }
                if (this.leadingZeros) {
                    n8 = 0;
                    while (n8 < n3) {
                        cArray[n5] = 48;
                        ++n8;
                        ++n5;
                    }
                }
                n8 = 0;
                while (n8 < n2) {
                    cArray[n5] = 48;
                    ++n8;
                    ++n5;
                }
                object = string.toCharArray();
                int n9 = 0;
                while (n9 < ((char[])object).length) {
                    cArray[n5] = object[n9];
                    ++n9;
                    ++n5;
                }
            }
            object = new String(cArray);
            if (this.conversionCharacter == 'X') {
                object = ((String)object).toUpperCase();
            }
            return object;
        }

        private String printOFormat(short s2) {
            String string = null;
            if (s2 == Short.MIN_VALUE) {
                string = "100000";
            } else if (s2 < 0) {
                String string2 = Integer.toString(~(-s2 - 1) ^ Short.MIN_VALUE, 8);
                switch (string2.length()) {
                    case 1: {
                        string = "10000" + string2;
                        break;
                    }
                    case 2: {
                        string = "1000" + string2;
                        break;
                    }
                    case 3: {
                        string = "100" + string2;
                        break;
                    }
                    case 4: {
                        string = "10" + string2;
                        break;
                    }
                    case 5: {
                        string = "1" + string2;
                    }
                }
            } else {
                string = Integer.toString(s2, 8);
            }
            return this.printOFormat(string);
        }

        private String printOFormat(long l2) {
            String string = null;
            if (l2 == Long.MIN_VALUE) {
                string = "1000000000000000000000";
            } else if (l2 < 0L) {
                String string2 = Long.toString(-l2 - 1L ^ 0xFFFFFFFFFFFFFFFFL ^ Long.MIN_VALUE, 8);
                switch (string2.length()) {
                    case 1: {
                        string = "100000000000000000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "10000000000000000000" + string2;
                        break;
                    }
                    case 3: {
                        string = "1000000000000000000" + string2;
                        break;
                    }
                    case 4: {
                        string = "100000000000000000" + string2;
                        break;
                    }
                    case 5: {
                        string = "10000000000000000" + string2;
                        break;
                    }
                    case 6: {
                        string = "1000000000000000" + string2;
                        break;
                    }
                    case 7: {
                        string = "100000000000000" + string2;
                        break;
                    }
                    case 8: {
                        string = "10000000000000" + string2;
                        break;
                    }
                    case 9: {
                        string = "1000000000000" + string2;
                        break;
                    }
                    case 10: {
                        string = "100000000000" + string2;
                        break;
                    }
                    case 11: {
                        string = "10000000000" + string2;
                        break;
                    }
                    case 12: {
                        string = "1000000000" + string2;
                        break;
                    }
                    case 13: {
                        string = "100000000" + string2;
                        break;
                    }
                    case 14: {
                        string = "10000000" + string2;
                        break;
                    }
                    case 15: {
                        string = "1000000" + string2;
                        break;
                    }
                    case 16: {
                        string = "100000" + string2;
                        break;
                    }
                    case 17: {
                        string = "10000" + string2;
                        break;
                    }
                    case 18: {
                        string = "1000" + string2;
                        break;
                    }
                    case 19: {
                        string = "100" + string2;
                        break;
                    }
                    case 20: {
                        string = "10" + string2;
                        break;
                    }
                    case 21: {
                        string = "1" + string2;
                    }
                }
            } else {
                string = Long.toString(l2, 8);
            }
            return this.printOFormat(string);
        }

        private String printOFormat(int n2) {
            String string = null;
            if (n2 == Integer.MIN_VALUE) {
                string = "20000000000";
            } else if (n2 < 0) {
                String string2 = Integer.toString(~(-n2 - 1) ^ Integer.MIN_VALUE, 8);
                switch (string2.length()) {
                    case 1: {
                        string = "2000000000" + string2;
                        break;
                    }
                    case 2: {
                        string = "200000000" + string2;
                        break;
                    }
                    case 3: {
                        string = "20000000" + string2;
                        break;
                    }
                    case 4: {
                        string = "2000000" + string2;
                        break;
                    }
                    case 5: {
                        string = "200000" + string2;
                        break;
                    }
                    case 6: {
                        string = "20000" + string2;
                        break;
                    }
                    case 7: {
                        string = "2000" + string2;
                        break;
                    }
                    case 8: {
                        string = "200" + string2;
                        break;
                    }
                    case 9: {
                        string = "20" + string2;
                        break;
                    }
                    case 10: {
                        string = "2" + string2;
                        break;
                    }
                    case 11: {
                        string = "3" + string2.substring(1);
                    }
                }
            } else {
                string = Integer.toString(n2, 8);
            }
            return this.printOFormat(string);
        }

        private String printOFormat(String string) {
            int n2 = 0;
            int n3 = 0;
            if (string.equals("0") && this.precisionSet && this.precision == 0) {
                string = "";
            }
            if (this.precisionSet) {
                n2 = this.precision - string.length();
            }
            if (this.alternateForm) {
                ++n2;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.fieldWidthSet) {
                n3 = this.fieldWidth - n2 - string.length();
            }
            if (n3 < 0) {
                n3 = 0;
            }
            int n4 = n2 + string.length() + n3;
            char[] cArray = new char[n4];
            if (this.leftJustify) {
                int n5;
                for (n5 = 0; n5 < n2; ++n5) {
                    cArray[n5] = 48;
                }
                char[] cArray2 = string.toCharArray();
                int n6 = 0;
                while (n6 < cArray2.length) {
                    cArray[n5] = cArray2[n6];
                    ++n6;
                    ++n5;
                }
                n6 = 0;
                while (n6 < n3) {
                    cArray[n5] = 32;
                    ++n6;
                    ++n5;
                }
            } else {
                int n7;
                if (this.leadingZeros) {
                    for (n7 = 0; n7 < n3; ++n7) {
                        cArray[n7] = 48;
                    }
                } else {
                    for (n7 = 0; n7 < n3; ++n7) {
                        cArray[n7] = 32;
                    }
                }
                int n8 = 0;
                while (n8 < n2) {
                    cArray[n7] = 48;
                    ++n8;
                    ++n7;
                }
                char[] cArray3 = string.toCharArray();
                int n9 = 0;
                while (n9 < cArray3.length) {
                    cArray[n7] = cArray3[n9];
                    ++n9;
                    ++n7;
                }
            }
            return new String(cArray);
        }

        private String printCFormat(char c2) {
            int n2 = 1;
            int n3 = this.fieldWidth;
            if (!this.fieldWidthSet) {
                n3 = n2;
            }
            char[] cArray = new char[n3];
            if (this.leftJustify) {
                cArray[0] = c2;
                for (int i2 = 1; i2 <= n3 - n2; ++i2) {
                    cArray[i2] = 32;
                }
            } else {
                for (int i3 = 0; i3 < n3 - n2; ++i3) {
                    cArray[i3] = 32;
                }
                cArray[i3] = c2;
            }
            return new String(cArray);
        }

        private String printSFormat(String string) {
            int n2 = string.length();
            int n3 = this.fieldWidth;
            if (this.precisionSet && n2 > this.precision) {
                n2 = this.precision;
            }
            if (!this.fieldWidthSet) {
                n3 = n2;
            }
            int n4 = 0;
            if (n3 > n2) {
                n4 += n3 - n2;
            }
            n4 = n2 >= string.length() ? (n4 += string.length()) : (n4 += n2);
            char[] cArray = new char[n4];
            if (this.leftJustify) {
                int n5;
                char[] cArray2;
                if (n2 >= string.length()) {
                    cArray2 = string.toCharArray();
                    for (n5 = 0; n5 < string.length(); ++n5) {
                        cArray[n5] = cArray2[n5];
                    }
                } else {
                    cArray2 = string.substring(0, n2).toCharArray();
                    for (n5 = 0; n5 < n2; ++n5) {
                        cArray[n5] = cArray2[n5];
                    }
                }
                int n6 = 0;
                while (n6 < n3 - n2) {
                    cArray[n5] = 32;
                    ++n6;
                    ++n5;
                }
            } else {
                int n7;
                for (n7 = 0; n7 < n3 - n2; ++n7) {
                    cArray[n7] = 32;
                }
                if (n2 >= string.length()) {
                    char[] cArray3 = string.toCharArray();
                    for (int i2 = 0; i2 < string.length(); ++i2) {
                        cArray[n7] = cArray3[i2];
                        ++n7;
                    }
                } else {
                    char[] cArray4 = string.substring(0, n2).toCharArray();
                    for (int i3 = 0; i3 < n2; ++i3) {
                        cArray[n7] = cArray4[i3];
                        ++n7;
                    }
                }
            }
            return new String(cArray);
        }

        private boolean setConversionCharacter() {
            char c2;
            boolean bl = false;
            this.conversionCharacter = '\u0000';
            if (this.pos < this.fmt.length() && ((c2 = this.fmt.charAt(this.pos)) == 'i' || c2 == 'd' || c2 == 'f' || c2 == 'g' || c2 == 'G' || c2 == 'o' || c2 == 'x' || c2 == 'X' || c2 == 'e' || c2 == 'E' || c2 == 'c' || c2 == 's' || c2 == '%' || c2 == 'n')) {
                this.conversionCharacter = c2;
                ++this.pos;
                bl = true;
            }
            return bl;
        }

        private void setOptionalHL() {
            this.optionalh = false;
            this.optionall = false;
            this.optionalL = false;
            if (this.pos < this.fmt.length()) {
                char c2 = this.fmt.charAt(this.pos);
                if (c2 == 'h') {
                    this.optionalh = true;
                    ++this.pos;
                } else if (c2 == 'l') {
                    this.optionall = true;
                    ++this.pos;
                } else if (c2 == 'L') {
                    this.optionalL = true;
                    ++this.pos;
                }
            }
        }

        private void setPrecision() {
            int n2 = this.pos;
            this.precisionSet = false;
            if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '.') {
                ++this.pos;
                if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '*') {
                    ++this.pos;
                    if (!this.setPrecisionArgPosition()) {
                        this.variablePrecision = true;
                        this.precisionSet = true;
                    }
                } else {
                    char c2;
                    while (this.pos < this.fmt.length() && Character.isDigit(c2 = this.fmt.charAt(this.pos))) {
                        ++this.pos;
                    }
                    if (this.pos > n2 + 1) {
                        String string = this.fmt.substring(n2 + 1, this.pos);
                        this.precision = Integer.parseInt(string);
                        this.precisionSet = true;
                    }
                }
            }
        }

        private void setFieldWidth() {
            int n2 = this.pos;
            this.fieldWidth = 0;
            this.fieldWidthSet = false;
            if (this.pos < this.fmt.length() && this.fmt.charAt(this.pos) == '*') {
                ++this.pos;
                if (!this.setFieldWidthArgPosition()) {
                    this.variableFieldWidth = true;
                    this.fieldWidthSet = true;
                }
            } else {
                char c2;
                while (this.pos < this.fmt.length() && Character.isDigit(c2 = this.fmt.charAt(this.pos))) {
                    ++this.pos;
                }
                if (n2 < this.pos && n2 < this.fmt.length()) {
                    String string = this.fmt.substring(n2, this.pos);
                    this.fieldWidth = Integer.parseInt(string);
                    this.fieldWidthSet = true;
                }
            }
        }

        private void setArgPosition() {
            int n2;
            for (n2 = this.pos; n2 < this.fmt.length() && Character.isDigit(this.fmt.charAt(n2)); ++n2) {
            }
            if (n2 > this.pos && n2 < this.fmt.length() && this.fmt.charAt(n2) == '$') {
                this.positionalSpecification = true;
                this.argumentPosition = Integer.parseInt(this.fmt.substring(this.pos, n2));
                this.pos = n2 + 1;
            }
        }

        private boolean setFieldWidthArgPosition() {
            int n2;
            boolean bl = false;
            for (n2 = this.pos; n2 < this.fmt.length() && Character.isDigit(this.fmt.charAt(n2)); ++n2) {
            }
            if (n2 > this.pos && n2 < this.fmt.length() && this.fmt.charAt(n2) == '$') {
                this.positionalFieldWidth = true;
                this.argumentPositionForFieldWidth = Integer.parseInt(this.fmt.substring(this.pos, n2));
                this.pos = n2 + 1;
                bl = true;
            }
            return bl;
        }

        private boolean setPrecisionArgPosition() {
            int n2;
            boolean bl = false;
            for (n2 = this.pos; n2 < this.fmt.length() && Character.isDigit(this.fmt.charAt(n2)); ++n2) {
            }
            if (n2 > this.pos && n2 < this.fmt.length() && this.fmt.charAt(n2) == '$') {
                this.positionalPrecision = true;
                this.argumentPositionForPrecision = Integer.parseInt(this.fmt.substring(this.pos, n2));
                this.pos = n2 + 1;
                bl = true;
            }
            return bl;
        }

        boolean isPositionalSpecification() {
            return this.positionalSpecification;
        }

        int getArgumentPosition() {
            return this.argumentPosition;
        }

        boolean isPositionalFieldWidth() {
            return this.positionalFieldWidth;
        }

        int getArgumentPositionForFieldWidth() {
            return this.argumentPositionForFieldWidth;
        }

        boolean isPositionalPrecision() {
            return this.positionalPrecision;
        }

        int getArgumentPositionForPrecision() {
            return this.argumentPositionForPrecision;
        }

        private void setFlagCharacters() {
            this.thousands = false;
            this.leftJustify = false;
            this.leadingSign = false;
            this.leadingSpace = false;
            this.alternateForm = false;
            this.leadingZeros = false;
            while (this.pos < this.fmt.length()) {
                char c2 = this.fmt.charAt(this.pos);
                if (c2 == '\'') {
                    this.thousands = true;
                } else if (c2 == '-') {
                    this.leftJustify = true;
                    this.leadingZeros = false;
                } else if (c2 == '+') {
                    this.leadingSign = true;
                    this.leadingSpace = false;
                } else if (c2 == ' ') {
                    if (!this.leadingSign) {
                        this.leadingSpace = true;
                    }
                } else if (c2 == '#') {
                    this.alternateForm = true;
                } else {
                    if (c2 != '0') break;
                    if (!this.leftJustify) {
                        this.leadingZeros = true;
                    }
                }
                ++this.pos;
            }
        }
    }
}

