/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.Iterator;
import jess.Accumulate;
import jess.ConditionalElement;
import jess.ConditionalElementX;
import jess.Deffacts;
import jess.Deffunction;
import jess.Defglobal;
import jess.Defmodule;
import jess.Defquery;
import jess.Defrule;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.Group;
import jess.HasLHS;
import jess.JessException;
import jess.ListRenderer;
import jess.Pattern;
import jess.Test1;
import jess.Value;
import jess.ValueVector;
import jess.Visitable;
import jess.Visitor;

public class PrettyPrinter
implements Visitor {
    private Visitable m_visitable;
    private boolean m_inTestCE = false;

    public PrettyPrinter(Visitable visitable) {
        this.m_visitable = visitable;
    }

    public Object visitDeffacts(Deffacts deffacts) {
        ListRenderer listRenderer = new ListRenderer("deffacts", deffacts.getName());
        if (deffacts.getDocstring() != null && deffacts.getDocstring().length() > 0) {
            listRenderer.addQuoted(deffacts.getDocstring());
        }
        for (int i2 = 0; i2 < deffacts.getNFacts(); ++i2) {
            listRenderer.newLine();
            listRenderer.add(deffacts.getFact(i2));
        }
        return listRenderer.toString();
    }

    public Object visitDeftemplate(Deftemplate deftemplate) {
        int n2;
        ListRenderer listRenderer;
        ListRenderer listRenderer2 = new ListRenderer("deftemplate", deftemplate.getName());
        listRenderer2.indent("  ");
        if (deftemplate.getParent() != null && deftemplate.getParent() != Deftemplate.getRootTemplate()) {
            listRenderer2.add("extends");
            listRenderer2.add(deftemplate.getParent().getName());
        }
        if (deftemplate.getDocstring() != null && deftemplate.getDocstring().length() > 0) {
            listRenderer2.newLine();
            listRenderer2.addQuoted(deftemplate.getDocstring());
        }
        ListRenderer listRenderer3 = new ListRenderer("declare");
        if (deftemplate.isSlotSpecific()) {
            this.indentIfNotFirstDeclaration(listRenderer3);
            listRenderer = new ListRenderer("slot-specific");
            listRenderer.add("TRUE");
            listRenderer3.add(listRenderer);
        }
        if (deftemplate.getBackwardChaining()) {
            this.indentIfNotFirstDeclaration(listRenderer3);
            listRenderer = new ListRenderer("backchain-reactive");
            listRenderer.add("TRUE");
            listRenderer3.add(listRenderer);
        }
        try {
            if (deftemplate.isShadowTemplate()) {
                this.indentIfNotFirstDeclaration(listRenderer3);
                listRenderer = new ListRenderer("from-class");
                listRenderer.add(deftemplate.getShadowClassName());
                listRenderer3.add(listRenderer);
                if (deftemplate.includesVariables()) {
                    ListRenderer listRenderer4 = new ListRenderer("include-variables");
                    listRenderer4.add("TRUE");
                    listRenderer3.add(listRenderer4);
                }
            }
        }
        catch (JessException jessException) {
            listRenderer3.add(jessException);
        }
        if (listRenderer3.hasContent()) {
            listRenderer2.newLine();
            listRenderer2.add(listRenderer3);
        }
        for (int i2 = n2 = this.firstSlotToPrint(deftemplate); i2 < deftemplate.m_data.size(); i2 += 3) {
            try {
                Value value = deftemplate.m_data.get(i2 + 0);
                ListRenderer listRenderer5 = new ListRenderer(value.type() == 16384 ? "slot" : "multislot", value);
                if (this.shouldIncludeSlotDefault(deftemplate)) {
                    value = deftemplate.m_data.get(i2 + 1);
                    if (!this.valueIsNil(value)) {
                        String string = this.getDefaultType(value);
                        listRenderer5.add(new ListRenderer(string, value));
                    }
                    if ((value = deftemplate.m_data.get(i2 + 2)).intValue(null) != -1) {
                        listRenderer5.add(new ListRenderer("type", Deftemplate.getSlotTypeName(value)));
                    }
                }
                listRenderer2.newLine();
                listRenderer2.add(listRenderer5);
                continue;
            }
            catch (JessException jessException) {
                listRenderer2.add(jessException.toString());
                break;
            }
        }
        return listRenderer2.toString();
    }

    private String getDefaultType(Value value) throws JessException {
        int n2 = value.type();
        if (n2 == 64) {
            return "default-dynamic";
        }
        if (n2 == 512) {
            ValueVector valueVector = value.listValue(null);
            for (int i2 = 0; i2 < valueVector.size(); ++i2) {
                if (valueVector.get(i2).type() != 64) continue;
                return "default-dynamic";
            }
        }
        return "default";
    }

    private boolean valueIsNil(Value value) {
        int n2 = value.type();
        if (n2 == 1 && value.equals(Funcall.NIL)) {
            return true;
        }
        return n2 == 512 && value.equals(Funcall.NILLIST);
    }

    private boolean shouldIncludeSlotDefault(Deftemplate deftemplate) {
        if (deftemplate.isShadowTemplate()) {
            return false;
        }
        return !deftemplate.isBackwardChainingTrigger() || deftemplate.getSlotIndex("OBJECT") == -1;
    }

    private int firstSlotToPrint(Deftemplate deftemplate) {
        if (deftemplate.isShadowTemplate()) {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        if (deftemplate.getParent() != null) {
            n2 = deftemplate.getParent().getNSlots() * 3;
        }
        return n2;
    }

    public Object visitDefglobal(Defglobal defglobal) {
        ListRenderer listRenderer = new ListRenderer("defglobal");
        listRenderer.add("?" + defglobal.getName());
        listRenderer.add("=");
        listRenderer.add(defglobal.getInitializationValue());
        return listRenderer.toString();
    }

    public Object visitDeffunction(Deffunction deffunction) {
        ListRenderer listRenderer = new ListRenderer("deffunction", deffunction.getName());
        ListRenderer listRenderer2 = new ListRenderer();
        Iterator iterator = deffunction.getArguments();
        while (iterator.hasNext()) {
            Deffunction.Argument argument = (Deffunction.Argument)iterator.next();
            String string = argument.m_type == 8 ? "?" : "$?";
            listRenderer2.add(string + argument.m_name);
        }
        listRenderer.add(listRenderer2);
        if (deffunction.getDocstring() != null && deffunction.getDocstring().length() > 0) {
            listRenderer.addQuoted(deffunction.getDocstring());
        }
        iterator = deffunction.getActions();
        while (iterator.hasNext()) {
            listRenderer.newLine();
            listRenderer.add(iterator.next());
        }
        return listRenderer.toString();
    }

    public Object visitDefrule(Defrule defrule) {
        ListRenderer listRenderer;
        ListRenderer listRenderer2 = new ListRenderer("defrule");
        listRenderer2.add(defrule.getName());
        listRenderer2.indent("  ");
        if (defrule.m_docstring != null && defrule.m_docstring.length() > 0) {
            listRenderer2.newLine();
            listRenderer2.addQuoted(defrule.m_docstring);
        }
        ListRenderer listRenderer3 = new ListRenderer("declare");
        if (defrule.hasNonDefaultSalience()) {
            listRenderer = new ListRenderer("salience");
            listRenderer.add(defrule.getSalienceValue());
            listRenderer3.add(listRenderer);
        }
        if (defrule.getAutoFocus()) {
            this.indentIfNotFirstDeclaration(listRenderer3);
            listRenderer = new ListRenderer("auto-focus");
            listRenderer.add("TRUE");
            listRenderer3.add(listRenderer);
        }
        this.addNodeIndexHashDeclaration(defrule, listRenderer3);
        if (defrule.isNoLoop()) {
            this.indentIfNotFirstDeclaration(listRenderer3);
            listRenderer = new ListRenderer("no-loop");
            listRenderer.add("TRUE");
            listRenderer3.add(listRenderer);
        }
        if (listRenderer3.hasContent()) {
            listRenderer2.newLine();
            listRenderer2.add(listRenderer3);
        }
        if (defrule.getNext() == null) {
            this.doSimpleLHS(listRenderer2, defrule);
        } else {
            this.doOrLHS(listRenderer2, defrule);
        }
        listRenderer2.newLine();
        listRenderer2.add("=>");
        for (int i2 = 0; i2 < defrule.getNActions(); ++i2) {
            listRenderer2.newLine();
            listRenderer2.add(defrule.getAction(i2).toString());
        }
        return listRenderer2.toString();
    }

    private void indentIfNotFirstDeclaration(ListRenderer listRenderer) {
        if (listRenderer.hasContent()) {
            listRenderer.indent("           ");
            listRenderer.newLine();
        }
    }

    private void doOrLHS(ListRenderer listRenderer, HasLHS hasLHS) {
        ListRenderer listRenderer2 = new ListRenderer("or");
        listRenderer2.indent("    ");
        while (hasLHS != null) {
            ListRenderer listRenderer3 = new ListRenderer("and");
            listRenderer3.indent("      ");
            this.doSimpleLHS(listRenderer3, hasLHS);
            listRenderer2.newLine();
            listRenderer2.add(listRenderer3);
            hasLHS = hasLHS.getNext();
        }
        listRenderer.newLine();
        listRenderer.add(listRenderer2);
    }

    private void doSimpleLHS(ListRenderer listRenderer, HasLHS hasLHS) {
        ConditionalElement conditionalElement = hasLHS.getConditionalElements();
        for (int i2 = 0; i2 < conditionalElement.getGroupSize(); ++i2) {
            ConditionalElement conditionalElement2 = conditionalElement.getConditionalElement(i2);
            if (conditionalElement2.getName().indexOf("__query-trigger-") != -1) continue;
            listRenderer.newLine();
            listRenderer.add(((Visitable)((Object)conditionalElement2)).accept(this));
        }
    }

    public Object visitGroup(Group group) {
        ListRenderer listRenderer = new ListRenderer(group.getName());
        for (int i2 = 0; i2 < group.getGroupSize(); ++i2) {
            ConditionalElementX conditionalElementX = group.getConditionalElementX(i2);
            listRenderer.add(((Visitable)((Object)conditionalElementX)).accept(this));
        }
        if (group.getBoundName() != null && !group.getName().equals("not")) {
            return '?' + group.getBoundName() + " <- " + listRenderer.toString();
        }
        return listRenderer.toString();
    }

    public Object visitPattern(Pattern pattern) {
        this.m_inTestCE = pattern.getName().equals("test");
        String string = PrettyPrinter.contextualize(this.m_visitable, pattern.getName());
        ListRenderer listRenderer = new ListRenderer(string);
        Deftemplate deftemplate = pattern.getDeftemplate();
        try {
            for (int i2 = 0; i2 < pattern.getNSlots(); ++i2) {
                if (pattern.getNTests(i2) == 0 && pattern.getSlotLength(i2) <= -1) continue;
                ListRenderer listRenderer2 = deftemplate.getSlotName(i2).equals("__data") ? listRenderer : new ListRenderer(deftemplate.getSlotName(i2));
                for (int i3 = -1; i3 <= pattern.getSlotLength(i2); ++i3) {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i4 = 0; i4 < pattern.getNTests(i2); ++i4) {
                        Test1 test1 = pattern.getTest(i2, i4);
                        if (test1.m_subIdx != i3) continue;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append("&");
                        }
                        stringBuffer.append(test1.accept(this));
                    }
                    if (stringBuffer.length() <= 0) continue;
                    listRenderer2.add(stringBuffer);
                }
                if (deftemplate.getSlotName(i2).equals("__data")) continue;
                listRenderer.add(listRenderer2);
            }
        }
        catch (JessException jessException) {
            listRenderer.add(jessException.getDetail());
        }
        if (pattern.getBoundName() != null) {
            return '?' + pattern.getBoundName() + " <- " + listRenderer.toString();
        }
        return listRenderer.toString();
    }

    static String contextualize(Visitable visitable, String string) {
        if (!(visitable instanceof HasLHS)) {
            return string;
        }
        HasLHS hasLHS = (HasLHS)visitable;
        String string2 = hasLHS.getModule() + "::";
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public Object visitTest1(Test1 test1) {
        StringBuffer stringBuffer = new StringBuffer();
        if (test1.m_test == 1) {
            stringBuffer.append("~");
        }
        if (test1.m_slotValue.type() == 64 && !this.m_inTestCE) {
            stringBuffer.append(":");
        }
        stringBuffer.append(test1.m_slotValue);
        return stringBuffer.toString();
    }

    public Object visitAccumulate(Accumulate accumulate) {
        ListRenderer listRenderer = new ListRenderer("accumulate");
        ConditionalElementX conditionalElementX = accumulate.getConditionalElementX(0);
        listRenderer.add(accumulate.getInitializer());
        listRenderer.add(accumulate.getBody());
        listRenderer.add(accumulate.getReturn());
        listRenderer.add(((Visitable)((Object)conditionalElementX)).accept(this));
        if (accumulate.getBoundName() != null) {
            return '?' + accumulate.getBoundName() + " <- " + listRenderer.toString();
        }
        return listRenderer.toString();
    }

    public Object visitDefmodule(Defmodule defmodule) {
        ListRenderer listRenderer = new ListRenderer("defmodule");
        listRenderer.add(defmodule.getName());
        if (defmodule.getDocstring() != null) {
            listRenderer.newLine();
            listRenderer.indent("  ");
            listRenderer.add(defmodule.getDocstring());
        }
        return listRenderer.toString();
    }

    public Object visitFuncall(Funcall funcall) {
        return funcall.toString();
    }

    public Object visitFact(Fact fact) {
        return fact.toString();
    }

    public Object visitDefquery(Defquery defquery) {
        ListRenderer listRenderer;
        ListRenderer listRenderer2 = new ListRenderer("defquery");
        listRenderer2.add(defquery.getName());
        listRenderer2.indent("  ");
        if (defquery.m_docstring != null && defquery.m_docstring.length() > 0) {
            listRenderer2.newLine();
            listRenderer2.addQuoted(defquery.m_docstring);
        }
        ListRenderer listRenderer3 = new ListRenderer("declare");
        if (defquery.getNVariables() > 0) {
            listRenderer = new ListRenderer("variables");
            for (int i2 = 0; i2 < defquery.getNVariables(); ++i2) {
                listRenderer.add(defquery.getQueryVariable(i2));
            }
            listRenderer3.add(listRenderer);
        }
        if (defquery.getMaxBackgroundRules() > 0) {
            this.indentIfNotFirstDeclaration(listRenderer3);
            listRenderer = new ListRenderer("max-background-rules");
            listRenderer.add(String.valueOf(defquery.getMaxBackgroundRules()));
            listRenderer3.add(listRenderer);
        }
        this.addNodeIndexHashDeclaration(defquery, listRenderer3);
        if (listRenderer3.hasContent()) {
            listRenderer2.newLine();
            listRenderer2.add(listRenderer3);
        }
        if (defquery.getNext() == null) {
            this.doSimpleLHS(listRenderer2, defquery);
        } else {
            this.doOrLHS(listRenderer2, defquery);
        }
        return listRenderer2.toString();
    }

    private void addNodeIndexHashDeclaration(HasLHS hasLHS, ListRenderer listRenderer) {
        if (hasLHS.getNodeIndexHash() > 0) {
            this.indentIfNotFirstDeclaration(listRenderer);
            ListRenderer listRenderer2 = new ListRenderer("node-index-hash");
            listRenderer2.add(String.valueOf(hasLHS.getNodeIndexHash()));
            listRenderer.add(listRenderer2);
        }
    }

    public String toString() {
        return (String)this.m_visitable.accept(this);
    }
}

