/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import jess.BindingValue;
import jess.ConditionalElement;
import jess.ConditionalElementX;
import jess.Defglobal;
import jess.Deftemplate;
import jess.Funcall;
import jess.FuncallValue;
import jess.Group;
import jess.JessException;
import jess.RU;
import jess.Rete;
import jess.Test1;
import jess.TestedSlot;
import jess.Value;
import jess.Variable;
import jess.Visitable;
import jess.Visitor;

public class Pattern
implements ConditionalElement,
ConditionalElementX,
Serializable,
Visitable {
    private Deftemplate m_deft;
    private static final int INITSIZE = 1;
    private Test1[][] m_tests;
    private int[] m_slotLengths;
    private boolean m_negated;
    private boolean m_logical;
    private boolean m_explicit;
    private String m_name;
    private String m_boundName;

    public Object clone() {
        try {
            Pattern pattern = (Pattern)super.clone();
            if (this.m_slotLengths != null) {
                pattern.m_slotLengths = (int[])this.m_slotLengths.clone();
            }
            if (this.m_tests != null) {
                pattern.m_tests = (Test1[][])this.m_tests.clone();
                for (int i2 = 0; i2 < this.m_tests.length; ++i2) {
                    if (this.m_tests[i2] == null) continue;
                    pattern.m_tests[i2] = (Test1[])this.m_tests[i2].clone();
                    for (int i3 = 0; i3 < this.m_tests[i2].length; ++i3) {
                        pattern.m_tests[i2][i3] = (Test1)this.m_tests[i2][i3].clone();
                    }
                }
            }
            return pattern;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Pattern(String string, Rete rete) throws JessException {
        this(rete.createDeftemplate(string));
    }

    public Pattern(Deftemplate deftemplate) {
        this.m_name = deftemplate.getName();
        this.m_deft = deftemplate;
        int n2 = this.m_deft.getNSlots();
        this.m_tests = new Test1[n2][];
        this.m_slotLengths = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.m_slotLengths[i2] = -1;
        }
    }

    Pattern(Pattern pattern, String string) throws JessException {
        this.m_name = string;
        this.m_deft = pattern.m_deft;
        this.m_tests = new Test1[pattern.m_tests.length][];
        for (int i2 = 0; i2 < this.m_tests.length; ++i2) {
            Test1[] test1Array = this.m_tests[i2] = pattern.m_tests[i2] == null ? null : new Test1[pattern.m_tests[i2].length];
            if (this.m_tests[i2] == null) continue;
            System.arraycopy(pattern.m_tests[i2], 0, this.m_tests[i2], 0, this.m_tests[i2].length);
            for (int i3 = 0; i3 < this.m_tests[i2].length; ++i3) {
                Value value = this.m_tests[i2][i3].m_slotValue;
                if (!(value instanceof Variable) || !value.variableValue(null).startsWith("_blank_")) continue;
                this.m_tests[i2][i3] = new Test1(this.m_tests[i2][i3], new Variable(RU.gensym("_blank_"), value.type()));
            }
        }
        this.m_slotLengths = pattern.m_slotLengths;
    }

    public void setSlotLength(String string, int n2) throws JessException {
        int n3 = this.m_deft.getSlotIndex(string);
        if (n3 == -1) {
            throw new JessException("Pattern.setSlotLength", "No such slot " + string + " in template", this.m_deft.getName());
        }
        this.m_slotLengths[n3] = n2;
    }

    public void addTest(Test1 test1) throws JessException {
        int n2;
        String string = test1.m_slot;
        int n3 = this.m_deft.getSlotIndex(string);
        if (n3 == -1) {
            throw new JessException("Pattern.addTest", "No such slot " + string + " in template ", this.m_deft.getName());
        }
        if (this.m_tests[n3] == null) {
            this.m_tests[n3] = new Test1[1];
        }
        for (n2 = 0; n2 < this.m_tests[n3].length && this.m_tests[n3][n2] != null; ++n2) {
        }
        if (n2 == this.m_tests[n3].length) {
            Test1[] test1Array = new Test1[n2 + 1];
            System.arraycopy(this.m_tests[n3], 0, test1Array, 0, n2);
            this.m_tests[n3] = test1Array;
        }
        if (n2 > 0 && this.m_tests[n3][n2 - 1].m_subIdx > test1.m_subIdx) {
            throw new JessException("Pattern.addTest", "Attempt to add out-of-order test: index ", this.m_tests[n3][n2 - 1].m_subIdx + " > " + test1.m_subIdx);
        }
        this.m_tests[n3][n2] = test1;
    }

    void replaceTests(int n2, Test1[] test1Array) {
        this.m_tests[n2] = test1Array;
    }

    public void addDirectlyMatchedVariables(Set set) throws JessException {
        for (int i2 = 0; i2 < this.getNSlots(); ++i2) {
            for (int i3 = 0; i3 < this.getNTests(i2); ++i3) {
                boolean bl;
                Test1 test1 = this.getTest(i2, i3);
                Value value = test1.m_slotValue;
                boolean bl2 = bl = test1.m_test == 0;
                if (!(value instanceof Variable) || !bl) continue;
                String string = value.variableValue(null);
                set.add(string);
            }
        }
        if (this.getBoundName() != null) {
            set.add(this.getBoundName());
        }
    }

    public void renameUnmentionedVariables(Set set, Map map, int n2) throws JessException {
        String string = "_" + n2 + "_";
        for (int i2 = 0; i2 < this.getNSlots(); ++i2) {
            for (int i3 = 0; i3 < this.getNTests(i2); ++i3) {
                String string2;
                String string3;
                Test1 test1 = this.getTest(i2, i3);
                Value value = test1.m_slotValue;
                if (!(value instanceof Variable) || Defglobal.isADefglobalName(string3 = value.variableValue(null)) || set.contains(string3) || string3.startsWith(string)) continue;
                if (map.get(string3) == null) {
                    string2 = string + string3;
                    map.put(string3, string2);
                } else {
                    string2 = (String)map.get(string3);
                }
                test1.m_slotValue = new Variable(string2, value.type());
            }
        }
        this.substituteVariableNamesInFuncalls(map);
    }

    public void recordTestedSlots(int n2, Set set) {
        for (int i2 = 0; i2 < this.getNSlots(); ++i2) {
            if (this.m_tests[i2] == null) continue;
            set.add(new TestedSlot(n2, i2));
        }
    }

    private void substituteVariableNamesInFuncalls(Map map) throws JessException {
        for (int i2 = 0; i2 < this.getNSlots(); ++i2) {
            if (this.getNTests(i2) == 0) continue;
            for (int i3 = 0; i3 < this.getNTests(i2); ++i3) {
                Value value = this.getTest((int)i2, (int)i3).m_slotValue;
                if (value.type() != 64) continue;
                this.substFuncall(value.funcallValue(null), map);
            }
        }
    }

    private void substFuncall(Funcall funcall, Map map) throws JessException {
        for (int i2 = 1; i2 < funcall.size(); ++i2) {
            Value value = funcall.get(i2);
            if (value instanceof Variable) {
                String string = (String)map.get(value.variableValue(null));
                if (string == null) continue;
                funcall.set(new Variable(string, value.type()), i2);
                continue;
            }
            if (!(value instanceof FuncallValue)) continue;
            this.substFuncall(value.funcallValue(null), map);
        }
    }

    public void findVariableDefinitions(int n2, Map map, Map map2) throws JessException {
        Serializable serializable;
        if (this.m_boundName != null && map.get(this.m_boundName) == null) {
            serializable = new BindingValue(this.m_boundName, this, n2, -1, -1, 16);
            map2.put(this.m_boundName, serializable);
        }
        serializable = this.getDeftemplate();
        for (int i2 = 0; i2 < this.getNSlots(); ++i2) {
            for (int i3 = 0; i3 < this.getNTests(i2); ++i3) {
                String string;
                boolean bl;
                Test1 test1 = this.getTest(i2, i3);
                Value value = test1.m_slotValue;
                boolean bl2 = bl = test1.m_test == 0;
                if (!(value instanceof Variable) || map.get(string = value.variableValue(null)) != null || map2.get(string) != null || Defglobal.isADefglobalName(string) || !bl) continue;
                int n3 = ((Deftemplate)serializable).getSlotDataType(i2);
                map2.put(string, new BindingValue(string, this, n2, i2, test1.m_subIdx, n3));
            }
        }
    }

    public boolean getNegated() {
        return this.m_negated;
    }

    public void setNegated() {
        this.m_negated = true;
    }

    public void setLogical() {
        this.m_logical = true;
    }

    public boolean getLogical() {
        return this.m_logical;
    }

    public void setExplicit() {
        this.m_explicit = true;
    }

    public boolean getExplicit() {
        return this.m_explicit;
    }

    public boolean getBackwardChaining() {
        return this.m_deft.getBackwardChaining();
    }

    public String getName() {
        if (this.m_name.equals("MAIN::test")) {
            return "test";
        }
        return this.m_name;
    }

    public void setBoundName(String string) throws JessException {
        if ((this.m_negated || this.m_name.equals("test")) && string != null) {
            throw new JessException("Pattern.setBoundName", "Can't bind negated pattern to variable", string);
        }
        this.m_boundName = string;
    }

    public String getBoundName() {
        if (this.isBackwardChainingTrigger() && this.m_boundName == null) {
            this.m_boundName = RU.gensym("__factidx");
        }
        return this.m_boundName;
    }

    public int getNSlots() {
        return this.m_deft.getNSlots();
    }

    public int getNTests(int n2) {
        if (this.m_tests[n2] == null) {
            return 0;
        }
        return this.m_tests[n2].length;
    }

    public int getSlotLength(int n2) {
        return this.m_slotLengths[n2];
    }

    public int getNMultifieldsInSlot(int n2) {
        int n3 = 0;
        if (this.m_tests[n2] == null) {
            return n3;
        }
        for (int i2 = 0; i2 < this.m_tests[n2].length; ++i2) {
            if (this.m_tests[n2][i2].m_slotValue.type() != 8192) continue;
            ++n3;
        }
        return n3;
    }

    public boolean isMultifieldSubslot(int n2, int n3) {
        if (this.m_tests[n2] == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_tests[n2].length; ++i2) {
            if (this.m_tests[n2][i2].m_slotValue.type() != 8192 || this.m_tests[n2][i2].m_subIdx != n3) continue;
            return true;
        }
        return false;
    }

    boolean[] getMultifieldFlags(int n2) {
        boolean[] blArray = new boolean[this.getSlotLength(n2)];
        for (int i2 = 0; i2 < this.getSlotLength(n2); ++i2) {
            if (!this.isMultifieldSubslot(n2, i2)) continue;
            blArray[i2] = true;
        }
        return blArray;
    }

    public Test1 getTest(int n2, int n3) {
        return this.m_tests[n2][n3];
    }

    public Deftemplate getDeftemplate() {
        return this.m_deft;
    }

    public void addToGroup(Group group) throws JessException {
        group.m_data.add((Pattern)this.clone());
    }

    public ConditionalElementX canonicalize() {
        return this;
    }

    public Object accept(Visitor visitor) {
        return visitor.visitPattern(this);
    }

    public int getGroupSize() {
        return 1;
    }

    public boolean isGroup() {
        return false;
    }

    public ConditionalElement getConditionalElement(int n2) {
        return this.getConditionalElementX(n2);
    }

    public int getPatternCount() {
        return 1;
    }

    public ConditionalElementX getConditionalElementX(int n2) {
        if (n2 > 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public boolean equals(Object object) {
        int n2;
        if (!(object instanceof Pattern)) {
            return false;
        }
        Pattern pattern = (Pattern)object;
        if (!this.getName().equals(pattern.getName())) {
            return false;
        }
        if (this.m_negated != pattern.m_negated) {
            return false;
        }
        for (n2 = 0; n2 < this.m_slotLengths.length; ++n2) {
            if (this.m_slotLengths[n2] == pattern.m_slotLengths[n2]) continue;
            return false;
        }
        for (n2 = 0; n2 < this.m_tests.length; ++n2) {
            if (this.m_tests[n2] == null || pattern.m_tests[n2] == null) {
                if (this.m_tests[n2] == pattern.m_tests[n2]) continue;
                return false;
            }
            if (this.m_tests[n2].length != pattern.m_tests[n2].length) {
                return false;
            }
            for (int i2 = 0; i2 < this.m_tests[n2].length; ++i2) {
                if ((this.m_tests[n2][i2] == null || pattern.m_tests[n2][i2] == null) && this.m_tests[n2][i2] != pattern.m_tests[n2][i2]) {
                    return false;
                }
                if (this.m_tests[n2][i2].equals(pattern.m_tests[n2][i2])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBackwardChainingTrigger() {
        return !this.m_negated && this.m_deft.isBackwardChainingTrigger();
    }

    public String getBackchainingTemplateName() {
        return this.m_deft.getBackchainingTemplateName();
    }

    public String getNameWithoutBackchainingPrefix() {
        return this.m_deft.getNameWithoutBackchainingPrefix();
    }

    public String toString() {
        return "(" + this.getName() + ")";
    }
}

