/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jess.HasLHS;
import jess.JessEvent;
import jess.JessException;
import jess.JessListener;
import jess.Node;
import jess.Node1;
import jess.Node2;
import jess.NodeJoin;
import jess.PrettyPrinter;
import jess.Rete;
import jess.Token;

class NodeViewer
extends JFrame
implements JessListener {
    private Node m_node;
    private TextArea m_view;
    private TextArea m_events;

    NodeViewer(Node node, final Rete rete) {
        super(node.toString());
        this.m_node = node;
        rete.store("NODE", this.m_node);
        this.m_view = new TextArea(40, 20);
        this.m_events = new TextArea(40, 20);
        this.m_view.setEditable(false);
        this.m_events.setEditable(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel.add(this.m_view);
        jPanel.add(this.m_events);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                NodeViewer.this.dispose();
                NodeViewer.this.m_node.removeJessListener(NodeViewer.this);
                rete.removeJessListener(NodeViewer.this);
            }
        });
        this.getContentPane().add((Component)jPanel, "Center");
        this.describeNode();
        this.setSize(600, 600);
        this.validate();
        this.setVisible(true);
        this.m_node.addJessListener(this);
        rete.addJessListener(this);
        rete.setEventMask(rete.getEventMask() | 1 | 0x800);
    }

    void describeNode() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_node instanceof Node1) {
            stringBuffer.append(this.m_node);
        } else if (this.m_node instanceof Node2) {
            try {
                stringBuffer.append(this.m_node);
                stringBuffer.append("\n");
                stringBuffer.append(((Node2)this.m_node).displayMemory().toString());
                stringBuffer.append("\n");
                stringBuffer.append(((Node2)this.m_node).getIndexingInfo());
            }
            catch (JessException jessException) {}
        } else if (this.m_node instanceof NodeJoin) {
            stringBuffer.append(this.m_node);
        } else if (this.m_node instanceof HasLHS) {
            stringBuffer.append(new PrettyPrinter((HasLHS)this.m_node).toString());
        }
        this.m_view.setText(stringBuffer.toString());
    }

    public void eventHappened(JessEvent jessEvent) throws JessException {
        Object object = jessEvent.getSource();
        if (object == this.m_node) {
            Token token = (Token)jessEvent.getObject();
            int n2 = jessEvent.getType();
            if (this.m_view != null) {
                this.m_events.append(n2 + ": " + token + "\n");
            }
        }
        this.describeNode();
    }
}

