/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.util.Iterator;
import jess.Defrule;
import jess.Fact;
import jess.HasLHS;
import jess.JessException;
import jess.MemoryInfo;
import jess.Node2;
import jess.Rete;
import jess.Token;
import jess.TokenList;
import jess.TokenTree;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class Node2Test
extends TestCase {
    static /* synthetic */ Class class$jess$Node2Test;

    public Node2Test(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(class$jess$Node2Test == null ? (class$jess$Node2Test = Node2Test.class$("jess.Node2Test")) : class$jess$Node2Test);
    }

    public void testLeakIfChangeBehindTheScenes() throws JessException {
        Rete rete = new Rete();
        rete.getCompiler().setHashKey(1);
        rete.eval("(defrule rule(A ?X)(B ?Y)(test (eq (?Y foo) ?X))(C)=>)");
        Object object = new Object();
        Y y2 = new Y();
        y2.m_data = object;
        rete.store("X", object);
        rete.store("Y", y2);
        rete.eval("(assert (A (fetch X)))");
        rete.eval("(assert (B (fetch Y)))");
        HasLHS hasLHS = rete.findDefrule("rule");
        Node2 node2 = this.lastJoinNode(hasLHS);
        TokenTree tokenTree = node2.m_left;
        Node2Test.assertEquals((int)1, (int)tokenTree.getHash());
        TokenList tokenList = tokenTree.getTokenList(0);
        Node2Test.assertNotNull((Object)tokenList);
        Node2Test.assertEquals((int)1, (int)tokenList.size());
        Node2Test.assertEquals((int)1, (int)new TokenTree.Spy((TokenTree)tokenTree).m_size);
        y2.m_data = new Object();
        rete.eval("(retract 1)");
        Node2Test.assertEquals((int)0, (int)tokenList.size());
        Node2Test.assertEquals((int)0, (int)new TokenTree.Spy((TokenTree)tokenTree).m_size);
    }

    public void testClearTokenTree() throws JessException {
        Rete rete = new Rete();
        rete.getCompiler().setHashKey(1);
        rete.eval("(defrule rule(A ?X)(B ?Y)(test (eq (?Y foo) ?X))(C)=>)");
        Object object = new Object();
        Y y2 = new Y();
        y2.m_data = object;
        rete.store("X", object);
        rete.store("Y", y2);
        rete.eval("(assert (A (fetch X)))");
        rete.eval("(assert (B (fetch Y)))");
        HasLHS hasLHS = rete.findDefrule("rule");
        Node2 node2 = this.lastJoinNode(hasLHS);
        TokenTree tokenTree = node2.m_left;
        TokenList tokenList = tokenTree.getTokenList(0);
        Node2Test.assertNotNull((Object)tokenList);
        Node2Test.assertEquals((int)1, (int)tokenList.size());
        Node2Test.assertEquals((int)1, (int)new TokenTree.Spy((TokenTree)tokenTree).m_size);
        tokenTree.clear();
        Node2Test.assertEquals((int)0, (int)tokenList.size());
        Node2Test.assertEquals((int)0, (int)new TokenTree.Spy((TokenTree)tokenTree).m_size);
    }

    public void testRemoveLogicalSupportFrom() throws Exception {
        Rete rete = new Rete();
        Node2 node2 = new Node2(101);
        Fact fact = new Fact("foo", rete);
        Fact fact2 = new Fact("bar", rete);
        Token token = new Token(fact2);
        node2.dependsOn(fact, token);
        Node2Test.assertNotNull(node2.getLogicalDependencies().get(token));
        node2.m_logicalDepends.removeLogicalSupportFrom(token, rete.getGlobalContext());
        Node2Test.assertNull(node2.getLogicalDependencies().get(token));
    }

    public void testSetUpMemoryIndices2() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule (foo a ?x) (bar ?x) => )");
        Defrule defrule = (Defrule)rete.findDefrule("rule");
        Node2 node2 = this.lastJoinNode(defrule);
        MemoryInfo memoryInfo = new MemoryInfo(node2.m_tests, node2.m_nTests);
        Node2Test.assertEquals((boolean)true, (boolean)memoryInfo.blessed);
        Node2Test.assertEquals((int)0, (int)memoryInfo.tokenIndex);
        Node2Test.assertEquals((int)0, (int)memoryInfo.leftSlot);
        Node2Test.assertEquals((int)1, (int)memoryInfo.leftSubSlot);
        Node2Test.assertEquals((int)0, (int)memoryInfo.rightSlot);
        Node2Test.assertEquals((int)0, (int)memoryInfo.rightSubSlot);
        TokenTree.Spy spy = new TokenTree.Spy(node2.m_left);
        Node2Test.assertEquals((int)0, (int)spy.m_slot);
        Node2Test.assertEquals((int)1, (int)spy.m_subSlot);
        Node2Test.assertEquals((int)0, (int)spy.m_fact);
        Node2Test.assertEquals((boolean)false, (boolean)spy.m_useSortcode);
        TokenTree.Spy spy2 = new TokenTree.Spy(node2.m_right);
        Node2Test.assertEquals((int)0, (int)spy2.m_slot);
        Node2Test.assertEquals((int)0, (int)spy2.m_subSlot);
        Node2Test.assertEquals((int)0, (int)spy2.m_fact);
        Node2Test.assertEquals((boolean)false, (boolean)spy.m_useSortcode);
        try {
            rete.reset();
            rete.assertString("(bar 123)");
        }
        catch (JessException jessException) {
            Node2Test.fail((String)"Caught unexpected exception");
        }
    }

    public void testSetUpMemoryIndices() throws Exception {
        Rete rete = new Rete();
        rete.eval("(defrule rule (baz) (foo 0 ?x 1) (bar 1 2 ?x) => )");
        Defrule defrule = (Defrule)rete.findDefrule("rule");
        Node2 node2 = this.lastJoinNode(defrule);
        MemoryInfo memoryInfo = new MemoryInfo(node2.m_tests, node2.m_nTests);
        Node2Test.assertEquals((boolean)true, (boolean)memoryInfo.blessed);
        Node2Test.assertEquals((int)1, (int)memoryInfo.tokenIndex);
        Node2Test.assertEquals((int)0, (int)memoryInfo.leftSlot);
        Node2Test.assertEquals((int)1, (int)memoryInfo.leftSubSlot);
        Node2Test.assertEquals((int)0, (int)memoryInfo.rightSlot);
        Node2Test.assertEquals((int)2, (int)memoryInfo.rightSubSlot);
        TokenTree.Spy spy = new TokenTree.Spy(node2.m_left);
        Node2Test.assertEquals((int)0, (int)spy.m_slot);
        Node2Test.assertEquals((int)1, (int)spy.m_subSlot);
        Node2Test.assertEquals((int)1, (int)spy.m_fact);
        Node2Test.assertEquals((boolean)false, (boolean)spy.m_useSortcode);
        TokenTree.Spy spy2 = new TokenTree.Spy(node2.m_right);
        Node2Test.assertEquals((int)0, (int)spy2.m_slot);
        Node2Test.assertEquals((int)2, (int)spy2.m_subSlot);
        Node2Test.assertEquals((int)0, (int)spy2.m_fact);
        Node2Test.assertEquals((boolean)false, (boolean)spy.m_useSortcode);
    }

    private Node2 lastJoinNode(HasLHS hasLHS) {
        Node2 node2 = null;
        Iterator iterator = hasLHS.getNodes();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof Node2)) continue;
            node2 = (Node2)e2;
        }
        return node2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Y {
        Object m_data;

        public Object foo() {
            return this.m_data;
        }
    }
}

