/*
 * Decompiled with CFR 0.152.
 */
package jess;

import jess.Accumulate;
import jess.AccumulateFact;
import jess.Context;
import jess.JessException;
import jess.Node2;
import jess.Rete;
import jess.Token;
import jess.Value;

class Node2Accumulate
extends Node2 {
    private Value m_body;
    private Value m_initializer;
    private Value m_return;

    public Node2Accumulate(Accumulate accumulate, int n2) {
        super(n2);
        this.m_body = accumulate.getBody();
        this.m_initializer = accumulate.getInitializer();
        this.m_return = accumulate.getReturn();
    }

    void callNodeLeft(int n2, Token token, Context context) throws JessException {
        switch (n2) {
            case 0: 
            case 2: 
            case 4: {
                Context context2 = this.setupForAccumulation(context, token);
                this.accumulateResults(n2, token, context2);
                this.sendAccumulateToken(n2, token, context2);
                break;
            }
            case 1: 
            case 5: {
                this.m_left.remove(token);
                this.sendNilResultsToken(n2, token, context);
                break;
            }
            default: {
                super.callNodeLeft(n2, token, context);
            }
        }
    }

    private void sendNilResultsToken(int n2, Token token, Context context) throws JessException {
        Context context2 = context.push();
        this.m_initializer.resolveValue(context2);
        this.sendAccumulateToken(n2, token, context2);
    }

    void callNodeRight(int n2, Token token, Context context) throws JessException {
        if (n2 != 3) {
            Context context2 = this.setupForAccumulation(context, token);
            super.callNodeRight(n2, token, context2);
        }
    }

    private void accumulateResults(int n2, Token token, Context context) throws JessException {
        super.callNodeLeft(n2, token, context);
    }

    private Context setupForAccumulation(Context context, Token token) throws JessException {
        Context context2 = context.push();
        context2.setToken(token);
        this.m_initializer.resolveValue(context2);
        return context2;
    }

    private void sendAccumulateToken(int n2, Token token, Context context) throws JessException {
        AccumulateFact accumulateFact = new AccumulateFact();
        accumulateFact.updateTime(context.getEngine().getTime());
        accumulateFact.setSlotValue("value", this.m_return.resolveValue(context));
        accumulateFact.setFactId(-2);
        Token token2 = Rete.getFactory().newToken(token, accumulateFact);
        super.passAlong(n2, token2, context);
    }

    public void tokenMatchesLeft(int n2, Token token, Token token2, Context context) throws JessException {
        context.setFact(token2.fact(0));
        this.m_body.resolveValue(context);
    }

    public void tokenMatchesRight(int n2, Token token, Token token2, Context context) throws JessException {
        switch (n2) {
            case 0: 
            case 2: {
                this.sendNilResultsToken(1, token, context);
                Context context2 = this.setupForAccumulation(context, token);
                this.runTestsVaryRight(n2, token, context2, this);
                this.sendAccumulateToken(n2, token, context2);
                break;
            }
            case 4: {
                Context context3 = this.setupForAccumulation(context, token);
                this.runTestsVaryRight(n2, token, context3, this);
                this.sendAccumulateToken(n2, token, context3);
                break;
            }
            case 1: {
                this.sendNilResultsToken(n2, token, context);
                Context context4 = this.setupForAccumulation(context, token);
                this.runTestsVaryRight(n2, token, context4, this);
                this.sendAccumulateToken(0, token, context4);
                break;
            }
            case 5: {
                this.sendNilResultsToken(n2, token, context);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("[Node2Accumulate");
        stringBuffer.append(";usecount = ");
        stringBuffer.append(this.m_usecount);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Node2Accumulate)) {
            return false;
        }
        Node2Accumulate node2Accumulate = (Node2Accumulate)object;
        if (!node2Accumulate.m_initializer.equals(this.m_initializer)) {
            return false;
        }
        if (!node2Accumulate.m_body.equals(this.m_body)) {
            return false;
        }
        return node2Accumulate.m_return.equals(this.m_return);
    }
}

