/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import jess.BindingValue;
import jess.Context;
import jess.Fact;
import jess.Funcall;
import jess.HasLHS;
import jess.JessException;
import jess.LogicalNode;
import jess.MatchInfoSource;
import jess.MemoryInfo;
import jess.NodeJoin;
import jess.NodeLogicalDependencyHandler;
import jess.Pattern;
import jess.Rete;
import jess.Test1;
import jess.Test2Multi;
import jess.Test2Simple;
import jess.TestBase;
import jess.Token;
import jess.TokenList;
import jess.TokenTask;
import jess.TokenTree;
import jess.Value;
import jess.ValueVector;
import jess.Variable;

class Node2
extends NodeJoin
implements LogicalNode,
Serializable,
TokenTask {
    TokenTree m_left;
    TokenTree m_right;
    protected int m_tokenSize;
    protected int m_hashkey;
    Pattern m_pattern;
    HasLHS m_defrule;
    public int m_matches = 0;
    private boolean m_blessed = false;
    protected NodeLogicalDependencyHandler m_logicalDepends;

    Node2(int n2) {
        this.m_hashkey = n2;
    }

    void addTest(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n5 == -1 && n7 == -1) {
            this.addTest(new Test2Simple(n2, n3, n4, n6));
        } else {
            this.addTest(new Test2Multi(n2, n3, n4, n5, n6, n7));
        }
    }

    void callNodeLeft(int n2, Token token, Context context) throws JessException {
        try {
            this.m_matches = 0;
            this.broadcastEvent(n2, 32768, token);
            switch (n2) {
                case 0: 
                case 4: {
                    try {
                        this.m_tokenSize = token.size();
                        this.m_left.add(token, false);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new JessException("Node2.callNode", "Negated conjunction with", "unbound variables");
                    }
                    this.runTestsVaryRight(n2, token, context, this);
                    this.askForBackChain(token, context);
                    break;
                }
                case 2: {
                    try {
                        this.m_tokenSize = token.size();
                        Token token2 = Rete.getFactory().newToken(token);
                        if (this.m_left.add(token2, true)) {
                            this.runTestsVaryRight(0, token2, context, this);
                            this.askForBackChain(token, context);
                        }
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new JessException("Node2.callNode", "Negated conjunction with", "unbound variables");
                    }
                }
                case 1: 
                case 5: {
                    Token token3 = this.m_left.remove(token);
                    if (token3 != null) {
                        this.runTestsVaryRight(n2, token3, context, this);
                    }
                    break;
                }
                case 3: {
                    this.initTokenTrees();
                    if (this.m_logicalDepends != null) {
                        this.m_logicalDepends.clear();
                    }
                    this.passAlong(n2, token, context);
                    break;
                }
                default: {
                    throw new JessException("Node2.callNode", "Bad tag", n2);
                }
            }
        }
        catch (JessException jessException) {
            jessException.addContext("rule LHS (Node2)");
            throw jessException;
        }
    }

    void callNodeRight(int n2, Token token, Context context) throws JessException {
        try {
            this.broadcastEvent(n2, 65536, token);
            switch (n2) {
                case 0: 
                case 2: 
                case 4: {
                    this.m_right.add(token, n2 == 2);
                    this.runTestsVaryLeft(n2, token, context, this);
                    break;
                }
                case 1: 
                case 5: {
                    Token token2 = this.m_right.remove(token);
                    if (token2 != null) {
                        this.runTestsVaryLeft(n2, token, context, this);
                    }
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new JessException("Node2.callNode", "Bad tag in token", n2);
                }
            }
        }
        catch (JessException jessException) {
            jessException.addContext("rule LHS (Node2)");
            throw jessException;
        }
    }

    void debugPrint(int n2, Token token, int n3) {
        System.out.println("TEST " + this.toString() + "(" + this.hashCode() + ");calltype=" + n3 + ";tag=" + n2 + ";class=" + token.fact(0).getName());
    }

    void runTestsVaryRight(int n2, Token token, Context context, TokenTask tokenTask) throws JessException {
        if (this.m_blessed) {
            Value value = this.m_left.extractKey(token);
            TokenList tokenList = this.m_right.getTestableTokens(value);
            this.doRunTestsVaryRight(n2, token, tokenList, context, tokenTask);
        } else {
            this.doRunTestsVaryRight(n2, token, context, tokenTask);
        }
    }

    void doRunTestsVaryRight(int n2, Token token, Context context, TokenTask tokenTask) throws JessException {
        for (int i2 = 0; i2 < this.m_right.getHash(); ++i2) {
            this.doRunTestsVaryRight(n2, token, this.m_right.getTokenList(i2), context, tokenTask);
        }
    }

    void doRunTestsVaryRight(int n2, Token token, TokenList tokenList, Context context, TokenTask tokenTask) throws JessException {
        if (tokenList != null) {
            int n3 = tokenList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                context.setToken(token);
                Token token2 = tokenList.get(i2);
                if (!this.runTests(this.m_nTests, context, token2)) continue;
                tokenTask.tokenMatchesLeft(n2, token, token2, context);
            }
        }
    }

    public void tokenMatchesLeft(int n2, Token token, Token token2, Context context) throws JessException {
        if (n2 != 1 && n2 != 5) {
            ++this.m_matches;
        }
        if (this.m_nTests != 0) {
            token = token.prepare(true);
        }
        Token token3 = Rete.getFactory().newToken(token, token2);
        if (this.m_logicalDepends != null) {
            this.m_logicalDepends.tokenMatched(n2, token3, context);
        }
        this.passAlong(n2, token3, context);
    }

    public void tokenMatchesRight(int n2, Token token, Token token2, Context context) throws JessException {
        this.tokenMatchesLeft(n2, token, token2, context);
    }

    void runTestsVaryLeft(int n2, Token token, Context context, TokenTask tokenTask) throws JessException {
        if (this.m_blessed) {
            Value value = this.m_right.extractKey(token);
            TokenList tokenList = this.m_left.getTestableTokens(value);
            this.doRunTestsVaryLeft(n2, token, tokenList, context, tokenTask);
        } else {
            this.doRunTestsVaryLeft(n2, token, context, this);
        }
    }

    void doRunTestsVaryLeft(int n2, Token token, Context context, TokenTask tokenTask) throws JessException {
        for (int i2 = 0; i2 < this.m_left.getHash(); ++i2) {
            this.doRunTestsVaryLeft(n2, token, this.m_left.getTokenList(i2), context, tokenTask);
        }
    }

    void doRunTestsVaryLeft(int n2, Token token, TokenList tokenList, Context context, TokenTask tokenTask) throws JessException {
        int n3;
        if (tokenList != null && (n3 = tokenList.size()) > 0) {
            int n4 = this.m_nTests;
            for (int i2 = 0; i2 < n3; ++i2) {
                Token token2 = tokenList.get(i2);
                context.setToken(token2);
                if (!this.runTests(n4, context, token)) continue;
                tokenTask.tokenMatchesRight(n2, token2, token, context);
            }
        }
    }

    boolean runTests(int n2, Context context, Token token) throws JessException {
        TestBase[] testBaseArray = this.m_tests;
        context.setFact(token.topFact());
        for (int i2 = 0; i2 < n2; ++i2) {
            if (testBaseArray[i2].doTest(context)) continue;
            return false;
        }
        return true;
    }

    void setBackchainInfo(Pattern pattern, HasLHS hasLHS) {
        this.m_pattern = pattern;
        this.m_defrule = hasLHS;
    }

    private void askForBackChain(Token token, Context context) throws JessException {
        if (this.m_pattern == null || this.m_matches != 0) {
            return;
        }
        Fact fact = new Fact(this.m_pattern.getBackchainingTemplateName(), context.getEngine());
        for (int i2 = 0; i2 < this.m_pattern.getNSlots(); ++i2) {
            int n2;
            int n3 = this.m_pattern.getDeftemplate().getSlotType(i2);
            Value value = Funcall.NIL;
            ValueVector valueVector = null;
            if (n3 == 32768) {
                valueVector = new ValueVector();
            }
            for (n2 = 0; n2 < this.m_pattern.getNTests(i2); ++n2) {
                Test1 test1 = this.m_pattern.getTest(i2, n2);
                if (test1.m_test != 0) continue;
                if (test1.m_slotValue instanceof Variable) {
                    BindingValue bindingValue = (BindingValue)this.m_defrule.getBindings().get(test1.m_slotValue.variableValue(null));
                    if (bindingValue == null) {
                        value = test1.m_slotValue;
                    } else if (bindingValue.getFactNumber() < token.size()) {
                        value = token.fact(bindingValue.getFactNumber()).get(bindingValue.getSlotIndex());
                        if (bindingValue.getSubIndex() != -1) {
                            value = value.listValue(null).get(bindingValue.getSubIndex());
                        }
                    }
                    if (n3 == 16384) {
                        break;
                    }
                } else {
                    value = test1.m_slotValue;
                    if (n3 == 16384) break;
                }
                if (n3 != 32768) continue;
                if (valueVector.size() < test1.m_subIdx + 1) {
                    valueVector.setLength(test1.m_subIdx + 1);
                }
                valueVector.set(value, test1.m_subIdx);
                value = Funcall.NIL;
            }
            if (n3 == 32768) {
                for (n2 = 0; n2 < valueVector.size(); ++n2) {
                    if (valueVector.get(n2) != null) continue;
                    valueVector.set(Funcall.NIL, n2);
                }
                value = new Value(valueVector, 512);
            }
            fact.set(value, i2);
        }
        context.getEngine().setPendingFact(fact, this.m_matches == 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("[Node2 ntests=");
        stringBuffer.append(this.m_nTests);
        stringBuffer.append(" ");
        for (int i2 = 0; i2 < this.m_nTests; ++i2) {
            stringBuffer.append(this.m_tests[i2].toString());
            stringBuffer.append(" ");
        }
        stringBuffer.append(";usecount = ");
        stringBuffer.append(this.m_usecount);
        if (this.m_blessed) {
            stringBuffer.append(";blessed");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    protected void initTokenTrees() {
        if (this.m_left == null) {
            MemoryInfo memoryInfo = new MemoryInfo(this.m_tests, this.m_nTests);
            this.m_blessed = memoryInfo.blessed;
            int n2 = memoryInfo.leftSlot == -1 ? 0 : memoryInfo.tokenIndex;
            this.m_left = new TokenTree(this.m_hashkey, memoryInfo.leftSlot == -1, n2, memoryInfo.leftSlot, memoryInfo.leftSubSlot);
            this.m_right = new TokenTree(this.m_hashkey, memoryInfo.rightSlot == -1, 0, memoryInfo.rightSlot, memoryInfo.rightSubSlot);
        } else {
            this.m_left.clear();
            this.m_right.clear();
        }
    }

    StringBuffer displayMemory() {
        StringBuffer stringBuffer = new StringBuffer("*** Left Memory:\n");
        this.m_left.dumpMemory(stringBuffer);
        stringBuffer.append("*** RightMemory:\n");
        this.m_right.dumpMemory(stringBuffer);
        return stringBuffer;
    }

    void complete() throws JessException {
        this.initTokenTrees();
    }

    public int getTokenSize() {
        return this.m_tokenSize + 1;
    }

    public void dependsOn(Fact fact, Token token) {
        this.ensureHandlerAllocated();
        this.m_logicalDepends.dependsOn(fact, token);
    }

    public Map getLogicalDependencies() {
        return this.m_logicalDepends.getMap();
    }

    public void setMatchInfoSource(MatchInfoSource matchInfoSource) {
        this.ensureHandlerAllocated();
        this.m_logicalDepends.setMatchInfoSource(matchInfoSource);
    }

    private void ensureHandlerAllocated() {
        if (this.m_logicalDepends == null) {
            this.m_logicalDepends = new NodeLogicalDependencyHandler(this.getTokenSize());
        }
    }

    public String getIndexingInfo() throws JessException {
        if (this.m_blessed) {
            return "Left memory indexed by " + this.m_left.getIndexingInfo() + "\n" + "Right memory indexed by " + this.m_right.getIndexingInfo();
        }
        return "Unindexed.";
    }

    public int getNodeType() {
        return 2;
    }
}

