/*
 * Decompiled with CFR 0.152.
 */
package jess;

import jess.Context;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.Node1;
import jess.Token;
import jess.Value;

class Node1TNEQ
extends Node1 {
    private Value m_value;
    private int m_idx;

    Node1TNEQ(int n2, Value value) throws JessException {
        this.m_value = this.cleanupBindings(value);
        this.m_idx = n2;
    }

    void callNodeRight(int n2, Token token, Context context) throws JessException {
        if (this.processClearCommand(n2, token, context)) {
            return;
        }
        if (n2 == 1 || n2 == 5) {
            this.passAlong(n2, token, context);
            return;
        }
        try {
            boolean bl = false;
            Fact fact = token.topFact();
            if (this.m_value.type() == 64) {
                context.setFact(fact);
                context.setToken(token);
                if (this.m_value.resolveValue(context).equals(Funcall.FALSE)) {
                    bl = true;
                }
                token = token.prepare(bl);
            } else if (!fact.get(this.m_idx).equals(this.m_value.resolveValue(context))) {
                bl = true;
            }
            if (bl) {
                this.passAlong(n2, token, context);
            }
            return;
        }
        catch (JessException jessException) {
            jessException.addContext("rule LHS (TNEQ)");
            throw jessException;
        }
        catch (Exception exception) {
            JessException jessException = new JessException("Node1TNEQ.call", "Error during LHS execution", exception);
            jessException.addContext("rule LHS (TNEQ)");
            throw jessException;
        }
    }

    public String toString() {
        return "[Test that slot at index " + this.m_idx + " is not equal to " + this.m_value + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof Node1TNEQ) {
            Node1TNEQ node1TNEQ = (Node1TNEQ)object;
            return this.m_idx == node1TNEQ.m_idx && this.m_value.equals(node1TNEQ.m_value);
        }
        return false;
    }
}

