/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import jess.Context;
import jess.Fact;
import jess.JessException;
import jess.Node1;
import jess.Rete;
import jess.Token;
import jess.Value;
import jess.ValueVector;

class Node1MTMF
extends Node1 {
    private int m_idx;
    private int m_slotSize;
    private int m_nMultifields;
    private boolean[] m_multiIndexes;

    Node1MTMF(int n2, boolean[] blArray) {
        this.m_idx = n2;
        this.m_slotSize = blArray.length;
        this.m_multiIndexes = blArray;
        for (int i2 = 0; i2 < this.m_slotSize; ++i2) {
            if (!this.m_multiIndexes[i2]) continue;
            ++this.m_nMultifields;
        }
    }

    void callNodeRight(int n2, Token token, Context context) throws JessException {
        if (this.processClearCommand(n2, token, context)) {
            return;
        }
        ValueVector valueVector = token.fact(0).get(this.m_idx).listValue(null);
        int n3 = valueVector.size();
        int n4 = n3 - this.m_slotSize + this.m_nMultifields;
        if (n4 < 0) {
            return;
        }
        this.partition(n2, token, n4, this.m_nMultifields, context);
    }

    void partition(int n2, Token token, int n3, int n4, Context context) throws JessException {
        int[] nArray = new int[n4];
        do {
            if (this.testForSum(nArray, n3, n4)) {
                this.process(n2, token, nArray, context);
            }
            this.addOne(nArray, n3, n4);
        } while (nArray[n4 - 1] <= n3);
    }

    void addOne(int[] nArray, int n2, int n3) {
        nArray[0] = nArray[0] + 1;
        for (int i2 = 0; i2 < n3 - 1; ++i2) {
            if (nArray[i2] <= n2) continue;
            nArray[i2] = 0;
            int n4 = i2 + 1;
            nArray[n4] = nArray[n4] + 1;
        }
    }

    boolean testForSum(int[] nArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 += nArray[i2];
        }
        return n4 == n2;
    }

    private void process(int n2, Token token, int[] nArray, Context context) throws JessException {
        Fact fact = this.createModifiedFact(token.fact(0), token.fact(0).get(this.m_idx).listValue(null), nArray);
        token = Rete.getFactory().newToken(fact, n2);
        this.passAlong(n2, token, context);
    }

    private Fact createModifiedFact(Fact fact, ValueVector valueVector, int[] nArray) throws JessException {
        Fact fact2 = (Fact)fact.clone();
        fact2.setIcon(fact.getIcon());
        ValueVector valueVector2 = new ValueVector();
        valueVector2.setLength(this.m_slotSize);
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.m_slotSize; ++i2) {
            if (!this.m_multiIndexes[i2]) {
                valueVector2.set(valueVector.get(n2++), i2);
                continue;
            }
            ValueVector valueVector3 = new ValueVector();
            int n4 = nArray[n3++];
            valueVector3.setLength(n4);
            for (int i3 = 0; i3 < n4; ++i3) {
                valueVector3.set(valueVector.get(n2++), i3);
            }
            valueVector2.set(new Value(valueVector3, 512), i2);
        }
        fact2.set(new Value(valueVector2, 512), this.m_idx);
        return fact2;
    }

    void newProcess(int n2, Token token, int[] nArray, Context context) throws JessException {
        Context context2 = context.push();
        Fact fact = this.newCreateModifiedFact(token.fact(0), token.fact(0).get(this.m_idx).listValue(null), nArray, context2);
        token = Rete.getFactory().newToken(fact, n2);
        this.passAlong(n2, token, context2);
    }

    Fact newCreateModifiedFact(Fact fact, ValueVector valueVector, int[] nArray, Context context) throws JessException {
        Fact fact2 = (Fact)fact.clone();
        fact2.setIcon(fact.getIcon());
        ValueVector valueVector2 = new ValueVector();
        valueVector2.setLength(this.m_slotSize);
        int n2 = fact.getFactId();
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this.m_slotSize; ++i2) {
            Serializable serializable;
            if (!this.m_multiIndexes[i2]) {
                serializable = valueVector.get(n3++);
                valueVector2.set((Value)serializable, i2);
                context.setVariable(n2 + "_" + this.m_idx + "_" + i2, (Value)serializable);
                continue;
            }
            serializable = new ValueVector();
            int n5 = nArray[n4++];
            ((ValueVector)serializable).setLength(n5);
            for (int i3 = 0; i3 < n5; ++i3) {
                ((ValueVector)serializable).set(valueVector.get(n3++), i3);
            }
            Value value = new Value((ValueVector)serializable, 512);
            valueVector2.set(value, i2);
            context.setVariable(n2 + "_" + this.m_idx + "_" + i2, value);
        }
        fact2.set(new Value(valueVector2, 512), this.m_idx);
        return fact2;
    }

    public String toString() {
        return "[Split the multislot at index " + this.m_idx + " into " + this.m_slotSize + " pieces]";
    }

    public boolean equals(Object object) {
        if (object instanceof Node1MTMF) {
            Node1MTMF node1MTMF = (Node1MTMF)object;
            if (this.m_idx != node1MTMF.m_idx || this.m_slotSize != node1MTMF.m_slotSize || this.m_nMultifields != node1MTMF.m_nMultifields) {
                return false;
            }
            for (int i2 = 0; i2 < this.m_slotSize; ++i2) {
                if (this.m_multiIndexes[i2] == node1MTMF.m_multiIndexes[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

