/*
 * Decompiled with CFR 0.152.
 */
package jess;

import jess.Context;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.Node1;
import jess.Token;
import jess.Value;
import jess.ValueVector;

class Node1MTEQ
extends Node1 {
    private int m_idx;
    private int m_subidx;
    private Value m_value;

    Node1MTEQ(int n2, int n3, Value value) throws JessException {
        this.m_idx = n2;
        this.m_subidx = n3;
        this.m_value = this.cleanupBindings(value);
    }

    void callNodeRight(int n2, Token token, Context context) throws JessException {
        try {
            Value value;
            if (this.processClearCommand(n2, token, context)) {
                return;
            }
            if (n2 == 1 || n2 == 5) {
                this.passAlong(n2, token, context);
                return;
            }
            boolean bl = false;
            Fact fact = token.topFact();
            String string = fact.getFactId() + "_" + this.m_idx + "_" + this.m_subidx;
            if (context.isVariableDefined(string)) {
                value = context.getVariable(string);
            } else {
                ValueVector valueVector = fact.get(this.m_idx).listValue(null);
                if (valueVector.size() >= this.m_subidx) {
                    value = valueVector.get(this.m_subidx);
                } else {
                    return;
                }
            }
            if (this.m_value.type() == 64) {
                context.setFact(fact);
                context.setToken(token);
                if (!this.m_value.resolveValue(context).equals(Funcall.FALSE)) {
                    bl = true;
                }
                token = token.prepare(bl);
            } else if (value.equals(this.m_value.resolveValue(context))) {
                bl = true;
            }
            if (bl) {
                this.passAlong(n2, token, context);
            }
            return;
        }
        catch (JessException jessException) {
            jessException.addContext("rule LHS (MTEQ)");
            throw jessException;
        }
        catch (Exception exception) {
            JessException jessException = new JessException("Node1MTEQ.call", "Error during LHS execution", exception);
            jessException.addContext("rule LHS");
            throw jessException;
        }
    }

    public String toString() {
        return "[Test that the multislot entry at index " + this.m_idx + ", subindex " + this.m_subidx + " equals " + this.m_value + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof Node1MTEQ) {
            Node1MTEQ node1MTEQ = (Node1MTEQ)object;
            return this.m_idx == node1MTEQ.m_idx && this.m_subidx == node1MTEQ.m_subidx && this.m_value.equals(node1MTEQ.m_value);
        }
        return false;
    }
}

