/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import jess.Context;
import jess.JessEvent;
import jess.JessException;
import jess.JessListener;
import jess.NodeSink;
import jess.Token;

public abstract class Node
implements Serializable {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_NODE1 = 1;
    public static final int TYPE_NODE2 = 2;
    public static final int TYPE_NODENOT2 = 3;
    public static final int TYPE_TEST = 4;
    public static final int TYPE_TERMINAL = 5;
    public static final int TYPE_ADAPTER = 6;
    int m_usecount = 0;
    Node[] m_succ;
    int m_nSucc;
    private transient List m_listeners;

    public Enumeration getSuccessors() {
        return new NodeEnumeration();
    }

    public Iterator successors() {
        return new NodeIterator();
    }

    Node resolve(Node node) {
        for (int i2 = 0; i2 < this.m_nSucc; ++i2) {
            if (!this.m_succ[i2].equals(node)) continue;
            return this.m_succ[i2];
        }
        return node;
    }

    Node addSuccessor(Node node, NodeSink nodeSink) throws JessException {
        if (this.m_succ == null || this.m_nSucc == this.m_succ.length) {
            Node[] nodeArray = this.m_succ;
            this.m_succ = new Node[this.m_nSucc + 5];
            if (nodeArray != null) {
                System.arraycopy(nodeArray, 0, this.m_succ, 0, this.m_nSucc);
            }
        }
        this.m_succ[this.m_nSucc++] = node;
        nodeSink.addNode(node);
        return node;
    }

    Node mergeSuccessor(Node node, NodeSink nodeSink) throws JessException {
        for (int i2 = 0; i2 < this.m_nSucc; ++i2) {
            Node node2 = this.m_succ[i2];
            if (!node.equals(node2)) continue;
            nodeSink.addNode(node2);
            return node2;
        }
        this.addSuccessor(node, nodeSink);
        return node;
    }

    void removeSuccessor(Node node) {
        for (int i2 = 0; i2 < this.m_nSucc; ++i2) {
            if (node != this.m_succ[i2]) continue;
            System.arraycopy(this.m_succ, i2 + 1, this.m_succ, i2, --this.m_nSucc - i2);
            return;
        }
    }

    void callNodeLeft(int n2, Token token, Context context) throws JessException {
        throw new JessException("callNodeLeft", "Undefined in class", this.getClass().getName());
    }

    void callNodeRight(int n2, Token token, Context context) throws JessException {
        throw new JessException("callNodeRight", "Undefined in class", this.getClass().getName());
    }

    public synchronized void addJessListener(JessListener jessListener) {
        if (this.m_listeners == null) {
            this.m_listeners = Collections.synchronizedList(new ArrayList());
        }
        this.m_listeners.add(jessListener);
    }

    public synchronized void removeJessListener(JessListener jessListener) {
        if (this.m_listeners == null) {
            return;
        }
        this.m_listeners.remove(jessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastEvent(int n2, int n3, Object object) throws JessException {
        if (this.m_listeners != null) {
            Node node = this;
            synchronized (node) {
                if (this.m_listeners != null) {
                    JessEvent jessEvent = new JessEvent(this, n3, n2, object, null);
                    Iterator iterator = this.m_listeners.iterator();
                    while (iterator.hasNext()) {
                        JessListener jessListener = (JessListener)iterator.next();
                        jessListener.eventHappened(jessEvent);
                    }
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    abstract String getCompilationTraceToken();

    public abstract int getNodeType();

    private class NodeIterator
    implements Iterator {
        private int m_index = 0;

        private NodeIterator() {
        }

        public boolean hasNext() {
            return this.m_index < Node.this.m_nSucc;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more elements");
            }
            return Node.this.m_succ[this.m_index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class NodeEnumeration
    implements Enumeration {
        private int m_index = 0;

        private NodeEnumeration() {
        }

        public boolean hasMoreElements() {
            return this.m_index < Node.this.m_nSucc;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new RuntimeException("No more elements");
            }
            return Node.this.m_succ[this.m_index++];
        }
    }
}

