/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;

public class JessException
extends Exception
implements Serializable {
    public static final int NO_ERROR = 0;
    public static final int GENERAL_ERROR = 1;
    public static final int CLASS_NOT_FOUND = 2;
    private int m_errorCode = 1;
    private Throwable m_nextException;
    private int m_lineNumber = -1;
    private String m_detail;
    private String m_routine;
    private String m_data;
    private String m_programText;
    private StringBuffer m_context;

    public JessException(String string, String string2, String string3) {
        super(string2 + " " + string3);
        this.m_routine = string;
        this.m_detail = string2;
        this.m_data = string3;
    }

    public JessException(String string, String string2, int n2) {
        this(string, string2, String.valueOf(n2));
    }

    public JessException(String string, String string2, Throwable throwable) {
        super(string2);
        this.m_routine = string;
        this.m_detail = string2;
        this.m_nextException = throwable;
    }

    public Throwable getCause() {
        return this.m_nextException;
    }

    public int getLineNumber() {
        return this.m_lineNumber;
    }

    void setLineNumber(int n2) {
        this.m_lineNumber = n2;
    }

    public String getDetail() {
        return this.m_detail;
    }

    public String getRoutine() {
        return this.m_routine;
    }

    public String getData() {
        return this.m_data;
    }

    public String getProgramText() {
        return this.m_programText;
    }

    void setProgramText(String string) {
        this.m_programText = string;
    }

    void addContext(String string) {
        if (this.m_context == null) {
            this.m_context = new StringBuffer();
        }
        this.m_context.append("\n\twhile executing ");
        this.m_context.append(string);
    }

    public String getContext() {
        return this.m_context.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Jess reported an error in routine ");
        stringBuffer.append(this.m_routine);
        if (this.m_context != null) {
            stringBuffer.append(this.m_context.toString());
        }
        stringBuffer.append(".\n");
        stringBuffer.append("  Message: ");
        stringBuffer.append(this.getMessage());
        stringBuffer.append(".");
        if (this.m_programText != null) {
            stringBuffer.append("\n  Program text: ");
            stringBuffer.append(this.m_programText);
            if (this.m_lineNumber != -1) {
                stringBuffer.append(" at line ");
                stringBuffer.append(this.m_lineNumber);
                stringBuffer.append(".");
            }
        }
        return stringBuffer.toString();
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public void setErrorCode(int n2) {
        this.m_errorCode = n2;
    }
}

