/*
 * Decompiled with CFR 0.152.
 */
package jess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jess.Context;
import jess.Funcall;
import jess.JessEvent;
import jess.JessException;
import jess.JessListener;
import jess.Rete;

class JessEventSupport
implements Serializable {
    private List m_listeners = Collections.synchronizedList(new ArrayList());
    private List m_debugListeners = Collections.synchronizedList(new ArrayList());
    private int m_eventMask = 0;
    private boolean m_debug;

    JessEventSupport(Rete rete) {
        this.addJessListener(rete);
    }

    public void addJessListener(JessListener jessListener) {
        this.m_listeners.add(jessListener);
    }

    public void removeJessListener(JessListener jessListener) {
        this.m_listeners.remove(jessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listJessListeners() {
        List list = this.m_listeners;
        synchronized (list) {
            return new ArrayList(this.m_listeners).iterator();
        }
    }

    public synchronized int getEventMask() {
        return this.m_eventMask;
    }

    public synchronized void setEventMask(int n2) {
        this.m_eventMask = n2;
    }

    final void broadcastEvent(Object object, int n2, Object object2, Context context) throws JessException {
        if ((n2 & this.getEventMask()) == 0) {
            return;
        }
        this.sendEventToListeners(object, n2, object2, this.m_listeners, context);
    }

    public boolean isDebug() {
        return this.m_debug;
    }

    public void addDebugListener(JessListener jessListener) {
        this.m_debugListeners.add(jessListener);
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
    }

    public void removeDebugListener(JessListener jessListener) {
        this.m_debugListeners.remove(jessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator listDebugListeners() {
        List list = this.m_debugListeners;
        synchronized (list) {
            return new ArrayList(this.m_debugListeners).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastDebugEvent(Object object, int n2, Object object2, Context context) throws JessException {
        if (this.m_debug) {
            if (n2 == 524288) {
                context.pushStackFrame((Funcall)object2);
            }
            try {
                this.sendEventToListeners(object, n2, object2, this.m_debugListeners, context);
            }
            finally {
                if (n2 == 0x200000) {
                    context.popStackFrame((Funcall)object2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventToListeners(Object object, int n2, Object object2, List list, Context context) throws JessException {
        ArrayList arrayList;
        int n3;
        List list2 = list;
        synchronized (list2) {
            n3 = list.size();
            if (n3 == 0) {
                return;
            }
            arrayList = new ArrayList(list);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            try {
                JessEvent jessEvent = new JessEvent(object, n2, object2, context);
                ((JessListener)arrayList.get(i2)).eventHappened(jessEvent);
                continue;
            }
            catch (JessException jessException) {
                throw jessException;
            }
            catch (Exception exception) {
                throw new JessException("JessEventSupport.broadcastEvent", "Event handler threw an exception", exception);
            }
        }
    }
}

